# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.39
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
# This file is compatible with both classic and new-style classes.

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_dbxml', [dirname(__file__)])
        except ImportError:
            import _dbxml
            return _dbxml
        if fp is not None:
            try:
                _mod = imp.load_module('_dbxml', fp, pathname, description)
            finally:
                fp.close()
                return _mod
    _dbxml = swig_import_helper()
    del swig_import_helper
else:
    import _dbxml
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


try:
    import weakref
    weakref_proxy = weakref.proxy
except:
    weakref_proxy = lambda x: x


class XmlException(Exception):
    """Base class for BDB XML exceptions.  It should never be called directly, and
    if it is, it's an unknown error
    Attributes:
        what -- the exception message
    """
    def __init__(self, msg):
        self.exceptionCode = INTERNAL_ERROR
        self.what = "Unknown exception thrown: ",msg
    def __str__(self):
        return "XmlException %d, %s"%(self.exceptionCode,self.what)
    def getexceptionCode(self):
        return self.exceptionCode
    def what(self):
        return self.what

class XmlDatabaseError(XmlException):
    """Raised when Berkeley DB returns an error
    Attributes:
        dbError -- the Berkeley DB errno
    """
    def __init__(self, msg, dberr):
        self.exceptionCode = DATABASE_ERROR
        self.what = msg
        self.dbError = dberr
    def __str__(self):
        return "XmlDatabaseError %d, %s"%(self.dbError,self.what)
    def getDbErrno(self):
        return self.dbError

class XmlContainerClosed(XmlException):
    """Raised when an operation requires an open container and it is closed.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = CONTAINER_CLOSED
        self.what = msg

class XmlContainerExists(XmlException):
    """Raised when an operation requires that a container does not exist
    and it exists.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = CONTAINER_EXISTS
        self.what = msg

class XmlContainerOpen(XmlException):
    """Raised when an operation requires a closed container and it is open.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = CONTAINER_OPEN
        self.what = msg

class XmlDocumentNotFound(XmlException):
    """Raised when a specified document is not found in a container.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = DOCUMENT_NOT_FOUND
        self.what = msg

class XmlInvalidValue(XmlException):
    """Raised when a invalid value or parameter is specified.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = INVALID_VALUE
        self.what = msg

class XmlParserError(XmlException):
    """Raised when there is an XML parser error while parsing a document.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = XML_PARSER_ERROR
        self.what = msg

class XmlInternalError(XmlException):
    """Raised when there is an internal error in the BDB XML library.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = INTERNAL_ERROR
        self.what = msg

class XmlVersionMismatch(XmlException):
    """Raised when there is version mismatch between the library and a container.
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = VERSION_MISMATCH
        self.what = msg

class XmlLazyEvaluation(XmlException):
    """Raised when an operation that requires an eager result set is
    called on a lazily evaluated result set.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = LAZY_EVALUATION
        self.what = msg

class XmlUnknownIndex(XmlException):
    """Raised when an operation is called on an unknown index in a container.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = UNKNOWN_INDEX
        self.what = msg

class XmlQueryEvaluationError(XmlException):
    """Raised when there is a runtime error during query evaluation
    
    Attributes: see XmlException
    queryLine -- line of the query that caused the exception, if available
    queryColumn -- column of the query that caused the exception, if available
    
    """
    def __init__(self, msg, line, column):
        self.exceptionCode = QUERY_EVALUATION_ERROR
        self.what = msg
        self.queryLine = line
        self.queryColumn = column
    def __str__(self):
        return "XmlQueryEvaluationError %s, line %d, column %d"%(self.what,self.queryLine,self.queryColumn)
    def getqueryLine(self):
        return self.queryLine
    def getqueryColumn(self):
        return self.queryColumn

class XmlQueryParserError(XmlException):
    """Raised when there is an error parsing a query expression
    
    Attributes: see XmlException
    queryLine -- line of the query that caused the exception, if available
    queryColumn -- column of the query that caused the exception, if available
    """
    def __init__(self, msg, line, column):
        self.exceptionCode = QUERY_PARSER_ERROR
        self.what = msg
        self.queryLine = line
        self.queryColumn = column
    def __str__(self):
        return "XmlQueryParserError %s, line %d, column %d"%(self.what,self.queryLine,self.queryColumn)
    def getqueryLine(self):
        return self.queryLine
    def getqueryColumn(self):
        return self.queryColumn

class XmlEventError(XmlException):
    """Raised when there is an error during an XmlEventReader or 
    XmlEventWriter call.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = EVENT_ERROR
        self.what = msg

class XmlContainerNotFound(XmlException):
    """Raised when a required container is not found.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = CONTAINER_NOT_FOUND
        self.what = msg

class XmlUniqueError(XmlException):
    """Raised when there is an attempt to insert a duplicate of a
    uniquely indexed item such as a document name.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = UNIQUE_ERROR
        self.what = msg

class XmlNoMemoryError(XmlException):
    """Raised when an operation runs out of memory.
    TBD -- should this be a Python MemoryError?
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = NO_MEMORY_ERROR
        self.what = msg

class XmlNullPointer(XmlException):
    """Raised when an operation is attempted on a null or uninitialized object.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = NULL_POINTER
        self.what = msg

class XmlTransactionError(XmlException):
    """Raised when there is a transaction-related error.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = TRANSACTION_ERROR
        self.what = msg

class XmlOperationInterrupted(XmlException):
    """Raised when a query operation is interrupted and does not complete.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = OPERATION_INTERRUPTED
        self.what = msg

class XmlOperationTimeout(XmlException):
    """Raised when a query operation times out.
    
    Attributes: see XmlException
    """
    def __init__(self, msg):
        self.exceptionCode = OPERATION_TIMEOUT
        self.what = msg


INTERNAL_ERROR = _dbxml.INTERNAL_ERROR
CONTAINER_OPEN = _dbxml.CONTAINER_OPEN
CONTAINER_CLOSED = _dbxml.CONTAINER_CLOSED
NULL_POINTER = _dbxml.NULL_POINTER
XML_PARSER_ERROR = _dbxml.INDEXER_PARSER_ERROR
DATABASE_ERROR = _dbxml.DATABASE_ERROR
QUERY_PARSER_ERROR = _dbxml.QUERY_PARSER_ERROR
QUERY_EVALUATION_ERROR = _dbxml.QUERY_EVALUATION_ERROR
LAZY_EVALUATION = _dbxml.LAZY_EVALUATION
DOCUMENT_NOT_FOUND = _dbxml.DOCUMENT_NOT_FOUND
CONTAINER_EXISTS = _dbxml.CONTAINER_EXISTS
UNKNOWN_INDEX = _dbxml.UNKNOWN_INDEX
INVALID_VALUE = _dbxml.INVALID_VALUE
VERSION_MISMATCH = _dbxml.VERSION_MISMATCH
EVENT_ERROR = _dbxml.EVENT_ERROR
CONTAINER_NOT_FOUND = _dbxml.CONTAINER_NOT_FOUND
TRANSACTION_ERROR = _dbxml.TRANSACTION_ERROR
UNIQUE_ERROR = _dbxml.UNIQUE_ERROR
NO_MEMORY_ERROR = _dbxml.NO_MEMORY_ERROR
OPERATION_INTERRUPTED = _dbxml.OPERATION_INTERRUPTED
OPERATION_TIMEOUT = _dbxml.OPERATION_TIMEOUT

DB_CREATE = _dbxml.DB_CREATE
DB_READ_UNCOMMITTED = _dbxml.DB_READ_UNCOMMITTED
DB_DIRTY_READ = _dbxml.DB_DIRTY_READ
DB_EXCL = _dbxml.DB_EXCL
DB_NOMMAP = _dbxml.DB_NOMMAP
DB_RDONLY = _dbxml.DB_RDONLY
DB_THREAD = _dbxml.DB_THREAD
DB_READ_COMMITTED = _dbxml.DB_READ_COMMITTED
DB_DEGREE_2 = _dbxml.DB_DEGREE_2
DB_INIT_LOCK = _dbxml.DB_INIT_LOCK
DB_INIT_LOG = _dbxml.DB_INIT_LOG
DB_INIT_MPOOL = _dbxml.DB_INIT_MPOOL
DB_INIT_TXN = _dbxml.DB_INIT_TXN
DB_SALVAGE = _dbxml.DB_SALVAGE
DB_AGGRESSIVE = _dbxml.DB_AGGRESSIVE
DB_TXN_SNAPSHOT = _dbxml.DB_TXN_SNAPSHOT
DB_MULTIVERSION = _dbxml.DB_MULTIVERSION
DBXML_ADOPT_DBENV = _dbxml.DBXML_ADOPT_DBENV
DBXML_ALLOW_EXTERNAL_ACCESS = _dbxml.DBXML_ALLOW_EXTERNAL_ACCESS
DBXML_ALLOW_AUTO_OPEN = _dbxml.DBXML_ALLOW_AUTO_OPEN
DBXML_ALLOW_VALIDATION = _dbxml.DBXML_ALLOW_VALIDATION
DBXML_TRANSACTIONAL = _dbxml.DBXML_TRANSACTIONAL
DBXML_CHKSUM = _dbxml.DBXML_CHKSUM
DBXML_ENCRYPT = _dbxml.DBXML_ENCRYPT
DBXML_INDEX_NODES = _dbxml.DBXML_INDEX_NODES
DBXML_NO_INDEX_NODES = _dbxml.DBXML_NO_INDEX_NODES
DBXML_STATISTICS = _dbxml.DBXML_STATISTICS
DBXML_NO_STATISTICS = _dbxml.DBXML_NO_STATISTICS
DBXML_REVERSE_ORDER = _dbxml.DBXML_REVERSE_ORDER
DBXML_INDEX_VALUES = _dbxml.DBXML_INDEX_VALUES
DBXML_CACHE_DOCUMENTS = _dbxml.DBXML_CACHE_DOCUMENTS
DBXML_LAZY_DOCS = _dbxml.DBXML_LAZY_DOCS
DBXML_DOCUMENT_PROJECTION = _dbxml.DBXML_DOCUMENT_PROJECTION
DBXML_NO_AUTO_COMMIT = _dbxml.DBXML_NO_AUTO_COMMIT
DBXML_WELL_FORMED_ONLY = _dbxml.DBXML_WELL_FORMED_ONLY
DBXML_GEN_NAME = _dbxml.DBXML_GEN_NAME
LEVEL_NONE = _dbxml.LEVEL_NONE
LEVEL_DEBUG = _dbxml.LEVEL_DEBUG
LEVEL_INFO = _dbxml.LEVEL_INFO
LEVEL_WARNING = _dbxml.LEVEL_WARNING
LEVEL_ERROR = _dbxml.LEVEL_ERROR
LEVEL_ALL = _dbxml.LEVEL_ALL
CATEGORY_NONE = _dbxml.CATEGORY_NONE
CATEGORY_INDEXER = _dbxml.CATEGORY_INDEXER
CATEGORY_QUERY = _dbxml.CATEGORY_QUERY
CATEGORY_OPTIMIZER = _dbxml.CATEGORY_OPTIMIZER
CATEGORY_DICTIONARY = _dbxml.CATEGORY_DICTIONARY
CATEGORY_CONTAINER = _dbxml.CATEGORY_CONTAINER
CATEGORY_NODESTORE = _dbxml.CATEGORY_NODESTORE
CATEGORY_MANAGER = _dbxml.CATEGORY_MANAGER
CATEGORY_ALL = _dbxml.CATEGORY_ALL
metaDataNamespace_uri = _dbxml.metaDataNamespace_uri
metaDataNamespace_prefix = _dbxml.metaDataNamespace_prefix
metaDataName_name = _dbxml.metaDataName_name
metaDataName_root = _dbxml.metaDataName_root
class XmlManager(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlManager, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlManager, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlManager(*args)
        try: self.this.append(this)
        except: self.this = this
        if (len(args) > 1): self.env = args[0]



    __swig_destroy__ = _dbxml.delete_XmlManager
    __del__ = lambda self : None;
    def getFlags(self): return _dbxml.XmlManager_getFlags(self)
    def getDefaultContainerConfig(self): return _dbxml.XmlManager_getDefaultContainerConfig(self)
    def setDefaultContainerConfig(self, *args): return _dbxml.XmlManager_setDefaultContainerConfig(self, *args)
    def setDefaultContainerType(self, *args): return _dbxml.XmlManager_setDefaultContainerType(self, *args)
    def getDefaultContainerType(self): return _dbxml.XmlManager_getDefaultContainerType(self)
    def setDefaultPageSize(self, *args): return _dbxml.XmlManager_setDefaultPageSize(self, *args)
    def getDefaultPageSize(self): return _dbxml.XmlManager_getDefaultPageSize(self)
    def setDefaultSequenceIncrement(self, *args): return _dbxml.XmlManager_setDefaultSequenceIncrement(self, *args)
    def getDefaultSequenceIncrement(self): return _dbxml.XmlManager_getDefaultSequenceIncrement(self)
    def getHome(self): return _dbxml.XmlManager_getHome(self)
    def registerResolver(self, *args): return _dbxml.XmlManager_registerResolver(self, *args)
    def getImplicitTimezone(self): return _dbxml.XmlManager_getImplicitTimezone(self)
    def setImplicitTimezone(self, *args): return _dbxml.XmlManager_setImplicitTimezone(self, *args)
    def existsContainer(self, *args): return _dbxml.XmlManager_existsContainer(self, *args)
    def removeContainer(self, *args): return _dbxml.XmlManager_removeContainer(self, *args)
    def renameContainer(self, *args): return _dbxml.XmlManager_renameContainer(self, *args)
    def upgradeContainer(self, *args): return _dbxml.XmlManager_upgradeContainer(self, *args)
    def setDefaultContainerFlags(self, *args): return _dbxml.XmlManager_setDefaultContainerFlags(self, *args)
    def getDefaultContainerFlags(self): return _dbxml.XmlManager_getDefaultContainerFlags(self)
    def compactContainer(self, *args): return _dbxml.XmlManager_compactContainer(self, *args)
    def truncateContainer(self, *args): return _dbxml.XmlManager_truncateContainer(self, *args)
    def reindexContainer(self, *args): return _dbxml.XmlManager_reindexContainer(self, *args)
    def createStdInInputStream(self): return _dbxml.XmlManager_createStdInInputStream(self)
    def createLocalFileInputStream(self, *args): return _dbxml.XmlManager_createLocalFileInputStream(self, *args)
    def createMemBufInputStream(self, *args): return _dbxml.XmlManager_createMemBufInputStream(self, *args)
    def createURLInputStream(self, *args): return _dbxml.XmlManager_createURLInputStream(self, *args)
    def createContainer(self, *args):
        val = _dbxml.XmlManager_createContainer(self, *args)
        val.mgr = self


        return val

    def openContainer(self, *args):
        val = _dbxml.XmlManager_openContainer(self, *args)
        val.mgr = self


        return val

    def dumpContainer(self, *args): return _dbxml.XmlManager_dumpContainer(self, *args)
    def loadContainer(self, *args): return _dbxml.XmlManager_loadContainer(self, *args)
    def verifyContainer(self, *args): return _dbxml.XmlManager_verifyContainer(self, *args)
    def createDocument(self): return _dbxml.XmlManager_createDocument(self)
    def createQueryContext(self, *args): return _dbxml.XmlManager_createQueryContext(self, *args)
    def createUpdateContext(self): return _dbxml.XmlManager_createUpdateContext(self)
    def prepare(self, *args): return _dbxml.XmlManager_prepare(self, *args)
    def query(self, *args): return _dbxml.XmlManager_query(self, *args)
    def createResults(self): return _dbxml.XmlManager_createResults(self)
    def createTransaction(self, *args): return _dbxml.XmlManager_createTransaction(self, *args)
    def createIndexLookup(self, *args): return _dbxml.XmlManager_createIndexLookup(self, *args)
    __swig_getmethods__["setLogLevel"] = lambda x: _dbxml.XmlManager_setLogLevel
    if _newclass:setLogLevel = staticmethod(_dbxml.XmlManager_setLogLevel)
    __swig_getmethods__["setLogCategory"] = lambda x: _dbxml.XmlManager_setLogCategory
    if _newclass:setLogCategory = staticmethod(_dbxml.XmlManager_setLogCategory)
    __swig_getmethods__["get_version_major"] = lambda x: _dbxml.XmlManager_get_version_major
    if _newclass:get_version_major = staticmethod(_dbxml.XmlManager_get_version_major)
    __swig_getmethods__["get_version_minor"] = lambda x: _dbxml.XmlManager_get_version_minor
    if _newclass:get_version_minor = staticmethod(_dbxml.XmlManager_get_version_minor)
    __swig_getmethods__["get_version_patch"] = lambda x: _dbxml.XmlManager_get_version_patch
    if _newclass:get_version_patch = staticmethod(_dbxml.XmlManager_get_version_patch)
    __swig_getmethods__["get_version_string"] = lambda x: _dbxml.XmlManager_get_version_string
    if _newclass:get_version_string = staticmethod(_dbxml.XmlManager_get_version_string)
XmlManager_swigregister = _dbxml.XmlManager_swigregister
XmlManager_swigregister(XmlManager)

def XmlManager_setLogLevel(*args):
  return _dbxml.XmlManager_setLogLevel(*args)
XmlManager_setLogLevel = _dbxml.XmlManager_setLogLevel

def XmlManager_setLogCategory(*args):
  return _dbxml.XmlManager_setLogCategory(*args)
XmlManager_setLogCategory = _dbxml.XmlManager_setLogCategory

def XmlManager_get_version_major():
  return _dbxml.XmlManager_get_version_major()
XmlManager_get_version_major = _dbxml.XmlManager_get_version_major

def XmlManager_get_version_minor():
  return _dbxml.XmlManager_get_version_minor()
XmlManager_get_version_minor = _dbxml.XmlManager_get_version_minor

def XmlManager_get_version_patch():
  return _dbxml.XmlManager_get_version_patch()
XmlManager_get_version_patch = _dbxml.XmlManager_get_version_patch

def XmlManager_get_version_string():
  return _dbxml.XmlManager_get_version_string()
XmlManager_get_version_string = _dbxml.XmlManager_get_version_string

class XmlIndexLookup(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlIndexLookup, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlIndexLookup, name)
    __repr__ = _swig_repr
    NONE = _dbxml.XmlIndexLookup_NONE
    EQ = _dbxml.XmlIndexLookup_EQ
    GT = _dbxml.XmlIndexLookup_GT
    GTE = _dbxml.XmlIndexLookup_GTE
    LT = _dbxml.XmlIndexLookup_LT
    LTE = _dbxml.XmlIndexLookup_LTE
    def __init__(self, *args): 
        this = _dbxml.new_XmlIndexLookup(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlIndexLookup
    __del__ = lambda self : None;
    def isNull(self): return _dbxml.XmlIndexLookup_isNull(self)
    def getIndex(self): return _dbxml.XmlIndexLookup_getIndex(self)
    def setIndex(self, *args): return _dbxml.XmlIndexLookup_setIndex(self, *args)
    def getNodeURI(self): return _dbxml.XmlIndexLookup_getNodeURI(self)
    def getNodeName(self): return _dbxml.XmlIndexLookup_getNodeName(self)
    def setNode(self, *args): return _dbxml.XmlIndexLookup_setNode(self, *args)
    def getParentURI(self): return _dbxml.XmlIndexLookup_getParentURI(self)
    def getParentName(self): return _dbxml.XmlIndexLookup_getParentName(self)
    def setParent(self, *args): return _dbxml.XmlIndexLookup_setParent(self, *args)
    def getLowBoundValue(self): return _dbxml.XmlIndexLookup_getLowBoundValue(self)
    def getLowBoundOperation(self): return _dbxml.XmlIndexLookup_getLowBoundOperation(self)
    def setLowBound(self, *args): return _dbxml.XmlIndexLookup_setLowBound(self, *args)
    def getHighBoundValue(self): return _dbxml.XmlIndexLookup_getHighBoundValue(self)
    def getHighBoundOperation(self): return _dbxml.XmlIndexLookup_getHighBoundOperation(self)
    def setHighBound(self, *args): return _dbxml.XmlIndexLookup_setHighBound(self, *args)
    def getContainer(self): return _dbxml.XmlIndexLookup_getContainer(self)
    def setContainer(self, *args): return _dbxml.XmlIndexLookup_setContainer(self, *args)
    def execute(self, *args): return _dbxml.XmlIndexLookup_execute(self, *args)
XmlIndexLookup_swigregister = _dbxml.XmlIndexLookup_swigregister
XmlIndexLookup_swigregister(XmlIndexLookup)

class XmlContainer(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlContainer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlContainer, name)
    __repr__ = _swig_repr
    WholedocContainer = _dbxml.XmlContainer_WholedocContainer
    NodeContainer = _dbxml.XmlContainer_NodeContainer
    def __init__(self, *args): 
        this = _dbxml.new_XmlContainer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlContainer
    __del__ = lambda self : None;
    def sync(self): return _dbxml.XmlContainer_sync(self)
    def close(self): return _dbxml.XmlContainer_close(self)
    def getFlags(self): return _dbxml.XmlContainer_getFlags(self)
    def addAlias(self, *args): return _dbxml.XmlContainer_addAlias(self, *args)
    def removeAlias(self, *args): return _dbxml.XmlContainer_removeAlias(self, *args)
    def getManager(self): return _dbxml.XmlContainer_getManager(self)
    def getName(self): return _dbxml.XmlContainer_getName(self)
    def getContainerType(self): return _dbxml.XmlContainer_getContainerType(self)
    def getIndexNodes(self): return _dbxml.XmlContainer_getIndexNodes(self)
    def getPageSize(self): return _dbxml.XmlContainer_getPageSize(self)
    def getAutoIndexing(self, *args): return _dbxml.XmlContainer_getAutoIndexing(self, *args)
    def getContainerConfig(self): return _dbxml.XmlContainer_getContainerConfig(self)
    def setAutoIndexing(self, *args): return _dbxml.XmlContainer_setAutoIndexing(self, *args)
    def setIndexSpecification(self, *args): return _dbxml.XmlContainer_setIndexSpecification(self, *args)
    def addIndex(self, *args): return _dbxml.XmlContainer_addIndex(self, *args)
    def deleteIndex(self, *args): return _dbxml.XmlContainer_deleteIndex(self, *args)
    def replaceIndex(self, *args): return _dbxml.XmlContainer_replaceIndex(self, *args)
    def addDefaultIndex(self, *args): return _dbxml.XmlContainer_addDefaultIndex(self, *args)
    def deleteDefaultIndex(self, *args): return _dbxml.XmlContainer_deleteDefaultIndex(self, *args)
    def replaceDefaultIndex(self, *args): return _dbxml.XmlContainer_replaceDefaultIndex(self, *args)
    def putDocument(self, *args): return _dbxml.XmlContainer_putDocument(self, *args)
    def putDocumentAsEventWriter(self, *args): return _dbxml.XmlContainer_putDocumentAsEventWriter(self, *args)
    def deleteDocument(self, *args): return _dbxml.XmlContainer_deleteDocument(self, *args)
    def updateDocument(self, *args): return _dbxml.XmlContainer_updateDocument(self, *args)
    def getNumDocuments(self, *args): return _dbxml.XmlContainer_getNumDocuments(self, *args)
    def getIndexSpecification(self, *args): return _dbxml.XmlContainer_getIndexSpecification(self, *args)
    def getNode(self, *args): return _dbxml.XmlContainer_getNode(self, *args)
    def getDocument(self, *args): return _dbxml.XmlContainer_getDocument(self, *args)
    def getAllDocuments(self, *args): return _dbxml.XmlContainer_getAllDocuments(self, *args)
    def lookupIndex(self, *args): return _dbxml.XmlContainer_lookupIndex(self, *args)
    def lookupStatistics(self, *args): return _dbxml.XmlContainer_lookupStatistics(self, *args)
XmlContainer_swigregister = _dbxml.XmlContainer_swigregister
XmlContainer_swigregister(XmlContainer)

class XmlDocument(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlDocument, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlDocument, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlDocument(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlDocument
    __del__ = lambda self : None;
    def setName(self, *args): return _dbxml.XmlDocument_setName(self, *args)
    def getName(self): return _dbxml.XmlDocument_getName(self)
    def setContent(self, *args): return _dbxml.XmlDocument_setContent(self, *args)
    def getContentAsXmlInputStream(self): return _dbxml.XmlDocument_getContentAsXmlInputStream(self)
    def setContentAsXmlInputStream(self, *args): return _dbxml.XmlDocument_setContentAsXmlInputStream(self, *args)
    def getContentAsEventReader(self): return _dbxml.XmlDocument_getContentAsEventReader(self)
    def setContentAsEventReader(self, *args): return _dbxml.XmlDocument_setContentAsEventReader(self, *args)
    def getContentAsEventWriter(self, *args): return _dbxml.XmlDocument_getContentAsEventWriter(self, *args)
    def fetchAllData(self): return _dbxml.XmlDocument_fetchAllData(self)
    def removeMetaData(self, *args): return _dbxml.XmlDocument_removeMetaData(self, *args)
    def setMetaData(self, *args): return _dbxml.XmlDocument_setMetaData(self, *args)
    def getContentAsString(self): return _dbxml.XmlDocument_getContentAsString(self)
    def getContent(self): return _dbxml.XmlDocument_getContent(self)
    def getMetaData(self, *args): return _dbxml.XmlDocument_getMetaData(self, *args)
    def getMetaDataIterator(self): return _dbxml.XmlDocument_getMetaDataIterator(self)
    def equals(self, *args): return _dbxml.XmlDocument_equals(self, *args)
XmlDocument_swigregister = _dbxml.XmlDocument_swigregister
XmlDocument_swigregister(XmlDocument)

class XmlMetaDataIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlMetaDataIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlMetaDataIterator, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlMetaDataIterator(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlMetaDataIterator
    __del__ = lambda self : None;
    def reset(self): return _dbxml.XmlMetaDataIterator_reset(self)
    def next(self): return _dbxml.XmlMetaDataIterator_next(self)
    def __iter__(self): return self

XmlMetaDataIterator_swigregister = _dbxml.XmlMetaDataIterator_swigregister
XmlMetaDataIterator_swigregister(XmlMetaDataIterator)

class XmlMetaData(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlMetaData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlMetaData, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlMetaData
    __del__ = lambda self : None;
    def get_uri(self): return _dbxml.XmlMetaData_get_uri(self)
    def get_name(self): return _dbxml.XmlMetaData_get_name(self)
    def get_value(self): return _dbxml.XmlMetaData_get_value(self)
    def __init__(self): 
        this = _dbxml.new_XmlMetaData()
        try: self.this.append(this)
        except: self.this = this
XmlMetaData_swigregister = _dbxml.XmlMetaData_swigregister
XmlMetaData_swigregister(XmlMetaData)

class XmlQueryContext(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlQueryContext, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlQueryContext, name)
    __repr__ = _swig_repr
    LiveValues = _dbxml.XmlQueryContext_LiveValues
    Eager = _dbxml.XmlQueryContext_Eager
    Lazy = _dbxml.XmlQueryContext_Lazy
    def __init__(self, *args): 
        this = _dbxml.new_XmlQueryContext(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlQueryContext
    __del__ = lambda self : None;
    def setNamespace(self, *args): return _dbxml.XmlQueryContext_setNamespace(self, *args)
    def getNamespace(self, *args): return _dbxml.XmlQueryContext_getNamespace(self, *args)
    def removeNamespace(self, *args): return _dbxml.XmlQueryContext_removeNamespace(self, *args)
    def clearNamespaces(self): return _dbxml.XmlQueryContext_clearNamespaces(self)
    def setVariableValue(self, *args): return _dbxml.XmlQueryContext_setVariableValue(self, *args)
    def setBaseURI(self, *args): return _dbxml.XmlQueryContext_setBaseURI(self, *args)
    def getBaseURI(self): return _dbxml.XmlQueryContext_getBaseURI(self)
    def setReturnType(self, *args): return _dbxml.XmlQueryContext_setReturnType(self, *args)
    def getReturnType(self): return _dbxml.XmlQueryContext_getReturnType(self)
    def setEvaluationType(self, *args): return _dbxml.XmlQueryContext_setEvaluationType(self, *args)
    def getEvaluationType(self): return _dbxml.XmlQueryContext_getEvaluationType(self)
    def setDefaultCollection(self, *args): return _dbxml.XmlQueryContext_setDefaultCollection(self, *args)
    def getDefaultCollection(self): return _dbxml.XmlQueryContext_getDefaultCollection(self)
    def interruptQuery(self): return _dbxml.XmlQueryContext_interruptQuery(self)
    def setQueryTimeoutSeconds(self, *args): return _dbxml.XmlQueryContext_setQueryTimeoutSeconds(self, *args)
    def getQueryTimeoutSeconds(self): return _dbxml.XmlQueryContext_getQueryTimeoutSeconds(self)
    def getDebugListener(self): return _dbxml.XmlQueryContext_getDebugListener(self)
    def setDebugListener(self, *args): return _dbxml.XmlQueryContext_setDebugListener(self, *args)
    def getVariableValue(self, *args): return _dbxml.XmlQueryContext_getVariableValue(self, *args)
    def getVariableValues(self, *args): return _dbxml.XmlQueryContext_getVariableValues(self, *args)
XmlQueryContext_swigregister = _dbxml.XmlQueryContext_swigregister
XmlQueryContext_swigregister(XmlQueryContext)

class XmlResults(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlResults, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlResults, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlResults
    __del__ = lambda self : None;
    def __init__(self, *args): 
        this = _dbxml.new_XmlResults(*args)
        try: self.this.append(this)
        except: self.this = this
    def hasNext(self): return _dbxml.XmlResults_hasNext(self)
    def hasPrevious(self): return _dbxml.XmlResults_hasPrevious(self)
    def isNull(self): return _dbxml.XmlResults_isNull(self)
    def getEvaluationType(self): return _dbxml.XmlResults_getEvaluationType(self)
    def next(self, *args): return _dbxml.XmlResults_next(self, *args)
    def previous(self, *args): return _dbxml.XmlResults_previous(self, *args)
    def peek(self, *args): return _dbxml.XmlResults_peek(self, *args)
    def __iter__(self): return self

    def reset(self): return _dbxml.XmlResults_reset(self)
    def size(self): return _dbxml.XmlResults_size(self)
    def add(self, *args): return _dbxml.XmlResults_add(self, *args)
    def asEventWriter(self): return _dbxml.XmlResults_asEventWriter(self)
    def copyResults(self): return _dbxml.XmlResults_copyResults(self)
    def concatResults(self, *args): return _dbxml.XmlResults_concatResults(self, *args)
XmlResults_swigregister = _dbxml.XmlResults_swigregister
XmlResults_swigregister(XmlResults)

class XmlUpdateContext(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlUpdateContext, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlUpdateContext, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlUpdateContext(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlUpdateContext
    __del__ = lambda self : None;
XmlUpdateContext_swigregister = _dbxml.XmlUpdateContext_swigregister
XmlUpdateContext_swigregister(XmlUpdateContext)

class XmlValue(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlValue, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlValue, name)
    __repr__ = _swig_repr
    ELEMENT_NODE = _dbxml.XmlValue_ELEMENT_NODE
    ATTRIBUTE_NODE = _dbxml.XmlValue_ATTRIBUTE_NODE
    TEXT_NODE = _dbxml.XmlValue_TEXT_NODE
    CDATA_SECTION_NODE = _dbxml.XmlValue_CDATA_SECTION_NODE
    ENTITY_REFERENCE_NODE = _dbxml.XmlValue_ENTITY_REFERENCE_NODE
    ENTITY_NODE = _dbxml.XmlValue_ENTITY_NODE
    PROCESSING_INSTRUCTION_NODE = _dbxml.XmlValue_PROCESSING_INSTRUCTION_NODE
    COMMENT_NODE = _dbxml.XmlValue_COMMENT_NODE
    DOCUMENT_NODE = _dbxml.XmlValue_DOCUMENT_NODE
    DOCUMENT_TYPE_NODE = _dbxml.XmlValue_DOCUMENT_TYPE_NODE
    DOCUMENT_FRAGMENT_NODE = _dbxml.XmlValue_DOCUMENT_FRAGMENT_NODE
    NOTATION_NODE = _dbxml.XmlValue_NOTATION_NODE
    NONE = _dbxml.XmlValue_NONE
    NODE = _dbxml.XmlValue_NODE
    ANY_SIMPLE_TYPE = _dbxml.XmlValue_ANY_SIMPLE_TYPE
    ANY_URI = _dbxml.XmlValue_ANY_URI
    BASE_64_BINARY = _dbxml.XmlValue_BASE_64_BINARY
    BOOLEAN = _dbxml.XmlValue_BOOLEAN
    DATE = _dbxml.XmlValue_DATE
    DATE_TIME = _dbxml.XmlValue_DATE_TIME
    DAY_TIME_DURATION = _dbxml.XmlValue_DAY_TIME_DURATION
    DECIMAL = _dbxml.XmlValue_DECIMAL
    DOUBLE = _dbxml.XmlValue_DOUBLE
    DURATION = _dbxml.XmlValue_DURATION
    FLOAT = _dbxml.XmlValue_FLOAT
    G_DAY = _dbxml.XmlValue_G_DAY
    G_MONTH = _dbxml.XmlValue_G_MONTH
    G_MONTH_DAY = _dbxml.XmlValue_G_MONTH_DAY
    G_YEAR = _dbxml.XmlValue_G_YEAR
    G_YEAR_MONTH = _dbxml.XmlValue_G_YEAR_MONTH
    HEX_BINARY = _dbxml.XmlValue_HEX_BINARY
    NOTATION = _dbxml.XmlValue_NOTATION
    QNAME = _dbxml.XmlValue_QNAME
    STRING = _dbxml.XmlValue_STRING
    TIME = _dbxml.XmlValue_TIME
    YEAR_MONTH_DURATION = _dbxml.XmlValue_YEAR_MONTH_DURATION
    UNTYPED_ATOMIC = _dbxml.XmlValue_UNTYPED_ATOMIC
    BINARY = _dbxml.XmlValue_BINARY
    def __init__(self, *args): 
        this = _dbxml.new_XmlValue(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlValue
    __del__ = lambda self : None;
    def getType(self): return _dbxml.XmlValue_getType(self)
    def getTypeURI(self): return _dbxml.XmlValue_getTypeURI(self)
    def getTypeName(self): return _dbxml.XmlValue_getTypeName(self)
    def isNull(self): return _dbxml.XmlValue_isNull(self)
    def isType(self, *args): return _dbxml.XmlValue_isType(self, *args)
    def isNumber(self): return _dbxml.XmlValue_isNumber(self)
    def isString(self): return _dbxml.XmlValue_isString(self)
    def isBoolean(self): return _dbxml.XmlValue_isBoolean(self)
    def isBinary(self): return _dbxml.XmlValue_isBinary(self)
    def isNode(self): return _dbxml.XmlValue_isNode(self)
    def asNumber(self): return _dbxml.XmlValue_asNumber(self)
    def asString(self): return _dbxml.XmlValue_asString(self)
    def asBoolean(self): return _dbxml.XmlValue_asBoolean(self)
    def asBinary(self): return _dbxml.XmlValue_asBinary(self)
    def asDocument(self): return _dbxml.XmlValue_asDocument(self)
    def asEventReader(self): return _dbxml.XmlValue_asEventReader(self)
    def getNodeHandle(self): return _dbxml.XmlValue_getNodeHandle(self)
    def equals(self, *args): return _dbxml.XmlValue_equals(self, *args)
    def getNodeName(self): return _dbxml.XmlValue_getNodeName(self)
    def getNodeValue(self): return _dbxml.XmlValue_getNodeValue(self)
    def getNamespaceURI(self): return _dbxml.XmlValue_getNamespaceURI(self)
    def getPrefix(self): return _dbxml.XmlValue_getPrefix(self)
    def getLocalName(self): return _dbxml.XmlValue_getLocalName(self)
    def getNodeType(self): return _dbxml.XmlValue_getNodeType(self)
    def getParentNode(self): return _dbxml.XmlValue_getParentNode(self)
    def getFirstChild(self): return _dbxml.XmlValue_getFirstChild(self)
    def getLastChild(self): return _dbxml.XmlValue_getLastChild(self)
    def getPreviousSibling(self): return _dbxml.XmlValue_getPreviousSibling(self)
    def getNextSibling(self): return _dbxml.XmlValue_getNextSibling(self)
    def getAttributes(self): return _dbxml.XmlValue_getAttributes(self)
    def getOwnerElement(self): return _dbxml.XmlValue_getOwnerElement(self)
    __swig_getmethods__["setValue"] = lambda x: _dbxml.XmlValue_setValue
    if _newclass:setValue = staticmethod(_dbxml.XmlValue_setValue)
XmlValue_swigregister = _dbxml.XmlValue_swigregister
XmlValue_swigregister(XmlValue)

def XmlValue_setValue(*args):
  return _dbxml.XmlValue_setValue(*args)
XmlValue_setValue = _dbxml.XmlValue_setValue

class XmlIndexSpecification(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlIndexSpecification, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlIndexSpecification, name)
    __repr__ = _swig_repr
    UNIQUE_OFF = _dbxml.XmlIndexSpecification_UNIQUE_OFF
    UNIQUE_ON = _dbxml.XmlIndexSpecification_UNIQUE_ON
    PATH_NONE = _dbxml.XmlIndexSpecification_PATH_NONE
    PATH_NODE = _dbxml.XmlIndexSpecification_PATH_NODE
    PATH_EDGE = _dbxml.XmlIndexSpecification_PATH_EDGE
    NODE_NONE = _dbxml.XmlIndexSpecification_NODE_NONE
    NODE_ELEMENT = _dbxml.XmlIndexSpecification_NODE_ELEMENT
    NODE_ATTRIBUTE = _dbxml.XmlIndexSpecification_NODE_ATTRIBUTE
    NODE_METADATA = _dbxml.XmlIndexSpecification_NODE_METADATA
    KEY_NONE = _dbxml.XmlIndexSpecification_KEY_NONE
    KEY_PRESENCE = _dbxml.XmlIndexSpecification_KEY_PRESENCE
    KEY_EQUALITY = _dbxml.XmlIndexSpecification_KEY_EQUALITY
    KEY_SUBSTRING = _dbxml.XmlIndexSpecification_KEY_SUBSTRING
    def __init__(self): 
        this = _dbxml.new_XmlIndexSpecification()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlIndexSpecification
    __del__ = lambda self : None;
    def addIndex(self, *args): return _dbxml.XmlIndexSpecification_addIndex(self, *args)
    def deleteIndex(self, *args): return _dbxml.XmlIndexSpecification_deleteIndex(self, *args)
    def replaceIndex(self, *args): return _dbxml.XmlIndexSpecification_replaceIndex(self, *args)
    def addDefaultIndex(self, *args): return _dbxml.XmlIndexSpecification_addDefaultIndex(self, *args)
    def deleteDefaultIndex(self, *args): return _dbxml.XmlIndexSpecification_deleteDefaultIndex(self, *args)
    def replaceDefaultIndex(self, *args): return _dbxml.XmlIndexSpecification_replaceDefaultIndex(self, *args)
    def reset(self): return _dbxml.XmlIndexSpecification_reset(self)
    def getAutoIndexing(self): return _dbxml.XmlIndexSpecification_getAutoIndexing(self)
    def setAutoIndexing(self, *args): return _dbxml.XmlIndexSpecification_setAutoIndexing(self, *args)
    def find(self, *args): return _dbxml.XmlIndexSpecification_find(self, *args)
    def next(self): return _dbxml.XmlIndexSpecification_next(self)
    def getDefaultIndex(self): return _dbxml.XmlIndexSpecification_getDefaultIndex(self)
    __swig_getmethods__["getValueType"] = lambda x: _dbxml.XmlIndexSpecification_getValueType
    if _newclass:getValueType = staticmethod(_dbxml.XmlIndexSpecification_getValueType)
    def __iter__(self): return self

XmlIndexSpecification_swigregister = _dbxml.XmlIndexSpecification_swigregister
XmlIndexSpecification_swigregister(XmlIndexSpecification)

def XmlIndexSpecification_getValueType(*args):
  return _dbxml.XmlIndexSpecification_getValueType(*args)
XmlIndexSpecification_getValueType = _dbxml.XmlIndexSpecification_getValueType

class XmlIndexDeclaration(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlIndexDeclaration, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlIndexDeclaration, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlIndexDeclaration
    __del__ = lambda self : None;
    def get_uri(self): return _dbxml.XmlIndexDeclaration_get_uri(self)
    def get_name(self): return _dbxml.XmlIndexDeclaration_get_name(self)
    def get_index(self): return _dbxml.XmlIndexDeclaration_get_index(self)
    def __init__(self): 
        this = _dbxml.new_XmlIndexDeclaration()
        try: self.this.append(this)
        except: self.this = this
XmlIndexDeclaration_swigregister = _dbxml.XmlIndexDeclaration_swigregister
XmlIndexDeclaration_swigregister(XmlIndexDeclaration)

class XmlQueryExpression(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlQueryExpression, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlQueryExpression, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlQueryExpression(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlQueryExpression
    __del__ = lambda self : None;
    def getQuery(self): return _dbxml.XmlQueryExpression_getQuery(self)
    def getQueryPlan(self): return _dbxml.XmlQueryExpression_getQueryPlan(self)
    def isUpdateExpression(self): return _dbxml.XmlQueryExpression_isUpdateExpression(self)
    def execute(self, *args): return _dbxml.XmlQueryExpression_execute(self, *args)
XmlQueryExpression_swigregister = _dbxml.XmlQueryExpression_swigregister
XmlQueryExpression_swigregister(XmlQueryExpression)

class XmlInputStream(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlInputStream, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlInputStream, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlInputStream
    __del__ = lambda self : None;
    def curPos(self): return _dbxml.XmlInputStream_curPos(self)
    def readBytes(self, *args): return _dbxml.XmlInputStream_readBytes(self, *args)
    def freeMemory(self): return _dbxml.XmlInputStream_freeMemory(self)
    def __init__(self): 
        if self.__class__ == XmlInputStream:
            _self = None
        else:
            _self = self
        this = _dbxml.new_XmlInputStream(_self, )
        try: self.this.append(this)
        except: self.this = this
    def __disown__(self):
        self.this.disown()
        _dbxml.disown_XmlInputStream(self)
        return weakref_proxy(self)
XmlInputStream_swigregister = _dbxml.XmlInputStream_swigregister
XmlInputStream_swigregister(XmlInputStream)

class XmlResolver(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlResolver, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlResolver, name)
    __repr__ = _swig_repr
    def __init__(self): 
        if self.__class__ == XmlResolver:
            _self = None
        else:
            _self = self
        this = _dbxml.new_XmlResolver(_self, )
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlResolver
    __del__ = lambda self : None;
    def resolveDocument(self, *args): return _dbxml.XmlResolver_resolveDocument(self, *args)
    def resolveCollection(self, *args): return _dbxml.XmlResolver_resolveCollection(self, *args)
    def resolveSchema(self, *args): return _dbxml.XmlResolver_resolveSchema(self, *args)
    def resolveEntity(self, *args): return _dbxml.XmlResolver_resolveEntity(self, *args)
    def resolveModuleLocation(self, *args): return _dbxml.XmlResolver_resolveModuleLocation(self, *args)
    def resolveModule(self, *args): return _dbxml.XmlResolver_resolveModule(self, *args)
    def resolveExternalFunction(self, *args): return _dbxml.XmlResolver_resolveExternalFunction(self, *args)
    def __disown__(self):
        self.this.disown()
        _dbxml.disown_XmlResolver(self)
        return weakref_proxy(self)
XmlResolver_swigregister = _dbxml.XmlResolver_swigregister
XmlResolver_swigregister(XmlResolver)

class XmlArguments(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlArguments, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlArguments, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlArguments
    __del__ = lambda self : None;
    def getArgument(self, *args): return _dbxml.XmlArguments_getArgument(self, *args)
    def getNumberOfArgs(self): return _dbxml.XmlArguments_getNumberOfArgs(self)
XmlArguments_swigregister = _dbxml.XmlArguments_swigregister
XmlArguments_swigregister(XmlArguments)

class XmlExternalFunction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlExternalFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlExternalFunction, name)
    __repr__ = _swig_repr
    def __init__(self): 
        if self.__class__ == XmlExternalFunction:
            _self = None
        else:
            _self = self
        this = _dbxml.new_XmlExternalFunction(_self, )
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlExternalFunction
    __del__ = lambda self : None;
    def execute(self, *args): return _dbxml.XmlExternalFunction_execute(self, *args)
    def close(self): return _dbxml.XmlExternalFunction_close(self)
    def __disown__(self):
        self.this.disown()
        _dbxml.disown_XmlExternalFunction(self)
        return weakref_proxy(self)
XmlExternalFunction_swigregister = _dbxml.XmlExternalFunction_swigregister
XmlExternalFunction_swigregister(XmlExternalFunction)

class XmlStackFrame(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlStackFrame, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlStackFrame, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def getQueryFile(self): return _dbxml.XmlStackFrame_getQueryFile(self)
    def getQueryLine(self): return _dbxml.XmlStackFrame_getQueryLine(self)
    def getQueryColumn(self): return _dbxml.XmlStackFrame_getQueryColumn(self)
    def query(self, *args): return _dbxml.XmlStackFrame_query(self, *args)
    def getQueryPlan(self): return _dbxml.XmlStackFrame_getQueryPlan(self)
    def getPreviousStackFrame(self): return _dbxml.XmlStackFrame_getPreviousStackFrame(self)
    __swig_destroy__ = _dbxml.delete_XmlStackFrame
    __del__ = lambda self : None;
XmlStackFrame_swigregister = _dbxml.XmlStackFrame_swigregister
XmlStackFrame_swigregister(XmlStackFrame)

class XmlDebugListener(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlDebugListener, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlDebugListener, name)
    __repr__ = _swig_repr
    def __init__(self): 
        if self.__class__ == XmlDebugListener:
            _self = None
        else:
            _self = self
        this = _dbxml.new_XmlDebugListener(_self, )
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlDebugListener
    __del__ = lambda self : None;
    def start(self, *args): return _dbxml.XmlDebugListener_start(self, *args)
    def end(self, *args): return _dbxml.XmlDebugListener_end(self, *args)
    def enter(self, *args): return _dbxml.XmlDebugListener_enter(self, *args)
    def exit(self, *args): return _dbxml.XmlDebugListener_exit(self, *args)
    def error(self, *args): return _dbxml.XmlDebugListener_error(self, *args)
    def __disown__(self):
        self.this.disown()
        _dbxml.disown_XmlDebugListener(self)
        return weakref_proxy(self)
XmlDebugListener_swigregister = _dbxml.XmlDebugListener_swigregister
XmlDebugListener_swigregister(XmlDebugListener)

class XmlContainerConfig(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlContainerConfig, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlContainerConfig, name)
    __repr__ = _swig_repr
    On = _dbxml.XmlContainerConfig_On
    Off = _dbxml.XmlContainerConfig_Off
    UseDefault = _dbxml.XmlContainerConfig_UseDefault
    __swig_destroy__ = _dbxml.delete_XmlContainerConfig
    __del__ = lambda self : None;
    def __init__(self, *args): 
        this = _dbxml.new_XmlContainerConfig(*args)
        try: self.this.append(this)
        except: self.this = this
    def getMode(self): return _dbxml.XmlContainerConfig_getMode(self)
    def setMode(self, *args): return _dbxml.XmlContainerConfig_setMode(self, *args)
    def getContainerType(self): return _dbxml.XmlContainerConfig_getContainerType(self)
    def setContainerType(self, *args): return _dbxml.XmlContainerConfig_setContainerType(self, *args)
    def getPageSize(self): return _dbxml.XmlContainerConfig_getPageSize(self)
    def setPageSize(self, *args): return _dbxml.XmlContainerConfig_setPageSize(self, *args)
    def getSequenceIncrement(self): return _dbxml.XmlContainerConfig_getSequenceIncrement(self)
    def setSequenceIncrement(self, *args): return _dbxml.XmlContainerConfig_setSequenceIncrement(self, *args)
    def setIndexNodes(self, *args): return _dbxml.XmlContainerConfig_setIndexNodes(self, *args)
    def getIndexNodes(self): return _dbxml.XmlContainerConfig_getIndexNodes(self)
    def setChecksum(self, *args): return _dbxml.XmlContainerConfig_setChecksum(self, *args)
    def getChecksum(self): return _dbxml.XmlContainerConfig_getChecksum(self)
    def setEncrypted(self, *args): return _dbxml.XmlContainerConfig_setEncrypted(self, *args)
    def getEncrypted(self): return _dbxml.XmlContainerConfig_getEncrypted(self)
    def setAllowValidation(self, *args): return _dbxml.XmlContainerConfig_setAllowValidation(self, *args)
    def getAllowValidation(self): return _dbxml.XmlContainerConfig_getAllowValidation(self)
    def setStatistics(self, *args): return _dbxml.XmlContainerConfig_setStatistics(self, *args)
    def getStatistics(self): return _dbxml.XmlContainerConfig_getStatistics(self)
    def setTransactional(self, *args): return _dbxml.XmlContainerConfig_setTransactional(self, *args)
    def getTransactional(self): return _dbxml.XmlContainerConfig_getTransactional(self)
    def setAllowCreate(self, *args): return _dbxml.XmlContainerConfig_setAllowCreate(self, *args)
    def getAllowCreate(self): return _dbxml.XmlContainerConfig_getAllowCreate(self)
    def setExclusiveCreate(self, *args): return _dbxml.XmlContainerConfig_setExclusiveCreate(self, *args)
    def getExclusiveCreate(self): return _dbxml.XmlContainerConfig_getExclusiveCreate(self)
    def setNoMMap(self, *args): return _dbxml.XmlContainerConfig_setNoMMap(self, *args)
    def getNoMMap(self): return _dbxml.XmlContainerConfig_getNoMMap(self)
    def setReadOnly(self, *args): return _dbxml.XmlContainerConfig_setReadOnly(self, *args)
    def getReadOnly(self): return _dbxml.XmlContainerConfig_getReadOnly(self)
    def setMultiversion(self, *args): return _dbxml.XmlContainerConfig_setMultiversion(self, *args)
    def getMultiversion(self): return _dbxml.XmlContainerConfig_getMultiversion(self)
    def setReadUncommitted(self, *args): return _dbxml.XmlContainerConfig_setReadUncommitted(self, *args)
    def getReadUncommitted(self): return _dbxml.XmlContainerConfig_getReadUncommitted(self)
    def setThreaded(self, *args): return _dbxml.XmlContainerConfig_setThreaded(self, *args)
    def getThreaded(self): return _dbxml.XmlContainerConfig_getThreaded(self)
    def setTransactionNotDurable(self, *args): return _dbxml.XmlContainerConfig_setTransactionNotDurable(self, *args)
    def getTransactionNotDurable(self): return _dbxml.XmlContainerConfig_getTransactionNotDurable(self)
    def setCompressionName(self, *args): return _dbxml.XmlContainerConfig_setCompressionName(self, *args)
    def getCompressionName(self): return _dbxml.XmlContainerConfig_getCompressionName(self)
XmlContainerConfig_swigregister = _dbxml.XmlContainerConfig_swigregister
XmlContainerConfig_swigregister(XmlContainerConfig)

class XmlTransaction(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlTransaction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlTransaction, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlTransaction
    __del__ = lambda self : None;
    def __init__(self, *args): 
        this = _dbxml.new_XmlTransaction(*args)
        try: self.this.append(this)
        except: self.this = this
    def abort(self): return _dbxml.XmlTransaction_abort(self)
    def createChild(self, flags = 0): return _dbxml.XmlTransaction_createChild(self, flags)
    def commit(self, *args): return _dbxml.XmlTransaction_commit(self, *args)
    def getDB_TXN(self): return _dbxml.XmlTransaction_getDB_TXN(self)
XmlTransaction_swigregister = _dbxml.XmlTransaction_swigregister
XmlTransaction_swigregister(XmlTransaction)

class XmlStatistics(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlStatistics, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlStatistics, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlStatistics(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlStatistics
    __del__ = lambda self : None;
    def getNumberOfIndexedKeys(self): return _dbxml.XmlStatistics_getNumberOfIndexedKeys(self)
    def getNumberOfUniqueKeys(self): return _dbxml.XmlStatistics_getNumberOfUniqueKeys(self)
    def getSumKeyValueSize(self): return _dbxml.XmlStatistics_getSumKeyValueSize(self)
XmlStatistics_swigregister = _dbxml.XmlStatistics_swigregister
XmlStatistics_swigregister(XmlStatistics)

class XmlEventReader(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlEventReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlEventReader, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    StartElement = _dbxml.XmlEventReader_StartElement
    EndElement = _dbxml.XmlEventReader_EndElement
    Characters = _dbxml.XmlEventReader_Characters
    CDATA = _dbxml.XmlEventReader_CDATA
    Comment = _dbxml.XmlEventReader_Comment
    Whitespace = _dbxml.XmlEventReader_Whitespace
    StartDocument = _dbxml.XmlEventReader_StartDocument
    EndDocument = _dbxml.XmlEventReader_EndDocument
    StartEntityReference = _dbxml.XmlEventReader_StartEntityReference
    EndEntityReference = _dbxml.XmlEventReader_EndEntityReference
    ProcessingInstruction = _dbxml.XmlEventReader_ProcessingInstruction
    DTD = _dbxml.XmlEventReader_DTD
    __swig_destroy__ = _dbxml.delete_XmlEventReader
    __del__ = lambda self : None;
    def close(self): return _dbxml.XmlEventReader_close(self)
    def setReportEntityInfo(self, *args): return _dbxml.XmlEventReader_setReportEntityInfo(self, *args)
    def getReportEntityInfo(self): return _dbxml.XmlEventReader_getReportEntityInfo(self)
    def setExpandEntities(self, *args): return _dbxml.XmlEventReader_setExpandEntities(self, *args)
    def getExpandEntities(self): return _dbxml.XmlEventReader_getExpandEntities(self)
    def next(self): return _dbxml.XmlEventReader_next(self)
    def nextTag(self): return _dbxml.XmlEventReader_nextTag(self)
    def hasNext(self): return _dbxml.XmlEventReader_hasNext(self)
    def getEventType(self): return _dbxml.XmlEventReader_getEventType(self)
    def getNamespaceURI(self): return _dbxml.XmlEventReader_getNamespaceURI(self)
    def getLocalName(self): return _dbxml.XmlEventReader_getLocalName(self)
    def getPrefix(self): return _dbxml.XmlEventReader_getPrefix(self)
    def getValue(self): return _dbxml.XmlEventReader_getValue(self)
    def getValueLength(self): return _dbxml.XmlEventReader_getValueLength(self)
    def getAttributeCount(self): return _dbxml.XmlEventReader_getAttributeCount(self)
    def isAttributeSpecified(self, *args): return _dbxml.XmlEventReader_isAttributeSpecified(self, *args)
    def getAttributeLocalName(self, *args): return _dbxml.XmlEventReader_getAttributeLocalName(self, *args)
    def getAttributeNamespaceURI(self, *args): return _dbxml.XmlEventReader_getAttributeNamespaceURI(self, *args)
    def getAttributePrefix(self, *args): return _dbxml.XmlEventReader_getAttributePrefix(self, *args)
    def getAttributeValue(self, *args): return _dbxml.XmlEventReader_getAttributeValue(self, *args)
    def getEncoding(self): return _dbxml.XmlEventReader_getEncoding(self)
    def getVersion(self): return _dbxml.XmlEventReader_getVersion(self)
    def getSystemId(self): return _dbxml.XmlEventReader_getSystemId(self)
    def isStandalone(self): return _dbxml.XmlEventReader_isStandalone(self)
    def standaloneSet(self): return _dbxml.XmlEventReader_standaloneSet(self)
    def encodingSet(self): return _dbxml.XmlEventReader_encodingSet(self)
    def hasEntityEscapeInfo(self): return _dbxml.XmlEventReader_hasEntityEscapeInfo(self)
    def needsEntityEscape(self, index = 0): return _dbxml.XmlEventReader_needsEntityEscape(self, index)
    def hasEmptyElementInfo(self): return _dbxml.XmlEventReader_hasEmptyElementInfo(self)
    def isEmptyElement(self): return _dbxml.XmlEventReader_isEmptyElement(self)
    def isWhiteSpace(self): return _dbxml.XmlEventReader_isWhiteSpace(self)
XmlEventReader_swigregister = _dbxml.XmlEventReader_swigregister
XmlEventReader_swigregister(XmlEventReader)

class XmlEventWriter(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlEventWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlEventWriter, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _dbxml.delete_XmlEventWriter
    __del__ = lambda self : None;
    def close(self): return _dbxml.XmlEventWriter_close(self)
    def writeAttribute(self, *args): return _dbxml.XmlEventWriter_writeAttribute(self, *args)
    def writeText(self, *args): return _dbxml.XmlEventWriter_writeText(self, *args)
    def writeDTD(self, *args): return _dbxml.XmlEventWriter_writeDTD(self, *args)
    def writeProcessingInstruction(self, *args): return _dbxml.XmlEventWriter_writeProcessingInstruction(self, *args)
    def writeStartElement(self, *args): return _dbxml.XmlEventWriter_writeStartElement(self, *args)
    def writeEndElement(self, *args): return _dbxml.XmlEventWriter_writeEndElement(self, *args)
    def writeStartDocument(self, *args): return _dbxml.XmlEventWriter_writeStartDocument(self, *args)
    def writeEndDocument(self): return _dbxml.XmlEventWriter_writeEndDocument(self)
    def writeStartEntity(self, *args): return _dbxml.XmlEventWriter_writeStartEntity(self, *args)
    def writeEndEntity(self, *args): return _dbxml.XmlEventWriter_writeEndEntity(self, *args)
XmlEventWriter_swigregister = _dbxml.XmlEventWriter_swigregister
XmlEventWriter_swigregister(XmlEventWriter)

class XmlEventReaderToWriter(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XmlEventReaderToWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XmlEventReaderToWriter, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _dbxml.new_XmlEventReaderToWriter(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _dbxml.delete_XmlEventReaderToWriter
    __del__ = lambda self : None;
    def start(self): return _dbxml.XmlEventReaderToWriter_start(self)
XmlEventReaderToWriter_swigregister = _dbxml.XmlEventReaderToWriter_swigregister
XmlEventReaderToWriter_swigregister(XmlEventReaderToWriter)



