declare variable $projectFile external;
declare variable $projectDoc := doc($projectFile);

declare variable $mainProject := "dbxml";
declare variable $testProjects := ();

declare function local:fileLine($file)
{
  let $projects := $file/ancestor::project
    [not(starts-with(@name, "db_")) and @name != "db" and not(contains(@name, "php"))]
  where $projects
  return (
    "&#10;", string(($file/@name)[1]),

    for $project in $projects
    return (
      if($project/@name = $mainProject) then " library"
      else if($project/@name = $testProjects) then (" app=", $project/@name)
      else if($project/type = "library") then (" dll=", $project/@name)
      else if($project/type = "app") then (" app=", $project/@name)
      else error(QName("", "error"), "Unknown project type")
    )
  )
};

string-join((
"#
# Generated by gensrcfiles.xq from dbxml.template.xml ** DO NOT EDIT **
#
# This is an input file for the s_win32_dsp and s_vxworks scripts.  It lists
# the source files in the Berkeley DB XML tree and notes which are 
# used to build the Win/32 and VxWorks libraries.
#
# Please keep this list sorted alphabetically!
#
# Each non-blank, non-comment line is of the form
#   filename		module [ module ...]
#
# The possible modules, including the name of the project (.dsp) file:
#
#   app=NAME		Linked into application NAME.exe (NAME.{dsp,vcproj})
#   test=NAME		Linked into application NAME.exe, linked
#                       with Xerces and Pathan, as well (NAME.{dsp,vcproj})
#   dll=NAME		Linked into dll NAME.dll (dbxml_NAME.{dsp,vcproj})
#   lib			File is in the main Windows DLL/LIB (dbxml.dsp)
"
,
"#library.filters=", string-join(
  for $f in distinct-values($projectDoc//filter/@name)
  where $f != "build_windows" and $f != "include"
  order by $f
  return $f, " ")
,
for $f in $projectDoc//file
order by lower-case($f/@name)
return local:fileLine($f)
), "")
