//
// Copyright (c) 2000 by Tech Soft 3D, LLC.
// The information contained herein is confidential and proprietary to
// Tech Soft 3D, LLC., and considered a trade secret as defined under
// civil and criminal statutes.  Tech Soft 3D shall pursue its civil
// and criminal remedies in the event of unauthorized use or misappropriation
// of its trade secrets.  Use of this information by anyone other than
// authorized employees of Tech Soft 3D, LLC. is granted only under a
// written non-disclosure agreement, expressly prescribing the scope and
// manner of such use.
//
// $Header: //DWF/Working_Area/Willie.Zhu/w3dtk/BCompressData.cpp#1 $
//
// This file contains the lookup tables to implement the repulse compression
// algorithm.  The algorithm is so named because it is based on quantization
// to a set of vectors that were the output of a point repulsion simulation.
//

#include "dwf/w3dtk/BCompress.h"
#include "dwf/w3dtk/BInternal.h"

#ifndef BSTREAM_DISABLE_REPULSE_COMPRESSION

float normal_vectors10[1024][3] = {
     {0.430089f, 0.134657f, 0.892688f},  {0.150279f, -0.183885f, 0.971392f},  {-0.326936f, -0.558815f, -0.762128f},  {-0.559076f, 0.139246f, 0.817340f},  
     {-0.271485f, 0.005293f, 0.962428f},  {0.991540f, -0.089424f, 0.094086f},  {0.392934f, -0.456626f, -0.798183f},  {-0.278875f, -0.654244f, -0.702989f},  
     {0.128683f, -0.965710f, 0.225486f},  {0.036685f, 0.607280f, -0.793641f},  {-0.122186f, -0.505501f, 0.854131f},  {0.068168f, -0.994442f, -0.080243f},  
     {0.403541f, 0.777066f, -0.483036f},  {0.817483f, 0.229852f, -0.528101f},  {0.307531f, -0.945496f, 0.107060f},  {-0.056187f, 0.056294f, -0.996832f},  
     {0.864637f, -0.065361f, -0.498127f},  {0.612404f, -0.386390f, -0.689684f},  {-0.431040f, -0.060375f, -0.900311f},  {-0.471711f, 0.103839f, 0.875618f},  
     {-0.684815f, 0.301055f, -0.663622f},  {-0.995545f, 0.071385f, 0.061606f},  {0.569126f, 0.816040f, 0.100869f},  {-0.830669f, 0.145926f, 0.537303f},  
     {0.883364f, 0.425681f, -0.196121f},  {0.970011f, 0.229119f, -0.081131f},  {0.434379f, -0.045278f, -0.899591f},  {-0.831760f, 0.041975f, -0.553547f},  
     {0.294932f, 0.752448f, 0.588929f},  {0.795995f, -0.277658f, 0.537865f},  {0.475395f, 0.270003f, -0.837316f},  {0.023157f, 0.094282f, 0.995276f},  
     {-0.729263f, 0.326796f, 0.601149f},  {-0.821533f, -0.218244f, 0.526737f},  {0.190070f, 0.358880f, -0.913826f},  {0.294971f, -0.429060f, 0.853756f},  
     {0.373142f, 0.268597f, -0.888043f},  {-0.190094f, -0.423670f, -0.885645f},  {0.481574f, 0.857592f, 0.180618f},  {-0.975543f, -0.209645f, -0.066067f},  
     {-0.823279f, -0.388686f, 0.413684f},  {-0.102477f, 0.362854f, 0.926194f},  {-0.841028f, 0.472027f, -0.264316f},  {0.328433f, 0.188808f, 0.925464f},  
     {0.357288f, -0.153376f, 0.921315f},  {-0.352645f, -0.869426f, -0.346035f},  {0.195539f, -0.935644f, -0.293827f},  {0.904771f, -0.190070f, 0.381132f},  
     {0.263382f, -0.164990f, -0.950478f},  {-0.402435f, 0.516105f, -0.756096f},  {0.217107f, 0.459301f, -0.861340f},  {-0.115456f, 0.459642f, 0.880568f},  
     {-0.755145f, -0.532483f, -0.382385f},  {0.098282f, 0.838968f, -0.535231f},  {0.883271f, -0.162074f, -0.439959f},  {-0.793576f, -0.577500f, -0.191654f},  
     {-0.064980f, 0.821630f, 0.566305f},  {0.143749f, 0.845485f, 0.514288f},  {0.317438f, -0.938611f, -0.135067f},  {-0.461356f, -0.820089f, -0.338533f},  
     {0.658144f, 0.663664f, -0.355523f},  {0.246258f, -0.112615f, 0.962640f},  {-0.772178f, 0.541232f, -0.332879f},  {-0.960597f, -0.065845f, -0.270035f},  
     {0.099191f, 0.143343f, -0.984690f},  {0.478193f, -0.853425f, 0.207355f},  {-0.660483f, -0.327967f, 0.675426f},  {0.504834f, 0.807215f, 0.305855f},  
     {0.695024f, -0.561105f, 0.449559f},  {0.412001f, 0.825449f, -0.385861f},  {-0.305702f, -0.918131f, -0.252155f},  {0.359240f, -0.840981f, 0.404596f},  
     {-0.266287f, 0.767551f, 0.583058f},  {-0.820467f, 0.434130f, -0.371974f},  {-0.394015f, -0.905314f, 0.158619f},  {0.582509f, 0.723294f, 0.370849f},  
     {0.747990f, -0.566841f, 0.345257f},  {0.038876f, -0.868023f, 0.494999f},  {0.408634f, -0.694533f, -0.592150f},  {0.790721f, 0.608167f, -0.069950f},  
     {-0.363404f, -0.063818f, 0.929443f},  {0.195665f, -0.977256f, -0.081772f},  {-0.296017f, 0.839688f, -0.455300f},  {0.963788f, 0.221147f, 0.149016f},  
     {0.410908f, -0.257780f, -0.874474f},  {0.883476f, -0.390299f, 0.259108f},  {-0.347633f, -0.178808f, 0.920423f},  {0.213906f, 0.348190f, 0.912693f},  
     {-0.511293f, 0.846835f, 0.146459f},  {-0.142156f, -0.522701f, -0.840581f},  {0.409284f, -0.903272f, 0.128790f},  {0.277691f, -0.620561f, 0.733343f},  
     {-0.233893f, 0.748483f, -0.620537f},  {-0.798010f, -0.602642f, 0.001414f},  {0.005710f, -0.364827f, -0.931058f},  {-0.162432f, -0.245305f, -0.955741f},  
     {0.242882f, 0.933247f, -0.264686f},  {0.813793f, 0.235873f, 0.531135f},  {0.851469f, 0.514368f, 0.102104f},  {0.661806f, -0.544253f, -0.515560f},  
     {-0.234889f, 0.316609f, -0.919014f},  {-0.109604f, 0.698722f, 0.706947f},  {0.563920f, 0.825694f, -0.014957f},  {0.739038f, -0.654948f, 0.157690f},  
     {-0.180942f, 0.829291f, 0.528713f},  {0.981913f, 0.126456f, -0.140908f},  {0.062704f, -0.944968f, 0.321097f},  {-0.822769f, -0.072844f, -0.563689f},  
     {-0.089358f, -0.829427f, -0.551422f},  {-0.005444f, 0.957466f, 0.288493f},  {0.106183f, 0.897356f, 0.428342f},  {-0.599305f, -0.268704f, 0.754076f},  
     {-0.028187f, 0.998128f, -0.054286f},  {0.905033f, -0.374169f, -0.202269f},  {0.382004f, 0.923994f, 0.017522f},  {0.900378f, -0.292111f, 0.322477f},  
     {0.103694f, -0.061755f, -0.992690f},  {0.641652f, 0.762993f, -0.078259f},  {-0.190476f, 0.883140f, -0.428699f},  {-0.390668f, -0.359960f, 0.847235f},  
     {-0.736560f, 0.673176f, 0.065675f},  {0.311434f, 0.851662f, 0.421522f},  {0.308816f, 0.896578f, 0.317460f},  {-0.382282f, 0.882079f, -0.275314f},  
     {0.605788f, -0.637044f, -0.476651f},  {0.717005f, 0.151347f, -0.680440f},  {-0.864934f, 0.484760f, 0.129988f},  {-0.797694f, 0.603061f, -0.001193f},  
     {-0.779433f, -0.552333f, 0.295656f},  {0.749984f, 0.594623f, -0.289736f},  {-0.883541f, -0.334684f, 0.327631f},  {-0.191930f, 0.196461f, 0.961544f},  
     {-0.446828f, 0.061891f, -0.892476f},  {0.919233f, 0.122498f, -0.374173f},  {-0.635817f, -0.274304f, -0.721453f},  {-0.585324f, 0.299073f, 0.753625f},  
     {-0.662957f, 0.748613f, 0.008192f},  {0.241753f, 0.553045f, -0.797306f},  {0.957090f, -0.288544f, -0.026866f},  {0.303854f, 0.410533f, 0.859730f},  
     {0.191303f, 0.783739f, -0.590895f},  {-0.310132f, 0.872340f, 0.377944f},  {0.732389f, 0.556448f, 0.392393f},  {0.081128f, 0.770926f, -0.631737f},  
     {0.441651f, -0.752198f, -0.489023f},  {-0.768994f, -0.297558f, -0.565780f},  {-0.694452f, -0.544782f, 0.470053f},  {-0.378910f, -0.460021f, -0.803000f},  
     {0.358732f, -0.906068f, 0.224393f},  {0.795509f, -0.062554f, -0.602704f},  {-0.618574f, -0.613727f, -0.490617f},  {-0.039002f, -0.823445f, 0.566054f},  
     {0.846508f, -0.462080f, -0.264397f},  {-0.032672f, 0.167162f, -0.985388f},  {0.155063f, 0.968067f, -0.196979f},  {0.560007f, -0.206292f, 0.802394f},  
     {-0.428958f, -0.247302f, 0.868813f},  {-0.829162f, 0.157985f, -0.536219f},  {0.572107f, -0.426052f, 0.700838f},  {0.787461f, -0.570814f, 0.232542f},  
     {-0.343240f, 0.253286f, -0.904452f},  {-0.417518f, -0.875298f, -0.243993f},  {0.565751f, -0.724372f, 0.393968f},  {0.233999f, 0.004401f, 0.972227f},  
     {-0.712090f, 0.499570f, 0.493314f},  {0.150229f, -0.167384f, -0.974379f},  {-0.030870f, 0.746236f, -0.664966f},  {-0.429884f, -0.675698f, 0.598859f},  
     {-0.789808f, 0.389867f, -0.473505f},  {0.598894f, 0.229606f, 0.767207f},  {0.529575f, 0.810063f, -0.251692f},  {-0.497171f, 0.781550f, 0.376829f},  
     {-0.679886f, -0.524351f, -0.512652f},  {-0.382754f, -0.751754f, 0.536997f},  {-0.290385f, 0.573372f, -0.766108f},  {0.188031f, 0.981271f, 0.041844f},  
     {-0.663894f, -0.493717f, 0.561683f},  {0.837349f, 0.382634f, 0.390432f},  {0.649086f, -0.449984f, 0.613352f},  {0.922578f, 0.020514f, 0.385264f},  
     {0.407456f, 0.875118f, 0.261052f},  {-0.883133f, -0.029440f, -0.468198f},  {-0.688205f, -0.044932f, -0.724124f},  {-0.322332f, -0.909348f, 0.263036f},  
     {0.678488f, 0.060191f, 0.732141f},  {-0.601149f, -0.088574f, -0.794213f},  {0.059593f, 0.805382f, 0.589753f},  {0.599402f, 0.362882f, -0.713466f},  
     {0.749635f, -0.660399f, 0.043815f},  {-0.867360f, -0.324136f, -0.377654f},  {0.511181f, -0.859052f, -0.026914f},  {0.655399f, -0.710968f, -0.254906f},  
     {-0.975637f, -0.139990f, -0.168924f},  {-0.788000f, 0.573266f, -0.224547f},  {-0.230310f, 0.972793f, -0.025114f},  {0.484739f, -0.399556f, 0.778064f},  
     {-0.960335f, 0.076348f, 0.268193f},  {-0.910074f, 0.241477f, -0.336830f},  {0.492565f, 0.404602f, 0.770504f},  {0.458822f, 0.728311f, 0.508965f},  
     {-0.388475f, 0.167884f, 0.906037f},  {-0.137004f, 0.258282f, -0.956306f},  {-0.839217f, -0.445915f, 0.311247f},  {-0.672312f, 0.697200f, 0.248813f},  
     {-0.352881f, -0.933940f, 0.056849f},  {-0.915780f, -0.290587f, -0.277321f},  {0.419524f, -0.903070f, -0.091999f},  {0.896618f, -0.083997f, 0.434765f},  
     {-0.895435f, 0.266016f, 0.356975f},  {-0.170888f, 0.623007f, -0.763321f},  {-0.855629f, 0.318845f, -0.407722f},  {0.302037f, -0.897946f, 0.320103f},  
     {-0.836443f, 0.329716f, 0.437779f},  {-0.865963f, 0.438696f, 0.240112f},  {0.920601f, -0.389570f, 0.026984f},  {-0.025255f, 0.756834f, 0.653119f},  
     {0.185096f, -0.715486f, -0.673662f},  {-0.144997f, 0.152544f, -0.977602f},  {-0.986381f, -0.158647f, 0.043410f},  {0.510607f, -0.670558f, -0.538176f},  
     {0.749839f, -0.657809f, -0.070914f},  {-0.533843f, 0.224240f, -0.815309f},  {0.489901f, 0.060827f, -0.869653f},  {-0.153968f, -0.168334f, 0.973631f},  
     {-0.093352f, 0.255116f, 0.962393f},  {0.792988f, 0.419071f, -0.442210f},  {0.227312f, 0.122458f, 0.966092f},  {0.697260f, -0.361159f, -0.619187f},  
     {0.893856f, 0.419815f, 0.157405f},  {-0.657043f, -0.686463f, -0.311550f},  {-0.825207f, -0.555199f, 0.103867f},  {-0.605835f, -0.774892f, 0.180297f},  
     {0.651185f, 0.757986f, 0.037637f},  {-0.710883f, -0.385730f, 0.588096f},  {-0.858258f, 0.513151f, -0.008309f},  {0.090362f, -0.811759f, 0.576959f},  
     {-0.417376f, -0.907846f, -0.040149f},  {0.350200f, 0.558042f, -0.752296f},  {-0.593643f, 0.373786f, -0.712651f},  {-0.041160f, -0.685428f, 0.726976f},  
     {-0.682953f, -0.610066f, -0.401741f},  {-0.969062f, 0.201511f, -0.142521f},  {0.698470f, -0.044089f, 0.714280f},  {-0.248790f, -0.032269f, -0.968020f},  
     {0.707210f, 0.434170f, -0.557988f},  {-0.260888f, -0.493877f, -0.829472f},  {-0.930088f, -0.101781f, 0.352955f},  {-0.296812f, 0.351036f, 0.888075f},  
     {0.726669f, -0.263129f, 0.634598f},  {0.218299f, -0.061123f, -0.973966f},  {0.152118f, 0.629519f, -0.761949f},  {-0.497380f, -0.753611f, -0.429748f},  
     {-0.148044f, -0.914726f, 0.375978f},  {0.833750f, -0.349436f, -0.427498f},  {-0.747024f, -0.274754f, 0.605364f},  {0.911260f, 0.327580f, -0.249591f},  
     {0.326757f, 0.466382f, -0.822021f},  {0.469353f, 0.640327f, -0.608021f},  {0.196082f, -0.489417f, 0.849719f},  {0.653666f, -0.346348f, 0.672877f},  
     {0.604361f, -0.640282f, 0.474117f},  {0.854335f, -0.288591f, 0.432236f},  {-0.765568f, -0.001869f, -0.643353f},  {-0.022046f, -0.543175f, -0.839330f},  
     {-0.712819f, 0.455115f, -0.533629f},  {0.102957f, 0.445585f, -0.889300f},  {-0.648753f, 0.724548f, -0.232701f},  {0.067841f, -0.374117f, 0.924897f},  
     {-0.954886f, -0.161269f, 0.249370f},  {0.319837f, 0.301080f, 0.898362f},  {-0.950517f, 0.300875f, 0.077403f},  {-0.262491f, 0.544174f, 0.796852f},  
     {-0.986620f, 0.014765f, 0.162365f},  {0.633146f, 0.490703f, 0.598613f},  {-0.192622f, -0.579948f, 0.791554f},  {0.662613f, 0.256669f, -0.703609f},  
     {-0.252987f, -0.374653f, 0.891983f},  {0.906079f, 0.200181f, 0.372758f},  {0.813200f, -0.570974f, -0.112670f},  {-0.474088f, -0.250688f, -0.844036f},  
     {-0.155542f, 0.544393f, 0.824283f},  {0.874993f, 0.028269f, 0.483310f},  {-0.944511f, -0.179060f, -0.275383f},  {-0.976369f, 0.132096f, 0.171041f},  
     {0.060670f, 0.693176f, -0.718210f},  {0.870960f, 0.407777f, 0.274130f},  {-0.697942f, 0.071409f, -0.712585f},  {-0.217025f, 0.923728f, 0.315637f},  
     {-0.750286f, -0.439619f, 0.493766f},  {0.789170f, -0.171414f, 0.589769f},  {-0.505927f, -0.134000f, -0.852104f},  {-0.039431f, 0.304765f, -0.951611f},  
     {0.291697f, 0.952342f, 0.089201f},  {0.053697f, -0.262809f, 0.963352f},  {0.481561f, -0.501027f, 0.719077f},  {-0.415432f, 0.724976f, -0.549387f},  
     {0.676270f, -0.736263f, -0.023987f},  {-0.436415f, -0.779638f, 0.449119f},  {0.617510f, -0.728539f, 0.296501f},  {-0.760176f, -0.641673f, -0.101918f},  
     {-0.497143f, -0.580509f, -0.644870f},  {0.041587f, -0.147098f, 0.988247f},  {-0.841268f, 0.020760f, 0.540220f},  {-0.685223f, -0.344696f, -0.641602f},  
     {0.608193f, -0.010243f, 0.793723f},  {0.092265f, 0.989840f, 0.108181f},  {-0.392565f, 0.904712f, -0.165497f},  {-0.620264f, -0.667315f, 0.412266f},  
     {-0.556909f, 0.645972f, 0.522086f},  {0.261884f, -0.836594f, -0.481173f},  {-0.921414f, -0.103349f, -0.374587f},  {-0.134921f, 0.985958f, -0.098398f},  
     {-0.682659f, 0.262571f, 0.681933f},  {0.475242f, -0.607800f, -0.636179f},  {0.933017f, -0.293426f, 0.208278f},  {-0.472714f, -0.580229f, 0.663231f},  
     {0.051610f, -0.462424f, -0.885156f},  {-0.744778f, 0.344165f, -0.571713f},  {-0.997679f, -0.043628f, 0.052282f},  {0.628178f, 0.728463f, 0.273374f},  
     {-0.029511f, -0.432479f, 0.901161f},  {0.186003f, -0.974310f, 0.126976f},  {-0.294938f, 0.240382f, 0.924785f},  {0.807470f, 0.484237f, 0.336906f},  
     {-0.015764f, 0.414135f, -0.910079f},  {-0.809978f, 0.544774f, 0.217158f},  {0.329187f, 0.075275f, 0.941260f},  {0.909179f, -0.390859f, 0.143603f},  
     {0.863213f, 0.126933f, -0.488623f},  {0.646592f, 0.625334f, 0.436893f},  {0.775270f, -0.476115f, 0.415055f},  {0.717017f, -0.466827f, 0.517648f},  
     {0.083749f, 0.498744f, 0.862694f},  {-0.473683f, -0.870035f, -0.136614f},  {0.015542f, 0.210536f, 0.977463f},  {0.283317f, 0.717522f, -0.636313f},  
     {-0.712056f, 0.640978f, -0.286574f},  {0.816064f, -0.440535f, -0.374123f},  {0.772626f, -0.536964f, -0.338702f},  {-0.338513f, -0.452056f, 0.825260f},  
     {-0.625079f, 0.516690f, -0.585071f},  {0.394208f, 0.700823f, 0.594513f},  {0.105473f, 0.939003f, 0.327335f},  {0.284952f, -0.885206f, -0.367714f},  
     {-0.561744f, -0.761613f, -0.323094f},  {0.218954f, 0.704155f, 0.675444f},  {-0.881904f, 0.360525f, -0.303756f},  {0.178456f, -0.394351f, 0.901466f},  
     {-0.223126f, 0.428101f, -0.875754f},  {0.679587f, 0.051818f, -0.731763f},  {-0.835920f, -0.541501f, -0.089522f},  {-0.882541f, -0.160735f, 0.441912f},  
     {-0.078017f, -0.603267f, 0.793714f},  {0.012818f, 0.681085f, 0.732092f},  {-0.009291f, -0.529014f, 0.848562f},  {0.046715f, 0.968217f, -0.245709f},  
     {-0.080351f, 0.573831f, -0.815022f},  {-0.145725f, 0.710766f, -0.688168f},  {0.309160f, 0.842843f, -0.440495f},  {0.002412f, -0.999742f, 0.022603f},  
     {-0.010698f, 0.819931f, -0.572362f},  {0.854583f, 0.519075f, -0.015769f},  {-0.821690f, -0.430325f, -0.373692f},  {0.817416f, -0.576045f, 0.001899f},  
     {-0.527320f, -0.014458f, -0.849544f},  {-0.149411f, 0.767455f, 0.623449f},  {0.224501f, -0.956053f, -0.188578f},  {0.117037f, 0.895685f, -0.429010f},  
     {0.222827f, 0.897406f, -0.380802f},  {-0.180137f, 0.076280f, 0.980679f},  {0.939186f, 0.108390f, 0.325853f},  {0.328345f, -0.053418f, -0.943046f},  
     {-0.970595f, 0.238574f, -0.032048f},  {-0.711635f, -0.672145f, -0.204442f},  {-0.238948f, -0.321594f, -0.916232f},  {0.390965f, 0.910085f, 0.137444f},  
     {0.337386f, -0.770866f, -0.540311f},  {-0.897463f, -0.433796f, -0.079886f},  {0.927580f, -0.268390f, -0.259926f},  {0.537064f, -0.044717f, -0.842355f},  
     {0.237331f, -0.879607f, 0.412269f},  {0.951879f, -0.292728f, 0.090755f},  {0.565208f, 0.796038f, 0.216479f},  {0.742269f, 0.309805f, 0.594187f},  
     {0.962241f, -0.073790f, -0.262007f},  {-0.307699f, 0.623871f, 0.718406f},  {0.422453f, 0.247408f, 0.871965f},  {0.539160f, -0.623454f, 0.566226f},  
     {0.279488f, 0.959673f, -0.030245f},  {0.996329f, 0.022293f, -0.082656f},  {-0.521790f, -0.820973f, -0.231816f},  {0.129199f, 0.049611f, 0.990377f},  
     {-0.696980f, 0.187525f, -0.692137f},  {-0.592873f, 0.801440f, 0.078707f},  {0.166931f, 0.043277f, -0.985018f},  {-0.480124f, 0.732732f, 0.482271f},  
     {-0.873773f, -0.400004f, -0.276619f},  {-0.012901f, -0.912225f, 0.409486f},  {-0.801852f, -0.186143f, -0.567788f},  {-0.045107f, -0.329169f, 0.943193f},  
     {0.996171f, -0.084114f, -0.023858f},  {-0.856674f, 0.386344f, 0.341830f},  {-0.231880f, -0.478535f, 0.846898f},  {0.469898f, 0.880975f, -0.055482f},  
     {0.122568f, -0.370678f, -0.920638f},  {0.797866f, -0.558818f, -0.226126f},  {-0.640277f, 0.371576f, 0.672292f},  {-0.095585f, -0.874238f, 0.475995f},  
     {-0.370154f, -0.618959f, 0.692730f},  {0.535283f, 0.164741f, -0.828452f},  {0.115565f, -0.904180f, 0.411222f},  {0.506851f, -0.849388f, -0.147110f},  
     {-0.932155f, 0.018372f, 0.361593f},  {-0.706167f, -0.649042f, 0.282972f},  {0.834755f, 0.504625f, 0.220312f},  {0.598118f, 0.113175f, 0.793376f},  
     {0.175015f, -0.658453f, 0.731990f},  {0.681964f, 0.168587f, 0.711690f},  {-0.061870f, -0.097721f, 0.993289f},  {-0.521022f, -0.484663f, 0.702594f},  
     {0.506027f, 0.774576f, -0.379430f},  {0.120338f, -0.992558f, 0.018657f},  {0.266908f, 0.262087f, -0.927400f},  {0.668627f, -0.154953f, -0.727274f},  
     {0.789728f, 0.496258f, -0.360635f},  {-0.525153f, -0.632576f, 0.569264f},  {-0.263415f, 0.092667f, -0.960222f},  {0.388640f, 0.464663f, 0.795643f},  
     {0.385853f, 0.058519f, -0.920702f},  {-0.512736f, 0.690233f, -0.510568f},  {-0.321021f, -0.707730f, 0.629336f},  {0.688216f, 0.527096f, 0.498527f},  
     {0.550620f, 0.824254f, -0.131996f},  {-0.746531f, 0.502183f, -0.436467f},  {-0.619811f, -0.436290f, 0.652293f},  {-0.952103f, 0.250226f, 0.175746f},  
     {-0.203542f, -0.811589f, -0.547626f},  {-0.625030f, 0.546405f, 0.557476f},  {0.576005f, -0.799718f, 0.169321f},  {-0.920113f, 0.140585f, 0.365551f},  
     {-0.212402f, -0.591425f, -0.777883f},  {0.279943f, 0.515299f, 0.809999f},  {-0.930859f, -0.277982f, 0.237122f},  {-0.411576f, 0.851656f, 0.324480f},  
     {-0.114705f, 0.961852f, 0.248360f},  {0.791403f, -0.379348f, 0.479350f},  {-0.472655f, 0.813525f, -0.338783f},  {0.898121f, 0.028326f, -0.438835f},  
     {-0.190677f, -0.946598f, -0.259989f},  {0.764963f, 0.579785f, 0.280503f},  {0.567578f, 0.448843f, 0.690214f},  {-0.718295f, 0.019057f, 0.695478f},  
     {0.557911f, 0.630178f, -0.540010f},  {-0.750322f, -0.117118f, -0.650616f},  {0.738898f, -0.647817f, -0.185371f},  {-0.445909f, 0.449281f, 0.774152f},  
     {-0.548513f, -0.089943f, 0.831290f},  {-0.771727f, -0.605941f, 0.193063f},  {0.389557f, -0.469889f, 0.792117f},  {-0.954358f, 0.163600f, -0.249872f},  
     {0.941212f, 0.213768f, 0.261579f},  {0.765206f, -0.267588f, -0.585539f},  {0.718569f, 0.422798f, 0.552178f},  {-0.207318f, -0.140518f, -0.968129f},  
     {0.904011f, 0.425670f, 0.039612f},  {0.833098f, -0.255828f, -0.490407f},  {-0.748959f, -0.656176f, 0.092159f},  {0.488842f, 0.714026f, -0.501199f},  
     {0.640134f, 0.609284f, -0.467976f},  {-0.505386f, -0.846381f, 0.168001f},  {-0.211547f, -0.736722f, 0.642253f},  {-0.127906f, -0.923337f, -0.362061f},  
     {-0.156628f, 0.963607f, -0.216631f},  {0.921315f, -0.069263f, -0.382597f},  {0.946934f, 0.025006f, -0.320453f},  {0.278776f, -0.328687f, 0.902358f},  
     {0.810474f, -0.574013f, 0.116792f},  {-0.576578f, 0.699549f, 0.422123f},  {0.829662f, 0.319861f, -0.457548f},  {0.166113f, -0.850908f, 0.498359f},  
     {-0.319367f, 0.777878f, -0.541212f},  {-0.728384f, 0.663284f, -0.171789f},  {0.371942f, -0.156608f, -0.914950f},  {-0.754848f, -0.462714f, -0.464866f},  
     {0.505938f, -0.711579f, 0.487526f},  {-0.248066f, 0.204902f, -0.946825f},  {0.205527f, 0.846356f, -0.491365f},  {-0.584536f, -0.564396f, -0.582902f},  
     {0.485957f, 0.770376f, 0.412755f},  {0.453036f, 0.558092f, -0.695192f},  {0.502793f, 0.643582f, 0.577063f},  {0.548501f, -0.341948f, -0.763033f},  
     {0.584884f, -0.785604f, -0.201836f},  {-0.330220f, 0.940087f, -0.084799f},  {-0.068741f, -0.447929f, -0.891423f},  {0.299022f, -0.709895f, -0.637679f},  
     {-0.241663f, -0.233284f, 0.941901f},  {-0.453500f, -0.664121f, -0.594375f},  {-0.397933f, 0.808356f, 0.433832f},  {0.943562f, -0.192562f, 0.269463f},  
     {0.351401f, 0.910941f, -0.216111f},  {-0.280253f, -0.848240f, -0.449385f},  {0.979374f, -0.183876f, -0.083759f},  {0.753604f, 0.076098f, 0.652908f},  
     {-0.933343f, -0.334258f, 0.130929f},  {-0.166157f, -0.681398f, -0.712804f},  {-0.692214f, 0.605435f, -0.392795f},  {-0.703203f, -0.601725f, 0.378726f},  
     {0.561707f, -0.527749f, 0.637155f},  {0.637248f, 0.534236f, -0.555434f},  {-0.867412f, -0.497410f, 0.013388f},  {-0.084646f, 0.141750f, 0.986277f},  
     {0.158039f, 0.252036f, -0.954726f},  {0.646352f, -0.238721f, 0.724735f},  {-0.546972f, -0.742301f, 0.387053f},  {-0.346488f, 0.693532f, 0.631632f},  
     {-0.031025f, 0.532425f, 0.845908f},  {0.008941f, -0.974844f, 0.222711f},  {-0.178482f, -0.973829f, 0.140717f},  {-0.506316f, 0.820548f, 0.265228f},  
     {-0.002827f, 0.918430f, 0.395573f},  {0.822582f, 0.512480f, -0.246422f},  {-0.639108f, -0.039639f, 0.768095f},  {-0.491232f, 0.519970f, 0.698801f},  
     {-0.358091f, 0.138806f, -0.923311f},  {0.183540f, -0.890671f, -0.415954f},  {-0.529900f, -0.203978f, 0.823164f},  {0.097425f, 0.734088f, 0.672029f},  
     {-0.838409f, -0.101087f, 0.535586f},  {0.531217f, -0.796473f, 0.288858f},  {-0.769412f, 0.114224f, -0.628456f},  {0.631551f, -0.125223f, 0.765156f},  
     {0.213320f, -0.556664f, -0.802882f},  {0.538452f, 0.550144f, 0.638287f},  {-0.542680f, -0.795714f, 0.268958f},  {-0.428874f, 0.779950f, -0.455790f},  
     {-0.153508f, -0.672472f, 0.724028f},  {-0.050004f, -0.700274f, -0.712120f},  {0.052530f, 0.597037f, 0.800492f},  {-0.926574f, 0.125003f, -0.354732f},  
     {0.751174f, -0.481390f, -0.451664f},  {-0.107777f, 0.477687f, -0.871894f},  {0.106140f, 0.391158f, 0.914183f},  {0.136009f, 0.939316f, -0.314939f},  
     {-0.804599f, -0.359137f, -0.472907f},  {0.796037f, 0.603612f, 0.044470f},  {-0.623288f, -0.781676f, -0.022229f},  {-0.493786f, 0.334852f, 0.802527f},  
     {-0.839224f, -0.502469f, 0.207914f},  {-0.388035f, -0.617864f, -0.683866f},  {-0.576622f, -0.541480f, 0.611806f},  {0.754394f, 0.194482f, 0.626951f},  
     {0.019351f, 0.865366f, 0.500766f},  {-0.062787f, 0.955236f, -0.289105f},  {-0.009261f, -0.775068f, -0.631810f},  {-0.723363f, -0.231189f, -0.650613f},  
     {-0.859488f, -0.276667f, 0.429809f},  {-0.054923f, 0.664195f, -0.745539f},  {-0.120559f, 0.788833f, -0.602667f},  {0.988422f, 0.119553f, 0.093428f},  
     {0.541435f, -0.721638f, -0.431377f},  {0.714887f, -0.156476f, 0.681507f},  {-0.643150f, 0.077004f, 0.761858f},  {0.050860f, 0.046216f, -0.997636f},  
     {-0.176817f, 0.930843f, -0.319792f},  {0.853964f, -0.484215f, 0.190476f},  {0.099803f, 0.970340f, 0.220182f},  {0.709444f, -0.650548f, 0.271063f},  
     {0.405266f, 0.371704f, -0.835222f},  {-0.510775f, 0.859430f, 0.022118f},  {0.787203f, 0.594959f, 0.162283f},  {0.449307f, -0.355051f, -0.819794f},  
     {0.389991f, -0.364457f, 0.845623f},  {0.972997f, -0.092595f, 0.211431f},  {0.948946f, -0.280848f, -0.143619f},  {-0.017160f, 0.997828f, 0.063598f},  
     {-0.528441f, 0.585767f, 0.614514f},  {0.573265f, -0.578612f, -0.580152f},  {0.722032f, 0.502319f, -0.475759f},  {-0.440992f, -0.522361f, -0.729839f},  
     {0.774206f, -0.364774f, -0.517247f},  {0.688962f, 0.681976f, -0.245437f},  {-0.498573f, -0.317040f, 0.806790f},  {0.464544f, -0.186029f, 0.865790f},  
     {0.940703f, -0.088186f, 0.327569f},  {-0.492768f, 0.863296f, -0.109089f},  {0.821519f, -0.481843f, 0.304850f},  {-0.166590f, -0.045466f, 0.984977f},  
     {-0.220914f, 0.436000f, 0.872411f},  {-0.283534f, -0.945148f, 0.162182f},  {-0.861496f, -0.473871f, -0.182404f},  {-0.451270f, -0.132149f, 0.882548f},  
     {-0.457709f, -0.425097f, 0.780894f},  {-0.009704f, -0.986458f, -0.163730f},  {-0.691130f, -0.215730f, 0.689782f},  {-0.327608f, 0.365271f, -0.871350f},  
     {0.368347f, -0.628554f, -0.685011f},  {0.931910f, -0.167335f, -0.321779f},  {0.999227f, 0.017499f, 0.035193f},  {0.670301f, -0.736657f, 0.089623f},  
     {0.304565f, -0.267086f, -0.914279f},  {-0.965283f, -0.218868f, 0.142570f},  {0.194851f, 0.456998f, 0.867863f},  {-0.663153f, -0.744124f, 0.080677f},  
     {0.632857f, -0.048338f, -0.772758f},  {0.193446f, -0.270922f, -0.942964f},  {-0.804611f, 0.498908f, 0.322011f},  {-0.493579f, -0.423648f, -0.759541f},  
     {-0.891660f, -0.041093f, 0.450836f},  {0.389480f, 0.715610f, -0.579835f},  {0.794490f, 0.137985f, -0.591393f},  {0.142073f, -0.639296f, -0.755722f},  
     {-0.143676f, -0.402916f, 0.903889f},  {-0.791978f, -0.331152f, 0.512942f},  {0.540843f, -0.088222f, 0.836484f},  {0.405344f, -0.772444f, 0.488904f},  
     {0.659274f, 0.385424f, 0.645605f},  {-0.842402f, -0.252147f, -0.476215f},  {-0.429723f, -0.358144f, -0.828897f},  {0.767990f, 0.457516f, 0.448185f},  
     {-0.284431f, 0.124533f, 0.950574f},  {-0.512517f, -0.705073f, 0.490100f},  {0.986730f, -0.078210f, -0.142292f},  {0.621613f, 0.452900f, -0.639124f},  
     {0.889250f, -0.258605f, -0.377303f},  {-0.390205f, -0.810892f, -0.436113f},  {-0.167783f, -0.873014f, -0.457925f},  {-0.620911f, 0.147225f, -0.769931f},  
     {0.333402f, -0.745716f, 0.576846f},  {0.434293f, 0.608905f, 0.663795f},  {0.362617f, -0.659838f, 0.658120f},  {0.697605f, -0.585245f, -0.413322f},  
     {0.290985f, -0.818851f, 0.494783f},  {-0.467520f, -0.811979f, 0.349450f},  {-0.868622f, -0.141996f, -0.474693f},  {-0.616629f, 0.029294f, -0.786709f},  
     {-0.240925f, 0.959955f, -0.142975f},  {0.979183f, 0.024849f, -0.201451f},  {0.431394f, 0.468524f, -0.770963f},  {0.557412f, 0.681424f, 0.474293f},  
     {0.327557f, 0.161014f, -0.931011f},  {-0.900410f, -0.214983f, -0.378211f},  {0.707556f, -0.446745f, -0.547524f},  {0.438304f, -0.690023f, 0.575985f},  
     {-0.409691f, -0.521255f, 0.748630f},  {0.360231f, 0.566312f, 0.741299f},  {-0.314871f, -0.783112f, -0.536277f},  {-0.013474f, -0.932229f, -0.361617f},  
     {-0.423518f, -0.742149f, -0.519468f},  {0.622642f, 0.758018f, -0.194231f},  {-0.910607f, 0.321693f, 0.259439f},  {0.434160f, 0.165704f, -0.885465f},  
     {-0.576433f, -0.807161f, -0.127346f},  {0.900421f, 0.427878f, -0.078500f},  {0.819506f, -0.161296f, -0.549903f},  {-0.448411f, 0.182916f, -0.874911f},  
     {0.173561f, 0.711151f, -0.681279f},  {-0.258609f, -0.893528f, 0.367054f},  {-0.422867f, 0.905603f, -0.032674f},  {0.225294f, -0.781428f, -0.581905f},  
     {0.588241f, 0.057935f, -0.806608f},  {0.747161f, -0.166560f, -0.643434f},  {-0.762859f, 0.206789f, 0.612605f},  {0.476351f, -0.147669f, -0.866766f},  
     {0.046790f, -0.964200f, -0.261014f},  {0.675730f, 0.277494f, 0.682925f},  {-0.896612f, 0.397592f, -0.194955f},  {0.067762f, -0.990119f, 0.122773f},  
     {-0.199676f, 0.315061f, 0.927829f},  {-0.816080f, 0.274788f, -0.508433f},  {-0.886638f, -0.447162f, 0.117976f},  {-0.500172f, 0.227194f, 0.835590f},  
     {-0.347290f, -0.707080f, -0.615977f},  {-0.940183f, 0.315506f, -0.128498f},  {0.973379f, 0.226582f, 0.034544f},  {0.953519f, 0.228237f, -0.196747f},  
     {-0.038833f, -0.263901f, -0.963768f},  {-0.222162f, 0.953371f, 0.204272f},  {0.874247f, -0.483847f, -0.039799f},  {0.325740f, -0.551430f, -0.767996f},  
     {-0.321953f, -0.293576f, 0.900089f},  {-0.123877f, -0.991656f, 0.035666f},  {0.686457f, 0.350021f, -0.637387f},  {-0.284335f, 0.929190f, -0.236135f},  
     {0.682892f, 0.649496f, 0.334385f},  {-0.984322f, 0.087616f, -0.153081f},  {-0.716215f, -0.697781f, -0.011700f},  {0.716692f, 0.575358f, -0.394102f},  
     {-0.073364f, -0.962129f, -0.262537f},  {0.940447f, 0.326265f, 0.095448f},  {0.963563f, -0.175512f, -0.201845f},  {0.470942f, -0.789803f, 0.392969f},  
     {-0.241261f, -0.902645f, -0.356407f},  {0.369258f, 0.923899f, -0.100297f},  {-0.262441f, -0.647529f, 0.715424f},  {0.305018f, 0.929384f, 0.207870f},  
     {-0.921787f, -0.386892f, 0.024970f},  {0.156991f, -0.576369f, 0.801968f},  {0.465804f, -0.598847f, 0.651467f},  {0.076488f, 0.345201f, -0.935407f},  
     {-0.624878f, -0.155009f, 0.765179f},  {0.470259f, -0.796646f, -0.379753f},  {-0.206851f, 0.821465f, -0.531421f},  {-0.547189f, 0.412302f, 0.728418f},  
     {0.523508f, 0.042837f, 0.850943f},  {0.366375f, -0.823735f, -0.432701f},  {-0.868800f, 0.207239f, 0.449710f},  {0.844269f, 0.519458f, -0.131810f},  
     {0.479931f, -0.292457f, 0.827124f},  {-0.119677f, 0.983493f, 0.135715f},  {0.369729f, 0.641826f, -0.671834f},  {-0.897708f, 0.433219f, -0.080266f},  
     {0.971205f, 0.113551f, 0.209445f},  {-0.226662f, 0.969759f, 0.090511f},  {-0.567775f, 0.481707f, -0.667526f},  {-0.810670f, 0.576266f, 0.103596f},  
     {-0.964737f, -0.042971f, 0.259685f},  {0.500398f, -0.440138f, -0.745574f},  {-0.649130f, 0.604610f, 0.461602f},  {-0.292237f, 0.824701f, 0.484218f},  
     {-0.350803f, 0.015614f, -0.936319f},  {0.505458f, 0.370223f, -0.779389f},  {0.924020f, 0.319190f, 0.210487f},  {0.392559f, -0.861305f, -0.322568f},  
     {-0.258336f, 0.663524f, -0.702138f},  {-0.730761f, 0.680255f, -0.056944f},  {-0.132097f, -0.977952f, -0.161741f},  {-0.998566f, 0.016334f, -0.050977f},  
     {-0.982946f, -0.102364f, 0.152771f},  {-0.582339f, 0.811343f, -0.051033f},  {-0.464032f, -0.883428f, 0.065029f},  {0.167959f, 0.559848f, 0.811394f},  
     {0.008409f, 0.882818f, -0.469641f},  {0.128530f, 0.540641f, -0.831377f},  {0.725085f, 0.688424f, -0.017992f},  {-0.613240f, 0.262900f, -0.744863f},  
     {0.282593f, -0.465287f, -0.838838f},  {-0.376402f, 0.755264f, 0.536562f},  {-0.931230f, 0.279689f, -0.233633f},  {-0.306282f, -0.950523f, -0.051942f},  
     {-0.681881f, 0.438179f, 0.585693f},  {-0.191499f, 0.629746f, 0.752827f},  {-0.742032f, 0.604056f, 0.290697f},  {-0.961321f, -0.273214f, 0.034872f},  
     {0.136485f, 0.653798f, 0.744258f},  {0.650544f, 0.743678f, 0.154062f},  {0.594795f, -0.799789f, -0.080967f},  {0.629913f, 0.158650f, -0.760289f},  
     {-0.550532f, -0.486801f, -0.678188f},  {-0.689630f, -0.699883f, 0.185943f},  {0.078705f, -0.269109f, -0.959888f},  {0.108903f, -0.782635f, -0.612881f},  
     {0.140387f, -0.743507f, 0.653826f},  {0.745489f, 0.247863f, -0.618717f},  {0.368584f, 0.787375f, 0.494151f},  {-0.238112f, -0.739000f, -0.630224f},  
     {-0.486159f, 0.554422f, -0.675475f},  {-0.537067f, 0.105859f, -0.836871f},  {0.435771f, 0.854396f, -0.283040f},  {-0.243651f, -0.968753f, 0.046384f},  
     {-0.340978f, 0.696415f, -0.631458f},  {-0.740597f, -0.604839f, -0.292721f},  {0.478742f, 0.875804f, 0.061424f},  {0.068033f, -0.685407f, 0.724975f},  
     {-0.115647f, -0.347751f, -0.930427f},  {-0.112861f, -0.967330f, 0.227012f},  {0.509313f, 0.293154f, 0.809112f},  {-0.124930f, 0.991958f, 0.020305f},  
     {0.670463f, -0.728775f, -0.139159f},  {-0.481604f, 0.846833f, -0.225679f},  {-0.055787f, -0.219848f, 0.973938f},  {0.933937f, 0.330532f, -0.136050f},  
     {0.573145f, 0.698113f, -0.429118f},  {0.285473f, -0.533314f, 0.796292f},  {0.068117f, -0.712082f, -0.698784f},  {-0.082995f, 0.913754f, -0.397701f},  
     {0.538149f, -0.509584f, -0.671357f},  {0.655390f, -0.729219f, 0.196735f},  {0.263689f, 0.953120f, -0.148424f},  {0.414435f, -0.909809f, 0.022147f},  
     {0.080295f, 0.996733f, -0.008701f},  {-0.211153f, -0.858462f, 0.467394f},  {-0.360210f, -0.289183f, -0.886917f},  {0.103087f, -0.931923f, -0.347695f},  
     {-0.602214f, 0.652609f, -0.459826f},  {-0.012036f, -0.057632f, -0.998265f},  {-0.660945f, 0.564337f, -0.494647f},  {-0.365599f, -0.918912f, -0.148117f},  
     {-0.710413f, -0.099880f, 0.696661f},  {0.570524f, -0.319705f, 0.756499f},  {0.865920f, -0.476172f, -0.153113f},  {-0.052978f, -0.886536f, -0.459616f},  
     {0.408425f, -0.889171f, -0.206309f},  {0.492003f, -0.829326f, -0.264861f},  {0.727572f, -0.367053f, 0.579578f},  {0.122501f, 0.167088f, 0.978302f},  
     {0.147094f, -0.842186f, -0.518735f},  {-0.746042f, 0.641506f, 0.178584f},  {-0.314435f, 0.474865f, -0.821970f},  {0.299728f, 0.367539f, -0.880385f},  
     {0.517072f, 0.174883f, 0.837885f},  {-0.129915f, 0.373362f, -0.918544f},  {-0.667293f, -0.160351f, -0.727329f},  {0.049228f, -0.603018f, 0.796207f},  
     {0.223860f, 0.236474f, 0.945498f},  {0.086963f, -0.482574f, 0.871527f},  {-0.269666f, -0.788404f, 0.552901f},  {0.032702f, -0.025720f, 0.999134f},  
     {-0.455129f, 0.675270f, 0.580403f},  {-0.563484f, 0.774047f, -0.288681f},  {0.207716f, 0.937619f, 0.278790f},  {-0.394800f, 0.374298f, 0.839067f},  
     {0.409611f, 0.357924f, 0.839112f},  {-0.010677f, 0.984014f, 0.177773f},  {0.879769f, 0.219338f, -0.421778f},  {-0.529433f, -0.672468f, -0.517192f},  
     {0.991960f, 0.124375f, -0.023375f},  {0.421527f, -0.852837f, 0.308194f},  {-0.903938f, 0.424815f, 0.049273f},  {0.718742f, -0.627486f, -0.299450f},  
     {-0.303005f, -0.553089f, 0.776067f},  {-0.002566f, 0.430237f, 0.902713f},  {-0.876186f, 0.200841f, -0.438133f},  {-0.886710f, 0.081555f, 0.455075f},  
     {0.118491f, -0.976123f, -0.182053f},  {0.764973f, 0.341690f, -0.545953f},  {0.407605f, 0.834408f, 0.370974f},  {0.508681f, -0.856181f, 0.090547f},  
     {0.138195f, -0.069239f, 0.987982f},  {-0.656121f, 0.745761f, -0.115521f},  {0.577412f, -0.148954f, -0.802750f},  {0.008365f, 0.322343f, 0.946586f},  
     {-0.783221f, -0.041056f, 0.620386f},  {0.168672f, -0.467172f, -0.867929f},  {-0.990849f, 0.128353f, -0.041757f},  {0.529758f, 0.464135f, -0.709884f},  
     {-0.326171f, 0.933072f, 0.151621f},  {0.250622f, 0.824016f, 0.508121f},  {-0.624475f, 0.198262f, 0.755462f},  {0.981187f, -0.189988f, 0.034313f},  
     {0.034232f, -0.164601f, -0.985766f},  {-0.083345f, -0.161892f, -0.983282f},  {0.325698f, 0.662029f, 0.675010f},  {0.963177f, 0.009239f, 0.268710f},  
     {-0.279106f, 0.895842f, -0.345785f},  {-0.556398f, 0.601057f, -0.573717f},  {0.180150f, 0.779251f, 0.600262f},  {0.943723f, 0.330099f, -0.020530f},  
     {-0.708868f, 0.142367f, 0.690825f},  {-0.464058f, -0.015643f, 0.885667f},  {-0.592637f, -0.693108f, -0.410345f},  {0.309140f, -0.915357f, -0.257980f},  
     {0.774720f, 0.605690f, -0.181517f},  {0.467222f, 0.509954f, 0.722254f},  {-0.285863f, -0.216685f, -0.933450f},  {-0.532599f, 0.741688f, -0.407722f},  
     {0.840933f, -0.081204f, 0.535012f},  {0.594873f, -0.802754f, 0.041382f},  {0.719539f, -0.056725f, -0.692132f},  {-0.401726f, 0.270572f, 0.874876f},  
     {-0.125567f, -0.058427f, -0.990363f},  {0.249849f, 0.613692f, 0.748971f},  {-0.060683f, -0.946221f, 0.317778f},  {-0.165967f, 0.044346f, -0.985134f},  
     {0.345298f, -0.365757f, -0.864287f},  {0.875394f, 0.323286f, -0.359404f},  {-0.731750f, 0.555356f, 0.395122f},  {0.327578f, 0.885826f, -0.328640f},  
     {-0.376061f, 0.843851f, -0.382744f},  {0.843793f, -0.387411f, 0.371384f},  {-0.610806f, -0.608915f, 0.506102f},  {-0.156239f, -0.812817f, 0.561175f},  
     {-0.986432f, -0.026369f, -0.162042f},  {-0.053974f, -0.990625f, 0.125491f},  {0.879137f, -0.358096f, -0.314460f},  {0.236049f, -0.371187f, -0.898054f},  
     {-0.327633f, -0.107090f, -0.938716f},  {-0.189013f, -0.980194f, -0.059111f},  {0.856525f, 0.272732f, 0.438159f},  {-0.110425f, 0.927189f, 0.357947f},  
     {-0.432295f, -0.864713f, 0.255717f},  {-0.930255f, 0.010135f, -0.366775f},  {-0.516730f, 0.337121f, -0.786981f},  {-0.423716f, 0.901293f, 0.090201f},  
     {0.969160f, -0.193669f, 0.152385f},  {-0.814257f, -0.506911f, -0.282890f},  {-0.203461f, 0.881992f, 0.425081f},  {0.164620f, -0.292179f, 0.942089f},  
     {-0.574738f, -0.205075f, -0.792225f},  {-0.093559f, 0.879829f, 0.465992f},  {-0.624934f, -0.721178f, 0.298931f},  {0.567303f, -0.758924f, -0.319690f},  
     {0.988264f, 0.012329f, 0.152258f},  {-0.456924f, 0.642464f, -0.615191f},  {0.957877f, 0.125454f, -0.258328f},  {0.255410f, -0.709512f, 0.656778f},  
     {-0.563048f, -0.378955f, 0.734418f},  {-0.376852f, 0.610006f, -0.697048f},  {-0.099685f, 0.858086f, -0.503738f},  {0.632562f, -0.548415f, 0.546906f},  
     {-0.257956f, -0.113551f, 0.959461f},  {0.216604f, 0.151895f, -0.964371f},  {-0.495666f, 0.446844f, -0.744745f},  {0.320602f, -0.946887f, -0.024888f},  
     {-0.851489f, 0.502725f, -0.149110f},  {-0.913772f, -0.219784f, 0.341638f},  {-0.073455f, 0.023580f, 0.997020f},  {0.027893f, -0.838845f, -0.543655f},  
     {-0.573001f, 0.801227f, -0.172352f},  {0.761329f, 0.042853f, -0.646948f},  {-0.669734f, 0.730357f, 0.134291f},  {-0.664120f, 0.655824f, 0.358942f},  
     {-0.964001f, 0.048498f, -0.261438f},  {0.661821f, -0.648537f, 0.376022f},  {-0.661578f, 0.410007f, -0.627861f},  {-0.993560f, -0.096595f, -0.059232f},  
     {-0.065513f, -0.995667f, -0.065994f},  {0.454977f, 0.873972f, -0.170786f},  {-0.591102f, 0.482287f, 0.646528f},  {0.593834f, 0.742189f, -0.310671f},  
     {0.686554f, -0.267953f, -0.675903f},  {-0.045476f, 0.983669f, -0.174148f},  {-0.155558f, -0.297061f, 0.942102f},  {-0.914595f, -0.364076f, -0.175967f},  
     {-0.311345f, -0.393056f, -0.865200f},  {0.338103f, -0.042092f, 0.940167f},  {-0.365908f, -0.857958f, 0.360581f},  {0.588070f, 0.341665f, 0.733102f},  
     {0.011018f, 0.513908f, -0.857774f},  {0.298785f, 0.785264f, -0.542298f},  {0.770468f, -0.060437f, 0.634607f},  {-0.621419f, -0.751822f, -0.220458f},  
     {-0.885639f, 0.084895f, -0.456548f},  {-0.771255f, -0.159897f, 0.616116f},  {-0.374592f, 0.052167f, 0.925721f},  {0.548563f, 0.550284f, -0.629497f},  
     {-0.403013f, -0.180016f, -0.897315f},  {0.853123f, -0.186366f, 0.487287f},  {0.822174f, 0.129440f, 0.554324f},  {0.063820f, 0.989763f, -0.127657f},  
     {-0.672119f, -0.731536f, -0.114507f},  {0.711876f, 0.689663f, -0.132657f},  {0.211010f, 0.893905f, 0.395486f},  {0.792954f, 0.351703f, 0.497523f},  
     {-0.892499f, -0.392128f, 0.222893f},  {-0.232062f, 0.702359f, 0.672933f},  {-0.937544f, 0.347157f, -0.022224f},  {-0.125360f, -0.761071f, -0.636440f},  
     {-0.539781f, -0.319073f, -0.778992f},  {0.173148f, 0.981766f, -0.078459f},  {-0.980000f, 0.185956f, 0.070856f},  {-0.589096f, 0.744261f, 0.314709f},  
     {-0.432970f, 0.297037f, -0.851062f},  {-0.568423f, -0.819328f, 0.074807f},  {0.512835f, -0.247236f, -0.822116f},  {-0.095068f, -0.615577f, -0.782322f},  
     {-0.805205f, 0.269637f, 0.528149f},  {-0.320948f, 0.908951f, 0.266085f},  {-0.324614f, 0.460146f, 0.826373f},  {0.923516f, 0.224716f, -0.310840f},  
     {0.446694f, -0.078360f, 0.891249f},  {0.231093f, -0.972618f, 0.024702f},  {0.834803f, 0.033804f, -0.549509f},  {-0.943937f, -0.322223f, -0.071803f},  
     {-0.800182f, 0.589774f, -0.108979f},  {0.016580f, -0.760829f, 0.648741f},  {-0.598147f, -0.386855f, -0.701829f},  {-0.419797f, 0.883179f, 0.209202f},  
     {0.879596f, 0.137313f, 0.455474f},  {-0.200285f, 0.529687f, -0.824207f},  {-0.323903f, -0.827153f, 0.459244f},  {0.250853f, -0.943508f, 0.216485f},  
     {-0.420911f, 0.610611f, 0.670812f},  {0.024001f, -0.631745f, -0.774804f},  {0.429145f, 0.026442f, 0.902848f},  {0.599775f, 0.589333f, 0.541255f},  
     {0.572272f, 0.265782f, -0.775799f},  {0.217008f, -0.786925f, 0.577631f},  {-0.250431f, -0.955425f, -0.156354f},  {-0.625887f, 0.696380f, -0.351169f},  
     {-0.210488f, -0.939830f, 0.269099f},  {0.200742f, 0.966140f, 0.162099f},  {-0.524164f, -0.851062f, -0.030763f},  {-0.072052f, 0.618782f, 0.782251f},  
     {-0.914060f, 0.373915f, 0.157104f},  {0.263136f, -0.223095f, 0.938610f},  {0.871240f, -0.485122f, 0.074819f},  {-0.951887f, -0.252715f, -0.173341f},  
     {0.433862f, -0.537999f, -0.722717f},  {0.713426f, 0.665803f, 0.218474f},  {-0.762789f, 0.230361f, -0.604224f},  {0.263269f, 0.639623f, -0.722199f},  
     {0.374556f, -0.260869f, 0.889750f},  {0.116947f, 0.280611f, 0.952670f},  {0.852018f, 0.418083f, -0.315076f},  {0.257142f, -0.638153f, -0.725699f},  
     {0.027987f, 0.932168f, -0.360942f},  {0.815236f, 0.022579f, 0.578689f},  {0.894801f, 0.306321f, 0.324805f},  {-0.377878f, 0.538946f, 0.752825f},  
     {0.278384f, 0.050524f, -0.959140f},  {0.097177f, -0.554396f, -0.826560f},  {-0.780677f, 0.082881f, 0.619415f},  {0.918783f, -0.384748f, -0.088353f},  
     {-0.592957f, 0.779621f, 0.201477f},  {0.610532f, -0.253285f, -0.750398f},  {0.064722f, -0.891167f, -0.449034f},  {0.383352f, -0.566743f, 0.729276f},  
     {-0.414970f, 0.408082f, -0.813185f},  {-0.641771f, -0.462933f, -0.611411f},  {-0.723809f, -0.407635f, -0.556717f},  {-0.099097f, -0.755304f, 0.647839f},  
     {-0.772813f, -0.496913f, 0.394762f},  {-0.789973f, 0.446038f, 0.420706f},  {-0.329509f, 0.943513f, 0.034747f},  {0.636023f, -0.677334f, -0.369722f},  
     {0.626273f, -0.474185f, -0.618814f},  {-0.557619f, 0.024214f, 0.829744f},  {-0.941858f, 0.197007f, 0.272198f},  {0.727420f, 0.679081f, 0.098540f},  
     {-0.764962f, 0.388312f, 0.513855f},  {0.046031f, 0.239054f, -0.969915f},  {0.186747f, -0.929574f, 0.317833f},  {0, 0, 0} 
};


unsigned short closest_points10[MAXU10][MAXV10] = {
    {807,807,391,391,163,163,163,925,974,974,974,704,704,304,304,242,242,242,930,997,997,281,281,179,179,179,843,843,892,892,892,598,598,389,389,637,637,637,474,474,447,447,447,962,962,149,909,909,858,349,604,660,379,379,26,26,428,371,1000,1000,394,394,116,563,},
    {807,807,391,391,163,163,163,925,974,974,974,704,704,304,304,184,184,503,503,997,997,281,281,179,179,179,843,843,892,892,892,598,598,389,389,637,637,637,474,474,447,447,447,962,962,962,909,909,349,349,660,660,660,222,222,428,428,428,1000,1000,394,394,563,563,},
    {807,807,391,391,163,163,163,326,974,974,974,704,704,415,184,184,184,503,503,997,938,281,968,968,370,370,370,712,712,559,559,559,816,816,105,105,105,894,894,133,133,447,328,328,962,610,909,909,349,349,660,660,660,222,222,428,428,428,1000,1000,394,394,563,563,},
    {807,807,391,391,163,163,326,326,326,974,974,704,704,415,415,184,184,503,503,938,938,938,968,968,277,370,370,712,712,559,559,559,816,816,105,105,105,894,894,133,133,133,328,328,610,610,610,125,125,349,660,660,660,222,222,428,428,428,1000,1000,394,394,563,563,},
    {807,807,391,391,163,163,326,326,326,0,0,704,415,415,415,417,417,417,551,551,938,938,968,968,277,277,460,460,83,83,83,674,674,25,25,675,675,675,959,959,814,814,328,328,610,610,610,125,125,747,747,660,409,222,222,428,428,1000,1000,1000,394,394,563,563,},
    {807,807,391,391,391,163,326,326,326,0,0,800,800,415,415,417,417,417,551,551,97,97,878,878,277,277,460,460,83,83,83,674,674,25,25,675,675,675,959,959,814,814,814,13,13,610,753,125,125,747,747,409,409,409,651,428,428,1000,1000,1000,394,394,563,563,},
    {807,807,391,391,391,226,326,326,326,0,0,800,800,800,169,417,417,551,551,551,97,97,878,878,878,998,998,722,722,689,689,689,847,847,771,771,675,255,959,959,865,814,478,13,13,753,753,125,275,747,747,409,409,409,651,651,428,640,1000,1000,394,394,563,563,},
    {807,807,391,391,391,226,226,326,326,0,0,800,800,169,169,169,665,665,383,383,97,97,878,878,998,998,998,722,722,689,689,689,847,847,771,771,255,255,255,865,865,478,478,13,825,753,753,275,275,275,976,409,409,651,651,651,640,640,1000,1000,394,394,563,563,},
    {807,807,391,391,391,226,226,326,43,0,0,800,800,169,169,169,665,665,383,383,383,943,943,177,177,998,285,285,228,228,689,464,847,653,653,771,24,255,255,865,865,478,478,825,825,753,753,275,275,275,976,976,409,651,651,651,640,640,1000,901,394,394,563,563,},
    {807,807,391,391,391,226,226,43,43,43,386,386,766,766,169,927,665,665,383,383,383,943,943,177,177,177,285,285,228,228,464,464,464,653,653,24,24,24,994,994,994,225,225,825,825,682,682,682,275,976,976,976,30,30,651,651,640,640,901,901,394,394,563,563,},
    {807,807,391,391,391,226,226,43,43,43,386,386,766,766,766,927,927,616,616,462,462,462,619,619,177,323,285,414,414,228,98,464,361,653,653,707,24,24,994,994,225,225,225,825,244,682,682,682,187,187,976,976,30,30,651,36,640,640,901,901,394,394,563,563,},
    {807,807,391,391,391,226,226,43,43,43,386,386,766,766,766,927,927,616,616,462,462,462,619,619,323,323,323,414,414,98,98,98,361,361,707,707,521,521,521,424,424,225,225,244,244,244,682,187,187,187,721,30,30,30,36,36,640,640,901,901,394,394,563,563,},
    {807,807,391,391,391,226,226,43,43,43,386,386,766,766,198,927,927,616,616,273,462,431,619,619,142,323,449,414,414,570,98,545,361,361,707,707,521,521,521,424,424,578,578,578,244,244,623,623,187,187,721,721,30,30,36,36,640,640,901,901,394,394,563,563,},
    {807,807,391,391,795,226,226,804,43,269,386,812,812,198,198,198,450,450,273,273,273,431,431,142,142,449,449,449,570,570,545,545,545,79,79,852,852,129,129,129,687,687,578,578,509,623,623,623,835,721,721,721,568,36,36,36,422,422,901,901,64,64,563,563,},
    {807,807,391,391,795,226,804,804,43,269,269,812,812,198,198,198,450,450,273,273,273,431,431,142,142,684,449,449,570,570,1019,545,545,79,79,852,852,129,129,129,687,687,468,509,509,509,623,835,835,835,721,721,568,568,36,36,422,422,901,901,64,64,563,563,},
    {807,807,31,391,795,795,804,804,269,269,269,812,812,198,198,198,450,450,533,273,975,975,329,329,684,684,684,989,989,1019,1019,1019,734,734,941,941,581,581,581,60,687,468,468,468,509,509,935,835,835,835,638,568,568,568,36,422,422,422,901,901,64,64,563,563,},
    {807,807,31,391,795,795,804,804,804,269,269,812,812,427,198,853,853,533,533,533,975,975,329,329,684,684,684,989,989,1019,1019,1019,734,734,941,941,581,581,581,60,60,468,468,468,452,935,935,935,835,638,638,638,568,568,799,422,422,422,901,901,64,64,563,563,},
    {807,31,31,795,795,795,804,804,804,269,269,139,812,427,427,853,853,533,533,533,975,975,639,329,75,75,319,319,745,745,745,232,232,117,117,649,649,581,919,60,60,772,772,452,452,935,935,489,489,638,638,638,568,799,799,799,422,422,512,901,64,64,563,563,},
    {807,31,31,795,795,795,804,804,87,269,139,139,139,427,427,853,853,629,629,490,490,639,639,639,75,75,319,319,745,745,745,232,232,117,117,649,649,649,919,919,772,772,772,452,452,257,257,489,489,638,638,256,256,799,799,799,422,422,512,512,64,64,563,563,},
    {807,31,31,795,795,795,804,804,87,87,139,139,139,427,427,645,629,629,629,490,490,639,639,639,75,75,319,382,382,22,22,22,102,102,432,432,649,170,919,919,420,772,467,467,257,257,257,489,489,237,237,256,256,799,799,799,422,512,512,512,64,64,563,563,},
    {807,31,31,795,795,795,993,804,87,87,139,139,139,441,645,645,645,629,629,341,199,199,199,488,488,67,67,382,382,22,22,22,102,102,432,432,170,170,170,420,420,420,467,467,467,257,257,710,489,237,237,256,256,799,799,34,34,512,512,512,64,64,563,563,},
    {807,31,31,31,795,795,993,993,87,87,139,139,441,441,645,645,645,629,341,341,341,199,199,488,488,67,67,67,38,38,762,762,102,403,432,432,917,170,170,420,420,420,12,467,609,609,710,710,710,237,237,256,256,50,50,34,34,512,512,512,64,64,563,563,},
    {807,31,31,31,795,795,993,993,87,87,602,602,441,441,441,645,842,842,341,341,341,754,754,488,826,826,180,180,38,38,762,762,403,403,403,917,917,758,758,69,69,69,12,12,609,609,710,710,710,237,237,137,50,50,50,34,34,512,512,512,64,64,563,563,},
    {807,31,31,31,795,795,993,993,87,87,602,602,441,441,861,861,842,842,842,28,28,754,754,826,826,826,180,180,180,375,375,114,114,403,693,917,917,758,758,69,69,69,12,12,609,609,335,710,991,991,137,137,50,50,50,34,34,512,512,1021,64,64,563,563,},
    {807,31,31,31,795,993,993,993,542,542,602,602,731,731,861,861,861,842,28,28,28,754,754,121,121,122,180,180,375,375,375,114,114,693,693,693,500,500,867,867,69,358,358,929,929,335,335,335,991,991,137,137,137,50,50,34,34,699,512,1021,64,64,563,563,},
    {807,31,31,31,334,993,993,993,542,542,602,602,731,731,861,861,345,345,28,28,28,837,121,121,121,122,122,695,695,375,292,114,114,693,693,693,500,500,867,867,867,358,358,929,929,335,335,335,991,991,137,137,733,50,265,265,699,699,1021,1021,64,64,563,563,},
    {807,31,31,31,334,334,993,993,542,542,602,602,731,731,731,744,345,345,345,846,837,837,837,121,942,122,122,695,695,292,292,292,388,388,778,778,778,96,96,867,368,358,486,486,929,140,335,656,656,250,250,733,733,733,265,265,699,699,1021,1021,1021,64,563,563,},
    {807,31,31,31,334,334,993,993,542,542,332,332,731,731,744,744,345,345,846,846,846,837,837,942,942,942,810,810,981,981,292,175,388,388,778,778,778,96,96,368,368,368,486,486,140,140,140,656,656,250,250,733,733,733,265,265,699,699,1021,1021,1021,64,563,563,},
    {807,31,31,31,334,334,993,831,542,542,332,332,332,731,744,744,744,527,846,846,57,57,57,942,942,810,810,810,981,981,175,175,175,949,949,154,154,154,543,543,368,367,486,486,140,140,140,656,656,250,250,733,733,733,265,265,699,699,1021,1021,1021,153,563,563,},
    {807,31,31,31,334,334,831,831,542,542,332,332,332,538,538,744,527,527,527,186,57,57,110,110,110,342,342,566,566,981,305,175,175,949,949,154,154,154,543,543,367,367,367,53,53,143,143,143,284,284,250,9,733,928,265,265,699,699,1021,1021,1021,153,563,563,},
    {807,31,31,31,334,334,831,831,821,821,332,332,538,538,538,353,527,527,527,186,186,57,110,110,110,342,342,566,566,305,305,305,780,780,939,939,154,355,543,543,367,367,367,53,53,143,143,143,284,284,9,9,928,928,928,324,699,699,1021,1021,1021,153,563,563,},
    {807,31,31,31,334,334,831,831,821,821,821,516,538,538,538,353,353,527,186,186,186,552,552,520,520,342,109,566,566,305,305,780,780,780,939,939,355,355,355,996,996,732,732,732,360,360,143,143,284,284,9,9,928,928,928,324,324,699,291,1021,153,153,563,563,},
    {807,31,31,31,334,334,831,831,821,821,821,516,516,538,353,353,353,215,215,186,56,552,552,520,520,109,109,109,813,813,575,575,112,112,112,921,921,355,553,996,996,732,732,732,360,360,166,166,284,557,9,9,928,928,928,324,324,291,291,1021,153,153,15,563,},
    {807,31,31,31,334,334,831,831,821,821,821,516,516,983,983,353,353,215,215,56,56,552,889,520,520,109,109,109,813,813,575,575,112,112,112,921,921,553,553,553,775,775,732,898,360,360,166,166,166,557,557,356,356,928,928,324,324,291,291,1021,153,153,15,563,},
    {807,31,31,31,334,334,831,831,821,821,821,516,516,983,983,101,101,215,215,56,56,889,889,889,879,879,444,444,444,709,709,767,767,311,311,921,921,553,553,553,775,775,898,898,898,558,558,166,557,557,557,356,356,928,541,324,324,291,291,291,153,153,15,15,},
    {807,31,31,511,334,334,224,831,41,821,51,516,516,983,983,101,101,101,365,365,56,104,889,889,879,879,444,444,444,709,709,767,767,311,311,311,472,472,564,564,775,118,898,898,558,558,558,357,357,557,557,356,356,541,541,324,324,291,291,291,153,153,15,15,},
    {807,31,31,511,334,224,224,41,41,51,51,51,280,280,983,101,101,101,365,365,104,104,886,886,886,287,287,677,677,713,713,713,194,194,311,636,472,472,564,564,118,118,118,702,702,558,558,357,357,209,209,356,356,541,541,801,801,291,291,291,153,153,15,15,},
    {807,31,31,511,511,224,224,41,41,51,51,51,280,280,741,741,101,945,365,365,104,104,886,886,886,287,287,677,677,713,713,713,194,194,636,636,636,683,564,844,118,118,118,702,702,92,92,357,357,209,209,356,969,541,541,801,801,291,291,291,153,153,15,15,},
    {807,31,31,511,511,224,224,41,41,41,51,51,280,280,741,741,945,945,945,72,72,719,719,886,141,141,957,957,836,836,713,1014,1014,493,493,636,683,683,683,844,844,82,82,702,702,92,92,92,724,209,209,969,969,541,541,801,801,291,291,201,153,153,15,15,},
    {807,906,31,511,511,224,224,41,41,41,51,51,280,280,741,741,945,945,945,72,72,719,719,141,141,141,957,957,836,836,836,1014,1014,493,493,493,683,683,123,844,844,82,82,480,480,92,92,724,724,724,209,969,969,969,541,801,801,801,201,201,153,153,15,15,},
    {807,906,31,511,511,224,224,41,41,41,588,588,280,271,271,385,385,945,515,72,72,719,719,498,141,443,957,957,967,836,883,1014,658,658,493,306,306,123,123,868,868,868,82,480,480,480,760,724,724,724,174,969,969,348,348,801,801,201,201,201,153,153,15,15,},
    {807,906,31,511,511,224,224,668,668,588,588,588,271,271,271,385,385,515,515,515,737,737,498,498,498,443,443,967,967,883,883,883,658,658,658,306,306,123,123,868,868,868,535,480,480,760,760,760,724,174,174,969,969,348,348,801,801,201,201,201,153,153,15,15,},
    {807,906,511,511,511,224,224,668,668,668,588,588,271,271,271,385,385,515,515,515,737,737,498,498,498,443,443,967,967,88,883,569,569,658,585,585,769,769,446,446,446,535,535,295,295,760,760,897,897,174,174,174,798,348,348,348,100,201,201,201,217,153,15,15,},
    {807,906,906,511,511,224,224,668,668,668,588,588,958,271,999,999,385,972,515,808,808,395,395,171,171,171,519,519,88,88,88,569,569,585,585,585,769,769,446,446,446,535,535,295,295,295,760,897,897,174,174,798,798,348,348,100,100,201,201,201,217,153,15,15,},
    {807,906,906,511,511,131,131,668,668,668,247,958,958,958,999,999,972,972,972,808,808,395,395,171,171,171,519,519,1004,88,393,393,569,729,729,908,908,809,809,446,855,855,429,429,295,893,893,897,897,49,49,798,798,348,348,100,100,201,201,217,217,153,15,15,},
    {807,906,906,511,511,131,131,668,668,247,247,958,958,958,999,999,972,972,972,808,808,395,395,477,477,951,951,1004,1004,1004,393,393,729,729,729,908,908,809,809,809,855,855,429,429,429,893,893,756,897,49,49,798,798,595,595,100,100,100,201,217,217,217,15,15,},
    {807,906,906,511,511,131,131,668,668,247,247,247,958,958,999,999,523,972,576,576,308,308,477,477,477,951,951,1004,1004,910,393,136,136,729,829,829,266,266,809,979,979,855,784,429,845,845,893,756,756,49,49,1008,798,595,595,100,100,100,201,217,217,217,15,15,},
    {807,906,906,511,511,131,131,131,322,247,247,811,811,455,455,455,523,523,576,576,308,308,308,477,911,911,203,203,910,910,910,136,136,136,829,829,266,266,266,979,979,784,784,784,845,845,756,756,756,49,49,1008,1008,595,595,100,100,485,485,217,217,217,15,15,},
    {807,906,906,511,511,131,131,322,322,247,247,811,811,455,455,455,523,523,576,576,437,308,718,718,911,911,203,203,203,910,120,120,136,725,725,481,481,266,336,979,979,784,784,784,845,845,756,756,756,902,902,1008,1008,595,595,160,100,485,485,217,217,217,15,15,},
    {807,906,906,511,511,131,131,322,322,322,247,811,811,455,455,455,523,918,918,437,437,437,718,718,911,911,742,203,797,797,120,120,725,725,725,481,481,336,336,336,506,506,786,786,340,340,714,714,902,902,902,1008,1008,595,595,160,160,485,485,217,217,217,15,15,},
    {807,906,906,511,369,131,131,322,322,322,859,811,811,547,455,703,703,918,918,437,437,437,718,866,866,742,742,742,797,797,120,120,127,127,964,481,481,193,336,506,506,506,786,786,340,340,714,714,714,902,902,1008,952,952,160,160,160,485,485,217,217,217,15,15,},
    {807,906,906,511,369,131,131,322,322,322,859,859,547,547,547,703,703,918,918,740,740,164,164,866,866,866,742,325,325,715,715,127,127,127,964,964,193,193,62,62,62,433,433,786,340,340,914,714,238,902,882,882,952,952,160,160,160,485,485,217,217,863,15,15,},
    {807,906,906,369,369,131,620,322,322,859,859,859,547,547,547,703,703,406,740,740,740,164,164,866,866,606,606,325,325,715,715,715,234,234,964,904,193,193,62,62,62,433,433,264,264,914,914,238,238,238,882,882,952,952,160,160,160,485,485,217,217,863,15,15,},
    {807,906,906,369,369,369,620,620,322,200,859,859,547,547,135,135,406,406,406,740,740,1020,1013,1013,1013,606,606,325,325,126,126,234,234,234,904,904,904,42,42,73,73,433,433,264,264,914,914,914,238,238,882,882,952,952,160,160,160,485,485,426,863,863,15,15,},
    {807,906,906,369,369,369,620,620,200,200,859,671,671,547,135,135,406,406,406,32,1020,1020,1020,1013,1013,606,213,213,213,126,126,818,234,711,711,904,904,42,42,73,73,168,168,168,317,317,914,20,238,735,882,221,221,952,655,160,524,524,426,426,863,863,15,15,},
    {807,906,906,369,369,369,620,620,200,200,200,671,671,671,135,135,312,312,32,32,1020,1020,1020,212,401,401,401,213,213,984,818,818,818,711,711,666,666,666,346,73,73,168,168,168,317,317,20,20,735,735,735,221,221,655,655,524,524,524,426,426,863,863,15,15,},
    {807,906,906,369,369,369,620,620,200,200,200,671,671,671,135,135,312,312,32,32,32,956,212,212,401,401,650,650,984,984,984,818,946,946,711,666,666,666,346,346,210,210,168,669,317,317,20,20,735,735,735,221,221,655,655,524,524,524,426,426,863,863,15,15,},
    {807,906,906,369,369,369,620,620,200,200,200,671,671,3,838,838,312,312,312,32,956,956,212,212,208,208,650,650,984,984,270,270,946,946,673,673,738,738,346,346,210,210,669,669,669,990,990,20,392,735,735,221,221,655,655,524,524,524,426,426,863,863,15,15,},
    {807,906,906,369,369,369,620,620,934,200,19,19,3,3,838,838,312,312,662,662,956,956,706,706,208,208,650,650,435,435,270,270,372,372,673,673,738,738,197,197,197,210,669,669,990,990,990,392,392,627,627,221,757,655,655,524,524,524,426,426,863,863,15,15,},
    {807,906,906,369,369,369,620,934,934,19,19,19,3,3,838,838,848,848,662,662,23,23,706,706,208,208,1018,1018,435,435,950,950,372,372,241,241,738,738,197,197,197,822,822,157,157,990,990,392,392,627,627,627,757,757,132,132,524,426,426,426,863,863,15,15,},
    {807,906,906,369,369,4,4,934,934,934,19,19,3,3,562,562,848,848,662,662,23,23,706,706,439,439,1018,1018,435,283,950,950,372,372,241,241,241,459,459,197,539,822,822,157,157,530,530,392,392,627,627,627,757,757,132,132,720,720,426,426,863,863,15,15,},
    {807,906,906,369,369,4,4,934,934,934,19,19,1017,3,562,562,848,848,1002,1002,23,23,823,823,439,439,1018,1018,283,283,950,950,834,834,834,241,459,459,459,539,539,932,932,157,157,530,530,530,286,286,627,757,757,757,132,132,720,720,426,426,863,863,15,15,},
    {807,906,906,587,369,4,4,934,934,934,19,1017,1017,1017,562,562,451,451,1002,1002,302,823,823,823,439,439,196,196,283,283,21,21,834,834,685,685,685,912,912,539,539,932,932,27,27,530,530,286,286,286,635,635,757,757,132,132,720,720,720,243,863,863,15,15,},
    {807,906,906,587,587,4,4,934,934,849,849,1017,1017,1017,562,562,451,451,1002,1002,302,302,823,823,412,412,196,196,272,272,21,21,727,727,727,685,685,912,912,881,881,932,932,27,27,27,262,262,286,286,635,635,364,364,132,132,720,720,243,243,863,863,15,15,},
    {807,906,906,587,587,4,4,934,934,849,849,1017,1017,1017,522,522,451,451,832,832,302,302,608,608,412,412,716,716,272,272,318,318,727,727,727,872,872,912,912,881,881,181,181,181,27,262,262,262,182,182,635,635,364,364,364,18,720,720,243,243,863,863,860,15,},
    {807,906,906,587,587,4,4,80,80,849,849,849,1017,522,522,522,451,451,832,832,528,528,608,608,246,246,716,716,716,728,318,318,318,915,915,872,872,63,63,881,881,181,181,181,107,107,262,262,182,182,635,185,364,364,18,18,720,720,243,243,243,863,860,15,},
    {807,906,906,587,587,4,4,80,80,849,849,456,456,522,522,522,788,788,832,832,528,528,608,608,246,246,716,716,728,728,728,318,915,915,915,192,192,63,63,310,310,310,634,107,107,107,453,453,182,182,185,185,364,364,18,18,18,720,243,243,243,860,860,15,},
    {807,906,906,587,587,4,4,80,80,80,849,456,456,456,522,788,788,788,933,933,528,528,351,351,246,246,268,268,268,728,218,218,218,915,915,192,192,282,282,310,310,634,634,634,107,107,453,453,182,182,185,185,185,290,18,18,18,876,243,243,243,860,860,785,},
    {807,906,906,587,587,4,900,80,80,591,591,456,456,456,700,700,788,788,933,933,33,33,351,351,905,905,268,268,601,601,601,218,218,39,39,192,192,282,282,641,641,634,634,634,398,398,453,453,802,802,185,185,290,290,18,18,876,876,243,243,243,860,860,785,},
    {807,906,906,587,587,900,900,80,80,591,591,591,456,700,700,700,594,594,933,933,33,33,33,556,905,905,905,442,601,601,601,743,743,39,39,987,987,282,282,641,641,641,617,617,398,398,555,555,802,802,888,888,290,290,290,18,876,876,243,243,243,860,860,785,},
    {807,906,906,587,587,900,900,80,80,591,591,591,526,526,700,700,594,594,254,254,33,33,556,556,556,905,442,442,442,504,504,743,743,963,963,987,987,205,205,205,641,617,617,617,398,398,555,555,802,802,888,888,290,290,290,936,876,876,876,243,860,860,860,785,},
    {807,906,906,587,587,900,900,900,86,591,591,591,526,526,111,111,594,594,254,254,254,613,556,556,556,130,130,442,504,504,504,696,696,963,963,923,923,205,205,189,189,189,617,617,145,145,555,555,134,134,888,888,290,290,936,936,876,876,876,243,860,860,860,785,},
    {807,906,906,587,587,900,900,900,86,86,591,526,526,526,111,111,66,66,254,254,613,613,613,40,40,130,130,944,944,504,504,696,696,377,377,923,923,396,396,189,189,544,544,544,145,145,303,303,134,134,888,888,279,279,936,936,876,876,876,463,860,860,860,785,},
    {807,906,418,587,587,900,900,900,86,86,156,156,526,526,111,111,66,66,66,233,233,613,613,40,40,202,202,944,944,670,670,696,696,377,377,377,590,396,396,362,362,544,544,544,1010,303,303,303,134,134,948,888,279,279,936,936,876,876,463,463,860,860,860,785,},
    {807,906,418,587,587,900,900,86,86,86,156,156,582,582,111,111,66,66,233,233,233,288,288,40,40,202,202,548,548,670,670,510,510,377,377,590,590,590,396,362,362,362,483,1010,1010,1010,303,303,966,134,948,948,279,279,936,936,854,854,463,463,860,860,860,785,},
    {807,906,418,587,587,900,900,86,86,86,156,156,582,582,582,896,896,66,434,233,233,288,288,1012,1012,202,202,548,548,548,230,510,510,350,350,590,590,885,885,885,362,483,483,1010,1010,1010,303,966,966,948,948,948,279,279,936,936,854,854,463,463,463,860,860,785,},
    {807,906,418,587,223,223,900,496,86,86,156,156,582,582,582,896,896,434,434,176,176,288,288,1012,1012,128,128,548,548,230,230,230,93,350,350,55,55,885,885,52,52,483,483,172,1010,1009,1009,966,966,966,948,948,618,279,782,782,854,854,463,463,463,860,860,785,},
    {807,906,418,418,223,223,496,496,86,680,680,119,582,582,896,896,896,434,434,176,176,146,146,146,1012,128,128,457,457,457,230,93,93,93,299,55,55,55,761,52,52,52,172,172,172,1009,1009,966,966,607,607,618,618,618,782,782,854,854,463,463,463,860,860,785,},
    {807,906,418,418,223,223,496,496,496,680,680,119,119,592,592,896,419,434,550,550,176,146,146,146,507,507,413,457,457,457,466,466,93,299,299,299,55,761,761,761,240,240,172,172,172,1009,1009,748,748,607,607,618,618,618,782,782,854,854,463,463,463,860,860,785,},
    {807,906,418,418,223,223,496,496,496,680,680,119,119,592,592,419,419,419,550,550,550,870,870,507,507,507,413,413,749,466,466,466,686,686,299,299,373,373,761,761,240,240,150,150,487,487,748,748,748,607,607,618,618,618,782,782,854,854,463,463,463,860,860,785,},
    {807,807,418,418,223,223,496,496,496,680,680,119,119,592,592,419,419,419,550,550,870,870,870,307,307,413,413,413,749,749,603,686,686,686,940,940,373,373,229,229,240,240,150,150,487,487,300,748,748,607,607,147,618,924,782,782,854,854,95,463,841,860,860,785,},
    {807,807,418,418,223,223,496,496,496,680,680,119,339,592,592,644,419,315,315,425,425,870,870,307,307,890,890,890,749,749,603,603,686,940,940,940,931,931,229,229,850,850,150,150,487,487,300,300,579,579,147,147,147,924,924,374,374,95,95,463,841,841,785,785,},
    {807,807,418,418,223,223,496,496,496,276,276,339,339,339,644,644,315,315,315,425,425,621,621,307,514,890,890,890,231,231,603,603,546,546,940,940,931,931,344,344,850,850,815,815,815,300,300,300,579,579,147,147,147,924,924,374,374,95,95,95,841,841,785,785,},
    {807,807,418,418,223,223,922,922,922,276,276,339,339,339,644,644,644,315,315,425,425,621,621,514,514,514,534,534,231,231,953,953,546,546,652,652,931,931,344,344,344,251,815,815,497,497,300,549,579,579,147,147,147,924,924,374,374,95,95,95,841,841,785,785,},
    {807,807,418,418,223,223,922,922,922,276,276,339,339,339,820,644,408,408,167,167,167,621,621,514,514,633,534,534,469,469,953,953,982,982,652,652,390,390,344,344,251,251,251,648,497,497,497,549,549,2,2,147,245,924,924,374,374,95,95,95,841,841,785,785,},
    {807,807,418,418,223,223,922,922,922,276,276,402,402,820,820,820,408,408,167,167,167,173,297,297,633,633,534,534,469,469,730,730,982,982,333,333,390,390,59,59,59,251,648,648,648,497,549,549,549,2,2,245,245,245,37,374,374,95,95,95,841,841,785,785,},
    {807,807,418,418,770,770,922,922,922,276,276,402,402,820,820,820,408,408,430,167,173,173,297,297,633,633,880,880,469,469,730,730,730,236,333,333,333,161,59,59,59,625,625,648,648,672,672,549,549,2,2,245,245,245,37,37,374,95,95,95,841,841,785,785,},
    {807,807,418,418,770,770,922,922,922,612,612,402,402,820,820,694,694,430,430,430,173,173,970,297,926,926,880,880,74,74,730,730,236,236,236,333,161,161,161,45,625,625,625,646,646,672,672,7,7,7,2,245,245,245,37,37,764,764,95,841,841,841,785,785,},
    {807,807,418,418,770,770,922,922,612,612,612,402,402,274,274,694,694,430,430,430,806,970,970,970,926,926,183,183,74,74,204,204,236,236,787,787,787,161,45,45,45,625,625,646,646,672,672,7,7,7,440,440,245,37,37,37,764,764,95,841,841,841,785,785,},
    {807,807,418,418,770,770,922,922,612,612,612,10,402,274,274,694,694,470,470,806,806,806,970,970,657,926,183,183,589,589,204,204,204,739,739,787,787,70,70,45,45,501,501,646,646,755,755,755,7,440,440,440,89,89,37,37,764,764,676,676,841,841,785,785,},
    {807,807,418,418,770,770,399,399,612,612,612,10,10,274,274,536,536,470,470,806,806,806,781,781,657,657,183,183,589,589,589,759,739,739,739,978,978,70,70,692,692,501,501,436,436,755,755,755,505,505,440,440,89,89,37,764,764,764,676,676,841,841,785,785,},
    {807,807,418,418,770,770,399,399,612,612,10,10,10,274,274,536,536,470,470,871,871,781,781,781,657,657,980,980,589,589,759,759,759,877,978,978,978,448,448,692,692,626,626,436,436,436,755,505,505,505,955,955,89,89,494,494,764,764,676,676,841,841,785,785,},
    {807,807,418,418,770,770,399,399,399,320,10,10,10,352,352,536,536,1011,1011,871,871,871,781,781,252,252,980,980,518,518,518,759,877,877,877,978,448,448,448,471,471,626,626,436,436,947,947,947,505,505,955,955,89,89,494,494,764,764,676,676,841,841,785,785,},
    {807,807,418,418,770,770,399,399,399,320,320,10,10,352,352,536,536,1011,1011,871,871,407,407,252,252,252,765,765,765,518,518,681,681,877,877,726,726,448,448,471,471,626,626,108,108,947,947,947,537,955,955,955,263,263,494,494,94,94,676,676,841,840,785,785,},
    {807,807,418,301,770,770,399,399,399,320,320,354,354,352,352,239,239,1011,1011,151,151,407,407,407,252,862,862,765,765,873,873,681,681,916,916,726,726,688,688,471,471,791,791,108,108,108,947,537,537,537,955,955,263,263,494,494,94,94,676,676,840,840,785,785,},
    {807,807,418,301,770,770,399,399,320,320,320,354,354,352,352,239,239,965,965,151,151,151,407,397,397,862,862,517,517,873,873,359,359,916,916,593,593,688,688,647,647,791,791,791,108,554,554,537,537,537,973,263,263,263,494,494,94,94,676,676,840,840,785,785,},
    {807,807,418,301,770,293,293,399,320,320,320,354,354,803,803,239,239,965,965,151,151,77,77,397,397,862,862,517,517,873,873,359,359,916,593,593,593,664,664,647,647,791,791,907,907,554,554,554,537,973,973,973,263,263,316,316,94,94,676,676,840,840,785,785,},
    {807,807,301,301,301,293,293,399,267,320,805,354,354,803,803,763,763,965,965,235,235,77,77,397,397,106,106,517,517,667,667,359,359,11,11,593,593,664,664,783,647,1006,1006,907,907,907,554,774,774,973,973,973,263,263,316,316,94,94,676,676,840,840,785,785,},
    {807,807,301,301,301,293,293,267,267,267,805,805,803,803,803,763,763,965,965,235,235,77,77,410,410,106,106,8,8,667,667,421,421,11,11,824,824,664,664,783,783,1006,1006,796,907,751,751,774,774,774,973,973,1001,316,316,316,94,94,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,267,267,267,805,805,803,803,803,763,763,752,752,235,235,479,479,410,410,1022,1022,8,8,321,321,421,421,81,81,824,824,824,46,783,783,525,796,796,796,751,751,774,774,611,611,1001,1001,316,316,316,94,94,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,267,267,267,805,805,697,697,697,416,416,752,752,977,977,479,479,380,1022,1022,1022,8,971,321,321,961,961,81,81,366,366,46,46,46,525,525,796,796,796,751,751,216,216,611,611,1001,1001,1001,316,316,404,750,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,267,267,267,805,805,697,697,697,416,416,752,752,977,977,479,479,380,380,1022,1022,971,971,321,321,961,961,81,81,366,366,366,46,46,525,525,309,796,659,659,216,216,216,611,611,1001,1001,833,833,404,404,750,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,267,267,347,805,258,697,697,697,416,416,895,895,977,977,632,632,380,380,211,211,971,971,14,14,14,903,903,58,58,366,851,851,343,343,309,309,309,659,659,216,216,216,611,611,532,532,833,833,404,404,404,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,887,267,347,347,258,258,697,697,91,91,895,895,977,977,632,632,71,71,211,211,148,148,14,14,14,903,903,58,58,58,851,851,343,343,705,309,309,376,659,495,495,995,995,532,532,532,833,833,404,404,404,750,750,840,840,785,785,},
    {807,807,301,301,301,293,293,887,347,347,347,258,258,773,91,91,91,895,895,628,628,632,632,71,71,211,817,148,148,90,90,779,779,206,206,58,792,792,723,723,705,705,705,376,376,495,495,495,995,995,532,532,532,833,833,404,404,404,750,750,840,840,785,785,},
    {807,807,301,301,301,1,887,887,347,347,347,258,258,773,773,91,91,630,630,628,628,615,615,71,71,817,817,148,65,90,90,779,779,206,206,206,792,792,723,723,705,705,705,376,376,495,495,495,995,995,679,532,736,833,833,875,404,605,750,750,840,840,785,785,},
    {807,807,301,301,301,1,887,887,887,347,347,35,773,773,773,91,91,630,630,628,628,615,615,691,691,817,817,65,65,65,827,827,190,190,206,411,792,793,793,701,701,701,144,144,78,78,78,596,596,679,679,679,736,736,875,875,404,605,750,165,840,840,116,785,},
    {807,807,807,301,1,1,887,887,887,347,35,35,35,773,773,1007,1007,630,630,643,643,615,615,691,691,691,529,65,65,827,827,827,190,190,411,411,411,793,793,701,701,701,144,144,78,78,78,596,596,679,679,679,736,736,875,875,605,605,605,165,165,840,116,785,},
    {807,807,807,301,1,1,887,887,887,475,35,35,35,773,1007,1007,1007,698,698,643,643,484,484,691,691,529,529,529,438,438,827,857,190,190,746,411,492,793,793,891,701,560,144,144,219,78,313,596,596,679,679,679,736,736,875,875,605,605,605,165,165,840,116,785,},
    {807,807,807,301,1,1,1,887,475,475,475,35,35,458,458,1007,1007,698,698,643,387,484,484,162,162,162,529,529,438,438,857,857,857,746,746,492,492,492,891,891,560,560,560,219,219,313,313,313,988,988,6,6,736,736,875,875,605,605,605,165,165,116,116,785,},
    {807,807,807,301,1,1,1,887,475,475,475,35,35,458,458,294,294,698,698,387,387,387,260,162,162,298,298,777,777,438,599,857,296,746,746,768,492,191,891,891,1015,560,560,219,219,313,313,313,988,988,6,6,6,864,864,875,605,605,605,165,165,116,116,785,},
    {807,807,807,828,1,1,1,985,475,475,475,572,572,458,458,294,294,698,698,387,387,260,260,260,913,298,298,777,777,777,599,599,296,296,768,768,768,191,191,1015,1015,124,124,124,577,577,313,776,988,988,6,6,6,864,864,600,600,605,605,165,165,116,116,785,},
    {807,807,807,828,1,1,1,985,985,475,475,572,572,458,195,294,294,508,508,508,899,260,260,913,913,913,567,567,777,103,599,599,296,296,768,768,454,191,191,1015,1015,124,124,124,577,577,776,776,776,717,717,6,864,864,864,600,600,605,605,165,165,116,116,785,},
    {807,807,807,828,1,1,985,985,985,475,992,572,572,195,195,294,294,508,508,508,899,899,68,68,913,913,567,567,103,103,188,188,188,220,220,454,454,454,819,819,631,631,124,99,577,577,776,776,776,717,717,571,571,864,864,600,600,48,48,165,165,116,116,785,},
    {807,807,807,828,828,1,985,985,985,992,992,572,572,195,195,195,158,158,508,899,899,899,68,68,76,76,567,159,103,103,188,188,188,220,220,454,454,819,819,819,631,631,99,99,99,1016,1016,776,717,717,717,571,571,864,84,600,600,48,48,165,165,116,116,785,},
    {807,807,807,828,828,1,985,985,985,992,992,572,708,195,195,158,158,158,178,178,899,331,68,68,76,76,76,159,159,476,476,363,363,363,278,278,405,405,338,338,338,631,540,99,642,1016,1016,17,17,717,491,571,571,84,84,600,600,48,48,165,165,116,116,785,},
    {807,807,807,828,828,61,61,985,985,992,992,708,708,708,789,789,158,158,178,178,331,331,331,330,330,76,586,159,159,476,476,363,363,363,278,278,405,405,338,338,338,540,540,642,642,1016,1016,17,17,491,491,571,571,84,84,600,600,48,48,165,165,116,116,785,},
    {807,807,807,828,828,61,61,985,44,992,992,708,708,708,789,789,259,259,178,178,331,331,331,330,330,586,586,565,565,565,986,986,678,678,790,790,790,152,152,337,337,540,540,642,642,227,227,17,17,491,491,954,954,84,84,482,482,48,48,249,249,116,116,785,},
    {807,807,828,828,828,61,61,44,44,44,992,583,708,708,789,789,259,259,259,794,794,445,445,330,869,586,586,565,565,565,986,986,678,678,790,790,790,152,152,337,337,337,580,580,642,227,227,17,17,491,491,954,954,84,84,482,482,48,48,249,249,116,116,785,},
    {807,807,828,828,828,61,61,44,44,44,583,583,708,155,789,789,259,259,259,794,794,445,445,445,869,869,85,85,327,327,327,214,214,1003,1003,790,113,152,874,874,253,253,580,580,580,227,227,920,920,1005,1005,954,954,954,84,482,482,48,48,249,249,116,116,785,},
    {807,807,828,828,828,61,61,44,44,44,583,583,155,155,155,513,513,248,248,248,29,29,445,261,869,869,85,85,327,327,327,214,214,1003,1003,113,113,113,874,874,253,253,253,580,461,461,920,920,920,1005,1005,954,954,663,663,482,482,48,48,249,249,116,116,563,},
    {807,807,828,828,828,61,61,44,44,44,583,583,155,155,155,513,513,248,248,248,29,29,261,261,261,115,115,314,314,327,381,214,138,138,1003,574,113,378,874,874,624,253,465,465,461,461,920,920,920,1005,1005,830,954,663,663,482,482,371,48,249,249,116,116,563,},
    {807,807,828,828,828,61,61,925,44,960,583,583,155,155,155,513,513,561,248,248,29,29,261,261,261,115,115,314,314,381,381,381,138,138,574,574,574,378,378,624,624,624,465,465,461,461,661,920,423,423,830,830,830,663,663,482,482,371,371,249,249,116,116,563,},
    {807,807,807,828,828,61,61,925,44,960,960,614,614,155,531,531,561,561,289,289,289,937,937,47,47,47,499,499,884,884,381,839,138,138,502,574,690,378,378,624,624,54,465,465,654,661,661,661,423,423,830,830,830,663,663,26,371,371,371,249,249,116,116,563,},
    {807,807,807,828,163,163,925,925,925,960,960,614,614,531,531,531,561,561,289,289,289,937,937,47,47,47,499,499,884,884,884,839,839,502,502,690,690,690,597,597,54,54,54,654,654,654,661,661,423,423,830,830,830,663,26,26,371,371,371,249,249,116,116,563,},
    {807,807,807,828,163,163,925,925,925,960,960,614,614,614,531,531,242,561,930,289,856,856,937,207,47,584,499,499,573,884,5,839,839,502,502,690,690,690,597,597,473,54,54,654,654,149,661,858,858,423,604,830,379,379,26,26,371,371,371,249,249,116,116,563,},
    {807,807,807,828,163,163,925,925,925,960,960,614,614,304,304,242,242,930,930,930,856,856,207,207,207,584,584,573,573,5,5,5,400,400,622,622,622,384,384,473,473,473,16,16,149,149,149,858,858,604,604,604,379,379,26,26,371,371,371,249,249,394,116,563,},
    {807,807,391,391,163,163,925,925,925,974,960,704,614,304,304,242,242,930,930,930,856,856,207,207,179,584,584,573,573,892,5,5,400,400,622,622,622,384,384,473,473,473,16,16,149,149,149,858,858,604,604,604,379,379,26,26,26,371,371,249,249,394,116,563,},
};

float normal_vectors8[256][3] = {
     {0.620990f, -0.725506f, -0.296670f},  {0.926086f, -0.328851f, -0.184994f},  {0.989311f, -0.139178f, -0.043501f},  {-0.368336f, -0.501176f, -0.783040f},  
     {-0.689223f, 0.213332f, -0.692431f},  {0.097225f, 0.315555f, -0.943913f},  {0.564576f, -0.635296f, 0.526927f},  {-0.414446f, 0.791886f, -0.448498f},  
     {0.557412f, 0.821430f, -0.120605f},  {0.286834f, 0.407354f, -0.867057f},  {0.387393f, 0.694886f, 0.605855f},  {0.736785f, -0.461236f, 0.494378f},  
     {0.332517f, 0.799797f, -0.499757f},  {0.736722f, 0.164753f, 0.655818f},  {-0.091900f, -0.796100f, -0.598147f},  {-0.612759f, 0.785115f, -0.090115f},  
     {0.730848f, -0.330125f, -0.597393f},  {-0.605073f, 0.728612f, -0.320954f},  {0.338634f, -0.657904f, -0.672673f},  {0.685574f, -0.058368f, 0.725659f},  
     {-0.772303f, -0.373938f, 0.513536f},  {-0.009803f, 0.999598f, -0.026611f},  {0.229527f, -0.308021f, -0.923277f},  {-0.717706f, -0.203851f, 0.665840f},  
     {-0.709962f, -0.257909f, -0.655315f},  {-0.995870f, 0.059986f, 0.068151f},  {-0.614604f, -0.458601f, 0.641831f},  {0.128827f, -0.988605f, -0.077865f},  
     {-0.405853f, 0.534245f, 0.741529f},  {0.777104f, -0.568233f, -0.270591f},  {0.980094f, 0.078693f, -0.182272f},  {0.067807f, -0.883167f, -0.464132f},  
     {-0.541641f, 0.064493f, -0.838132f},  {0.797863f, 0.574392f, 0.182999f},  {0.125394f, 0.559994f, -0.818953f},  {0.690848f, 0.595609f, -0.409853f},  
     {-0.195895f, 0.783650f, -0.589506f},  {-0.372751f, -0.294482f, -0.879964f},  {-0.851007f, -0.118711f, 0.511561f},  {0.536300f, -0.544993f, -0.644488f},  
     {0.934866f, -0.349206f, 0.063880f},  {0.931858f, -0.022019f, 0.362154f},  {0.990703f, -0.019947f, 0.134572f},  {0.836329f, -0.389239f, -0.386066f},  
     {0.185334f, -0.703197f, 0.686415f},  {-0.186011f, -0.249374f, 0.950375f},  {-0.556532f, -0.164831f, -0.814312f},  {-0.230471f, 0.963060f, -0.139277f},  
     {0.403774f, 0.513347f, 0.757259f},  {-0.713244f, -0.020308f, -0.700622f},  {0.357280f, 0.094059f, 0.929249f},  {-0.071779f, -0.979589f, 0.187759f},  
     {0.865168f, 0.183009f, 0.466897f},  {-0.224165f, 0.584786f, -0.779599f},  {-0.377600f, 0.671251f, -0.637840f},  {-0.423577f, 0.105753f, 0.899666f},  
     {0.127972f, -0.742434f, -0.657582f},  {0.462590f, 0.018542f, -0.886378f},  {0.151970f, -0.846000f, 0.511066f},  {0.499532f, -0.714214f, -0.490273f},  
     {-0.396244f, 0.892863f, 0.213977f},  {-0.409680f, -0.857980f, -0.309892f},  {0.647122f, 0.302257f, -0.699909f},  {-0.945421f, 0.307502f, 0.107808f},  
     {0.858463f, -0.252852f, 0.446215f},  {0.218014f, -0.931021f, -0.292694f},  {0.176246f, -0.549323f, -0.816812f},  {0.029025f, -0.394722f, -0.918342f},  
     {-0.922482f, -0.221359f, -0.316271f},  {-0.760673f, 0.624129f, -0.178437f},  {-0.168108f, 0.931942f, 0.321285f},  {-0.250840f, -0.951983f, -0.175520f},  
     {0.685302f, 0.727426f, 0.034835f},  {0.034330f, 0.753280f, 0.656803f},  {0.947107f, -0.218356f, 0.235178f},  {0.430873f, -0.851455f, -0.298952f},  
     {-0.554955f, -0.393591f, -0.732879f},  {0.777126f, -0.066733f, -0.625797f},  {0.525510f, -0.779236f, 0.341512f},  {0.106285f, -0.944085f, 0.312102f},  
     {0.302944f, 0.637921f, -0.708012f},  {-0.606260f, 0.196917f, 0.770501f},  {-0.862743f, 0.335949f, 0.377904f},  {-0.569807f, 0.609284f, 0.551446f},  
     {-0.179766f, -0.898356f, -0.400801f},  {-0.019218f, -0.965706f, -0.258925f},  {0.854868f, -0.431394f, 0.288271f},  {0.917941f, 0.381893f, 0.107435f},  
     {0.684470f, -0.546191f, -0.482883f},  {0.325501f, -0.884684f, 0.333742f},  {0.347783f, -0.933873f, -0.083231f},  {-0.934249f, -0.001223f, -0.356620f},  
     {0.791051f, 0.371649f, -0.485917f},  {0.552801f, -0.269667f, 0.788474f},  {-0.022682f, -0.409818f, 0.911885f},  {-0.216813f, -0.005288f, 0.976199f},  
     {0.720715f, 0.565420f, 0.401087f},  {-0.426492f, 0.904449f, -0.008752f},  {-0.242465f, -0.684526f, 0.687485f},  {-0.724660f, -0.591200f, -0.354048f},  
     {-0.336254f, 0.155231f, -0.928890f},  {0.934603f, 0.332989f, -0.125041f},  {0.954493f, -0.125975f, -0.270322f},  {0.282054f, 0.169051f, -0.944387f},  
     {-0.656688f, -0.507474f, -0.557881f},  {0.377649f, 0.924532f, -0.051205f},  {-0.590731f, -0.043282f, 0.805707f},  {-0.282162f, -0.815742f, 0.504925f},  
     {-0.472332f, -0.623141f, -0.623376f},  {-0.870433f, 0.111792f, 0.479426f},  {-0.211030f, 0.973182f, 0.091557f},  {0.796894f, 0.165056f, -0.581133f},  
     {-0.979556f, -0.167915f, 0.110792f},  {-0.919277f, 0.216507f, -0.328717f},  {0.908794f, 0.245321f, -0.337507f},  {-0.007950f, -0.135963f, 0.990682f},  
     {-0.425049f, 0.329950f, 0.842891f},  {-0.905702f, -0.420812f, -0.051200f},  {-0.800747f, -0.590094f, 0.102928f},  {0.374851f, -0.401480f, 0.835643f},  
     {-0.290914f, -0.954548f, 0.064869f},  {0.837684f, 0.544317f, -0.044774f},  {-0.332723f, -0.784686f, -0.523034f},  {0.256569f, -0.067551f, -0.964163f},  
     {-0.400578f, -0.125972f, 0.907562f},  {-0.454741f, 0.491091f, -0.742994f},  {0.389383f, 0.313668f, 0.866022f},  {0.166322f, 0.908474f, -0.383421f},  
     {0.575796f, -0.462537f, 0.674180f},  {-0.804119f, -0.362200f, -0.471386f},  {0.589067f, 0.356528f, 0.725181f},  {-0.777052f, -0.617099f, -0.124013f},  
     {0.564668f, 0.152982f, 0.811016f},  {-0.734247f, 0.485552f, 0.474469f},  {0.828525f, -0.045286f, 0.558118f},  {-0.360356f, -0.350761f, 0.864356f},  
     {0.903502f, 0.041179f, -0.426600f},  {-0.879019f, 0.475549f, -0.034330f},  {0.026676f, 0.895544f, 0.444172f},  {-0.013877f, -0.626438f, 0.779347f},  
     {0.223694f, 0.970039f, 0.094790f},  {0.176589f, -0.022503f, 0.984027f},  {-0.593635f, 0.791563f, 0.145002f},  {0.542586f, 0.760734f, -0.356208f},  
     {-0.646472f, -0.605301f, 0.464419f},  {0.506809f, -0.061018f, 0.859896f},  {0.014122f, 0.979765f, 0.199653f},  {0.624804f, -0.140066f, -0.768115f},  
     {-0.172276f, -0.458877f, -0.871638f},  {0.584942f, 0.544151f, 0.601451f},  {-0.228470f, 0.899735f, -0.371857f},  {-0.963342f, 0.245963f, -0.107121f},  
     {-0.218952f, 0.457397f, 0.861886f},  {-0.796603f, -0.510309f, 0.324051f},  {0.141706f, 0.772214f, -0.619358f},  {-0.046561f, -0.787069f, 0.615105f},  
     {-0.747399f, 0.042137f, 0.663038f},  {-0.710735f, 0.635580f, 0.301485f},  {-0.228235f, 0.233058f, 0.945300f},  {-0.649087f, -0.760385f, 0.022366f},  
     {0.183314f, -0.516886f, 0.836196f},  {0.546469f, -0.833334f, -0.083225f},  {0.207748f, -0.970464f, 0.122637f},  {-0.840834f, -0.125324f, -0.526586f},  
     {0.213647f, 0.926623f, 0.309394f},  {0.338759f, -0.182553f, 0.922993f},  {0.801422f, -0.583291f, 0.132268f},  {0.631662f, 0.493782f, -0.597647f},  
     {0.748391f, 0.375934f, 0.546429f},  {0.489186f, 0.661981f, -0.567872f},  {0.863792f, -0.188782f, -0.467145f},  {-0.023716f, 0.353793f, 0.935023f},  
     {0.634693f, -0.760323f, 0.138110f},  {0.542216f, 0.710198f, 0.449022f},  {0.404109f, 0.845236f, 0.349675f},  {-0.148023f, -0.000804f, -0.988984f},  
     {-0.755438f, 0.652499f, 0.059647f},  {0.375433f, -0.452891f, -0.808665f},  {-0.431417f, 0.871444f, -0.233379f},  {0.857818f, 0.389370f, 0.335467f},  
     {0.291930f, -0.817413f, -0.496602f},  {-0.001283f, 0.565808f, 0.824536f},  {0.858750f, -0.507476f, -0.070827f},  {-0.572351f, 0.621970f, -0.534385f},  
     {-0.950851f, -0.058706f, 0.304031f},  {-0.165283f, -0.234849f, -0.957877f},  {0.644002f, 0.087496f, -0.760004f},  {-0.847274f, 0.487850f, 0.210072f},  
     {-0.894975f, -0.277305f, 0.349459f},  {-0.950063f, 0.159621f, 0.268143f},  {-0.645743f, 0.428795f, -0.631783f},  {-0.424396f, -0.526940f, 0.736358f},  
     {-0.868543f, 0.423841f, -0.256890f},  {-0.989204f, 0.014897f, -0.145784f},  {0.045721f, -0.158250f, -0.986340f},  {-0.736779f, 0.541560f, -0.404808f},  
     {-0.079767f, -0.996497f, -0.025118f},  {0.473840f, 0.869953f, 0.136593f},  {-0.462315f, -0.675177f, 0.574806f},  {0.715563f, 0.670711f, -0.195232f},  
     {0.068616f, 0.080955f, -0.994353f},  {0.194544f, 0.448002f, 0.872609f},  {-0.660850f, -0.706722f, 0.252629f},  {-0.185324f, 0.655547f, 0.732061f},  
     {-0.373505f, 0.705989f, 0.601726f},  {-0.066456f, 0.461852f, -0.884464f},  {-0.030737f, -0.621968f, -0.782439f},  {-0.287717f, -0.912909f, 0.289511f},  
     {-0.290515f, 0.378735f, -0.878727f},  {0.717380f, -0.693076f, -0.070796f},  {0.370217f, -0.760460f, 0.533516f},  {-0.088899f, -0.902860f, 0.420644f},  
     {-0.021694f, 0.869657f, -0.493179f},  {-0.033670f, 0.688917f, -0.724057f},  {0.428737f, -0.213244f, -0.877902f},  {0.227070f, 0.818563f, 0.527631f},  
     {0.437963f, -0.889426f, 0.130806f},  {-0.754949f, 0.277544f, 0.594156f},  {-0.119255f, 0.233764f, -0.964952f},  {-0.549663f, -0.715290f, -0.431545f},  
     {0.175817f, 0.972620f, -0.151983f},  {0.627594f, 0.738912f, 0.245225f},  {-0.598190f, 0.417800f, 0.683822f},  {0.158525f, -0.296200f, 0.941879f},  
     {-0.506394f, 0.286922f, -0.813167f},  {-0.612580f, -0.761585f, -0.211507f},  {0.949382f, 0.190736f, 0.249587f},  {0.172970f, 0.230334f, 0.957615f},  
     {-0.483229f, -0.790033f, 0.377277f},  {-0.972690f, -0.207960f, -0.103082f},  {-0.360895f, -0.072245f, -0.929804f},  {-0.239352f, -0.666852f, -0.705705f},  
     {-0.342434f, 0.837513f, 0.425805f},  {-0.204226f, -0.510922f, 0.835015f},  {-0.910281f, -0.381847f, 0.159943f},  {0.836197f, 0.474025f, -0.275816f},  
     {-0.032776f, 0.963966f, -0.264000f},  {0.472183f, 0.253561f, -0.844245f},  {-0.463129f, -0.882879f, -0.077691f},  {0.569630f, -0.351602f, -0.742898f},  
     {0.726459f, -0.270655f, 0.631667f},  {0.986069f, 0.165382f, 0.017796f},  {0.371491f, 0.885581f, -0.278822f},  {-0.801890f, 0.338858f, -0.492085f},  
     {-0.553137f, -0.284174f, 0.783125f},  {0.388223f, -0.594789f, 0.703925f},  {0.704040f, -0.626338f, 0.334705f},  {-0.156529f, 0.815501f, 0.557187f},  
     {0.206948f, 0.643032f, 0.737348f},  {-0.861890f, -0.434225f, -0.261907f},  {-0.833414f, 0.115075f, -0.540536f},  {0.461754f, 0.476123f, -0.748392f},  
     {-0.023513f, 0.114853f, 0.993104f},  {-0.540789f, 0.752715f, 0.375456f},  {-0.487341f, -0.858626f, 0.158934f},  {0, 0, 0} 
};

unsigned char closest_points8[MAXU8][MAXV8] = {
    {252,141,141,50,50,145,145,19,19,134,134,134,41,41,42,42,42,30,30,102,136,136,77,77,186,186,57,57,57,123,123,200,},
    {252,141,141,50,50,145,132,132,13,13,134,52,41,226,226,241,241,30,30,30,136,136,111,111,186,186,57,57,57,123,123,200,},
    {252,141,141,50,50,50,132,132,13,13,52,52,52,226,226,241,241,241,30,114,114,111,111,111,186,186,186,57,57,103,123,200,},
    {252,141,141,50,50,50,132,132,13,13,52,52,52,226,226,87,241,101,101,114,114,92,111,111,62,186,237,57,103,103,200,200,},
    {252,141,141,50,50,50,132,132,130,168,168,168,179,179,87,87,87,101,101,235,92,92,92,62,62,62,237,237,103,103,200,200,},
    {252,141,141,50,50,126,126,130,130,168,168,168,179,179,87,87,121,121,235,235,235,92,92,62,62,62,237,237,103,103,200,200,},
    {252,252,227,227,50,126,126,130,130,130,168,96,96,33,33,33,121,121,235,235,35,35,167,167,62,237,237,237,103,103,200,200,},
    {252,252,227,227,227,126,126,130,130,149,149,96,96,96,33,33,121,199,199,199,35,35,167,167,251,251,237,237,103,103,200,200,},
    {252,252,227,227,227,126,126,48,48,149,149,173,96,221,221,72,72,199,199,199,35,35,167,167,251,251,9,9,103,103,200,200,},
    {252,252,227,227,227,126,48,48,48,149,149,173,173,221,221,72,72,8,8,143,143,169,169,169,251,251,9,9,9,103,200,200,},
    {252,252,227,227,227,201,201,48,48,10,10,173,173,221,197,197,8,8,8,143,143,169,169,169,80,251,9,9,5,5,200,200,},
    {252,252,227,227,227,201,201,48,248,10,10,174,174,174,197,197,105,8,242,242,143,12,12,80,80,80,9,9,5,5,200,200,},
    {252,252,227,227,201,201,201,248,248,10,215,215,174,174,197,197,105,105,242,242,242,12,12,80,80,80,34,9,5,5,200,200,},
    {252,252,252,227,201,201,201,248,248,215,215,215,164,164,140,140,105,105,220,242,127,12,12,154,80,34,34,34,5,5,200,200,},
    {252,252,252,171,171,201,181,248,248,73,215,215,164,164,140,140,140,220,220,127,127,127,154,154,154,34,34,34,5,5,200,200,},
    {252,252,252,171,171,181,181,181,73,73,73,138,138,146,146,140,21,220,220,127,127,212,154,154,213,34,34,205,5,5,200,200,},
    {252,252,252,171,171,181,181,181,73,73,138,138,138,146,146,146,21,21,236,236,212,212,212,213,213,213,34,205,205,5,218,200,},
    {252,252,252,171,171,181,181,181,73,247,247,138,70,70,146,110,21,21,236,236,236,212,212,213,213,213,205,205,205,218,218,200,},
    {252,252,252,171,171,152,181,203,203,247,247,247,70,70,110,110,110,47,47,150,150,150,36,36,213,53,205,205,205,218,218,200,},
    {252,252,252,171,171,152,152,203,203,247,247,232,232,70,60,110,110,47,47,150,150,150,36,36,53,53,53,205,205,218,218,200,},
    {252,252,252,158,171,152,152,203,203,204,204,232,232,60,60,97,97,97,178,178,7,7,36,54,53,53,53,205,218,218,218,200,},
    {252,252,252,158,158,152,152,28,28,204,204,232,232,60,60,97,97,97,178,178,7,7,54,54,54,53,53,208,208,218,218,200,},
    {252,252,252,158,158,152,152,28,28,204,204,253,253,253,142,142,15,15,15,17,17,7,54,54,54,125,208,208,208,218,218,200,},
    {252,252,252,158,158,152,116,28,28,83,83,83,253,253,142,142,15,15,15,17,17,183,183,183,125,125,208,208,208,218,218,175,},
    {252,252,252,158,158,116,116,28,28,83,83,83,157,157,157,176,176,15,69,17,17,183,183,183,125,125,208,208,208,218,218,175,},
    {252,252,252,158,158,116,116,116,222,222,83,133,157,157,157,176,176,69,69,69,195,195,183,190,125,125,224,208,100,218,218,175,},
    {252,252,95,158,158,116,116,116,222,222,133,133,133,187,187,176,137,137,69,195,195,195,190,190,190,224,224,100,100,100,175,175,},
    {252,252,95,158,55,116,116,81,222,222,217,133,82,187,187,187,137,137,192,192,195,243,243,190,190,224,224,100,100,100,175,175,},
    {252,252,95,95,55,55,81,81,81,217,217,82,82,82,63,63,137,137,192,192,243,243,243,4,4,224,224,100,100,100,175,175,},
    {252,252,95,95,55,55,81,81,81,217,217,82,82,82,63,63,63,151,151,113,113,243,243,4,4,4,32,32,100,100,175,175,},
    {252,252,95,95,55,55,81,81,156,156,109,109,109,189,189,63,151,151,151,113,113,250,250,4,4,32,32,32,100,100,175,175,},
    {252,95,95,95,55,55,106,106,156,156,109,109,109,189,189,25,25,193,193,91,91,250,250,250,49,32,32,32,230,230,175,175,},
    {252,95,95,95,55,55,106,106,156,156,38,109,184,184,184,25,25,193,193,91,91,91,250,49,49,49,32,32,230,230,175,175,},
    {252,95,95,95,124,124,106,106,156,156,38,38,184,184,112,112,112,229,193,91,91,163,163,49,49,49,46,230,230,230,175,175,},
    {252,95,95,95,124,124,106,106,23,23,38,38,188,188,112,112,229,229,229,68,68,163,163,24,49,46,46,230,230,230,175,175,},
    {252,95,95,95,124,124,244,244,23,23,23,188,188,188,234,234,229,229,229,68,68,129,163,24,24,46,46,230,230,230,175,175,},
    {252,115,95,95,124,124,244,244,23,23,20,20,188,188,234,234,117,117,249,249,129,129,129,24,24,46,46,37,230,230,175,175,},
    {252,115,95,45,124,124,244,244,244,26,20,20,153,153,234,234,117,117,249,249,129,129,129,24,76,76,46,37,230,230,175,175,},
    {252,115,95,45,124,135,244,244,26,26,26,20,153,153,118,118,118,131,131,99,99,104,104,104,76,76,37,37,37,185,175,175,},
    {252,115,45,45,45,135,135,244,26,26,26,144,144,153,118,118,118,131,131,99,99,104,104,104,76,76,37,37,37,185,185,175,},
    {252,115,45,45,45,135,135,191,191,26,144,144,144,202,202,159,159,131,225,99,99,219,104,108,76,3,37,37,37,185,185,175,},
    {252,115,115,45,45,135,135,191,191,198,198,144,228,202,202,159,159,225,225,225,219,219,108,108,108,3,3,37,185,185,185,175,},
    {252,115,115,45,45,135,233,191,191,198,198,228,228,228,254,254,159,238,225,225,219,219,108,108,3,3,3,148,185,185,185,175,},
    {252,115,115,45,45,233,233,233,98,198,198,228,228,228,254,254,238,238,238,61,61,122,122,108,231,3,148,148,185,185,185,194,},
    {252,115,115,45,45,233,233,233,98,98,107,107,207,207,254,120,120,238,61,61,61,122,122,231,231,231,148,148,148,185,185,194,},
    {252,115,115,45,94,233,233,233,98,98,107,107,207,207,207,120,120,71,71,71,84,122,122,231,231,231,148,148,148,185,194,194,},
    {252,115,115,45,94,94,233,139,98,155,107,211,211,207,51,120,120,71,71,84,84,84,14,14,231,206,148,148,67,185,194,194,},
    {252,115,115,94,94,94,139,139,139,155,155,211,211,51,51,51,196,196,85,85,84,84,14,14,206,206,206,67,67,67,194,194,},
    {252,115,115,94,94,94,139,139,139,155,155,211,211,79,51,51,196,196,85,85,31,31,14,14,206,206,206,67,67,67,194,194,},
    {252,115,115,223,94,94,139,139,44,155,58,58,79,79,79,162,27,27,27,85,31,31,31,56,56,206,206,67,67,67,194,194,},
    {252,115,115,223,94,160,160,44,44,44,58,58,79,79,162,162,27,27,65,65,65,31,56,56,56,66,66,67,67,67,194,194,},
    {252,115,115,223,223,160,160,160,44,44,58,58,89,89,162,162,90,90,65,65,65,180,180,56,56,66,66,66,67,194,194,194,},
    {252,115,115,223,223,160,160,160,44,44,210,210,89,89,216,216,90,90,90,75,75,180,180,18,18,66,66,66,22,22,194,194,},
    {252,115,115,223,223,160,160,245,245,245,210,210,78,78,216,216,161,161,75,75,75,59,59,18,18,66,66,22,22,22,194,194,},
    {252,115,115,223,223,119,119,245,245,245,210,6,78,78,172,172,161,161,161,0,59,59,59,18,18,177,177,22,22,22,194,194,},
    {252,115,115,223,223,119,119,119,245,245,6,6,78,78,172,172,209,161,0,0,0,59,59,39,39,177,177,22,22,22,194,194,},
    {252,115,141,223,165,119,119,119,128,128,6,6,246,246,172,172,209,209,209,0,0,88,39,39,39,177,177,22,22,22,194,194,},
    {252,141,141,165,165,119,119,119,128,128,11,11,246,246,166,166,209,209,29,29,88,88,88,39,239,239,177,214,22,123,194,194,},
    {252,141,141,165,165,165,93,93,128,128,11,11,11,86,166,166,182,182,29,29,29,88,88,16,239,239,214,214,214,123,123,194,},
    {252,141,141,165,165,165,93,93,93,240,11,11,86,86,86,40,182,182,182,43,43,43,16,16,239,239,214,214,214,123,123,194,},
    {252,141,141,165,165,165,93,93,240,240,240,64,64,86,86,40,40,1,1,43,43,43,16,16,239,147,214,214,214,123,123,200,},
    {252,141,141,165,165,145,145,93,240,240,240,64,64,74,74,40,40,1,1,1,170,170,16,16,147,147,147,214,123,123,123,200,},
    {252,141,141,141,165,145,145,19,19,240,134,64,64,74,74,74,2,2,102,102,170,170,170,77,147,147,147,57,123,123,123,200,},
    {252,141,141,141,50,145,145,19,19,134,134,134,41,41,42,42,2,2,102,102,102,170,77,77,77,147,57,57,57,123,123,200,},
};

#endif 

