//
//  Copyright (C) 2004-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include "stdafx.h"
#include "Renderers.h"
#include "GDFillPatterns.h"


// All these definitions were taken from Envision 9 code which took them from
// OnSite 6 code

//------------------------------------------------------------------------------
// AutoCAD, and World/MapInfo fill pattern definitions. The fill patterns are
// defined as monochrome bitmaps (i.e., one bit per pixel), with the following
// properties: rows of bits are byte aligned rows, and the bitmaps are defined
// bottom-up.  The AutoCAD fill pattern definitions were supplied to us by the
// Actrix SWD team.
//------------------------------------------------------------------------------


static unsigned char SOLID_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

static unsigned char NONE_BITS[] = {
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ANGLE_BITS[] = {
                                0xff, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
                                0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
                                0x00, 0x00, 0x00, 0x00};

static unsigned char BOX_BITS[] = {
                                0xc1, 0x3f, 0xf8, 0x01, 0x41, 0x20, 0x08, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0xc1, 0x3f, 0xf8, 0x01, 0x41, 0x00, 0x00, 0x00,
                                0x41, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
                                0x41, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
                                0x41, 0x00, 0x00, 0x00, 0x7f, 0xe0, 0x0f, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x7f, 0xe0, 0x0f, 0x00,
                                0x41, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
                                0x41, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00,
                                0x41, 0x00, 0x00, 0x00};

static unsigned char BRASS_BITS[] = {
                                0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00};

static unsigned char BRICK_BITS[] = {
                                0xff, 0xff, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00,
                                0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00, 0x02,
                                0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00,
                                0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00,
                                0x00, 0x02, 0x00};

static unsigned char BRSTONE_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00,
                                0x20, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00,
                                0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0xe0,
                                0x01, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
                                0x00, 0xe0, 0x01, 0x00, 0x00, 0x00, 0x20, 0x01,
                                0x00, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0x00,
                                0x20, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00,
                                0x00, 0x00, 0x20, 0x01, 0xff, 0xff, 0xff, 0xff,
                                0x0f, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x78,
                                0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
                                0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00,
                                0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00,
                                0x48, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00,
                                0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x78,
                                0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00};

static unsigned char CLAY_BITS[] = {
                                0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xff, 0xff,
                                0x0f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00};

static unsigned char CORK_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x0a, 0x00, 0x00, 0x80,
                                0x05, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0xa0,
                                0x01, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x50, 0x01, 0x00, 0x00, 0xa8, 0x00,
                                0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x2a, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x80, 0x0a, 0x00,
                                0x00, 0x40, 0x05, 0x00, 0x00, 0xa0, 0x02, 0x00,
                                0x00, 0x50, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x50, 0x01, 0x00, 0x00, 0xa8, 0x00, 0x00, 0x00,
                                0x54, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00};

static unsigned char CROSS_BITS[] = {
                                0x7f, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00,
                                0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80,
                                0x00, 0x00, 0x80, 0x00, 0x00, 0xf0, 0x07, 0x00,
                                0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0x80, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
                                0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00};

static unsigned char DASH_BITS[] = {
                                0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xc1, 0x0f, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char DOLMIT_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x02, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x02, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00};

static unsigned char DOTS_BITS[] = {
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char EARTH_BITS[] = {
                                0xff, 0xff, 0x7f, 0x02, 0x02, 0x02, 0x00, 0x00,
                                0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02,
                                0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x00, 0x00,
                                0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02,
                                0xff, 0xff, 0x7f, 0x02, 0x02, 0x02, 0x00, 0x00,
                                0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02,
                                0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x00, 0x00,
                                0x00, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02,
                                0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0xff, 0xff,
                                0x7f, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x08, 0x08, 0x08, 0x02, 0x02, 0x02,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x00, 0x00, 0x00, 0x09, 0x08, 0xc8, 0xff,
                                0xff, 0x0f, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00,
                                0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x00, 0x00, 0x00, 0x09, 0x08, 0xc8, 0xff,
                                0xff, 0x0f, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00,
                                0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00,
                                0x00, 0x00, 0x09, 0x08, 0xc8, 0xff, 0xff, 0x0f,
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x08, 0x08,
                                0x08, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x02,
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02};

static unsigned char ESCHER_BITS[] = {
                                0xf9, 0xff, 0xff, 0x3f, 0x12, 0x00, 0x20, 0x00,
                                0x12, 0x00, 0x40, 0x3f, 0x24, 0x00, 0xc0, 0x30,
                                0xe5, 0xff, 0xff, 0x10, 0x89, 0x02, 0x40, 0x08,
                                0x8a, 0x02, 0x40, 0x08, 0x52, 0x04, 0x20, 0x04,
                                0x61, 0x04, 0x20, 0x04, 0x3f, 0x08, 0x10, 0x02,
                                0x42, 0x08, 0x10, 0x22, 0x42, 0x10, 0x08, 0x21,
                                0x84, 0x10, 0x84, 0x10, 0x04, 0x21, 0x84, 0x10,
                                0x08, 0x21, 0x42, 0x08, 0x10, 0x42, 0x42, 0x08,
                                0x10, 0x42, 0x21, 0x04, 0x20, 0x84, 0x21, 0x04,
                                0x20, 0x84, 0x1f, 0x02, 0x40, 0x08, 0x29, 0x02,
                                0x80, 0x10, 0x49, 0x01, 0x80, 0x10, 0x45, 0x01,
                                0xff, 0xa1, 0xf4, 0x3f, 0x80, 0xa1, 0x12, 0x00,
                                0x80, 0x7e, 0x0a, 0x00, 0x40, 0x00, 0x09, 0x00,
                                0x40, 0x00, 0x05, 0x00, 0xff, 0xff, 0xfc, 0x3f,
                                0x40, 0x00, 0x09, 0x00, 0x80, 0x7e, 0x09, 0x00,
                                0x80, 0xa1, 0x12, 0x00, 0xff, 0xa1, 0xf2, 0x3f,
                                0x80, 0x10, 0x45, 0x01, 0x80, 0x10, 0x45, 0x01,
                                0x40, 0x08, 0x29, 0x02, 0x20, 0x84, 0x1f, 0x02,
                                0x20, 0x84, 0x11, 0x04, 0x10, 0x42, 0x21, 0x04,
                                0x10, 0x42, 0x22, 0x08, 0x08, 0x21, 0x42, 0x08,
                                0x04, 0x21, 0x84, 0x10, 0x84, 0x10, 0x84, 0x10,
                                0x42, 0x10, 0x08, 0x21, 0x42, 0x08, 0x10, 0x21,
                                0x3f, 0x08, 0x10, 0x02, 0x21, 0x04, 0x20, 0x02,
                                0x52, 0x04, 0x20, 0x04, 0x4a, 0x02, 0x40, 0x08,
                                0x89, 0x02, 0x40, 0x08, 0xe5, 0xff, 0xff, 0x10,
                                0x24, 0x00, 0xc0, 0x30, 0x12, 0x00, 0x40, 0x3f,
                                0x12, 0x00, 0x20, 0x00};

static unsigned char FLEX_BITS[] = {
                                0xff, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x00, 0x00, 0x08};

static unsigned char GRASS_BITS[] = {
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
                                0x00, 0x08, 0x05, 0x00, 0x00, 0x00, 0x04, 0x09,
                                0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
                                0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
                                0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00,
                                0x00, 0x00, 0x80, 0x24, 0x00, 0x00, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00};

static unsigned char GRATE_BITS[] = {
                                0xff, 0xff, 0x07, 0x01, 0x00, 0x00, 0x01, 0x00,
                                0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00};

static unsigned char HEX_BITS[] = {
                                0x7f, 0x00, 0xfc, 0x00, 0x00, 0x80, 0x00, 0x00,
                                0x00, 0x04, 0x80, 0x00, 0x00, 0x00, 0x04, 0x00,
                                0x01, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
                                0x02, 0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0x01,
                                0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x02,
                                0x80, 0x00, 0x00, 0x00, 0x04, 0x80, 0x00, 0x00,
                                0x00, 0x04, 0x7f, 0x00, 0xfc, 0x00, 0x00, 0x00,
                                0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02, 0x01,
                                0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00,
                                0x01, 0x02, 0x00, 0x00, 0x80, 0x00, 0x04, 0x00,
                                0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x01,
                                0x02, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00,
                                0x00, 0x02, 0x01, 0x00};

static unsigned char HONEY_BITS[] = {
                                0x7f, 0x00, 0x00, 0x80, 0x00, 0x02, 0x80, 0x00,
                                0x02, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00,
                                0xfe, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01,
                                0x80, 0x00, 0x02, 0x80, 0x00, 0x02};

static unsigned char HOUND_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x3f, 0x10, 0x04, 0x80,
                                0x20, 0x08, 0x04, 0x01, 0x00, 0x08, 0x02, 0x41,
                                0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80, 0x20,
                                0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01, 0x00,
                                0x08, 0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10,
                                0x00, 0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08,
                                0x04, 0x01, 0x00, 0x08, 0x02, 0x41, 0x00, 0x00,
                                0x82, 0x40, 0x10, 0x00, 0x80, 0x20, 0x10, 0x04,
                                0x00, 0x20, 0x08, 0x04, 0x01, 0x00, 0x08, 0x02,
                                0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80,
                                0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01,
                                0x00, 0x08, 0x02, 0x41, 0x00, 0x00, 0x82, 0x40,
                                0x10, 0x00, 0x80, 0x20, 0x10, 0x04, 0x00, 0x20,
                                0x08, 0x04, 0x01, 0x00, 0x08, 0xfe, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x20, 0x08, 0x04, 0x01, 0x00, 0x08,
                                0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00,
                                0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04,
                                0x01, 0x00, 0x08, 0x02, 0x41, 0x00, 0x00, 0x82,
                                0x40, 0x10, 0x00, 0x80, 0x20, 0x10, 0x04, 0x00,
                                0x20, 0x08, 0x04, 0x01, 0x00, 0x08, 0x02, 0x41,
                                0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80, 0x20,
                                0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01, 0x00,
                                0x08, 0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10,
                                0x00, 0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08,
                                0x04, 0x01, 0x00, 0x08, 0x02, 0x41, 0x00, 0x00,
                                0x82, 0x40, 0x10, 0x00, 0x80, 0x20, 0x10, 0x04,
                                0x00, 0x20, 0x08, 0x04, 0x01, 0x00, 0x08, 0x02,
                                0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80,
                                0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01,
                                0x00, 0x08, 0x02, 0x41, 0x00, 0xf8, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x01, 0x00, 0x08, 0x02, 0x41, 0x00,
                                0x00, 0x82, 0x40, 0x10, 0x00, 0x80, 0x20, 0x10,
                                0x04, 0x00, 0x20, 0x08, 0x04, 0x01, 0x00, 0x08,
                                0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00,
                                0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04,
                                0x01, 0x00, 0x08, 0x02, 0x41, 0x00, 0x00, 0x82,
                                0x40, 0x10, 0x00, 0x80, 0x20, 0x10, 0x04, 0x00,
                                0x20, 0x08, 0x04, 0x01, 0x00, 0x08, 0x02, 0x41,
                                0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80, 0x20,
                                0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01, 0x00,
                                0x08, 0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10,
                                0x00, 0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08,
                                0x04, 0xff, 0xff, 0xff, 0x03, 0x41, 0x00, 0x00,
                                0x82, 0x40, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x08, 0x02,
                                0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00, 0x80,
                                0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04, 0x01,
                                0x00, 0x08, 0x02, 0x41, 0x00, 0x00, 0x82, 0x40,
                                0x10, 0x00, 0x80, 0x20, 0x10, 0x04, 0x00, 0x20,
                                0x08, 0x04, 0x01, 0x00, 0x08, 0x02, 0x41, 0x00,
                                0x00, 0x82, 0x40, 0x10, 0x00, 0x80, 0x20, 0x10,
                                0x04, 0x00, 0x20, 0x08, 0x04, 0x01, 0x00, 0x08,
                                0x02, 0x41, 0x00, 0x00, 0x82, 0x40, 0x10, 0x00,
                                0x80, 0x20, 0x10, 0x04, 0x00, 0x20, 0x08, 0x04,
                                0x01, 0x00, 0x08, 0x02, 0x41, 0x00, 0x00, 0x82,
                                0x40, 0x10, 0x00, 0x80, 0x20, 0x10, 0x04, 0x00,
                                0x20, 0x08, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x0f, 0x82, 0x40, 0x10, 0x04, 0x80, 0xe0,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x41, 0x00,
                                0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10,
                                0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08,
                                0x04, 0x41, 0x00, 0x00, 0x02, 0x41, 0x10, 0x00,
                                0x80, 0x40, 0x10, 0x04, 0x00, 0x20, 0x10, 0x04,
                                0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00, 0x02,
                                0x41, 0x10, 0x00, 0x80, 0x40, 0x10, 0x04, 0x00,
                                0x20, 0x10, 0x04, 0x01, 0x00, 0x08, 0x04, 0x41,
                                0x00, 0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40,
                                0x10, 0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00,
                                0x08, 0x04, 0x41, 0x00, 0x00, 0x02, 0x41, 0x10,
                                0x00, 0x80, 0x40, 0x10, 0x04, 0x00, 0x20, 0x10,
                                0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00,
                                0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10, 0x04,
                                0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08, 0x04,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x1f, 0x04, 0x00, 0x20, 0x10, 0x04, 0x81,
                                0xff, 0xff, 0xff, 0x41, 0x00, 0x00, 0x02, 0x41,
                                0x10, 0x00, 0x80, 0x40, 0x10, 0x04, 0x00, 0x20,
                                0x10, 0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00,
                                0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10,
                                0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08,
                                0x04, 0x41, 0x00, 0x00, 0x02, 0x41, 0x10, 0x00,
                                0x80, 0x40, 0x10, 0x04, 0x00, 0x20, 0x10, 0x04,
                                0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00, 0x02,
                                0x41, 0x10, 0x00, 0x80, 0x40, 0x10, 0x04, 0x00,
                                0x20, 0x10, 0x04, 0x01, 0x00, 0x08, 0x04, 0x41,
                                0x00, 0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40,
                                0x10, 0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00,
                                0x08, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x10,
                                0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00,
                                0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10, 0x04,
                                0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08, 0x04,
                                0x41, 0x00, 0x00, 0x02, 0x41, 0x10, 0x00, 0x80,
                                0x40, 0x10, 0x04, 0x00, 0x20, 0x10, 0x04, 0x01,
                                0x00, 0x08, 0x04, 0x41, 0x00, 0x00, 0x02, 0x41,
                                0x10, 0x00, 0x80, 0x40, 0x10, 0x04, 0x00, 0x20,
                                0x10, 0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00,
                                0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10,
                                0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08,
                                0x04, 0x41, 0x00, 0x00, 0x02, 0x41, 0x10, 0x00,
                                0x80, 0x40, 0x10, 0x04, 0x00, 0x20, 0x10, 0x04,
                                0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00, 0xfe,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x08, 0x04, 0x41,
                                0x00, 0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40,
                                0x10, 0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00,
                                0x08, 0x04, 0x41, 0x00, 0x00, 0x02, 0x41, 0x10,
                                0x00, 0x80, 0x40, 0x10, 0x04, 0x00, 0x20, 0x10,
                                0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00, 0x00,
                                0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10, 0x04,
                                0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08, 0x04,
                                0x41, 0x00, 0x00, 0x02, 0x41, 0x10, 0x00, 0x80,
                                0x40, 0x10, 0x04, 0x00, 0x20, 0x10, 0x04, 0x01,
                                0x00, 0x08, 0x04, 0x41, 0x00, 0x00, 0x02, 0x41,
                                0x10, 0x00, 0x80, 0x40, 0x10, 0x04, 0x00, 0x20,
                                0x10, 0x04, 0x01, 0x00, 0x08, 0x04, 0x41, 0x00,
                                0x00, 0x02, 0x41, 0x10, 0x00, 0x80, 0x40, 0x10,
                                0x04, 0x00, 0x20, 0x10, 0x04, 0x01, 0x00, 0x08,
                                0x04, 0x41, 0x20, 0x00, 0x02, 0x41, 0x10, 0xf8,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x41, 0x20, 0x00, 0x00,
                                0x41, 0x10, 0x08, 0x00, 0x40, 0x10, 0x04, 0x02,
                                0x00, 0x10, 0x04, 0x81, 0x00, 0x00, 0x04, 0x41,
                                0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40,
                                0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00,
                                0x00, 0x04, 0x41, 0x20, 0x00, 0x00, 0x41, 0x10,
                                0x08, 0x00, 0x40, 0x10, 0x04, 0x02, 0x00, 0x10,
                                0x04, 0x81, 0x00, 0x00, 0x04, 0x41, 0x20, 0x00,
                                0x00, 0x41, 0x10, 0x08, 0x00, 0x40, 0x10, 0x04,
                                0x02, 0x00, 0x10, 0x04, 0x81, 0x00, 0x00, 0x04,
                                0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00,
                                0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81,
                                0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0x03, 0x41,
                                0x10, 0x08, 0x00, 0x40, 0xf0, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x41, 0x20,
                                0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40, 0x10,
                                0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00, 0x00,
                                0x04, 0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08,
                                0x00, 0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04,
                                0x81, 0x00, 0x00, 0x04, 0x41, 0x20, 0x00, 0x00,
                                0x41, 0x10, 0x08, 0x00, 0x40, 0x10, 0x04, 0x02,
                                0x00, 0x10, 0x04, 0x81, 0x00, 0x00, 0x04, 0x41,
                                0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40,
                                0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00,
                                0x00, 0x04, 0x41, 0x20, 0x00, 0x00, 0x41, 0x10,
                                0x08, 0x00, 0x40, 0x10, 0x04, 0x02, 0x00, 0x10,
                                0x04, 0x81, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x0f, 0x00, 0x40, 0x10, 0x04,
                                0x02, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00,
                                0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81,
                                0x00, 0x00, 0x04, 0x41, 0x20, 0x00, 0x00, 0x41,
                                0x10, 0x08, 0x00, 0x40, 0x10, 0x04, 0x02, 0x00,
                                0x10, 0x04, 0x81, 0x00, 0x00, 0x04, 0x41, 0x20,
                                0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40, 0x10,
                                0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00, 0x00,
                                0x04, 0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08,
                                0x00, 0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04,
                                0x81, 0x00, 0x00, 0x04, 0x41, 0x20, 0x00, 0x00,
                                0x41, 0x10, 0x08, 0x00, 0x40, 0x10, 0x04, 0x02,
                                0x00, 0x10, 0x04, 0x81, 0x00, 0x00, 0x04, 0x41,
                                0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40,
                                0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00,
                                0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x1f, 0x04, 0x02, 0x00, 0x10,
                                0x04, 0x81, 0xff, 0xff, 0xff, 0x41, 0x20, 0x00,
                                0x00, 0x41, 0x10, 0x08, 0x00, 0x40, 0x10, 0x04,
                                0x02, 0x00, 0x10, 0x04, 0x81, 0x00, 0x00, 0x04,
                                0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08, 0x00,
                                0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04, 0x81,
                                0x00, 0x00, 0x04, 0x41, 0x20, 0x00, 0x00, 0x41,
                                0x10, 0x08, 0x00, 0x40, 0x10, 0x04, 0x02, 0x00,
                                0x10, 0x04, 0x81, 0x00, 0x00, 0x04, 0x41, 0x20,
                                0x00, 0x00, 0x41, 0x10, 0x08, 0x00, 0x40, 0x10,
                                0x04, 0x02, 0x00, 0x10, 0x04, 0x81, 0x00, 0x00,
                                0x04, 0x41, 0x20, 0x00, 0x00, 0x41, 0x10, 0x08,
                                0x00, 0x40, 0x10, 0x04, 0x02, 0x00, 0x10, 0x04,
                                0x81, 0x00, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x3f, 0x10, 0x04, 0x81, 0x20, 0x00, 0x04, 0x41,
                                0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02, 0x00,
                                0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81, 0x20,
                                0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10,
                                0x08, 0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00,
                                0x04, 0x81, 0x20, 0x00, 0x00, 0x41, 0x20, 0x08,
                                0x00, 0x40, 0x10, 0x08, 0x02, 0x00, 0x10, 0x04,
                                0x82, 0x00, 0x00, 0x04, 0x81, 0x20, 0x00, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02,
                                0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81,
                                0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40,
                                0x10, 0x08, 0x02, 0x00, 0x10, 0x04, 0x82, 0x00,
                                0x00, 0x04, 0x81, 0x20, 0x00, 0x00, 0x41, 0x20,
                                0x08, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00,
                                0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08,
                                0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04,
                                0x81, 0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x40, 0x10, 0x08, 0x02, 0x00, 0x10, 0x04, 0x82,
                                0x00, 0x00, 0x04, 0x81, 0x20, 0x00, 0x00, 0x41,
                                0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02, 0x00,
                                0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81, 0x20,
                                0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10,
                                0x08, 0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00,
                                0x04, 0x81, 0x20, 0x00, 0x00, 0x41, 0x20, 0x08,
                                0x00, 0x40, 0x10, 0x08, 0x02, 0x00, 0x10, 0x04,
                                0x82, 0x00, 0x00, 0x04, 0x81, 0x20, 0x00, 0x00,
                                0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02,
                                0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81,
                                0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40,
                                0x10, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x41, 0x20,
                                0x08, 0x00, 0x40, 0x10, 0x08, 0x02, 0x00, 0x10,
                                0x04, 0x82, 0x00, 0x00, 0x04, 0x81, 0x20, 0x00,
                                0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08,
                                0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04,
                                0x81, 0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x40, 0x10, 0x08, 0x02, 0x00, 0x10, 0x04, 0x82,
                                0x00, 0x00, 0x04, 0x81, 0x20, 0x00, 0x00, 0x41,
                                0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02, 0x00,
                                0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81, 0x20,
                                0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10,
                                0x08, 0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00,
                                0x04, 0x81, 0x20, 0x00, 0x00, 0xff, 0xff, 0xff,
                                0x03, 0x40, 0x10, 0x08, 0x02, 0x00, 0xf0, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08, 0x02,
                                0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04, 0x81,
                                0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00, 0x40,
                                0x10, 0x08, 0x02, 0x00, 0x10, 0x04, 0x82, 0x00,
                                0x00, 0x04, 0x81, 0x20, 0x00, 0x00, 0x41, 0x20,
                                0x08, 0x00, 0x40, 0x10, 0x08, 0x02, 0x00, 0x10,
                                0x04, 0x82, 0x00, 0x00, 0x04, 0x81, 0x20, 0x00,
                                0x00, 0x41, 0x20, 0x08, 0x00, 0x40, 0x10, 0x08,
                                0x02, 0x00, 0x10, 0x04, 0x82, 0x00, 0x00, 0x04,
                                0x81, 0x20, 0x00, 0x00, 0x41, 0x20, 0x08, 0x00,
                                0x40, 0x10, 0x08, 0x02, 0x00, 0x10, 0x04, 0x82,
                                0x00, 0x00, 0x04, 0x81, 0x20, 0x00, 0x00, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x82, 0x00,
                                0x10, 0x04, 0x82, 0xe0, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10,
                                0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00,
                                0x00, 0x81, 0x20, 0x08, 0x00, 0x40, 0x20, 0x08,
                                0x02, 0x00, 0x10, 0x08, 0x82, 0x00, 0x00, 0x04,
                                0x82, 0x20, 0x00, 0x00, 0x81, 0x20, 0x08, 0x00,
                                0x40, 0x20, 0x08, 0x02, 0x00, 0x10, 0x08, 0x82,
                                0x00, 0x00, 0x04, 0x82, 0x20, 0x00, 0x00, 0x81,
                                0x20, 0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00,
                                0x10, 0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20,
                                0x00, 0x00, 0x81, 0x20, 0x08, 0x00, 0x40, 0x20,
                                0x08, 0x02, 0x00, 0x10, 0x08, 0x82, 0x00, 0x00,
                                0x04, 0x82, 0x20, 0x00, 0x00, 0x81, 0x20, 0x08,
                                0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10, 0x08,
                                0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00, 0x00,
                                0x81, 0x20, 0x08, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x04, 0x82,
                                0x20, 0x00, 0x00, 0x81, 0xff, 0xff, 0xff, 0x40,
                                0x20, 0x08, 0x02, 0x00, 0x10, 0x08, 0x82, 0x00,
                                0x00, 0x04, 0x82, 0x20, 0x00, 0x00, 0x81, 0x20,
                                0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10,
                                0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00,
                                0x00, 0x81, 0x20, 0x08, 0x00, 0x40, 0x20, 0x08,
                                0x02, 0x00, 0x10, 0x08, 0x82, 0x00, 0x00, 0x04,
                                0x82, 0x20, 0x00, 0x00, 0x81, 0x20, 0x08, 0x00,
                                0x40, 0x20, 0x08, 0x02, 0x00, 0x10, 0x08, 0x82,
                                0x00, 0x00, 0x04, 0x82, 0x20, 0x00, 0x00, 0x81,
                                0x20, 0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00,
                                0x10, 0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20,
                                0x00, 0x00, 0x81, 0x20, 0x08, 0x00, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x3f, 0x00, 0x00, 0x81, 0x20, 0x08,
                                0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10, 0x08,
                                0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00, 0x00,
                                0x81, 0x20, 0x08, 0x00, 0x40, 0x20, 0x08, 0x02,
                                0x00, 0x10, 0x08, 0x82, 0x00, 0x00, 0x04, 0x82,
                                0x20, 0x00, 0x00, 0x81, 0x20, 0x08, 0x00, 0x40,
                                0x20, 0x08, 0x02, 0x00, 0x10, 0x08, 0x82, 0x00,
                                0x00, 0x04, 0x82, 0x20, 0x00, 0x00, 0x81, 0x20,
                                0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10,
                                0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00,
                                0x00, 0x81, 0x20, 0x08, 0x00, 0x40, 0x20, 0x08,
                                0x02, 0x00, 0x10, 0x08, 0x82, 0x00, 0x00, 0x04,
                                0x82, 0x20, 0x00, 0x00, 0x81, 0x20, 0x08, 0x00,
                                0x40, 0x20, 0x08, 0xfe, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x20, 0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00,
                                0x10, 0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20,
                                0x00, 0x00, 0x81, 0x20, 0x08, 0x00, 0x40, 0x20,
                                0x08, 0x02, 0x00, 0x10, 0x08, 0x82, 0x00, 0x00,
                                0x04, 0x82, 0x20, 0x00, 0x00, 0x81, 0x20, 0x08,
                                0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10, 0x08,
                                0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00, 0x00,
                                0x81, 0x20, 0x08, 0x00, 0x40, 0x20, 0x08, 0x02,
                                0x00, 0x10, 0x08, 0x82, 0x00, 0x00, 0x04, 0x82,
                                0x20, 0x00, 0x00, 0x81, 0x20, 0x08, 0x00, 0x40,
                                0x20, 0x08, 0x02, 0x00, 0x10, 0x08, 0x82, 0x00,
                                0x00, 0x04, 0x82, 0x20, 0x00, 0x00, 0x81, 0x20,
                                0x08, 0x00, 0x40, 0x20, 0x08, 0x02, 0x00, 0x10,
                                0x08, 0x82, 0x00, 0x00, 0x04, 0x82, 0x20, 0x00,
                                0x00, 0x81, 0x20, 0x08, 0x00, 0x41, 0x20, 0x08,
                                0x02, 0x01, 0x10, 0xf8, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x08, 0x82,
                                0x40, 0x00, 0x00, 0x82, 0x20, 0x10, 0x00, 0x80,
                                0x20, 0x08, 0x04, 0x00, 0x20, 0x08, 0x02, 0x01,
                                0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20,
                                0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0x00, 0x20,
                                0x08, 0x02, 0x01, 0x00, 0x08, 0x82, 0x40, 0x00,
                                0x00, 0x82, 0x20, 0x10, 0x00, 0x80, 0x20, 0x08,
                                0x04, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x08,
                                0x82, 0x40, 0x00, 0x00, 0x82, 0x20, 0x10, 0x00,
                                0x80, 0x20, 0x08, 0x04, 0x00, 0x20, 0x08, 0x02,
                                0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82,
                                0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0xff,
                                0xff, 0xff, 0x03, 0x01, 0x00, 0x08, 0x82, 0x40,
                                0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00,
                                0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20, 0x10,
                                0x00, 0x80, 0x20, 0x08, 0x04, 0x00, 0x20, 0x08,
                                0x02, 0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00,
                                0x82, 0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04,
                                0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x08, 0x82,
                                0x40, 0x00, 0x00, 0x82, 0x20, 0x10, 0x00, 0x80,
                                0x20, 0x08, 0x04, 0x00, 0x20, 0x08, 0x02, 0x01,
                                0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20,
                                0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0x00, 0x20,
                                0x08, 0x02, 0x01, 0x00, 0x08, 0x82, 0x40, 0x00,
                                0x00, 0x82, 0x20, 0x10, 0x00, 0x80, 0x20, 0x08,
                                0x04, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f,
                                0x82, 0x40, 0x00, 0x00, 0x82, 0xe0, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x20, 0x08, 0x02,
                                0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82,
                                0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0x00,
                                0x20, 0x08, 0x02, 0x01, 0x00, 0x08, 0x82, 0x40,
                                0x00, 0x00, 0x82, 0x20, 0x10, 0x00, 0x80, 0x20,
                                0x08, 0x04, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00,
                                0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20, 0x10,
                                0x00, 0x80, 0x20, 0x08, 0x04, 0x00, 0x20, 0x08,
                                0x02, 0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00,
                                0x82, 0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04,
                                0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x08, 0x82,
                                0x40, 0x00, 0x00, 0x82, 0x20, 0x10, 0x00, 0x80,
                                0x20, 0x08, 0x04, 0x00, 0x20, 0x08, 0x02, 0x01,
                                0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20,
                                0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
                                0x00, 0x82, 0x20, 0x10, 0x00, 0x80, 0xff, 0xff,
                                0xff, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00, 0x08,
                                0x82, 0x40, 0x00, 0x00, 0x82, 0x20, 0x10, 0x00,
                                0x80, 0x20, 0x08, 0x04, 0x00, 0x20, 0x08, 0x02,
                                0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00, 0x82,
                                0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04, 0x00,
                                0x20, 0x08, 0x02, 0x01, 0x00, 0x08, 0x82, 0x40,
                                0x00, 0x00, 0x82, 0x20, 0x10, 0x00, 0x80, 0x20,
                                0x08, 0x04, 0x00, 0x20, 0x08, 0x02, 0x01, 0x00,
                                0x08, 0x82, 0x40, 0x00, 0x00, 0x82, 0x20, 0x10,
                                0x00, 0x80, 0x20, 0x08, 0x04, 0x00, 0x20, 0x08,
                                0x02, 0x01, 0x00, 0x08, 0x82, 0x40, 0x00, 0x00,
                                0x82, 0x20, 0x10, 0x00, 0x80, 0x20, 0x08, 0x04};

static unsigned char INSUL_BITS[] = {
                                0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
                                0x1f, 0x00, 0x00, 0x00};

static unsigned char MUDST_BITS[] = {
                                0xff, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x01, 0x01, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char NET3_BITS[] = {
                                0xff, 0x03, 0x02, 0x02, 0x04, 0x01, 0x04, 0x01,
                                0x88, 0x00, 0x88, 0x00, 0x50, 0x00, 0x20, 0x00,
                                0xff, 0x03, 0x50, 0x00, 0x88, 0x00, 0x88, 0x00,
                                0x04, 0x01, 0x04, 0x01, 0x02, 0x02, 0x01, 0x00};

static unsigned char PLAST_BITS[] = {
                                0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
                                0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char PLASTI_BITS[] = {
                                0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
                                0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char SACNCR_BITS[] = {
                                0x21, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x40, 0x00, 0x80, 0x00,
                                0x00, 0x01, 0x00, 0x02};

static unsigned char SQUARE_BITS[] = {
                                0x00, 0x00, 0x00, 0x00, 0xF0, 0x90, 0x90, 0xF0};

static unsigned char STARS_BITS[] = {
                                0x7f, 0xf0, 0x07, 0x02, 0x00, 0x02, 0x02, 0x00,
                                0x02, 0x04, 0x00, 0x01, 0x04, 0x00, 0x01, 0x08,
                                0x80, 0x00, 0x08, 0x00, 0x01, 0x04, 0x00, 0x01,
                                0x04, 0x00, 0x02, 0x02, 0x00, 0x02, 0x02, 0x00,
                                0x04, 0x7f, 0xf0, 0x07, 0x80, 0x08, 0x00, 0x80,
                                0x08, 0x00, 0x00, 0x05, 0x00, 0x00, 0x05, 0x00,
                                0x00, 0x02, 0x20, 0x00, 0x00, 0x50, 0x00, 0x00,
                                0x50, 0x00, 0x00, 0x88, 0x00, 0x00, 0x88, 0x7f,
                                0xf0, 0x07, 0x20, 0x20, 0x00, 0x20, 0x20, 0x00,
                                0x10, 0x40, 0x00, 0x10, 0x40, 0x00, 0x08, 0x80,
                                0x00, 0x10, 0x80, 0x00, 0x10, 0x40, 0x00, 0x20,
                                0x40, 0x00, 0x20, 0x20, 0x00, 0x40, 0x20, 0x00,
                                0x7f, 0xf0, 0x07, 0x00, 0x00, 0x88, 0x00, 0x00,
                                0x88, 0x00, 0x00, 0x50, 0x00, 0x00, 0x50, 0x00,
                                0x02, 0x20, 0x00, 0x05, 0x00, 0x00, 0x05, 0x00,
                                0x80, 0x08, 0x00, 0x80, 0x08, 0x00};

static unsigned char STEEL_BITS[] = {
                                0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10,
                                0x10, 0x20, 0x21, 0x00, 0x42, 0x00, 0x84, 0x00,
                                0x08, 0x01, 0x10, 0x02, 0x20, 0x04, 0x40, 0x08,
                                0x80, 0x10, 0x00, 0x21};

static unsigned char SWAMP_BITS[] = {
                                0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x40, 0x17, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char TRANS_BITS[] = {
                                0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00};

static unsigned char TRIANG_BITS[] = {
                                0x01, 0x00, 0x00, 0x02, 0x00, 0x08, 0x02, 0x00,
                                0x08, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x08,
                                0x00, 0x02, 0x08, 0x00, 0x02, 0x10, 0x00, 0x01,
                                0x10, 0x00, 0x01, 0x3f, 0x80, 0x0f, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
                                0x00, 0x00, 0x0a, 0x00, 0x00, 0x0a, 0x00, 0x00,
                                0x11, 0x00, 0x00, 0x11, 0x00, 0x80, 0x20, 0x00,
                                0x80, 0x20, 0x00, 0x40, 0x40, 0x00, 0x40, 0x40,
                                0x00, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00};

static unsigned char ZIGZAG_BITS[] = {
                                0xff, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
                                0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
                                0x01, 0xff, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
                                0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00};

static unsigned char AR_B816_BITS[] = {
                                0xff, 0xff, 0x0f, 0x01, 0x00, 0x00, 0x01, 0x00,
                                0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0xff, 0xff,
                                0x0f, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00,
                                0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04,
                                0x00, 0x00, 0x04, 0x00};

static unsigned char AR_B816C_BITS[] = {
                                0xff, 0xff, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x04,
                                0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00,
                                0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0xff, 0xff,
                                0x0f, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
                                0x00, 0x01, 0x00, 0x00};

static unsigned char AR_B88_BITS[] = {
                                0xff, 0x03, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
                                0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
                                0x01, 0x00, 0x01, 0x00, 0xff, 0x03, 0x20, 0x00,
                                0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
                                0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00};

static unsigned char AR_BRELM_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x07, 0x01, 0x00, 0x00,
                                0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x04, 0x01,
                                0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00,
                                0x04, 0x01, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00,
                                0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x04,
                                0x01, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00,
                                0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xfe, 0xff, 0xfb,
                                0x0f, 0x80, 0x02, 0x00, 0x0a, 0x00, 0x80, 0x02,
                                0x00, 0x0a, 0x00, 0x80, 0x02, 0x00, 0x0a, 0x00,
                                0x80, 0x02, 0x00, 0x0a, 0x00, 0x80, 0x02, 0x00,
                                0x0a, 0x00, 0x80, 0x02, 0x00, 0x0a, 0x00, 0x80,
                                0x02, 0x00, 0x0a, 0x00, 0x80, 0x02, 0x00, 0x0a,
                                0x00, 0x80, 0x02, 0x00, 0x0a, 0x00, 0xff, 0xfe,
                                0xff, 0xfb, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char AR_BRSTD_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x00,
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
                                0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
                                0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
                                0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0x0f, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04,
                                0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
                                0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
                                0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
                                0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00};

static unsigned char AR_CONC_BITS[] = {
                                0x03, 0x00, 0x80, 0x05, 0x10, 0x00, 0x00, 0x0a,
                                0x08, 0x0a, 0x00, 0x03, 0x12, 0x00, 0x00, 0x00,
                                0x4c, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00,
                                0x0e, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x07, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x00,
                                0x00, 0x00, 0x08, 0x00, 0x28, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x02,
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x04,
                                0x40, 0x10, 0x40, 0x00, 0x00, 0xa0, 0x60, 0x08,
                                0x00, 0x40, 0xd0, 0x00, 0x08, 0x00, 0x00, 0x90,
                                0x00, 0x08, 0xa0, 0x00, 0x00, 0x90, 0x00, 0xe4,
                                0x00, 0x00, 0x00, 0x20, 0x08, 0xa0, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x90, 0x04, 0xe0, 0x00, 0x00,
                                0x00, 0x90, 0x00, 0x60, 0x00, 0x48, 0x00, 0x00,
                                0x02, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
                                0x80, 0x30, 0x00, 0x00, 0x00, 0x02, 0x00, 0x82,
                                0x40, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00,
                                0x00, 0x11, 0x10, 0x01, 0x80, 0x21, 0x00, 0x02,
                                0x40, 0x02, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00,
                                0x80, 0x03, 0x00, 0x00, 0x0a, 0x80, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x08, 0x89, 0x10, 0x00,
                                0x02, 0x00, 0x01, 0x10, 0x00, 0xd0, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x00, 0x00, 0x60, 0x02, 0x14,
                                0x00, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x90,
                                0x00, 0x00, 0x88, 0x08, 0x00, 0x00, 0x00, 0x0e,
                                0x00, 0x18, 0xf0, 0x13, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x0c, 0x08, 0x00, 0x00, 0x12,
                                0x00, 0x00, 0x00, 0x05, 0x00, 0x12, 0x00, 0x1c,
                                0x00, 0x00, 0x00, 0x10, 0x00, 0x94, 0x00, 0x00,
                                0x02, 0x00, 0x00, 0x12, 0x40, 0x4d, 0x00, 0x04,
                                0x40, 0x1a, 0x00, 0x0c, 0x00, 0x00, 0x80, 0x00,
                                0x00, 0x0c, 0x00, 0x00, 0x00, 0x40, 0x00, 0x01,
                                0x10, 0x00, 0x08, 0x01, 0x01, 0x90, 0x08, 0x00,
                                0x00, 0x41, 0x10, 0x00, 0x00, 0x70, 0x00, 0x00,
                                0x00, 0x50, 0x04, 0x01, 0x11, 0x00, 0x00, 0x00,
                                0x00, 0x20, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
                                0x02, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x08,
                                0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24,
                                0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x20, 0x80,
                                0x00, 0x04, 0x00, 0x20, 0x12, 0x02, 0x00, 0x00,
                                0x21, 0x00, 0x02, 0x80, 0x03, 0x00, 0x00, 0x00,
                                0x82, 0x00, 0x00, 0x41, 0x00, 0x80, 0x42, 0x22,
                                0x05, 0x00, 0x00, 0x02, 0x60, 0x02, 0x80, 0x0b,
                                0x02, 0x20, 0x10, 0x02, 0x80, 0x11, 0x00, 0x00,
                                0x00, 0x00, 0x40, 0x02, 0x80, 0x11, 0x10, 0x00,
                                0x40, 0x01, 0x80, 0x03, 0x00, 0x1e, 0x10, 0x04,
                                0x84, 0x01, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00,
                                0x80, 0x00, 0x19, 0x00, 0x10, 0x00, 0x12, 0x00,
                                0x00, 0x00, 0x13, 0x00, 0x00, 0x40, 0x0d, 0x00,
                                0x04, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x40, 0x10, 0x00, 0x00, 0x08,
                                0x00, 0x28, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x20, 0x04,
                                0x00, 0x00, 0x02, 0x21, 0x60, 0x00, 0x00, 0x00,
                                0xa0, 0x20, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
                                0x40, 0x00, 0x00, 0x00, 0xd0, 0x00, 0x01, 0x00,
                                0x44, 0x00, 0x40, 0x00, 0x60, 0x00, 0x00, 0x10,
                                0x70, 0x40, 0x08, 0x00, 0x10, 0x00, 0x48, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x48, 0x02, 0x30, 0x00,
                                0x00, 0x00, 0x20, 0x02, 0x30, 0x00, 0x04, 0x00};

static unsigned char AR_HBONE_BITS[] = {
                                0x01, 0x10, 0x00, 0x02, 0x20, 0x80, 0x04, 0x40,
                                0x40, 0x08, 0x80, 0x20, 0x10, 0x00, 0x11, 0x20,
                                0x00, 0x0a, 0x40, 0x00, 0x04, 0xa0, 0x00, 0x02,
                                0x10, 0x01, 0x01, 0x08, 0x82, 0x00, 0x04, 0x44,
                                0x00, 0x02, 0x28, 0x00};

static unsigned char AR_PARQ1_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0xc2, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0xc2, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0xc2, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0xc2, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0xc2, 0xff, 0xff, 0xff, 0x0f,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0x21, 0x84, 0x10, 0x42, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0xff, 0xff, 0xff, 0x7f, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0xff, 0xff, 0xff, 0x7f, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0xff, 0xff, 0xff, 0x7f, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0xff, 0xff, 0xff, 0x7f, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0xff, 0xff, 0xff, 0x7f, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x08, 0x21, 0x84, 0x00};

static unsigned char AR_RROOF_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
                                0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0xf8,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xfe,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x7f, 0x00, 0x80, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x7f, 0xfc,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x3f, 0x80, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xfe,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x1f, 0xe0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x07, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xf0,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
                                0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x0f, 0x80, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x1f, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff,
                                0xff, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x03, 0xfc, 0xff, 0xff, 0xff,
                                0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x00, 0xfe, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x0f, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x0f, 0x00, 0x00, 0xf0, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x01, 0x00, 0xfc, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x1f, 0x00, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x3f, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0x03, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
                                0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
                                0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xc0, 0xff,
                                0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xf0, 0xff,
                                0xff, 0xff, 0xff, 0xc7, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x07, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f,
                                0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
                                0x00, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0x07, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x07, 0xc0, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xfe,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x01, 0xfe, 0xff, 0xff,
                                0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x7f, 0x00, 0xff, 0xff, 0xff,
                                0xff, 0x3f, 0xfe, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x01,
                                0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0xfc,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xfe,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0x7f, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x00,
                                0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
                                0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0xf8,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xfc,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xe0,
                                0xff, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xf8,
                                0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0xfc,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
                                0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x07, 0x80, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x0f, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf8, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x01, 0x00, 0xfe, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x0f, 0x00, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00,
                                0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfc,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0x3f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
                                0x1f, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0x01, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
                                0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
                                0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char AR_RROOF_90_BITS[] = {
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x28, 0x00, 0x44, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x28, 0x00,
                                0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x28, 0x00, 0x44, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x28, 0x00, 0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x28, 0x00, 0x04,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x28, 0x00, 0x04, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x28,
                                0x00, 0x04, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x28, 0x00, 0x44, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x28, 0x00, 0x44, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x28, 0x00,
                                0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x28, 0x00, 0x44, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x28, 0x04, 0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x04, 0x92, 0x02, 0x28, 0x04, 0x44,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x04,
                                0x92, 0x02, 0x28, 0x04, 0x44, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x04, 0x92, 0x02, 0x2a,
                                0x04, 0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x04, 0x90, 0x02, 0x2a, 0x04, 0x44, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x04, 0x90,
                                0x02, 0x2a, 0x04, 0x44, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x04, 0x90, 0x02, 0x2a, 0x04,
                                0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x04, 0x90, 0x02, 0x2a, 0x04, 0x44, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x04, 0x90, 0x02,
                                0x2a, 0x04, 0x44, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x04, 0x90, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa0, 0x80, 0x8a, 0x40, 0x11, 0x04,
                                0x90, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa0,
                                0x80, 0x8a, 0x40, 0x11, 0x04, 0x90, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa0, 0x80, 0x8a, 0x40,
                                0x11, 0x04, 0x90, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa0, 0x80, 0x8a, 0x40, 0x11, 0x04, 0x90,
                                0x02, 0x22, 0x04, 0x45, 0x04, 0x41, 0xa0, 0x80,
                                0x8a, 0x40, 0x11, 0x04, 0x90, 0x02, 0x22, 0x04,
                                0x45, 0x04, 0x41, 0xa0, 0x80, 0x8a, 0x40, 0x11,
                                0x04, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x41,
                                0xa0, 0x00, 0x8a, 0x40, 0x11, 0x04, 0x92, 0x02,
                                0x22, 0x04, 0x45, 0x04, 0x41, 0xa0, 0x00, 0x8a,
                                0x40, 0x11, 0x04, 0x92, 0x02, 0x22, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x00, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x00, 0x0a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x22,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x00, 0x0a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x00, 0x0a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x22, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x00,
                                0x02, 0x40, 0x11, 0x05, 0x92, 0x02, 0x22, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x00, 0x02, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x00, 0x02, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x22, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x00, 0x02,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x22, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x00, 0x02, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x00, 0x02, 0x40, 0x11, 0x05, 0x92, 0x02, 0x22,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x00, 0x02, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x00, 0x02, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x22, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x00,
                                0x82, 0x40, 0x11, 0x05, 0x92, 0x02, 0x22, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x00, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x00, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x22, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x22, 0x04, 0x45,
                                0x04, 0x01, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x22, 0x04, 0x45, 0x04, 0x01, 0xa4,
                                0x80, 0x8a, 0x40, 0x01, 0x05, 0x92, 0x02, 0x22,
                                0x04, 0x45, 0x04, 0x01, 0xa4, 0x80, 0x8a, 0x40,
                                0x01, 0x05, 0x92, 0x02, 0x22, 0x04, 0x41, 0x04,
                                0x01, 0xa4, 0x80, 0x8a, 0x40, 0x01, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x41, 0x04, 0x01, 0xa4, 0x80,
                                0x8a, 0x40, 0x01, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x41, 0x04, 0x01, 0xa4, 0x80, 0x8a, 0x40, 0x01,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x41, 0x00, 0x01,
                                0xa4, 0x80, 0x8a, 0x40, 0x01, 0x05, 0x12, 0x02,
                                0x2a, 0x04, 0x41, 0x00, 0x01, 0xa4, 0x80, 0x8a,
                                0x40, 0x01, 0x05, 0x12, 0x02, 0x2a, 0x04, 0x41,
                                0x00, 0x01, 0xa4, 0x80, 0x8a, 0x40, 0x01, 0x05,
                                0x12, 0x02, 0x2a, 0x04, 0x41, 0x00, 0x01, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x12, 0x02, 0x2a,
                                0x04, 0x41, 0x00, 0x01, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x12, 0x02, 0x2a, 0x04, 0x41, 0x00,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x12,
                                0x02, 0x2a, 0x04, 0x41, 0x00, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x12, 0x02, 0x2a, 0x04,
                                0x41, 0x00, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x02, 0x02, 0x2a, 0x04, 0x41, 0x00, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x02, 0x02,
                                0x2a, 0x04, 0x41, 0x00, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x02, 0x02, 0x2a, 0x04, 0x41,
                                0x00, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x02, 0x02, 0x2a, 0x04, 0x41, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x02, 0x00, 0x2a,
                                0x04, 0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x02, 0x00, 0x2a, 0x04, 0x41, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x02,
                                0x00, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x02, 0x00, 0x28, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x02, 0x00, 0x28, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x12, 0x00,
                                0x28, 0x04, 0x45, 0x04, 0x41, 0xa0, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x12, 0x00, 0x28, 0x04, 0x45,
                                0x04, 0x41, 0xa0, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x12, 0x00, 0x28, 0x04, 0x45, 0x04, 0x41, 0xa0,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x12, 0x00, 0x28,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x12, 0x00, 0x08, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x12,
                                0x00, 0x08, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x12, 0x00, 0x08, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x12, 0x00, 0x08, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x00,
                                0x08, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x00, 0x0a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x05,
                                0x92, 0x00, 0x0a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x10, 0x05, 0x92, 0x00, 0x0a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x10, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x82, 0x40, 0x10, 0x00, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x82, 0x40, 0x10, 0x00, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x82, 0x40, 0x10,
                                0x00, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x10, 0x00, 0x92, 0x02,
                                0x2a, 0x04, 0x05, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x10, 0x00, 0x92, 0x02, 0x2a, 0x04, 0x04,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x00,
                                0x92, 0x02, 0x2a, 0x04, 0x04, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x10, 0x00, 0x92, 0x02, 0x2a,
                                0x04, 0x04, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x10, 0x00, 0x92, 0x02, 0x2a, 0x04, 0x04, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x00, 0x92,
                                0x02, 0x2a, 0x04, 0x04, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x10, 0x00, 0x92, 0x02, 0x2a, 0x04,
                                0x04, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10,
                                0x00, 0x92, 0x02, 0x2a, 0x04, 0x04, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x10, 0x01, 0x92, 0x02,
                                0x2a, 0x04, 0x04, 0x04, 0x41, 0x24, 0x80, 0x8a,
                                0x40, 0x10, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x44,
                                0x04, 0x41, 0x24, 0x80, 0x8a, 0x40, 0x00, 0x01,
                                0x92, 0x02, 0x2a, 0x04, 0x44, 0x04, 0x41, 0x24,
                                0x80, 0x8a, 0x40, 0x01, 0x01, 0x92, 0x02, 0x2a,
                                0x04, 0x44, 0x04, 0x41, 0x24, 0x00, 0x8a, 0x40,
                                0x01, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0x24, 0x00, 0x8a, 0x40, 0x11, 0x01, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0x24, 0x00,
                                0x8a, 0x40, 0x11, 0x01, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0x24, 0x00, 0x8a, 0x40, 0x11,
                                0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0x24, 0x00, 0x8a, 0x40, 0x11, 0x01, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0x24, 0x00, 0x8a,
                                0x40, 0x11, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0x24, 0x00, 0x8a, 0x40, 0x11, 0x01,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0x24,
                                0x00, 0x8a, 0x40, 0x11, 0x01, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0x24, 0x00, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0x24, 0x00, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0x24, 0x00,
                                0x8a, 0x40, 0x11, 0x05, 0x82, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0x24, 0x80, 0x8a, 0x00, 0x11,
                                0x05, 0x82, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0x24, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x82, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0x24, 0x80, 0x8a,
                                0x00, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x00, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00,
                                0x11, 0x05, 0x92, 0x02, 0x22, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x92,
                                0x02, 0x22, 0x00, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x00, 0x11, 0x05, 0x92, 0x02, 0x22, 0x00,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11,
                                0x05, 0x92, 0x02, 0x22, 0x00, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x92, 0x02,
                                0x22, 0x00, 0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x00, 0x11, 0x05, 0x92, 0x02, 0x22, 0x00, 0x41,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05,
                                0x92, 0x02, 0x22, 0x00, 0x41, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x00, 0x11, 0x05, 0x92, 0x02, 0x02,
                                0x00, 0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00,
                                0x11, 0x05, 0x92, 0x02, 0x02, 0x00, 0x41, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x92,
                                0x02, 0x02, 0x00, 0x41, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x00, 0x11, 0x05, 0x92, 0x02, 0x22, 0x00,
                                0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11,
                                0x05, 0x92, 0x02, 0x22, 0x00, 0x41, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x00, 0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x00, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x00, 0x41,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x00, 0x41, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x00, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x00, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x00,
                                0x11, 0x05, 0x90, 0x02, 0x2a, 0x00, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x05, 0x90,
                                0x02, 0x2a, 0x00, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x00, 0x11, 0x05, 0x90, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x90, 0x00, 0x2a, 0x04, 0x05, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x90, 0x00,
                                0x2a, 0x04, 0x05, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x90, 0x00, 0x2a, 0x04, 0x05,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x90, 0x00, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x88, 0x40, 0x11, 0x05, 0x90, 0x00, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x88, 0x40,
                                0x11, 0x05, 0x90, 0x00, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x88, 0x40, 0x11, 0x05, 0x90,
                                0x00, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x88, 0x40, 0x11, 0x05, 0x90, 0x00, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x88, 0x40, 0x11,
                                0x05, 0x90, 0x00, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x88, 0x40, 0x11, 0x05, 0x10, 0x00,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x88,
                                0x40, 0x11, 0x05, 0x10, 0x00, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x88, 0x40, 0x11, 0x05,
                                0x10, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x08, 0x40, 0x11, 0x05, 0x10, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x08, 0x40,
                                0x11, 0x05, 0x10, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x08, 0x40, 0x11, 0x05, 0x12,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x08, 0x40, 0x10, 0x05, 0x12, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x08, 0x40, 0x10,
                                0x05, 0x12, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa0, 0x80, 0x08, 0x40, 0x10, 0x05, 0x12, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0xa0, 0x80, 0x08,
                                0x40, 0x10, 0x05, 0x12, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa0, 0x80, 0x08, 0x40, 0x10, 0x05,
                                0x12, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa0,
                                0x80, 0x08, 0x40, 0x10, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa0, 0x80, 0x08, 0x40,
                                0x10, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa0, 0x80, 0x08, 0x40, 0x10, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa0, 0x80,
                                0x08, 0x40, 0x10, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa0, 0x80, 0x08, 0x40, 0x10,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x08, 0x40, 0x10, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x08,
                                0x40, 0x10, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x08, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x01, 0xa4,
                                0x80, 0x0a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x01, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x01, 0x24, 0x80, 0x82, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x01, 0x04, 0x80,
                                0x82, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x01, 0x04, 0x80, 0x82, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x01,
                                0x04, 0x80, 0x82, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x00, 0x01, 0x04, 0x80, 0x82,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x00, 0x01, 0x04, 0x80, 0x82, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x00, 0x01, 0x04,
                                0x80, 0x82, 0x40, 0x11, 0x01, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x00, 0x01, 0x04, 0x80, 0x82, 0x40,
                                0x11, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x00,
                                0x01, 0x04, 0x80, 0x8a, 0x40, 0x11, 0x01, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x00, 0x01, 0x04, 0x80,
                                0x8a, 0x40, 0x11, 0x01, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x00, 0x01, 0x04, 0x80, 0x8a, 0x40, 0x11,
                                0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x00, 0x01,
                                0x04, 0x80, 0x8a, 0x40, 0x11, 0x01, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x00, 0x01, 0x84, 0x80, 0x8a,
                                0x40, 0x01, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x00, 0x01, 0x84, 0x80, 0x8a, 0x40, 0x01, 0x01,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x00, 0x41, 0x84,
                                0x80, 0x8a, 0x40, 0x01, 0x01, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x00, 0x41, 0x84, 0x80, 0x8a, 0x40,
                                0x01, 0x01, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x00,
                                0x41, 0x84, 0x80, 0x8a, 0x40, 0x01, 0x01, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x00, 0x41, 0x84, 0x80,
                                0x8a, 0x40, 0x01, 0x01, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x00, 0x41, 0x84, 0x80, 0x8a, 0x40, 0x01,
                                0x05, 0x92, 0x02, 0x28, 0x04, 0x45, 0x00, 0x41,
                                0x84, 0x80, 0x8a, 0x40, 0x01, 0x05, 0x92, 0x02,
                                0x28, 0x04, 0x45, 0x04, 0x41, 0x84, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x28, 0x00, 0x45,
                                0x04, 0x41, 0x84, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x28, 0x00, 0x45, 0x04, 0x41, 0x84,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x28,
                                0x00, 0x45, 0x04, 0x41, 0x84, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x28, 0x00, 0x45, 0x04,
                                0x41, 0x84, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x28, 0x00, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x82, 0x02, 0x28, 0x00,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x82, 0x02, 0x28, 0x00, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x82, 0x02,
                                0x28, 0x00, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x82, 0x02, 0x28, 0x00, 0x45,
                                0x04, 0x40, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x82, 0x02, 0x28, 0x00, 0x45, 0x04, 0x40, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x82, 0x02, 0x28,
                                0x00, 0x45, 0x04, 0x40, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x82, 0x02, 0x28, 0x00, 0x45, 0x04,
                                0x40, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x82,
                                0x02, 0x28, 0x04, 0x45, 0x04, 0x40, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x04, 0x92, 0x02, 0x28, 0x04,
                                0x45, 0x04, 0x40, 0xa0, 0x80, 0x8a, 0x00, 0x11,
                                0x04, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x40,
                                0xa0, 0x80, 0x8a, 0x00, 0x11, 0x04, 0x90, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x40, 0xa0, 0x80, 0x8a,
                                0x00, 0x11, 0x04, 0x90, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x40, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x04,
                                0x90, 0x02, 0x0a, 0x04, 0x45, 0x04, 0x40, 0xa4,
                                0x80, 0x8a, 0x00, 0x11, 0x04, 0x90, 0x02, 0x0a,
                                0x04, 0x45, 0x04, 0x40, 0xa4, 0x80, 0x8a, 0x00,
                                0x11, 0x04, 0x90, 0x02, 0x0a, 0x04, 0x45, 0x04,
                                0x40, 0xa4, 0x80, 0x8a, 0x00, 0x11, 0x04, 0x90,
                                0x02, 0x0a, 0x04, 0x45, 0x04, 0x40, 0xa4, 0x80,
                                0x8a, 0x00, 0x11, 0x04, 0x90, 0x02, 0x0a, 0x04,
                                0x45, 0x04, 0x40, 0xa4, 0x80, 0x8a, 0x00, 0x11,
                                0x04, 0x90, 0x02, 0x0a, 0x04, 0x45, 0x04, 0x40,
                                0xa4, 0x80, 0x8a, 0x00, 0x11, 0x04, 0x90, 0x02,
                                0x0a, 0x04, 0x45, 0x04, 0x40, 0xa4, 0x80, 0x8a,
                                0x00, 0x11, 0x04, 0x90, 0x02, 0x0a, 0x04, 0x45,
                                0x04, 0x40, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x04,
                                0x90, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x40, 0xa4,
                                0x80, 0x82, 0x40, 0x11, 0x04, 0x90, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x40, 0xa4, 0x80, 0x82, 0x40,
                                0x11, 0x04, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x40, 0xa4, 0x00, 0x82, 0x40, 0x11, 0x04, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x40, 0xa4, 0x00,
                                0x82, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x40, 0xa4, 0x00, 0x0a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x05, 0x04, 0x40,
                                0xa4, 0x00, 0x0a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x05, 0x04, 0x40, 0xa4, 0x00, 0x0a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x05,
                                0x04, 0x41, 0xa4, 0x00, 0x0a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x05, 0x04, 0x41, 0xa4,
                                0x00, 0x0a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x05, 0x04, 0x41, 0xa4, 0x00, 0x0a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x05, 0x04,
                                0x41, 0xa4, 0x00, 0x0a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x05, 0x04, 0x41, 0xa4, 0x00,
                                0x0a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x05, 0x04, 0x41, 0xa4, 0x00, 0x0a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x00, 0x0a, 0x40, 0x01, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x00, 0x0a,
                                0x40, 0x01, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x00, 0x08, 0x40, 0x01, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x00, 0x88, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x00, 0x88, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x88, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x01, 0xa4, 0x80,
                                0x88, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x01, 0xa4, 0x80, 0x88, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x01,
                                0xa4, 0x80, 0x88, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x01, 0xa4, 0x80, 0x88,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x41,
                                0x04, 0x01, 0xa4, 0x80, 0x88, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x41, 0x04, 0x01, 0xa4,
                                0x80, 0x88, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x41, 0x00, 0x01, 0xa4, 0x80, 0x88, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x41, 0x00,
                                0x01, 0xa4, 0x80, 0x88, 0x40, 0x11, 0x05, 0x82,
                                0x02, 0x2a, 0x04, 0x41, 0x00, 0x01, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x82, 0x02, 0x2a, 0x04,
                                0x41, 0x00, 0x01, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x82, 0x02, 0x2a, 0x04, 0x41, 0x00, 0x01,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x41, 0x00, 0x01, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x41,
                                0x00, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x41, 0x00, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x41, 0x00, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x41, 0x00,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x41, 0x00, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x41, 0x00, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x41, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x00,
                                0x2a, 0x04, 0x41, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x00, 0x0a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x00, 0x08, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x00, 0x08,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x00, 0x28, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x00, 0x28, 0x04, 0x45, 0x04, 0x41, 0x84, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x00, 0x28, 0x04,
                                0x45, 0x04, 0x41, 0x84, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x00, 0x28, 0x04, 0x45, 0x04, 0x41,
                                0x84, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x00,
                                0x28, 0x04, 0x45, 0x04, 0x41, 0x84, 0x80, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x00, 0x28, 0x04, 0x45,
                                0x04, 0x41, 0x84, 0x80, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x00, 0x28, 0x04, 0x45, 0x04, 0x41, 0x84,
                                0x80, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x00, 0x28,
                                0x04, 0x45, 0x04, 0x41, 0x84, 0x80, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x00, 0x28, 0x04, 0x45, 0x04,
                                0x41, 0x84, 0x80, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x00, 0x28, 0x04, 0x45, 0x04, 0x41, 0x84, 0x80,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x00, 0x2a, 0x04,
                                0x05, 0x04, 0x41, 0x84, 0x80, 0x8a, 0x40, 0x10,
                                0x05, 0x92, 0x00, 0x2a, 0x04, 0x05, 0x04, 0x41,
                                0x84, 0x80, 0x8a, 0x40, 0x10, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x05, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x10, 0x04, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x04,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x10, 0x04, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x10, 0x04, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x04, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80,
                                0x8a, 0x40, 0x10, 0x04, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10,
                                0x04, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0xa4, 0x80, 0x8a, 0x40, 0x10, 0x04, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a,
                                0x40, 0x10, 0x04, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x04,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0xa4,
                                0x80, 0x8a, 0x40, 0x10, 0x04, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x41, 0xa4, 0x80, 0x8a, 0x40,
                                0x10, 0x04, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x41, 0xa4, 0x80, 0x8a, 0x40, 0x10, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x41, 0x20, 0x80,
                                0x8a, 0x40, 0x10, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x41, 0x20, 0x80, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x41,
                                0x20, 0x00, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x40, 0x20, 0x00, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45,
                                0x04, 0x40, 0x20, 0x00, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x40, 0x20,
                                0x00, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x45, 0x04, 0x40, 0x20, 0x00, 0x8a, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04,
                                0x40, 0x20, 0x00, 0x8a, 0x40, 0x11, 0x05, 0x92,
                                0x02, 0x2a, 0x04, 0x45, 0x04, 0x40, 0x20, 0x00,
                                0x8a, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04,
                                0x45, 0x04, 0x40, 0x24, 0x00, 0x8a, 0x40, 0x11,
                                0x05, 0x92, 0x02, 0x2a, 0x04, 0x45, 0x04, 0x40,
                                0x24, 0x00, 0x8a, 0x40, 0x11, 0x05, 0x92, 0x02,
                                0x2a, 0x04, 0x45, 0x04, 0x40, 0x24, 0x00, 0x8a,
                                0x40, 0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x44,
                                0x04, 0x40, 0x24, 0x00, 0x8a, 0x40, 0x11, 0x05,
                                0x92, 0x02, 0x2a, 0x04, 0x44, 0x04, 0x40, 0x24,
                                0x00, 0x82, 0x40, 0x11, 0x05, 0x92, 0x02, 0x2a,
                                0x04, 0x44, 0x04, 0x40, 0x24, 0x80, 0x82, 0x40,
                                0x11, 0x05, 0x92, 0x02, 0x2a, 0x04, 0x44, 0x04};

static unsigned char AR_RSHKE_BITS[] = {
                                0xff, 0x07, 0xfc, 0x7f, 0xf8, 0xff, 0x07, 0x00,
                                0x01, 0xfc, 0x07, 0x40, 0x08, 0x00, 0xfc, 0x01,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x04, 0x40, 0x08, 0x00, 0x04, 0x00,
                                0x01, 0x04, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0xf0, 0xff, 0xe1, 0xff, 0x1f, 0xf8, 0x3f, 0x00,
                                0x1f, 0x00, 0x21, 0x00, 0xf0, 0x0f, 0xe0, 0x01,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0x10, 0x00, 0x21, 0x00, 0x10, 0x08, 0x20, 0x00,
                                0xfc, 0x00, 0x00, 0x00, 0x00, 0x08, 0x20, 0x00,
                                0x87, 0xff, 0x7f, 0xe0, 0xff, 0x80, 0xff, 0x01,
                                0x84, 0x00, 0xc0, 0x3f, 0x80, 0xff, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x84, 0x00, 0x40, 0x20, 0x80, 0x80, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x20, 0x80, 0xf0, 0x03, 0x00,
                                0xff, 0xc1, 0xff, 0x01, 0xfe, 0x1f, 0xfe, 0x01,
                                0x00, 0x7f, 0x00, 0xff, 0x03, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x41, 0x00, 0x01, 0x02, 0x10, 0x02, 0x00,
                                0x00, 0x40, 0x00, 0xc1, 0x0f, 0x00, 0x00, 0x00};

static unsigned char AR_RSHKE_90_BITS[] = {
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0xe8,
                                0xff, 0xff, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0xd0, 0xff,
                                0xff, 0x03, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0xfa, 0xff, 0x1f,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0xd0, 0xff, 0xff, 0x03, 0x00, 0x10, 0x00, 0x00,
                                0xfd, 0xff, 0x1f, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00,
                                0x00, 0x01, 0x00, 0xf0, 0xff, 0xff, 0x00, 0x00,
                                0x08, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x80,
                                0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x80, 0xfe, 0xff, 0x1f, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x80,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0xfd, 0xff, 0x3f,
                                0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x20, 0x00, 0x80, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0xa0, 0xff, 0xff, 0x01, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0xfd,
                                0xff, 0x3f, 0x00, 0x00, 0x01, 0x00, 0xd0, 0xff,
                                0xff, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0xff, 0xff, 0x1f, 0x00, 0x80, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x80, 0x00,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00,
                                0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0x08, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0xe8, 0xff, 0xff, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x03, 0x00, 0x08, 0x00,
                                0x00, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x02, 0x00,
                                0x08, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x02, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0xfa, 0xff, 0x1f, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x03, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0xd0, 0xff, 0xff,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0xfd, 0xff, 0x1f,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00,
                                0xf0, 0xff, 0xff, 0x01, 0x00, 0x08, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x08,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x80, 0x00,
                                0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x80, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x80, 0xfe, 0xff, 0x1f, 0x00, 0x00,
                                0xfd, 0xff, 0x3f, 0x00, 0x80, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x80, 0x00,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00,
                                0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0xa0, 0xff, 0xff, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x20, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0xfd, 0xff, 0x3f, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x80,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0xff,
                                0xff, 0x1f, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x08, 0x00, 0x80, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x80,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x08,
                                0x00, 0x80};

static unsigned char AR_RSHKE_180_BITS[] = {
                                0x81, 0xff, 0x7f, 0xf8, 0xff, 0x80, 0xff, 0x01,
                                0x00, 0x00, 0xc0, 0x0f, 0x02, 0x08, 0x00, 0x00,
                                0x00, 0x21, 0x00, 0x00, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0x01, 0x02, 0x08, 0x02, 0x00,
                                0x00, 0x21, 0x00, 0xff, 0x03, 0xf8, 0x03, 0x00,
                                0xff, 0xe1, 0xff, 0x01, 0xfe, 0x0f, 0xfe, 0x01,
                                0x00, 0x3f, 0x04, 0x20, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0x04, 0x04, 0x20, 0x08, 0x00, 0x84, 0x00,
                                0x00, 0xfc, 0x07, 0xe0, 0x0f, 0x00, 0x84, 0x00,
                                0xff, 0x07, 0xfc, 0x3f, 0xf8, 0xff, 0x87, 0x01,
                                0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x00, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x10, 0x40, 0x20, 0x00, 0x10, 0x02, 0x20, 0x00,
                                0x1f, 0xc0, 0x3f, 0x00, 0x10, 0x02, 0xe0, 0x01,
                                0xf0, 0x7f, 0xe0, 0xff, 0x1f, 0xfe, 0x3f, 0x00,
                                0x01, 0x00, 0x00, 0x00, 0xf0, 0x83, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x00, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0x81, 0x00, 0x40, 0x08, 0x80, 0x80, 0x00, 0x00,
                                0xff, 0x00, 0x40, 0x08, 0x80, 0xff, 0x00, 0x00};

static unsigned char AR_RSHKE_270_BITS[] = {
                                0xff, 0xff, 0x2f, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x20, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00,
                                0x20, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x02, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0xff, 0xff,
                                0x17, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0xf8,
                                0xff, 0x7f, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x08,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02,
                                0x00, 0xf8, 0xff, 0x7f, 0x01, 0x00, 0xf0, 0xff,
                                0xff, 0x02, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0x20, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x20, 0x00, 0x00, 0x02, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x00, 0x02,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00,
                                0x00, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x01, 0x00,
                                0x20, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x20, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0xf0, 0xff, 0x7f, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0xff, 0xff, 0x17, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x80,
                                0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0xf0,
                                0xff, 0xff, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x20, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x20, 0x00, 0x80, 0xff, 0xff,
                                0x17, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x80,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0xff,
                                0xff, 0x2f, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x20,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02,
                                0x00, 0xf0, 0xff, 0xff, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x00, 0xff, 0xff, 0x17, 0x00, 0x00,
                                0x01, 0x00, 0xf8, 0xff, 0x7f, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x00, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0xff, 0xff,
                                0x0f, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00,
                                0x02, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00, 0x02, 0x00, 0xf8, 0xff, 0x7f, 0x01,
                                0x00, 0x10, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x02, 0x00,
                                0x10, 0x00, 0x00, 0x01, 0x00, 0xf0, 0xff, 0xff,
                                0x02, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20,
                                0x00, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0x20, 0x00, 0x00, 0x02, 0x00, 0x10, 0x00,
                                0x00, 0x01, 0x00, 0x20, 0x00, 0x00, 0xff, 0xff,
                                0x1f, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20,
                                0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x00, 0x01,
                                0x00, 0xf0, 0xff, 0x7f, 0x01, 0x00, 0x10, 0x00,
                                0x80, 0xff, 0xff, 0x17, 0x00, 0x00, 0x01, 0x00,
                                0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x10,
                                0x00, 0x00, 0x01, 0x00, 0xf0, 0xff, 0xff, 0x00,
                                0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00,
                                0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00,
                                0x20, 0x00, 0x80, 0xff, 0xff, 0x17, 0x00, 0x00,
                                0x01, 0x00, 0x20, 0x00, 0x00, 0x01, 0x00, 0x10,
                                0x00, 0x00};

static unsigned char AR_SAND_BITS[] = {
                                0x01, 0x64, 0x00, 0x06, 0x00, 0x02, 0x00, 0x02,
                                0x00, 0x02, 0x00, 0x02, 0x04, 0x10, 0x08, 0x00,
                                0x00, 0x00, 0x01, 0x20, 0x00, 0x04, 0x00, 0x01,
                                0x20, 0x00, 0x00, 0x40, 0x04, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x00, 0x00, 0x02, 0x00, 0x00, 0x08, 0x00, 0x80,
                                0x00, 0x00, 0x08, 0x00, 0x00, 0x06, 0x00, 0x48,
                                0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x40, 0x00, 0x10, 0x00, 0x42, 0x42, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80,
                                0x00, 0x80, 0x00, 0xa0, 0x00, 0x90, 0x00, 0x82,
                                0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x90, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x02, 0x00, 0x20, 0x00, 0x08,
                                0x06, 0x00, 0x40, 0x00, 0x00, 0x10, 0x00, 0x00,
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00,
                                0x00, 0x00, 0x01, 0x20, 0x00, 0x04, 0x00, 0x01,
                                0x20, 0x00, 0x04, 0x80, 0x00, 0x00, 0x00, 0x00,
                                0x01, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80,
                                0x00, 0xc5, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
                                0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x06, 0x20,
                                0x01, 0x01, 0x00, 0x08, 0x00, 0x00, 0x01, 0x20,
                                0x10, 0x20, 0x00, 0x20, 0x00, 0x00, 0x40, 0x02,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0x02,
                                0x40, 0x00, 0x10, 0x00, 0x02, 0x40, 0x00, 0x00,
                                0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x80, 0x00,
                                0x00, 0x14, 0x00, 0x80, 0x01, 0x00, 0x10, 0x00,
                                0x00, 0x01};

static unsigned char ANSI31_BITS[] = {
                                0x01, 0x00, 0x02, 0x00, 0x04, 0x00, 0x08, 0x00,
                                0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x80, 0x00,
                                0x00, 0x01};

static unsigned char ANSI32_BITS[] = {
                                0x01, 0x02, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00,
                                0x04, 0x08, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00,
                                0x10, 0x20, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00,
                                0x40, 0x80, 0x00, 0x00, 0x80, 0x00, 0x01, 0x00,
                                0x00, 0x01, 0x02, 0x00, 0x00, 0x02, 0x04, 0x00,
                                0x00, 0x04, 0x08, 0x00, 0x00, 0x08, 0x10, 0x00,
                                0x00, 0x10, 0x20, 0x00, 0x00, 0x20, 0x40, 0x00,
                                0x00, 0x40, 0x80, 0x00, 0x00, 0x80, 0x00, 0x01,
                                0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x02, 0x04,
                                0x01, 0x00, 0x04, 0x00, 0x02, 0x00, 0x08, 0x00,
                                0x04, 0x00, 0x10, 0x00, 0x08, 0x00, 0x20, 0x00,
                                0x10, 0x00, 0x40, 0x00, 0x20, 0x00, 0x80, 0x00,
                                0x40, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x02,
                                0x00, 0x01, 0x00, 0x04};

static unsigned char ANSI33_BITS[] = {
                                0x01, 0x02, 0x00, 0x02, 0x04, 0x00, 0x04, 0x08,
                                0x00, 0x08, 0x10, 0x00, 0x10, 0x20, 0x00, 0x20,
                                0x40, 0x00, 0x40, 0x00, 0x00, 0x80, 0x00, 0x01,
                                0x00, 0x01, 0x02, 0x01, 0x02, 0x00, 0x02, 0x04,
                                0x00, 0x04, 0x08, 0x00, 0x08, 0x10, 0x00, 0x10,
                                0x20, 0x00, 0x20, 0x40, 0x00, 0x00, 0x80, 0x00,
                                0x80, 0x00, 0x01, 0x00, 0x01, 0x02};

static unsigned char ANSI34_BITS[] = {
                                0x01, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00, 0x02,
                                0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x04, 0x08,
                                0x10, 0x20, 0x00, 0x00, 0x00, 0x08, 0x10, 0x20,
                                0x40, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40, 0x80,
                                0x00, 0x00, 0x00, 0x20, 0x40, 0x80, 0x00, 0x01,
                                0x00, 0x00, 0x40, 0x80, 0x00, 0x01, 0x02, 0x00,
                                0x00, 0x80, 0x00, 0x01, 0x02, 0x04, 0x00, 0x00,
                                0x00, 0x01, 0x02, 0x04, 0x08, 0x00, 0x00, 0x00,
                                0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x04,
                                0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x08, 0x10,
                                0x20, 0x40, 0x00, 0x00, 0x00, 0x10, 0x20, 0x40,
                                0x80, 0x00, 0x00, 0x00, 0x20, 0x40, 0x80, 0x00,
                                0x01, 0x00, 0x00, 0x40, 0x80, 0x00, 0x01, 0x02,
                                0x00, 0x00, 0x80, 0x00, 0x01, 0x02, 0x04, 0x00,
                                0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x00, 0x00,
                                0x00, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00,
                                0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x08,
                                0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x10, 0x20,
                                0x40, 0x80, 0x00, 0x00, 0x00, 0x20, 0x40, 0x80,
                                0x00, 0x01, 0x00, 0x00, 0x40, 0x80, 0x00, 0x01,
                                0x02, 0x00, 0x00, 0x80, 0x00, 0x01, 0x02, 0x04,
                                0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x00,
                                0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x00, 0x00,
                                0x00, 0x04, 0x08, 0x10, 0x20, 0x01, 0x00, 0x00,
                                0x08, 0x10, 0x20, 0x00, 0x02, 0x00, 0x00, 0x10,
                                0x20, 0x40, 0x00, 0x04, 0x00, 0x00, 0x20, 0x40,
                                0x80, 0x00, 0x08, 0x00, 0x00, 0x40, 0x80, 0x00,
                                0x01, 0x10, 0x00, 0x00, 0x80, 0x00, 0x01, 0x02,
                                0x20, 0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x40,
                                0x00, 0x00, 0x00, 0x02, 0x04, 0x08, 0x80, 0x00,
                                0x00, 0x00, 0x04, 0x08, 0x10, 0x00, 0x01, 0x00,
                                0x00, 0x08, 0x10, 0x20, 0x01, 0x02, 0x00, 0x00,
                                0x10, 0x20, 0x00, 0x02, 0x04, 0x00, 0x00, 0x20,
                                0x40, 0x00, 0x04, 0x08, 0x00, 0x00, 0x40, 0x80,
                                0x00, 0x08, 0x10, 0x00, 0x00, 0x80, 0x00, 0x01,
                                0x10, 0x20, 0x00, 0x00, 0x00, 0x01, 0x02, 0x20,
                                0x40, 0x00, 0x00, 0x00, 0x02, 0x04, 0x40, 0x80,
                                0x00, 0x00, 0x00, 0x04, 0x08, 0x80, 0x00, 0x01,
                                0x00, 0x00, 0x08, 0x10, 0x00, 0x01, 0x02, 0x00,
                                0x00, 0x10, 0x20, 0x01, 0x02, 0x04, 0x00, 0x00,
                                0x20, 0x00, 0x02, 0x04, 0x08, 0x00, 0x00, 0x40,
                                0x00, 0x04, 0x08, 0x10, 0x00, 0x00, 0x80, 0x00,
                                0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x01, 0x10,
                                0x20, 0x40, 0x00, 0x00, 0x00, 0x02, 0x20, 0x40,
                                0x80, 0x00, 0x00, 0x00, 0x04, 0x40, 0x80, 0x00,
                                0x01, 0x00, 0x00, 0x08, 0x80, 0x00, 0x01, 0x02,
                                0x00, 0x00, 0x10, 0x00, 0x01, 0x02, 0x04, 0x00,
                                0x00, 0x20};

static unsigned char ANSI35_BITS[] = {
                                0x01, 0x02, 0x04, 0x08, 0x00, 0x02, 0x04, 0x08,
                                0x10, 0x00, 0x04, 0x08, 0x10, 0x20, 0x00, 0x08,
                                0x10, 0x20, 0x00, 0x00, 0x10, 0x20, 0x40, 0x00,
                                0x00, 0x20, 0x40, 0x80, 0x00, 0x01, 0x40, 0x80,
                                0x00, 0x01, 0x00, 0x80, 0x00, 0x01, 0x02, 0x04,
                                0x00, 0x01, 0x02, 0x04, 0x08, 0x01, 0x02, 0x04,
                                0x08, 0x00, 0x02, 0x04, 0x08, 0x10, 0x00, 0x04,
                                0x08, 0x10, 0x20, 0x00, 0x08, 0x10, 0x00, 0x40,
                                0x00, 0x10, 0x20, 0x00, 0x80, 0x00, 0x20, 0x40,
                                0x80, 0x00, 0x01, 0x40, 0x80, 0x00, 0x00, 0x02,
                                0x80, 0x00, 0x01, 0x02, 0x04, 0x00, 0x01, 0x02,
                                0x04, 0x08, 0x01, 0x02, 0x04, 0x08, 0x00, 0x02,
                                0x04, 0x08, 0x10, 0x00, 0x04, 0x08, 0x10, 0x20,
                                0x00, 0x08, 0x00, 0x20, 0x40, 0x00, 0x10, 0x00,
                                0x40, 0x80, 0x00, 0x20, 0x40, 0x80, 0x00, 0x01,
                                0x40, 0x00, 0x00, 0x01, 0x02, 0x80, 0x00, 0x01,
                                0x02, 0x04, 0x00, 0x01, 0x02, 0x04, 0x08, 0x01,
                                0x02, 0x04, 0x08, 0x00, 0x02, 0x04, 0x08, 0x10,
                                0x00, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x10,
                                0x20, 0x40, 0x00, 0x00, 0x20, 0x40, 0x80, 0x00,
                                0x20, 0x40, 0x80, 0x00, 0x01, 0x00, 0x80, 0x00,
                                0x01, 0x02, 0x80, 0x00, 0x01, 0x02, 0x04, 0x00,
                                0x01, 0x02, 0x04, 0x08};

static unsigned char ANSI36_BITS[] = {
                                0x01, 0x00, 0x02, 0x04, 0x04, 0x00, 0x08, 0x10,
                                0x10, 0x20, 0x20, 0x40, 0x40, 0x00, 0x80, 0x00,
                                0x00, 0x01, 0x00, 0x02, 0x02, 0x04, 0x00, 0x08,
                                0x08, 0x00, 0x10, 0x20, 0x20, 0x00};

static unsigned char ANSI37_BITS[] = {
                                0x01, 0x00, 0x02, 0x01, 0x84, 0x00, 0x48, 0x00,
                                0x30, 0x00, 0x30, 0x00, 0x48, 0x00, 0x84, 0x00,
                                0x02, 0x01};

static unsigned char ANSI38_BITS[] = {
                                0x01, 0x02, 0x00, 0x02, 0x05, 0x02, 0x84, 0x08,
                                0x01, 0x48, 0x10, 0x00, 0x30, 0x20, 0x00, 0x30,
                                0x40, 0x00, 0x48, 0x80, 0x00, 0x84, 0x00, 0x01,
                                0x00, 0x01, 0x02, 0x01, 0x02, 0x00, 0x02, 0x05,
                                0x00, 0x84, 0x08, 0x03, 0x48, 0x90, 0x00, 0x30,
                                0x60, 0x00, 0x30, 0x60, 0x00, 0x48, 0x90, 0x00,
                                0x84, 0x08, 0x01, 0x02, 0x01, 0x02};

static unsigned char ACAD_ISO02W100_BITS[] = {
                                0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO03W100_BITS[] = {
                                0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO04W100_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x1f, 0x02, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO05W100_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x1f, 0xc2, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO06W100_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x1f, 0x43, 0x18, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO07W100_BITS[] = {
                                0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO08W100_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x1f, 0xfe, 0x07, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO09W100_BITS[] = {
                                0xff, 0xff, 0xff, 0xff, 0x1f, 0xfe, 0xc7, 0xff,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO10W100_BITS[] = {
                                0xff, 0xff, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO11W100_BITS[] = {
                                0xff, 0xff, 0xc7, 0xff, 0xff, 0x61, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO12W100_BITS[] = {
                                0xff, 0xff, 0x87, 0x30, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO13W100_BITS[] = {
                                0xff, 0xff, 0x87, 0xff, 0xff, 0x63, 0x08, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO14W100_BITS[] = {
                                0xff, 0xff, 0xc7, 0x10, 0x06, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char ACAD_ISO15W100_BITS[] = {
                                0xff, 0xff, 0x87, 0xff, 0xff, 0x63, 0x0c, 0x01,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//------------------------------------------------------------------------------
// AutoCAD fill patterns defined as a series of line segments. The first element
// in each array specifies the number of segments, and subsequent quads of
// elements specify the line segment endpoints. These arrays were supplied to
// us by the Actrix SWD team.
//------------------------------------------------------------------------------

// Removed..... we use bitmaps


static unsigned char SHAPEFILL12_BITS[] = {0xff, 0xef, 0xff, 0xfe, 0xff, 0xef, 0xff, 0xfe};
static unsigned char SHAPEFILL13_BITS[] = {0xff, 0xee, 0xff, 0xbb, 0xff, 0xee, 0xff, 0xbb};
static unsigned char SHAPEFILL14_BITS[] = {0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb};
static unsigned char SHAPEFILL15_BITS[] = {0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55};
static unsigned char SHAPEFILL16_BITS[] = {0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11};
static unsigned char SHAPEFILL17_BITS[] = {0x00, 0x44, 0x00, 0x11, 0x00, 0x44, 0x00, 0x11};
static unsigned char SHAPEFILL18_BITS[] = {0x00, 0x10, 0x00, 0x01, 0x00, 0x10, 0x00, 0x01};
static unsigned char SHAPEFILL19_BITS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff};
static unsigned char SHAPEFILL20_BITS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff};
static unsigned char SHAPEFILL21_BITS[] = {0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff};
static unsigned char SHAPEFILL22_BITS[] = {0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff};
static unsigned char SHAPEFILL23_BITS[] = {0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff};
static unsigned char SHAPEFILL24_BITS[] = {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01};
static unsigned char SHAPEFILL25_BITS[] = {0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03};
static unsigned char SHAPEFILL26_BITS[] = {0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};
static unsigned char SHAPEFILL27_BITS[] = {0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33};
static unsigned char SHAPEFILL28_BITS[] = {0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55};
static unsigned char SHAPEFILL29_BITS[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
static unsigned char SHAPEFILL30_BITS[] = {0x81, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0};
static unsigned char SHAPEFILL31_BITS[] = {0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88};
static unsigned char SHAPEFILL32_BITS[] = {0x99, 0x33, 0x66, 0xcc, 0x99, 0x33, 0x66, 0xcc};
static unsigned char SHAPEFILL33_BITS[] = {0xee, 0xdd, 0xbb, 0x77, 0xee, 0xdd, 0xbb, 0x77};
static unsigned char SHAPEFILL34_BITS[] = {0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01};
static unsigned char SHAPEFILL35_BITS[] = {0x81, 0xc0, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03};
static unsigned char SHAPEFILL36_BITS[] = {0x88, 0x44, 0x22, 0x11, 0x88, 0x44, 0x22, 0x11};
static unsigned char SHAPEFILL37_BITS[] = {0x99, 0xcc, 0x66, 0x33, 0x99, 0xcc, 0x66, 0x33};
static unsigned char SHAPEFILL38_BITS[] = {0x77, 0xbb, 0xdd, 0xee, 0x77, 0xbb, 0xdd, 0xee};
static unsigned char SHAPEFILL39_BITS[] = {0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff};
static unsigned char SHAPEFILL40_BITS[] = {0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xff, 0xff};
static unsigned char SHAPEFILL41_BITS[] = {0x11, 0x11, 0x11, 0xff, 0x11, 0x11, 0x11, 0xff};
static unsigned char SHAPEFILL42_BITS[] = {0x33, 0x33, 0xff, 0xff, 0x33, 0x33, 0xff, 0xff};
static unsigned char SHAPEFILL43_BITS[] = {0x55, 0xff, 0x55, 0xff, 0x55, 0xff, 0x55, 0xff};
static unsigned char SHAPEFILL44_BITS[] = {0x80, 0x41, 0x22, 0x14, 0x08, 0x14, 0x22, 0x41};
static unsigned char SHAPEFILL45_BITS[] = {0x81, 0xc3, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0xc3};
static unsigned char SHAPEFILL46_BITS[] = {0x88, 0x55, 0x22, 0x55, 0x88, 0x55, 0x22, 0x55};
static unsigned char SHAPEFILL47_BITS[] = {0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33};
static unsigned char SHAPEFILL48_BITS[] = {0xb1, 0x30, 0x03, 0x1b, 0xd8, 0xc0, 0x0c, 0x8d};
static unsigned char SHAPEFILL49_BITS[] = {0x20, 0x02, 0x10, 0x80, 0x04, 0x40, 0x08, 0x01};
static unsigned char SHAPEFILL50_BITS[] = {0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55};
static unsigned char SHAPEFILL51_BITS[] = {0x00, 0x10, 0x20, 0x40, 0x00, 0x04, 0x02, 0x01};
static unsigned char SHAPEFILL52_BITS[] = {0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01};
static unsigned char SHAPEFILL53_BITS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01};
static unsigned char SHAPEFILL54_BITS[] = {0x80, 0x80, 0x80, 0x41, 0x22, 0x9c, 0x22, 0x41};
static unsigned char SHAPEFILL55_BITS[] = {0x8e, 0x44, 0xe8, 0xf1, 0xe2, 0x44, 0x2e, 0x1f};
static unsigned char SHAPEFILL56_BITS[] = {0x20, 0x20, 0x50, 0xaa, 0x02, 0x02, 0x05, 0xaa};
static unsigned char SHAPEFILL57_BITS[] = {0x40, 0xa0, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x04};
static unsigned char SHAPEFILL58_BITS[] = {0x0d, 0x0d, 0x0d, 0x0d, 0xfd, 0xfd, 0x00, 0xfd};
static unsigned char SHAPEFILL59_BITS[] = {0x10, 0x10, 0x10, 0xff, 0x01, 0x01, 0x01, 0xff};
static unsigned char SHAPEFILL60_BITS[] = {0x00, 0x01, 0x00, 0x11, 0x00, 0x01, 0x00, 0x55};
static unsigned char SHAPEFILL61_BITS[] = {0x20, 0x40, 0x80, 0x01, 0x83, 0x44, 0x38, 0x10};
static unsigned char SHAPEFILL62_BITS[] = {0x00, 0x55, 0x00, 0x11, 0x82, 0x44, 0x28, 0x11};
static unsigned char SHAPEFILL63_BITS[] = {0x00, 0x00, 0x50, 0x20, 0x00, 0x00, 0x05, 0x02};
static unsigned char SHAPEFILL64_BITS[] = {0x80, 0x80, 0x40, 0x30, 0x0c, 0x12, 0x21, 0xc0};
static unsigned char SHAPEFILL65_BITS[] = {0xc7, 0x28, 0x10, 0x10, 0x7c, 0x82, 0x01, 0x01};
static unsigned char SHAPEFILL66_BITS[] = {0x10, 0x20, 0x40, 0xff, 0x55, 0x2a, 0x04, 0x08};
static unsigned char SHAPEFILL67_BITS[] = {0x1f, 0x1f, 0x19, 0xee, 0xf1, 0xf1, 0x91, 0xee};
static unsigned char SHAPEFILL68_BITS[] = {0x10, 0x28, 0x54, 0xaa, 0x54, 0x28, 0x10, 0x00};
static unsigned char SHAPEFILL69_BITS[] = {0x22, 0x49, 0x9c, 0x39, 0x92, 0x44, 0x28, 0x14};
static unsigned char SHAPEFILL70_BITS[] = {0x00, 0x06, 0x06, 0x06, 0x00, 0x60, 0x60, 0x60};
static unsigned char SHAPEFILL71_BITS[] = {0x8f, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88};

// fill pattern definitions (bit patterns and segments)
struct FillPattern
{
    int m_width;          // width of the pattern in pixels
    int m_height;         // height of the pattern in pixels
    unsigned char* m_bits;// pointer to the pixel pattern array
};

static FillPattern s_fillPattern[] = {
    {  8,   8, NONE_BITS},             // none
    {  8,   8, SOLID_BITS},            // solid
    {  8,   8, SHAPEFILL14_BITS},      // hatch
    {  8,   8, SHAPEFILL19_BITS},      // horizontal shapefill19
    {  8,   8, SHAPEFILL24_BITS},      // vertical shapefill24
    {  8,   8, SHAPEFILL29_BITS},      // diagonal45 shapefill29
    {  8,   8, SHAPEFILL34_BITS},      // diagonal135 shapefill34
    {  8,   8, SHAPEFILL39_BITS},      // cross shapefill39
    {  8,   8, SHAPEFILL44_BITS},      // diagonalcross shapefill44
    { 10,  10, ANGLE_BITS},
    { 25,  25, BOX_BITS},
    { 10,  13, BRASS_BITS},
    { 17,  17, BRICK_BITS},
    { 36,  24, BRSTONE_BITS},
    { 20,  12, CLAY_BITS},
    { 32,  32, CORK_BITS},
    { 24,  24, CROSS_BITS},
    { 12,  12, DASH_BITS},
    { 96,  96, DOLMIT_BITS},
    {  8,  16, DOTS_BITS},
    { 44,  44, EARTH_BITS},
    { 30,  53, ESCHER_BITS},
    { 20,  10, FLEX_BITS},
    { 36,  36, GRASS_BITS},
    { 19,   5, GRATE_BITS},
    { 35,  20, HEX_BITS},
    { 18,  10, HONEY_BITS},
    {152, 152, HOUND_BITS},
    {  8,  12, INSUL_BITS},
    { 32,  16, MUDST_BITS},
    { 10,  16, NET3_BITS},
    { 16,  16, PLAST_BITS},
    { 16,  16, PLASTI_BITS},
    { 10,  10, SACNCR_BITS},
    {  8,   8, SQUARE_BITS},
    { 24,  42, STARS_BITS},
    { 14,  14, STEEL_BITS},
    { 58, 100, SWAMP_BITS},
    {  8,   8, TRANS_BITS},
    { 20,  36, TRIANG_BITS},
    { 16,  16, ZIGZAG_BITS},
    { 20,  20, AR_B816_BITS},
    { 20,  20, AR_B816C_BITS},
    { 10,  20, AR_B88_BITS},
    { 36,  24, AR_BRELM_BITS},
    { 36,  24, AR_BRSTD_BITS},
    { 64,  64, AR_CONC_BITS},
    { 24,  12, AR_HBONE_BITS},
    { 60,  60, AR_PARQ1_BITS},
    {288, 100, AR_RROOF_BITS},
    {100, 288, AR_RROOF_90_BITS},
    { 57,  80, AR_RSHKE_BITS},
    { 80,  57, AR_RSHKE_90_BITS},
    { 57,  80, AR_RSHKE_180_BITS},
    { 80,  57, AR_RSHKE_270_BITS},
    {100,  18, AR_SAND_BITS},
    {  9,   9, ANSI31_BITS},
    { 27,  27, ANSI32_BITS},
    { 18,  18, ANSI33_BITS},
    { 54,  54, ANSI34_BITS},
    { 36,  36, ANSI35_BITS},
    { 15,  15, ANSI36_BITS},
    {  9,   9, ANSI37_BITS},
    { 18,  18, ANSI38_BITS},
    { 23,   8, ACAD_ISO02W100_BITS},
    { 45,   8, ACAD_ISO03W100_BITS},
    { 46,   8, ACAD_ISO04W100_BITS},
    { 51,   8, ACAD_ISO05W100_BITS},
    { 56,   8, ACAD_ISO06W100_BITS},
    {  5,   8, ACAD_ISO07W100_BITS},
    { 54,   8, ACAD_ISO08W100_BITS},
    { 68,   8, ACAD_ISO09W100_BITS},
    { 28,   8, ACAD_ISO10W100_BITS},
    { 50,   8, ACAD_ISO11W100_BITS},
    { 33,   8, ACAD_ISO12W100_BITS},
    { 56,   8, ACAD_ISO13W100_BITS},
    { 38,   8, ACAD_ISO14W100_BITS},
    { 61,   8, ACAD_ISO15W100_BITS},
    {  8,   8, SHAPEFILL12_BITS},
    {  8,   8, SHAPEFILL13_BITS},
    {  8,   8, SHAPEFILL14_BITS},
    {  8,   8, SHAPEFILL15_BITS},
    {  8,   8, SHAPEFILL16_BITS},
    {  8,   8, SHAPEFILL17_BITS},
    {  8,   8, SHAPEFILL18_BITS},
    {  8,   8, SHAPEFILL19_BITS}, // duplicates Horizontal hatch
    {  8,   8, SHAPEFILL20_BITS},
    {  8,   8, SHAPEFILL21_BITS},
    {  8,   8, SHAPEFILL22_BITS},
    {  8,   8, SHAPEFILL23_BITS},
    {  8,   8, SHAPEFILL24_BITS}, // duplicates Vertical hatch
    {  8,   8, SHAPEFILL25_BITS},
    {  8,   8, SHAPEFILL26_BITS},
    {  8,   8, SHAPEFILL27_BITS},
    {  8,   8, SHAPEFILL28_BITS},
    {  8,   8, SHAPEFILL29_BITS}, // duplicate Diagonal45 hatch
    {  8,   8, SHAPEFILL30_BITS},
    {  8,   8, SHAPEFILL31_BITS},
    {  8,   8, SHAPEFILL32_BITS},
    {  8,   8, SHAPEFILL33_BITS},
    {  8,   8, SHAPEFILL34_BITS}, // duplicate Diagonal135 hatch
    {  8,   8, SHAPEFILL35_BITS},
    {  8,   8, SHAPEFILL36_BITS},
    {  8,   8, SHAPEFILL37_BITS},
    {  8,   8, SHAPEFILL38_BITS},
    {  8,   8, SHAPEFILL39_BITS}, // duplicate Cross hatch
    {  8,   8, SHAPEFILL40_BITS},
    {  8,   8, SHAPEFILL41_BITS},
    {  8,   8, SHAPEFILL42_BITS},
    {  8,   8, SHAPEFILL43_BITS},
    {  8,   8, SHAPEFILL44_BITS}, // duplicate DiagonalCross hatch
    {  8,   8, SHAPEFILL45_BITS},
    {  8,   8, SHAPEFILL46_BITS},
    {  8,   8, SHAPEFILL47_BITS},
    {  8,   8, SHAPEFILL48_BITS},
    {  8,   8, SHAPEFILL49_BITS},
    {  8,   8, SHAPEFILL50_BITS},
    {  8,   8, SHAPEFILL51_BITS},
    {  8,   8, SHAPEFILL52_BITS},
    {  8,   8, SHAPEFILL53_BITS},
    {  8,   8, SHAPEFILL54_BITS},
    {  8,   8, SHAPEFILL55_BITS},
    {  8,   8, SHAPEFILL56_BITS},
    {  8,   8, SHAPEFILL57_BITS},
    {  8,   8, SHAPEFILL58_BITS},
    {  8,   8, SHAPEFILL59_BITS},
    {  8,   8, SHAPEFILL60_BITS},
    {  8,   8, SHAPEFILL61_BITS},
    {  8,   8, SHAPEFILL62_BITS},
    {  8,   8, SHAPEFILL63_BITS},
    {  8,   8, SHAPEFILL64_BITS},
    {  8,   8, SHAPEFILL65_BITS},
    {  8,   8, SHAPEFILL66_BITS},
    {  8,   8, SHAPEFILL67_BITS},
    {  8,   8, SHAPEFILL68_BITS},
    {  8,   8, SHAPEFILL69_BITS},
    {  8,   8, SHAPEFILL70_BITS},
    {  8,   8, SHAPEFILL71_BITS}
};


static wchar_t* fillPatternNames[] = {
        L"None",
        L"Solid",
        L"Square",
        L"Line",
        L"Line_90",
        L"Line_45",
        L"Line_135",
        L"Net",
        L"Net_45",
        L"ANGLE",
        L"BOX",
        L"BRASS",
        L"BRICK",
        L"BRSTONE",
        L"CLAY",
        L"CORK",
        L"CROSS",
        L"DASH",
        L"DOLMIT",
        L"DOTS",
        L"EARTH",
        L"ESCHER",
        L"FLEX",
        L"GRASS",
        L"GRATE",
        L"HEX",
        L"HONEY",
        L"HOUND",
        L"INSUL",
        L"MUDST",
        L"NET3",
        L"PLAST",
        L"PLASTI",
        L"SACNCR",
        L"SQUARE",
        L"STARS",
        L"STEEL",
        L"SWAMP",
        L"TRANS",
        L"TRIANG",
        L"ZIGZAG",
        L"AR_B816",
        L"AR_B816C",
        L"AR_B88",
        L"AR_BRELM",
        L"AR_BRSTD",
        L"AR_CONC",
        L"AR_HBONE",
        L"AR_PARQ1",
        L"AR_RROOF",
        L"AR_RROOF_90",
        L"AR_RSHKE",
        L"AR_RSHKE_90",
        L"AR_RSHKE_180",
        L"AR_RSHKE_270",
        L"AR_SAND",
        L"ANSI31",
        L"ANSI32",
        L"ANSI33",
        L"ANSI34",
        L"ANSI35",
        L"ANSI36",
        L"ANSI37",
        L"ANSI38",
        L"ACAD_ISO02W100",
        L"ACAD_ISO03W100",
        L"ACAD_ISO04W100",
        L"ACAD_ISO05W100",
        L"ACAD_ISO06W100",
        L"ACAD_ISO07W100",
        L"ACAD_ISO08W100",
        L"ACAD_ISO09W100",
        L"ACAD_ISO10W100",
        L"ACAD_ISO11W100",
        L"ACAD_ISO12W100",
        L"ACAD_ISO13W100",
        L"ACAD_ISO14W100",
        L"ACAD_ISO15W100",
        L"ShapeFill12",
        L"ShapeFill13",
        L"ShapeFill14",
        L"ShapeFill15",
        L"ShapeFill16",
        L"ShapeFill17",
        L"ShapeFill18",
        L"ShapeFill19",
        L"ShapeFill20",
        L"ShapeFill21",
        L"ShapeFill22",
        L"ShapeFill23",
        L"ShapeFill24",
        L"ShapeFill25",
        L"ShapeFill26",
        L"ShapeFill27",
        L"ShapeFill28",
        L"ShapeFill29",
        L"ShapeFill30",
        L"ShapeFill31",
        L"ShapeFill32",
        L"ShapeFill33",
        L"ShapeFill34",
        L"ShapeFill35",
        L"ShapeFill36",
        L"ShapeFill37",
        L"ShapeFill38",
        L"ShapeFill39",
        L"ShapeFill40",
        L"ShapeFill41",
        L"ShapeFill42",
        L"ShapeFill43",
        L"ShapeFill44",
        L"ShapeFill45",
        L"ShapeFill46",
        L"ShapeFill47",
        L"ShapeFill48",
        L"ShapeFill49",
        L"ShapeFill50",
        L"ShapeFill51",
        L"ShapeFill52",
        L"ShapeFill53",
        L"ShapeFill54",
        L"ShapeFill55",
        L"ShapeFill56",
        L"ShapeFill57",
        L"ShapeFill58",
        L"ShapeFill59",
        L"ShapeFill60",
        L"ShapeFill61",
        L"ShapeFill62",
        L"ShapeFill63",
        L"ShapeFill64",
        L"ShapeFill65",
        L"ShapeFill66",
        L"ShapeFill67",
        L"ShapeFill68",
        L"ShapeFill69",
        L"ShapeFill70",
        L"ShapeFill71"
};


gdImagePtr GDFillPatterns::CreatePatternBitmap(const wchar_t* name, int fgColor, int bgColor)
{
    int index = 1; //Solid by default

    //find the index
    for (int i=0; i<sizeof(fillPatternNames) / sizeof(wchar_t*);  i++)
    {
        if (_wcsicmp(name, fillPatternNames[i]) == 0)
        {
            index = i;
            break;
        }
    }

    FillPattern fp = s_fillPattern[index];

    gdImagePtr ret = gdImageCreateTrueColor(fp.m_width, fp.m_height);
    gdImageAlphaBlending(ret, 0);

    for (int row=0; row<fp.m_height; row++)
    {
        for (int col=0; col < fp.m_width; col++)
        {
            int bytesPerRow =  (fp.m_width + 7) / 8;
            int baseIndex = (fp.m_height - row - 1) * bytesPerRow;
            int byteIndex =  baseIndex + col / 8;
            int bitIndex = col % 8;

            if ((fp.m_bits[byteIndex] & 0x01 << bitIndex) != 0)
                gdImageSetPixel(ret, col, row, fgColor);
            else
                gdImageSetPixel(ret, col, row, bgColor);
        }
    }

    gdImageAlphaBlending(ret, 1);

    return ret;
}
