#ifndef FDOSMPHRDREADER_H
#define FDOSMPHRDREADER_H		1
/*
 * Copyright (C) 2010  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */

#include <Sm/Ph/Mgr.h>
#include <Sm/Ph/Reader.h>
#include <Sm/Ph/Rd/TableJoin.h>

// Base Class for readers of RDBMS elements.


class FdoSmPhRdReader : public FdoSmPhReader
{
protected:
    //Unused constructor needed only to build on Linux
    FdoSmPhRdReader() {}

    // Create an RDBMS element reader
	//
	FdoSmPhRdReader(
        FdoSmPhReaderP reader    // inner reader created by implementing class
    );

	FdoSmPhRdReader(
        FdoSmPhMgrP         mgr,                // Physical Schema Manager
        FdoSmPhRowsP        rows                // row and field layout
    );

    // Deactivates the reader.
	~FdoSmPhRdReader(void);

    // MakeQueryReader creates an inner reader which uses SQL to get RDBMS elements
    // from the datastore. Called only for RDBMS's that have physical schemas.
    //
    // The inner reader massages the given SQL statement before passing it to the
    // RDBMS to:
    //  - Bind in the objectNames
    //  - Join to the table specified by the join parameter.
    //
    // For the massaging to work, the SQL statement must contain the following
    // substitution arguments:
    //
    //
    //      Either of the following:
    //
    //          $(JOIN_CLAUSE) - must be placed at the end of the from clause. This
    //              gets replaced by a JOIN clause ( "JOIN table alias ON ..." ).
    //              If the join parameter is NULL then it is simply removed from the
    //              SQL statement. Takes precedence over $(JOIN_FROM)
    //
    //          $(JOIN_FROM) - must be placed at the end of the from clause. This gets
    //              replaced by the table to join to. If the join parameter is NULL
    //              or $(JOIN_CLAUSE) has been specified then it is simply removed 
    //              from the SQL statement.
    //
    //      $(QUALIFICATION) - can be placed anywhere in the where clause. This 
    //          gets replaced by the qualification clause generated by this function
    //          The qualification clause consists of:
    //
    //               a bind statement for each name in the objectNames parameter
    //               Each object name is split into:
    //
    //                  - its schema part, which is bound to the column specified
    //                    by schemaColumn.
    //
    //                  - its table part, which is bound to the column specified
    //                    by dbObjectColumn.
    //
    //                if $(JOIN_CLAUSE) has not been specified, a clause that joins 
    //                to the join table.
    //
    //          If the objectNames collection is empty and the join parameter is 
    //          NULL, then there is no qualification clause and this substitution
    //          argument is removed.
    //
    //      $(WHERE) - if the qualification clause is the only clause in the 
    //          where clause then specify $(WHERE) instead of "where" in the SQL
    //          statement. This function will replace it with "where" if the 
    //          qualification clause is not empty. If the qualification clause
    //          is empty then this argument is simply removed.
    //
    //      $(AND) - if the qualification clause is not the only clause in the 
    //          where clause the specify $(AND) where an "and" connector is needed
    //          between the qualification clause and the other clauses.
    //          This function will replace it with "and" if the 
    //          qualification clause is not empty. If the qualification clause
    //          is empty then this argument is simply removed.
    //
    //

    // Overload for RDBMS's that have native schemas.
    FdoSmPhReaderP MakeQueryReader(
        FdoStringP readerName,      // Static cursor name. If set then reader
                                    // will be cached for re-use.
                                    // Set it to L"" to skip caching.
        FdoSmPhOwnerP owner,        // Datastore to query.
        FdoStringP sqlString,       // SQL statement for retrieving RDBMS elements.
        FdoStringP schemaColumn,    // Physical Schema column name
        FdoStringP dbObjectColumn,  // Table column name
        FdoStringsP objectNames,    // Names of tables to bind into query
                                    // Each object name must be of form:
                                    //    <schema_name>.<table_name>
        FdoSmPhRdTableJoinP join    // Specifies a join to another table.
    );

    // Overload for RDBMS's that don't have native schemas.
    FdoSmPhReaderP MakeQueryReader(
        FdoStringP readerName,      // Static cursor name. If set then reader
                                    // will be cached for re-use.
                                    // Set it to L"" to skip caching.
        FdoSmPhMgrP mgr,            // Physical Schema Manager
        FdoStringP sqlString,       // SQL statement for retrieving RDBMS elements.
        FdoStringP ownerColumn,     // Owner (datastore) column name
        FdoStringP dbObjectColumn,  // Table column name
        FdoStringP ownerName,       // Name of owner to bind into query
        FdoStringsP objectNames,    // Names of tables to bind into query
        FdoSmPhRdTableJoinP join    // Specifies a join to another table.
    );

    // Creates a set of rows describing the fields for this
    // reader. 
    // This function returns an empty collection.
    // Subclasses must override this function.
    virtual FdoSmPhRowsP MakeRows( FdoSmPhMgrP mgr );

    // Returns a string collection containing 1 element: the name of the 
    // given dbObject.
    FdoStringsP DbObject2Objects( FdoSmPhDbObjectP dbObject );

    // Returns a string collection containing 1 element: the 
    // given dbObject name.
    FdoStringsP DbObjectName2Objects( FdoStringP dbObjectName );

    // Called by MakeQueryReader to substitute arguments into SQL string.
    FdoStringP DoSqlSubstitutions( FdoStringP sqlString, FdoStringP joinClause, FdoStringP joinFrom, FdoStringP qualification );
};

typedef FdoPtr<FdoSmPhRdReader> FdoSmPhRdReaderP;

#endif


