/*
* Copyright (C) 2006  SL-King d.o.o
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "stdafx.h"
#include "c_SdoGeomToAGF2.h"


#define D_BUFF_SIZE_INC 600 * 3 * 8 // six hundred 3 dim points
#define D_BUFF_SIZE_RESERVE 512


c_SdoGeomToAGF2::c_SdoGeomToAGF2(SDO_GEOMETRY_TYPE* Geom,SDO_GEOMETRY_ind *GeomInd)
{
  m_SdoGeom = Geom;
  m_SdoGeomInd = GeomInd;
  
  m_BuffSize = D_BUFF_SIZE_INC + D_BUFF_SIZE_RESERVE;
  
  m_BuffMem = new char[m_BuffSize];
  
  m_BuffLen = 0;
  m_BuffCurr = (int*)m_BuffMem;
}

c_SdoGeomToAGF2::~c_SdoGeomToAGF2(void)
{
  delete [] m_BuffMem;
}


int c_SdoGeomToAGF2::GetSdoElemInfo(int Index)
{
  boolean exists;
  OCINumber *oci_number;
  int val;
  
  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCICollGetElem(c_OCI_API::g_OciHpEnvironment, c_OCI_API::g_OciHpError, 
    (OCIColl *)(m_SdoGeom->sdo_elem_info), 
    (sb4)(Index), 
    (boolean *)&exists, 
    (dvoid **)&oci_number, (dvoid **)0), __LINE__, __FILE__);
  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCINumberToInt(c_OCI_API::g_OciHpError, 
    oci_number, 
    (uword)sizeof(int), OCI_NUMBER_SIGNED,
    (dvoid *)&val), __LINE__, __FILE__);
    
  return val;    
}

int c_SdoGeomToAGF2::GetSdoOrdinatesSize()
{
  int size;
  
  OCICollSize(c_OCI_API::g_OciHpEnvironment,c_OCI_API::g_OciHpError,m_SdoGeom->sdo_ordinates,&size);
  
  

  return size;    
}

double c_SdoGeomToAGF2::GetSdoPointX()
{
  double val;

  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCINumberToReal(c_OCI_API::g_OciHpError, 
    &m_SdoGeom->sdo_point.x, 
    (uword)sizeof(double), (dvoid *)&val), __LINE__, __FILE__);
  return val;    
}
double c_SdoGeomToAGF2::GetSdoPointY()
{
  double val;

  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCINumberToReal(c_OCI_API::g_OciHpError, 
    &m_SdoGeom->sdo_point.y, 
    (uword)sizeof(double), (dvoid *)&val), __LINE__, __FILE__);
  return val;    
}
double c_SdoGeomToAGF2::GetSdoPointZ()
{
  double val;

  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCINumberToReal(c_OCI_API::g_OciHpError, 
    &m_SdoGeom->sdo_point.z, 
    (uword)sizeof(double), (dvoid *)&val), __LINE__, __FILE__);
  return val;    
}

double c_SdoGeomToAGF2::GetSdoOrdinate(int Index)
{
  boolean exists;
  OCINumber *oci_number;
  double val;

  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCICollGetElem(c_OCI_API::g_OciHpEnvironment, c_OCI_API::g_OciHpError, 
    (OCIColl *)(m_SdoGeom->sdo_ordinates), 
    (sb4)(Index), 
    (boolean *)&exists, 
    (dvoid **)&oci_number, (dvoid **)0), __LINE__, __FILE__);
  c_OCI_API::OciCheckError(c_OCI_API::g_OciHpError, OCINumberToReal(c_OCI_API::g_OciHpError, 
    oci_number, 
    (uword)sizeof(double), (dvoid *)&val), __LINE__, __FILE__);

  return val;    
}

int c_SdoGeomToAGF2::ToAGF()
{
  
  m_BuffLen = 0;
  m_BuffCurr = (int*)m_BuffMem;
  
  
  
  //m_ElemInfoSize = m_SdoGeom->getSdo_elem_info().size();
  if( m_SdoGeomInd->sdo_elem_info != OCI_IND_NULL )
    OCICollSize(c_OCI_API::g_OciHpEnvironment,c_OCI_API::g_OciHpError,m_SdoGeom->sdo_elem_info,&m_ElemInfoSize); 
  else
    m_ElemInfoSize = 0;
  
  //m_OrdinatesSize = m_SdoGeom->getSdo_ordinates().size();
  if( m_SdoGeomInd->sdo_ordinates != OCI_IND_NULL )
    OCICollSize(c_OCI_API::g_OciHpEnvironment,c_OCI_API::g_OciHpError,m_SdoGeom->sdo_ordinates,&m_OrdinatesSize);
  else
    m_OrdinatesSize=0;
  
  //if( m_SdoGeom->getSdo_gtype().isNull() ) return 0;
  if( m_SdoGeomInd->sdo_gtype == OCI_IND_NULL ) return 0;
  
  //int ora_gtype = ((int)m_SdoGeom->getSdo_gtype()) % 100;
  int sdo_gtype;
  c_OCI_API::OciCheckError( c_OCI_API::g_OciHpError, OCINumberToInt(c_OCI_API::g_OciHpError, &(m_SdoGeom->sdo_gtype),
    (uword)sizeof(int), OCI_NUMBER_SIGNED,
    (dvoid *)&sdo_gtype), __LINE__, __FILE__);
    
  int ora_gtype = sdo_gtype % 100 ;    
  
   
  //////////////////////////////
  // CoordinateDimensionality
  //////////////////////////////
  //int ora_dim = ((int)m_SdoGeom->getSdo_gtype()) / 1000;
  int ora_dim = sdo_gtype / 1000;
  
  //int mdim = ((int)m_SdoGeom->getSdo_gtype()) / 100;  
  int mdim = sdo_gtype / 100;  
  mdim = mdim % 10;
  
  switch(ora_dim)
  {
    case 2: // XY      
    {
      m_PointSize = 2;
      m_CoordDim = CoordDim_XY;
    }  
    break;
    case 3: // XYZ      
    {
      m_PointSize = 3;
      if( mdim > 0 )
      {
        m_CoordDim = CoordDim_XY | CoordDim_M;
      }
      else
      {
        m_CoordDim = CoordDim_XY | CoordDim_Z;
      }
    }
    break;
    case 4: // XYZ      
    {
      m_PointSize = 4;
      m_CoordDim = CoordDim_XY | CoordDim_Z | CoordDim_M;
    }
    break;
    default:
      return 0;
    break;
  }
  
  
  
  // count of numbers for one point in sdo_ordinates list
  
  
  switch(ora_gtype)
  {
    case 1: // Point
    {
      AGF_WriteGeometryType(FdoGeometryType_Point);
      AGF_WriteDimensionality();
      
      int eleminfo_ind=0; // starting poit fro reading subelements of points
      AGF_Get_GType1_Point(eleminfo_ind);   
    }
    break;
    
    case 2: // Line
    {
       
      int eleminfo_ind=0; // starting poit fro reading subelements of string
      
      bool islinear = true;
  
      AGF_Get_GType2_CurveOrLine(eleminfo_ind);  
      
      
      
    }
    break;
    
//////////////////////////////////////////////////////////////////////////////////    
//
//    Reading Ppolygon GTYPE 3
//
//////////////////////////////////////////////////////////////////////////////////
    
    case 3: // Polygon
    {
      
      
      
    /*  Polygon structure 
      struct LinearRing
      {
      int numPts; // >0
      double[] coords; // size = numPts* PositionSize(polygon)
      
      }
      struct Polygon
      {
      int geomType;
      CoordinateDimensionality type;
      int numRings; // >= 1 as there has to be at least one ring
      LinearRing[] lineStrings; // size = numRings
      }
   */   
    // read sdo_elem_info
    
      int eleminfo_ind=0; // starting poit fro reading subelements of polygon
  
      AGF_Get_GType3_PolygonOrCurvePolygon(eleminfo_ind);
      
    }  
    break;
    
    case 4: // multigeometry
    {
      int eleminfo_ind=0; // starting poit fro reading subelements of polygon
      AGF_WriteGeometryType(FdoGeometryType_MultiGeometry);

      AGF_GetType4_MultiGeometry(eleminfo_ind);
    }
    break;
    
    case 5:   // Multipoint      
    {
      int eleminfo_ind=0; // starting poit fro reading subelements of polygon
      AGF_WriteGeometryType(FdoGeometryType_MultiPoint);
  
      AGF_GetType5_Multi_Point(eleminfo_ind);
      
    }
    break;
    case 6:   // Multiline or MultiCurve
    {
      
      
      int eleminfo_ind=0; // starting poit fro reading subelements of polygon
      AGF_Get_GType6_Multi_LineOrCurve(eleminfo_ind);
      
      
      
    }
    break;
    
    case 7:
    {
      int eleminfo_ind=0; // starting poit fro reading subelements of polygon
      AGF_Get_GType7_Multi_PolygonOrCurvePolygon(eleminfo_ind);
    }
    break;
    
    default:
      return 0;
    break;
  }
  
  return m_BuffLen;
}//end of c_SdoGeomToAGF2::ToAKB


void c_SdoGeomToAGF2::AGF_WriteGeometryType(FdoGeometryType GeometryType)
{
  
  *m_BuffCurr++ = GeometryType;
  m_BuffLen += sizeof(int);
  
}//end of c_SdoGeomToAGF2::AGF_WriteGeometryType

void c_SdoGeomToAGF2::AGF_WriteDimensionality()
{
  
  *m_BuffCurr++ = m_CoordDim;
  m_BuffLen += sizeof(int);
  
}//end of c_SdoGeomToAGF2::AGF_WriteDimensionality

void c_SdoGeomToAGF2::AGF_UpdateInt(unsigned int BuffPos,int Val)
{
  int* ptr = (int*)&m_BuffMem[BuffPos];
  
  *ptr = Val;
}//end of c_SdoGeomToAGF2::AGF_UpdateInt

void c_SdoGeomToAGF2::AGF_WriteInt(int Val)
{
  *m_BuffCurr++ = Val;
  m_BuffLen += sizeof(int);
}//end of c_SdoGeomToAGF2::AGF_WriteInt

void c_SdoGeomToAGF2::RestoreBuff(int BuffPos)
{
  m_BuffCurr = (int*)&m_BuffMem[BuffPos];
  m_BuffLen = BuffPos;
}//end of c_SdoGeomToAGF2::AGF_WriteInt

// It will write to buffer NumPoint from index
// start reading ordinates from OrdIndex
//
//  It will increment buffer pointer and ordinates index
//
void c_SdoGeomToAGF2::AGF_WritePointsFromOrdinates(int& OrdIndex,int NumPoints)
{
  int bfs = m_PointSize * NumPoints * sizeof(double); // size is in int
  if( (m_BuffLen+bfs) > ( m_BuffSize-D_BUFF_SIZE_RESERVE) )
  {
    m_BuffSize = m_BuffLen + bfs + D_BUFF_SIZE_INC + D_BUFF_SIZE_RESERVE;
    
    char *newbuff = new char[m_BuffSize];
    
    memcpy(newbuff,m_BuffMem,m_BuffLen);
    
    delete [] m_BuffMem;
    
    m_BuffMem = newbuff;
    
    m_BuffCurr = (int*)&m_BuffMem[m_BuffLen];
    
  }
  
  switch( m_PointSize ) 
  {
    case 2:
    {              
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      for(int ind=0;ind<NumPoints;ind++)
      {
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        *pt++ = GetSdoOrdinate(OrdIndex++);          
        
      }
      
      m_BuffLen += NumPoints*2*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
    
    case 3:
    {
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      for(int ind=0;ind<NumPoints;ind++)
      {
        // X
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        // Y
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        // Z
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
      }
      
      m_BuffLen += NumPoints*3*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
    case 4:
    {
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      for(int ind=0;ind<NumPoints;ind++)
      {
        // X
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        // Y
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        // Z
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
        // M
        *pt++ = GetSdoOrdinate(OrdIndex++);
        
      }
      
      m_BuffLen += NumPoints*4*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
  }     

}//end of   c_SdoGeomToAGF2::AGF_WritePointsFromOrdinates

// 
//
//  This is used to write type rectnlge (1003,3) to FGF polygon
//
void c_SdoGeomToAGF2::AGF_WriteRectangle(int& OrdIndex)
{
  
  int NumPoints = 5;
  
  int bfs = m_PointSize * NumPoints * sizeof(double); // size is in int
  if( (m_BuffLen+bfs) > ( m_BuffSize-D_BUFF_SIZE_RESERVE) )
  {
    m_BuffSize = m_BuffLen + bfs + D_BUFF_SIZE_INC + D_BUFF_SIZE_RESERVE;
    
    char *newbuff = new char[m_BuffSize];
    
    memcpy(newbuff,m_BuffMem,m_BuffLen);
    
    delete [] m_BuffMem;
    
    m_BuffMem = newbuff;
    
    m_BuffCurr = (int*)&m_BuffMem[m_BuffLen];
    
  }
  
  double minx,miny,minz,minm;
  double maxx,maxy,maxz,maxm;
  
  switch( m_PointSize ) 
  {
    case 2:
    {              
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      minx = GetSdoOrdinate(OrdIndex++);
      miny = GetSdoOrdinate(OrdIndex++);
      
      maxx = GetSdoOrdinate(OrdIndex++);
      maxy = GetSdoOrdinate(OrdIndex++);
      
      
      // point 1
      *pt++ = minx;      
      *pt++ = miny;          
      
      // point 2
      *pt++ = maxx;      
      *pt++ = miny;          
      
      // point 3
      *pt++ = maxx;      
      *pt++ = maxy;          
      
      // point 4
      *pt++ = minx;      
      *pt++ = maxy;          
      
      // point 5 same as Point 1
      *pt++ = minx;      
      *pt++ = miny;          
        
      m_BuffLen += NumPoints*2*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
    
    case 3:
    {
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      
      minx = GetSdoOrdinate(OrdIndex++);
      miny = GetSdoOrdinate(OrdIndex++);
      minz = GetSdoOrdinate(OrdIndex++);
      
      maxx = GetSdoOrdinate(OrdIndex++);
      maxy = GetSdoOrdinate(OrdIndex++);
      maxz = GetSdoOrdinate(OrdIndex++);
      
      
      // point 1
      *pt++ = minx;      
      *pt++ = miny;          
      *pt++ = minz;          
      
      // point 2
      *pt++ = maxx;      
      *pt++ = miny;
      *pt++ = minz;          
      
      // point 3
      *pt++ = maxx;      
      *pt++ = maxy;          
      *pt++ = maxz;          
      
      // point 4
      *pt++ = minx;      
      *pt++ = maxy;          
      *pt++ = maxz;          
      
      // point 5 same as Point 1
      *pt++ = minx;      
      *pt++ = miny;
      *pt++ = minz;     
      
      m_BuffLen += NumPoints*3*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
    case 4:
    {
      double *pt;      
      pt = (double *)m_BuffCurr;
      
      minx = GetSdoOrdinate(OrdIndex++);
      miny = GetSdoOrdinate(OrdIndex++);
      minz = GetSdoOrdinate(OrdIndex++);
      minm = GetSdoOrdinate(OrdIndex++);
      
      maxx = GetSdoOrdinate(OrdIndex++);
      maxy = GetSdoOrdinate(OrdIndex++);
      maxz = GetSdoOrdinate(OrdIndex++);
      maxm = GetSdoOrdinate(OrdIndex++);
      
      
      // point 1
      *pt++ = minx;
      *pt++ = miny;
      *pt++ = minz;
      *pt++ = minm;
      
      // point 2
      *pt++ = maxx;
      *pt++ = miny;
      *pt++ = minz;
      *pt++ = minm;
      
      // point 3
      *pt++ = maxx;
      *pt++ = maxy;
      *pt++ = maxz;
      *pt++ = maxm;
      
      // point 4
      *pt++ = minx;      
      *pt++ = maxy;          
      *pt++ = maxz;
      *pt++ = maxm;          
      
      // point 5 same as Point 1
      *pt++ = minx;      
      *pt++ = miny;
      *pt++ = minz;  
      *pt++ = minm;  
      
      m_BuffLen += NumPoints*4*sizeof(double);
      
      m_BuffCurr = (int*)pt;
    }
    break;
  }     

}//end of   c_SdoGeomToAGF2::AGF_WriteRectangle

//
// Reads point
// Starts from element 'ElemInfo_Index' which is index of first triplet in m_SdoGeom->getSdo_elem_info() describing polygon
// WkbBuff.. points to buffer which will recevie transformation to AKB
// Returns number og bytes which are written to WkbBuff
// 0.. zero return means some error
// After function returns:
// - ElemInfo_Index..points on next triplet in m_SdoGeom->getSdo_elem_info() which is to be read ( or to the end of m_SdoGeom->getSdo_elem_info() array if polygon is last)
// - AgfBuff.. points onto the position after this polygon ( writting in WkbBuff is done with *WkbBuff++ = ... 
//
bool c_SdoGeomToAGF2::AGF_Get_GType1_Point(int& ElemInfo_Index)
{
  
  
  if( (m_ElemInfoSize>0) && (m_OrdinatesSize>0) )
  {
  // Point is defined with
    int eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); // do not step forward with ++
    int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
    
    if( eleminfo_etype != 1 ) return false;
    
    ElemInfo_Index += 3;
    
    int ord = eleminfo_offset-1;
    double *pt;
    
    pt = (double *)m_BuffCurr;
    
    *pt++ = GetSdoOrdinate(ord++);
    m_BuffLen += sizeof(double);
    
    *pt++ = GetSdoOrdinate(ord++);
    m_BuffLen += sizeof(double);
    
    if( m_PointSize == 3 ) 
    {
      *pt++ = GetSdoOrdinate(ord++);
      m_BuffLen += sizeof(double);
    }
    m_BuffCurr = (int*)pt;
  }
  else  
  {
  // then point should be defined with SDO_POINT_TYPE
    //if( m_SdoGeom->getSdo_point() )
    if( m_SdoGeomInd->sdo_point._atomic != OCI_IND_NULL )
    {
      double *pt;
      
      pt = (double *)m_BuffCurr;
      
      *pt++ = GetSdoPointX(); //m_SdoGeom->getSdo_point()->getX();
      m_BuffLen += sizeof(double);
      
      *pt++ = GetSdoPointY(); // m_SdoGeom->getSdo_point()->getY();
      m_BuffLen += sizeof(double);
      
      if( m_PointSize == 3 ) 
      {
        *pt++ = GetSdoPointZ();; // m_SdoGeom->getSdo_point()->getZ();
        m_BuffLen += sizeof(double);
      }
      m_BuffCurr = (int*)pt;
      

    }
  }
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_GType1_Point


//
//  Fi
//
// struct MultiPoint
// {
//   int geomType;
//   int numPoints; // > 0
//   Point[] points; // size = numPoints
// }
//
bool c_SdoGeomToAGF2::AGF_GetType5_Multi_Point(int& ElemInfo_Index)
{
  int elemid = ElemInfo_Index;
  
    
  if( (m_ElemInfoSize>0) && (m_OrdinatesSize>0) )
  {
    int ptr_num_strings_buffpos = m_BuffLen;
    int num_points1 = 0;
  
    AGF_WriteInt(0); // number of points
    
    while( ElemInfo_Index < m_ElemInfoSize )
    {
      int eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
      int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); // do not step forward with ++
      int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
      
      int numpoints = eleminfo_interp;
    
    // write number of points
     //*m_BuffCurr++ = numpoints;
      m_BuffLen += sizeof(int);
      
      int ord = eleminfo_offset-1;
      
      // write Point
      //
      //  struct Point // : Geometry
      //  {
      //    int geomType; // == GeometryType.Point;
      //    CoordinateDimensionality type; // all types allowed
      //    double[] coords; // size = PositionSize(this)
      //  }
      int pind=0;
      //while( (pind<numpoints) && (ord<m_OrdinatesSize) )
      while( (pind<numpoints) && (ord<m_OrdinatesSize) )
      {
        AGF_WriteGeometryType(FdoGeometryType_Point);
        AGF_WriteDimensionality();
        
        AGF_WritePointsFromOrdinates(ord,1);
        num_points1++;
        pind++;
      }
      ElemInfo_Index += 3;
    }
    AGF_UpdateInt(ptr_num_strings_buffpos,num_points1);
  // Point is defined with
 /*   int eleminfo_offset = GetSdoElemInfo(ElemInfo_Index];
    int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1]; // do not step forward with ++
    int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2];
        
    if( eleminfo_etype != 1 ) return false;
    
    int numpoints = eleminfo_interp;
    
    // write number of points
    *m_BuffCurr++ = numpoints;
    m_BuffLen += sizeof(int);
    
    int ord = eleminfo_offset-1;
    
    // write Point
    //
    //  struct Point // : Geometry
    //  {
    //    int geomType; // == GeometryType.Point;
    //    CoordinateDimensionality type; // all types allowed
    //    double[] coords; // size = PositionSize(this)
    //  }
    int pind=0;
    while( (pind<numpoints) && (ord<m_OrdinatesSize) )
    {
      AGF_WriteGeometryType(FdoGeometryType_Point);
      AGF_WriteDimensionality();
      
      AGF_WritePointsFromOrdinates(ord,1);
    }
    
    */
  }
  else  
  {
  // then point should be defined with SDO_POINT_TYPE
    //if( m_SdoGeom->getSdo_point() )
    if( m_SdoGeomInd->sdo_point._atomic != OCI_IND_NULL )
    {
      double *pt;
      
      pt = (double *)m_BuffCurr;
      
      *pt++ = GetSdoPointX(); // m_SdoGeom->getSdo_point()->getX();
      m_BuffLen += sizeof(double);
      
      *pt++ = GetSdoPointY(); // m_SdoGeom->getSdo_point()->getY();
      m_BuffLen += sizeof(double);
      
      if( m_PointSize >= 3 ) 
      {
        *pt++ = GetSdoPointZ(); // m_SdoGeom->getSdo_point()->getZ();
        m_BuffLen += sizeof(double);
        
        if( m_PointSize == 4 ) 
        {
          *pt++ = 0.0;
          m_BuffLen += sizeof(double);
        }
      }
      m_BuffCurr = (int*)pt;
      

    }
  }
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_GetType5_Multi_Point


//
// Reads line string m_SdoGeom->getSdo_gtype() 2
// Starts from element 'ElemInfo_Index' which is index of first triplet in m_SdoGeom->getSdo_elem_info() describing polygon
// WkbBuff.. points to buffer which will recevie transformation to AKB
// Returns number og bytes which are written to WkbBuff
// 0.. zero return means some error
// After function returns:
// - ElemInfo_Index..points on next triplet in m_SdoGeom->getSdo_elem_info() which is to be read ( or to the end of m_SdoGeom->getSdo_elem_info() array if polygon is last)
// - WkbBuff.. points onto the position after this polygon ( writting in WkbBuff is done with *WkbBuff++ = ... 
//
bool c_SdoGeomToAGF2::AGF_Get_GType2_CurveOrLine(int& ElemInfo_Index,bool ForceCurve/*=false*/)
{
 
  
  bool islinear = true;
  int geometry_type_buffpos = m_BuffLen;
  
  AGF_WriteGeometryType(FdoGeometryType_LineString);
  AGF_WriteDimensionality();    
      
      
  int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); // do not step forward with ++
  
  switch( eleminfo_etype )
  {
    case 1:   // point
    {
      return false; // don't now what to do with point in line
    }
    break;
    case 2:   // string
    {
      int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2); // do not step forward with ++
      if( eleminfo_interp == 1 ) // line string of points
      {
        if( ForceCurve )
        {
          islinear = false;
          AGF_Get_CurvePointString(ElemInfo_Index);
        }
        else
        {
          islinear = true;
          AGF_Get_LinearString(ElemInfo_Index);
        }
      }
      else
      {
        if( eleminfo_interp == 2 ) // line string of arc's
        {
          islinear = false;
          AGF_Get_CurveArcString(ElemInfo_Index);
         
        }
      }
    }
    break;
    case 4:  // compound line string ( connected with some stright lines and some arcs)
    {
      // elem_interp is number of element contained in this compund line string
      // elem_interp is number of next triplets in m_SdoGeom->getSdo_elem_info()
      // in subelemnts only allowed is etype == 2
      islinear = false;
      AGF_Get_CurveString(ElemInfo_Index);
      
    }
    break;
    case 1003:   // exteriror ring (must be  counterclockwise order of points)
    case 2003:   // interior ring  (must be  clockwise order of points)
    {
      return false;
    }
    break;
    case 1005:   // compound polygon - exteriror ring  (compound some are straight lines, some are arcs
    case 2005:   // compound polygon - interior ring
    {
      return false;
    }
    break;
    default:
      return false;
    break;
    
  }
  
  if( !islinear )
  {  
    AGF_UpdateInt(geometry_type_buffpos,FdoGeometryType_CurveString);
    
  }
  
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_GType2_CurveOrLine

//
// Reads line string m_SdoGeom->getSdo_gtype() 2
// Starts from element 'ElemInfo_Index' which is index of first triplet in m_SdoGeom->getSdo_elem_info() describing polygon
// WkbBuff.. points to buffer which will recevie transformation to AKB
// Returns number og bytes which are written to WkbBuff
// 0.. zero return means some error
// After function returns:
// - ElemInfo_Index..points on next triplet in m_SdoGeom->getSdo_elem_info() which is to be read ( or to the end of m_SdoGeom->getSdo_elem_info() array if polygon is last)
// - WkbBuff.. points onto the position after this polygon ( writting in WkbBuff is done with *WkbBuff++ = ... 
//
bool c_SdoGeomToAGF2::AGF_Get_GType6_Multi_LineOrCurve(int& ElemInfo_Index)
{
  
  
  bool islinear = true;
  
  // first check is it all linear or there are
  // is it MultiLine or MultiCurve
  int elemid = ElemInfo_Index;
  
  while( (elemid < m_ElemInfoSize) && islinear )
  {
    int elem_etype = GetSdoElemInfo(elemid+1);
    switch( elem_etype )
    {
      case 2:
      {
        int elem_interp = GetSdoElemInfo(elemid+2);
        switch( elem_interp )
        {
          case 1:
          break;
          case 2: // arcs
            islinear = false;
          break;
          
        }
      }
      break;
      case 4: //compund string
        islinear = false;
      break;
    }
    
    elemid += 3;
  }
  
  
  if( islinear )
    AGF_WriteGeometryType(FdoGeometryType_MultiLineString);
  else
    AGF_WriteGeometryType(FdoGeometryType_MultiCurveString);
    
  
  int num_strings = 0;
  int ptr_num_strings_buffpos = m_BuffLen;
  
  AGF_WriteInt(0); // number of lines
  
  bool forcecurve;
  if( islinear )
  {
  // read as MultiLine - MultiLineString
    forcecurve = false;
  }
  else
  {
    forcecurve = true; // because there are curves (not just linear) than i need to force all to be curves in multi
  }
  
  // read as MultiCurve - MultiCurveString
  int elen=0;
  bool repeat = true;
  while( (ElemInfo_Index < m_ElemInfoSize) && repeat )
  {
    if( AGF_Get_GType2_CurveOrLine(ElemInfo_Index,forcecurve) ) // force da je curve string (not linear)
    {
      num_strings++;  
    }
    else
    {
      repeat = false;
    }
  }
  
  AGF_UpdateInt(ptr_num_strings_buffpos,num_strings);
  
  return true;
  
}//end of c_SdoGeomToAGF2::AGF_Get_GType6_Multi_LineOrCurve

//
// This function will read linear rings from ordinates 1003.
// It will read more than one ring.
// It reads rings while there is 1003 or 2003 etype (linear - interpretation == 1) or end of subelements
// It will stop if next subelement is not 1003 etype or the ened of list is reached.
//
// It will write this to AgfBuff:
//
// LinearRing[] lineStrings; // size = NumRings
//
// struct LinearRing
// {
//   int numPts; // >0
//   double[] coords; // size = numPts* PositionSize(polygon)
//
// }
//
bool c_SdoGeomToAGF2::AGF_Get_LinearString(int& ElemInfo_Index)
{
  int eleminfo_offset;
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  
     
  eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
  eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);    
  if( eleminfo_interp!=1 ) return 0; // if not ring of straight lines out
    
  eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    
  ElemInfo_Index += 3;
    
    
  // read points
      
  int numpoints_string; // number of points in string
      
  // get next offset if exists
  int next_offset = 0;
  if( ElemInfo_Index < m_ElemInfoSize ) 
  {
    next_offset = GetSdoElemInfo(ElemInfo_Index);
    
    numpoints_string = (next_offset - eleminfo_offset) / m_PointSize;
  }
  else
  {
  // there is no next 
    numpoints_string = (GetSdoOrdinatesSize() + 1 - eleminfo_offset) / m_PointSize; // (((int)m_SdoGeom->getSdo_ordinates().size()) + 1 - eleminfo_offset) / m_PointSize;
  }
      
  // write numpoints
  AGF_WriteInt( numpoints_string );
      
// write String Points
  int ord = eleminfo_offset - 1;
  AGF_WritePointsFromOrdinates(ord,numpoints_string);
  
  
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_LinearString

//
// This function will read arc string from ordinates Etype 2 Interp 2.
// It will read more than one arc.
//
// It will write this to AgfBuff:
//
// double StartPoint[];  // one point
// int NumElements; (arcs)
// double Points[];
//
//
bool c_SdoGeomToAGF2::AGF_Get_CurveArcString(int& ElemInfo_Index)
{
  int eleminfo_offset;
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  
     
  eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
  eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);    
  eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    
  ElemInfo_Index += 3;
    
    
  // read points
      
  int numpoints_string; // number of points in string
      
  // get next offset if exists
  int next_offset = 0;
  if( ElemInfo_Index < m_ElemInfoSize ) 
  {
    next_offset = GetSdoElemInfo(ElemInfo_Index);
    
    numpoints_string = (next_offset - eleminfo_offset) / m_PointSize;
  }
  else
  {
  // there is no next ring
    numpoints_string = (GetSdoOrdinatesSize() + 1 - eleminfo_offset) / m_PointSize; // (((int)m_SdoGeom->getSdo_ordinates().size()) + 1 - eleminfo_offset) / m_PointSize;
  }

  if( numpoints_string < 3 ) return false;

  // first write start_point
  int ord = eleminfo_offset - 1;
  AGF_WritePointsFromOrdinates(ord,1);
  
  // second write number of elements (arcs)
  int numarcs = (numpoints_string-1) / 2;

  AGF_WriteInt(numarcs);
  
  
  // for each arc write int CurveElementType; // == 2
  // and two points for each arc
  for(int ind=0;ind<numarcs;ind++)
  {
    AGF_WriteInt(FdoGeometryComponentType_CircularArcSegment);
    AGF_WritePointsFromOrdinates(ord,2);
  }     
 
  
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_CurveArcString


//
// This function will read point string ( stright line ) but interpreted as part fo curve
//
// It will write this to AgfBuff:
//
// double StartPoint[];  // one point
// int NumElements; (1)
// int ElementTYpe;    // FdoGeometryComponentType_LineStringSegment
// int NumberOfPoints;
// double Points[];
//
//
bool c_SdoGeomToAGF2::AGF_Get_CurvePointString(int& ElemInfo_Index)
{
  int eleminfo_offset;
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  
     
  eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
  eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);    
  eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    
  ElemInfo_Index += 3;
    
    
  // read points
      
  int numpoints_string; // number of points in string
      
  // get next offset if exists
  int next_offset = 0;
  if( ElemInfo_Index < m_ElemInfoSize ) 
  {
    next_offset = GetSdoElemInfo(ElemInfo_Index);
    
    numpoints_string = (next_offset - eleminfo_offset) / m_PointSize;
  }
  else
  {
  // there is no next ring
    numpoints_string = (GetSdoOrdinatesSize() + 1 - eleminfo_offset) / m_PointSize; // (((int)m_SdoGeom->getSdo_ordinates().size()) + 1 - eleminfo_offset) / m_PointSize;
  }

  // first write start_point
  int ord = eleminfo_offset - 1;
  AGF_WritePointsFromOrdinates(ord,1);
  
  // second write number of elements 1
  AGF_WriteInt(1);
  
  
  AGF_WriteInt(FdoGeometryComponentType_LineStringSegment);
  
  // write number of points
  numpoints_string--; // because start one is already written
  
  AGF_WriteInt(numpoints_string);
  
  AGF_WritePointsFromOrdinates(ord,numpoints_string);
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_CurvePointString


//
// Reads curved subelements and ceates CurveString.
// First triplet eleminfo_interp is number of subelements
// Subelemnts are of Etype 2 ( straight lines or arcs)
//
// It will add start_point, number of subelements and subelements to output buffer.
//
// This is used reading ccurved strings ( Etype 4) or compund rings in polygons Etype ( 1005, 2005)
//
bool c_SdoGeomToAGF2::AGF_Get_CurveString(int& ElemInfo_Index)
{
  int eleminfo_offset;
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  
     
  eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
  eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);    
  eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    
  ElemInfo_Index += 3;
  
  int num_subs = eleminfo_interp;
  
  if( !num_subs ) return false; // error not supposed to be
  
  // read first subelement
  eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
  
  // read starting point
  int ord = eleminfo_offset - 1;
  AGF_WritePointsFromOrdinates(ord,1);
  
  // add number of subelements
  int num_string_elem_buffpos = m_BuffLen;
  int num_string_elem = 0;
  AGF_WriteInt(num_string_elem);
  
  int subelem_ind=0;
  while(  subelem_ind < num_subs )
  {
    eleminfo_offset = GetSdoElemInfo(ElemInfo_Index);
    eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
    eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);    
    ElemInfo_Index += 3;
    
    int numpoints; // number of points in string
      
    // get next offset if exists
    int next_offset = 0;
    if( ElemInfo_Index < m_ElemInfoSize ) 
    {
      next_offset = GetSdoElemInfo(ElemInfo_Index);
      
      numpoints = (next_offset - eleminfo_offset) / m_PointSize;
      
      // if last sub element that I need to reduce number of points by one beacuse
      // reading is shifted for one beacuse of AFG takes first point into previous element
      if( subelem_ind == (num_subs-1) ) { numpoints--; numpoints=numpoints<0 ? 0 : numpoints; }
    }
    else
    {
    // there is no next subelement
      numpoints = (GetSdoOrdinatesSize() + 1 - eleminfo_offset) / m_PointSize; // (((int)m_SdoGeom->getSdo_ordinates().size()) + 1 - eleminfo_offset) / m_PointSize;
      
      numpoints--; // beacuse first point is already written in previouse subelement
    }
    
    if( eleminfo_interp == 1)
    {
      AGF_WriteInt(FdoGeometryComponentType_LineStringSegment); // arc CurveElmentType
      
      
      // add number of points
      AGF_WriteInt(numpoints);
      
      
      AGF_WritePointsFromOrdinates(ord,numpoints);
      
      num_string_elem++;
    }
    else
    {
      AGF_WriteInt(FdoGeometryComponentType_CircularArcSegment); // arc CurveElmentType
      AGF_WritePointsFromOrdinates(ord,2); // za arc sta dve tocki
      num_string_elem++;
      
      int numarcs = (numpoints + 2) / 3;
      
      numpoints-=2;
      while( numpoints>=2 )
      {
        AGF_WriteInt(FdoGeometryComponentType_CircularArcSegment); // arc CurveElmentType
        AGF_WritePointsFromOrdinates(ord,2); // za arc sta dve tocki
        num_string_elem++;
        numpoints-=2;
      }
    }

    
    subelem_ind++;
  }
   
  AGF_UpdateInt(num_string_elem_buffpos,num_string_elem);
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_CurveString



bool c_SdoGeomToAGF2::AGF_Get_ExteriorRing(int& ElemInfo_Index,bool& IsLinear,bool ForceCurve)
{
  int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); // do not step forward with ++
  switch( eleminfo_etype )
  {
    case 1003:   // exteriror ring (must be  counterclockwise order of points)
    {         

      // 
      IsLinear = ForceCurve ? false : true;

      // check how exterior ring is defined
      int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
      switch( eleminfo_interp )      
      {
        case 1:
        {
          if( ForceCurve )
          {
            if( !AGF_Get_CurvePointString(ElemInfo_Index) ) 
            {
              return false;
            }

            IsLinear = false;
          }
          else
          {
            if( !AGF_Get_LinearString(ElemInfo_Index) )
            {
              return false; // ni prebran eterior ring
            }
          }
        }
        break;
      case 2:  // arc string
        {
          if( !AGF_Get_CurveArcString(ElemInfo_Index) ) 
          {
            return false;
          }

          IsLinear = false;
        }
        break;
      case 3: // rect
        {
          // rect like MBR
          // now in ordintaes there are 2 points   
          AGF_WriteInt( 5 );
          AGF_WriteRectangle(ElemInfo_Index);
          ElemInfo_Index += 3;
        }
        break;
      case 4: // circle
        {
          return false;
        }
        break;
        default:
        {
          return false;
        }
        break;
      }

      int numrings=1;   // exterior ring is read

    }
    break;
    case 1005:   // compound ring - exteriror ring  (compound some are straight lines, some are arcs
    {
      // elem_interp is number of subelement contained in this compund line polygon
      // elem_interp is number of next triplets (subelemnts) in m_SdoGeom->getSdo_elem_info()
      // in subelemnts only allowed is etype == 2

      // read exterior ring
      if( !AGF_Get_CurveString(ElemInfo_Index) ) return false;
      IsLinear = false;
    }
    break;
    default:  
    {
      return false;
    }
    break;
  }
  
  return true;
}
//
// Reads polygon
// Starts from element 'ElemInfo_Index' which is index of first triplet in m_SdoGeom->getSdo_elem_info() describing polygon
// WkbBuff.. points to buffer which will recevie transformation to AKB
// Returns number og bytes which are written to WkbBuff
// 0.. zero return means some error
// After function returns:
// - ElemInfo_Index..points on next triplet in m_SdoGeom->getSdo_elem_info() which is to be read ( or to the end of m_SdoGeom->getSdo_elem_info() array if polygon is last)
// - WkbBuff.. points onto the position after this polygon ( writting in WkbBuff is done with *WkbBuff++ = ... 
//
bool c_SdoGeomToAGF2::AGF_Get_GType3_PolygonOrCurvePolygon(int& ElemInfo_Index,bool ForceCurve)
{
  
  //int eleminfo_offset = GetSdoElemInfo(ElemInfo_Index++];
  int eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); // do not step forward with ++
  //int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index++];
      
  bool islinear = true;
  
  int geometry_type_buffpos = m_BuffLen;
  
  AGF_WriteGeometryType(FdoGeometryType_Polygon);
  AGF_WriteDimensionality();
        
  switch( eleminfo_etype )
  {
    case 1:   // point
    {
      return false; // don't now what to do with point in polygon
    }
    break;
    case 2:   // string of stright lines or arcs
              // if( eleminfo_interp == 1 ) // line string of points
              // if( eleminfo_interp == 2 ) // line string of arc's
    {
      return false; // don't now what to do with that in polygon
    }
    break;
    case 3: // old one
    {
       AGF_WriteInt(1); // number of rings is 1
       AGF_Get_LinearString(ElemInfo_Index);
    }
    break;
    case 4:  // compound line string ( connected with some stright lines and some arcs)
    {
      // elem_interp is number of element contained in this compund line string
      // elem_interp is number of next triplets in m_SdoGeom->getSdo_elem_info()
      // in subelemnts only allowed is etype == 2
      
      return false; // don't now what to do with that in polygon
    }
    break;
    case 1003:   // exteriror ring (must be  counterclockwise order of points)
    //case 2003:   // interior ring  (must be  clockwise order of points)
    {         

       // use temp buffer pointer to increment so we can revert to start
      int akb_tempbuff_buffpos = m_BuffLen;
      int akb_numrings_buffpos = m_BuffLen;     // remember where number of rings is
      
      AGF_WriteInt(0); // number of rings is
      
      
      // 
      bool all_islinear = ForceCurve ? false : true;
      
      // check how exterior ring is defined
      int eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
      switch( eleminfo_interp )      
      {
        case 1:
        {
          if( ForceCurve )
          {
            if( !AGF_Get_CurvePointString(ElemInfo_Index) ) 
            {
              RestoreBuff(akb_tempbuff_buffpos);
              return false;
            }
            
            all_islinear = false;
          }
          else
          {
            if( !AGF_Get_LinearString(ElemInfo_Index) )
            {
              RestoreBuff(akb_tempbuff_buffpos);
              return false; // ni prebran eterior ring
            }
          }
        }
        break;
        case 2:  // arc string
        {
          if( !AGF_Get_CurveArcString(ElemInfo_Index) ) 
          {
            RestoreBuff(akb_tempbuff_buffpos);
            return false;
          }
          
          all_islinear = false;
        }
        break;
        case 3: // rect
        {
        // rect like MBR
        // now in ordintaes there are 2 points   
          AGF_WriteInt( 5 );
          AGF_WriteRectangle(ElemInfo_Index);
        }
        break;
        case 4: // circle
        {
          return false;
        }
        break;
        default:
        {
          RestoreBuff(akb_tempbuff_buffpos);
          return false;
        }
        break;
      }
      
      int numrings=1;   // exterior ring is read
      
      
      // read interior rings 
      if( all_islinear && !ForceCurve ) // if up to now is linear then try to read as linear
      {
        bool inner_islinear=true;
        AGF_Get_LinearRings_Etype2003(ElemInfo_Index,numrings,inner_islinear);         
        
        AGF_UpdateInt( akb_numrings_buffpos, numrings );       
        
        // exterior ring was read as linear 
        if( !inner_islinear )
        {
          RestoreBuff(akb_tempbuff_buffpos);
          return false;
        }
      }
      else
      {
        AGF_Get_CurveInnerRings_Etype2003_2005(ElemInfo_Index,numrings,ForceCurve);         
        AGF_UpdateInt( akb_numrings_buffpos, numrings );           
      }
      
      islinear = all_islinear; 
    }
    break;
    case 2003:
    {
    // polygon has started with interior ring
    // skip all interior ringd (2003 and 2005) until found exterior ring (1005)
      int start_eleminfo_index = ElemInfo_Index;


      int exterior_eleminfo_index = ElemInfo_Index + 3;

      bool found_exterior = false;
      while( !found_exterior  && (exterior_eleminfo_index < m_ElemInfoSize ))            
      {
        int etype = GetSdoElemInfo(exterior_eleminfo_index+1); // do not step forward with ++
        if( etype == 1005 || etype == 1003)
        {
          found_exterior = true;
          break;
        }
        
        exterior_eleminfo_index += 3;
      }      
      if( !found_exterior ) return false; // found only interior ring - no exterior ring - error
      
      int akb_tempbuff_buffpos = m_BuffLen;
      int akb_numrings_buffpos = m_BuffLen;     // remember where number of rings is

      AGF_WriteInt(0); // number of rings is


      // 
      bool all_islinear = ForceCurve ? false : true;
      

      // check how exterior ring is defined
      ElemInfo_Index = exterior_eleminfo_index;
      if( !AGF_Get_ExteriorRing(exterior_eleminfo_index,all_islinear,ForceCurve) )
      {
        RestoreBuff(akb_tempbuff_buffpos);
        return false;
      }
      
      int numrings=1;   // exterior ring is read
      
      // read interior rings 
      ElemInfo_Index = start_eleminfo_index;
      if( all_islinear && !ForceCurve ) // if up to now is linear then try to read as linear
      {
        bool inner_islinear=true;
        AGF_Get_LinearRings_Etype2003(ElemInfo_Index,numrings,inner_islinear);         

        AGF_UpdateInt( akb_numrings_buffpos, numrings );       

        // exterior ring was read as linear 
        if( !inner_islinear )
        {
          RestoreBuff(akb_tempbuff_buffpos);
          return false;
        }
      }
      else
      {
        AGF_Get_CurveInnerRings_Etype2003_2005(ElemInfo_Index,numrings,ForceCurve);         
        AGF_UpdateInt( akb_numrings_buffpos, numrings );           
      }
      
      // set next elem info to read to be first after exterior ring
      ElemInfo_Index = exterior_eleminfo_index + 3;
    }
    break;
    
    case 1005:   // compound ring - exteriror ring  (compound some are straight lines, some are arcs
    //case 2005:   // compound ring - interior ring
    {
    // elem_interp is number of subelement contained in this compund line polygon
    // elem_interp is number of next triplets (subelemnts) in m_SdoGeom->getSdo_elem_info()
    // in subelemnts only allowed is etype == 2
      
      int akb_numrings_buffpos = m_BuffLen;
      
      AGF_WriteInt(0); // numrings
      
      int numrings=0;
      // read exterior ring
      if( !AGF_Get_CurveString(ElemInfo_Index) ) return false;
      
      numrings++;
      
      // read interior rings 
      AGF_Get_CurveInnerRings_Etype2003_2005(ElemInfo_Index,numrings,true);   
      
      AGF_UpdateInt( akb_numrings_buffpos, numrings );   
      
      islinear = false;     
            
    }
    break;
    case 2005:
    {
    // polygon has started with interior ring
    // skip all interior (2003 and 2005) until found exterior ring (1005)
      int start_eleminfo_index = ElemInfo_Index;
      
      
      int exterior_eleminfo_index = ElemInfo_Index + 3;
            
      bool found_exterior = false;
      while( !found_exterior  && (exterior_eleminfo_index < m_ElemInfoSize ))            
      {
        int etype = GetSdoElemInfo(exterior_eleminfo_index+1); // do not step forward with ++
        if( etype == 1005 )
        {
          found_exterior = true;
          break;
        }
        
        exterior_eleminfo_index += 3;
      }      
      if( !found_exterior ) return false; // found only interior ring - no exterior ring - error
      
      // read exterior; then return to read interiors
      int akb_numrings_buffpos = m_BuffLen;

      AGF_WriteInt(0); // numrings

      int numrings=0;
      
      islinear = false;   
      // read exterior ring
      // check how exterior ring is defined
      ElemInfo_Index = exterior_eleminfo_index;
      if( !AGF_Get_ExteriorRing(exterior_eleminfo_index,islinear,true) )
      {
        return false;
      }

      numrings++;

      // read interior rings 
      AGF_Get_CurveInnerRings_Etype2003_2005(start_eleminfo_index,numrings,true);   

      AGF_UpdateInt( akb_numrings_buffpos, numrings );   

        
      
      // set next elem info to read to be first after exterior ring
      ElemInfo_Index = exterior_eleminfo_index + 3;
      
    }
    break;
    default:
		  return false;
	  break;
    
  }
  
  if( !islinear )
  {
    AGF_UpdateInt(geometry_type_buffpos,FdoGeometryType_CurvePolygon);
  }
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_GType3_PolygonOrCurvePolygon

bool c_SdoGeomToAGF2::AGF_Get_GType7_Multi_PolygonOrCurvePolygon(int& ElemInfo_Index)
{
    
  
  bool islinear = true;
  
  // first check is it all linear or there are
  // is it MultiLine or MultiCurve
  int elemid = ElemInfo_Index;
  
  while( (elemid < m_ElemInfoSize) && islinear )
  {
    int elem_etype = GetSdoElemInfo(elemid+1);
    switch( elem_etype )
    {
      case 1003:
      case 2003:
      {
        int elem_interp = GetSdoElemInfo(elemid+2);
        switch( elem_interp )
        {
          case 1:
          break;
          case 2: // arcs
          case 4: // circle
            islinear = false;
          break;
          
        }
      }
      break;
      case 1005: //compund string
      case 2005: //compund string
        islinear = false;
      break;
    }
    
    elemid += 3;
  }
  
  
  if( islinear )
    AGF_WriteGeometryType(FdoGeometryType_MultiPolygon);
  else
    AGF_WriteGeometryType(FdoGeometryType_MultiCurvePolygon);
    
  
  int num_poly = 0;
  int ptr_num_poly_buffpos = m_BuffLen;
  
  AGF_WriteInt(0); // number of polygons
  
  bool forcecurve;
  if( islinear )
  {
  // read as MultiLine - MultiLineString
    forcecurve = false;
  }
  else
  {
    forcecurve = true; // because there are curves (not just linear) than i need to force all to be curves in multi
  }
  
  // read as MultiCurve - MultiCurveString
  int elen=0;
  bool repeat = true;
  while( (ElemInfo_Index < m_ElemInfoSize) && repeat )
  {
    if( AGF_Get_GType3_PolygonOrCurvePolygon(ElemInfo_Index,forcecurve) ) // force da je curve string (not linear)
    {
      num_poly++;  
    }
    else
    {
      repeat = false;
    }
  }
  
  AGF_UpdateInt(ptr_num_poly_buffpos,num_poly);
  
  return true; 
  
}//end of c_SdoGeomToAGF2::AGF_Get_GType7_Multi_PolygonOrCurvePolygon


bool c_SdoGeomToAGF2::AGF_GetType4_MultiGeometry(int& ElemInfo_Index)
{
  int num_geoms = 0;
  int ptr_num_geoms_buffpos = m_BuffLen;

  AGF_WriteInt(0); // number of geometries

 

  // read as MultiCurve - MultiCurveString
  int elen=0;
  bool repeat = true;
  while( (ElemInfo_Index < m_ElemInfoSize) && repeat )
  {
    int elem_etype = GetSdoElemInfo(ElemInfo_Index+1);
    switch( elem_etype )
    {
      case 1: // Point
      {
        AGF_WriteGeometryType(FdoGeometryType_Point);
        AGF_WriteDimensionality();

        repeat = AGF_Get_GType1_Point(ElemInfo_Index);   
      }
      break;

      case 2: // Line
      {
        
        bool islinear = true;

        repeat = AGF_Get_GType2_CurveOrLine(ElemInfo_Index);  
      }
      break;  
      
      case 1003: // exterior ring
      {
        repeat = AGF_Get_GType3_PolygonOrCurvePolygon(ElemInfo_Index);
      }
      break;
      
      
      case 1005: // exterior complex ring
      {
        repeat = AGF_Get_GType3_PolygonOrCurvePolygon(ElemInfo_Index);
      }
      break;
      
          
      default:
      {
        return 0;
      }
      break;   
    }
    
    num_geoms++;
  }

  AGF_UpdateInt(ptr_num_geoms_buffpos,num_geoms);

  return true;
}//end of c_SdoGeomToAGF2::AGF_GetType4_MultiGeometry
//
// This function will read linear rings from ordinates 1003.
// It will read more than one ring.
// It reads rings while there is 1003 or 2003 etype (linear - interpretation == 1) or end of subelements
// It will stop if next subelement is not 1003 etype or the ened of list is reached.
//
// It will write this to AgfBuff:
//
// LinearRing[] lineStrings; // size = NumRings
//
// struct LinearRing
// {
//   int numPts; // >0
//   double[] coords; // size = numPts* PositionSize(polygon)
//
// }
//
bool c_SdoGeomToAGF2::AGF_Get_LinearRings_Etype2003(int& ElemInfo_Index,int& NumRings,bool& IsLinear)
{
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  
  IsLinear = true;
  
  while( ElemInfo_Index<m_ElemInfoSize )
  {  
    eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
    eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
    
    if( eleminfo_etype != 2003 ) break; // if not interior ring out
    if( eleminfo_interp!=1 ) 
    {
      IsLinear = false;
      break; // if not ring of straight lines out
    }
        
    // read and write rings )
    AGF_Get_LinearString(ElemInfo_Index);
           
    NumRings++;
 
  }
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_LinearRings_Etype2003

/*
int c_SdoGeomToAGF2::AGF_Get_CurveRings_Etype2005(int& ElemInfo_Index,int*& AgfBuff,int& NumRings)
{
  int eleminfo_etype;
  int eleminfo_interp;
  
  int bufflen=0; // how many butes was added to buff
  
  while( ElemInfo_Index<m_ElemInfoSize )
  {  
    eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1]; 
    eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2];
    
    if( eleminfo_etype != 2005 ) break; // if not interior ring out
        
    // read and write rings )
    bufflen += AGF_Get_CurveString(ElemInfo_Index,AgfBuff);
           
    NumRings++;
 
  }
  
  return bufflen;
}//end of c_SdoGeomToAGF2::AGF_Get_CurveRings_Etype2005
*/

bool c_SdoGeomToAGF2::AGF_Get_CurveInnerRings_Etype2003_2005(int& ElemInfo_Index,int& NumRings,bool ForceCurve)
{
  int eleminfo_etype;
  int eleminfo_interp;
  
  
  while( ElemInfo_Index<m_ElemInfoSize )
  {  
    eleminfo_etype = GetSdoElemInfo(ElemInfo_Index+1); 
    eleminfo_interp = GetSdoElemInfo(ElemInfo_Index+2);
    
    switch( eleminfo_etype )
    {
      case 2005:
      {
        AGF_Get_CurveString(ElemInfo_Index);
        NumRings++;
      }
      break;
      case 2003:
      {
        switch( eleminfo_interp )
        {
          case 1:   // line string
          {
            int akb_tempbuff_buffpos = m_BuffLen;
            if( ForceCurve )
            {
              if( !AGF_Get_CurvePointString(ElemInfo_Index) ) 
              {
                RestoreBuff(akb_tempbuff_buffpos);
                return false;
              }
              
            }
            else
            {
              if( !AGF_Get_LinearString(ElemInfo_Index) )
              {
                RestoreBuff(akb_tempbuff_buffpos);
                return false; // ni prebran eterior ring
              }
            }
            //AGF_Get_LinearString(ElemInfo_Index);
            NumRings++; 
          }
          break;
          case 2:   // string of arcs
          {
            AGF_Get_CurveArcString(ElemInfo_Index);
            NumRings++; 
          }
          break;
          case 3:   // rect defined with two lower and uppoer points
          {
            ElemInfo_Index+=3; // skip it
          }
          break;
          case 4:   // circle
          {
            ElemInfo_Index+=3; // skip it
          }
          break;          
        }
      }
      break;
      default:
      {
        goto out_rings;
      }
    }          
    
  }
  
  out_rings:;
  
  return true;
}//end of c_SdoGeomToAGF2::AGF_Get_CurveInnerRings_Etype2003_2005




/*
  Describing sdo_elem_info
  
 switch( eleminfo_etype )
  {
    case 1:   // point
    {
      return 0; // don't now what to do with point in polygon
    }
    break;
    case 2:   // string
    {
      if( eleminfo_interp == 1 ) // line string of points
      {
      }
      else
      {
        if( eleminfo_interp == 2 ) // line string of arc's
        {
        }
      }
    }
    break;
    case 4:  // compound line string ( connected with some stright lines and some arcs)
    {
      // elem_interp is number of element contained in this compund line string
      // elem_interp is number of next triplets in m_SdoGeom->getSdo_elem_info()
      // in subelemnts only allowed is etype == 2
    }
    break;
    case 1003:   // exteriror ring (must be  counterclockwise order of points)
    case 2003:   // interior ring  (must be  clockwise order of points)
    {
      switch( eleminfo_interp )
      {
        case 1: // ring of straight lines
        break;
        case 2: // ring of just arcs
        break;
        case 3: // optimized ring (two-points) minpoint, maxpoint
        break;
        case 4: // circle
        break;
      }
    }
    break;
    case 1005:   // compound polygon - exteriror ring  (compound some are straight lines, some are arcs
    case 2005:   // compound polygon - interior ring
    {
    // elem_interp is number of subelement contained in this compund line polygon
    // elem_interp is number of next triplets (subelemnts) in m_SdoGeom->getSdo_elem_info()
    // in subelemnts only allowed is etype == 2
    }
    break;
    
  }
  */
