/*
* Copyright (C) 2006  SL-King d.o.o
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _c_KgOraFilterProcessor_h
#define _c_KgOraFilterProcessor_h

#include "c_FilterStringBuffer.h"
#include "c_KgOraExpressionProcessor.h"



/// \brief
/// The FdoIFilterProcessor interface can be used to process the nodes in a Filter
/// tree. It declares a process operation for each concrete class in the Filter
/// hierarchy. Providers or client applications can create classes that realize
/// this interface to do something meaningful with a Filter hierarchy. For
/// example, a RDBMS feature provider can implement a processor class to convert a
/// Filter hierarchy to the SQL equivalent syntax.
class c_KgOraFilterProcessor : public virtual FdoIFilterProcessor 
{
public:
  c_KgOraFilterProcessor(c_KgOraConnection* KgOraConn,c_KgOraSchemaDesc *KgOraSchemaDesc,FdoClassDefinition* ClassDef,const c_KgOraSridDesc& OraSrid);
public:
  ~c_KgOraFilterProcessor(void);
  virtual void Dispose() { delete this; }  

protected:
  c_KgOraConnection* m_KgOraConn;
  FdoPtr<c_KgOraSchemaDesc> m_KgOraSchemaDesc;
  //FdoPtr<FdoIdentifier> m_ClassId;  
  
  FdoPtr<FdoKgOraClassDefinition> m_phys_class;  
  FdoPtr<FdoClassDefinition> m_ClassDef;    
  //FdoPtr<FdoKgOraClassDefinition> m_phys_class;
  
  //c_KgOraSridDesc m_OraSridDesc;  
  //int m_OracleMainVersion;
  
public:  
  std::wstring m_SDE_SelectSpatialIndex; // this is where select sql is stored for spatial index when filter encounters spatial condition 
                                        // (SELECT  /*+ INDEX(SP_ S2008_IX1) */ DISTINCT sp_fid, eminx, eminy, emaxx,
                                        //  emaxy FROM OSMASTERMAP.S2008 SP_  WHERE SP_.gx >= :1 AND SP_.gx <= :2 AND
                                        //  SP_.gy >= :3 AND SP_.gy <= :4 AND SP_.eminx <= :5 AND SP_.eminy <= :6 AND
                                        //  SP_.emaxx >= :7 AND SP_.emaxy >= :8) S_
                                        
  std::wstring m_SDE_WhereSpatialIndex;                                        
  
public:
    /// \brief
    /// Processes the FdoBinaryLogicalOperator passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoBinaryLogicalOperator
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessBinaryLogicalOperator(FdoBinaryLogicalOperator& Filter);

    /// \brief
    /// Processes the FdoUnaryLogicalOperator passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoUnaryLogicalOperator
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessUnaryLogicalOperator(FdoUnaryLogicalOperator& Filter);

    /// \brief
    /// Processes the FdoComparisonCondition passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoComparisonCondition
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessComparisonCondition(FdoComparisonCondition& Filter);

    /// \brief
    /// Processes the FdoInCondition passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoInCondition
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessInCondition(FdoInCondition& Filter);

    /// \brief
    /// Processes the FdoNullCondition passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoNullCondition
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessNullCondition(FdoNullCondition& Filter);

    /// \brief
    /// Processes the FdoSpatialCondition passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoSpatialCondition
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessSpatialCondition(FdoSpatialCondition& Filter);

    /// \brief
    /// Processes the FdoDistanceCondition passed in as an argument.
    /// 
    /// \param Filter 
    /// Input the FdoDistanceCondition
    /// 
    /// \return
    /// Returns nothing
    /// 
    virtual void ProcessDistanceCondition(FdoDistanceCondition& Filter);  
    
    
public:
  const wchar_t* GetFilterText() { return m_StringBuff.GetString(); };   
  void ClearFilterText() { m_StringBuff.ClearBuffer(); };   
  
  c_KgOraExpressionProcessor& GetExpressionProcessor() { return m_ExpressionProcessor; };   
  c_KgOraExpressionProcessor* GetExpressionProcessorPtr() { return &m_ExpressionProcessor; };   
    
protected:
    c_KgOraExpressionProcessor m_ExpressionProcessor;
    c_FilterStringBuffer m_StringBuff;
    
    void ProcessFilter(FdoFilter* Filter); 
    void ProcessGeomExpresion( FdoExpression* Expr,c_KgOraSridDesc& OraSrid);
    void ProcessExpresion( FdoExpression* Expr );

    void AppendString(const wchar_t *Str);

    void PrependString(const wchar_t *Str);
	  
};

#endif
