#include "StdAfx.h"

#include "c_KgInfoUtil.h"
#include "c_KgInfDeleteTest.h"


CPPUNIT_TEST_SUITE_REGISTRATION(c_KgInfDeleteTest);



c_KgInfDeleteTest::c_KgInfDeleteTest(void)
{
}

c_KgInfDeleteTest::~c_KgInfDeleteTest(void)
{
}


void c_KgInfDeleteTest::DeleteTest()
{

try
{
  // Connect:
 
  FdoPtr<FdoIConnection> conn = c_KgInfoUtil::OpenUnitTestConnection();

  FdoPtr<FdoIDescribeSchema> comm1 = (FdoIDescribeSchema*)conn->CreateCommand(FdoCommandType_DescribeSchema);
  FdoPtr<FdoFeatureSchemaCollection> schemas = comm1->Execute();
 
  FdoStringP src_classname = L"informix~world~locn";
 /*
// Execute insert  
{  
  FdoPtr<FdoIInsert> comm_insert = (FdoIInsert*)conn->CreateCommand( FdoCommandType_Insert );    
  comm_insert->SetFeatureClassName( src_classname );
  
  FdoPtr<FdoPropertyValueCollection> propcol = comm_insert->GetPropertyValues();
 
{
  FdoPtr<FdoStringValue> name_val=  (FdoStringValue*)FdoDataValue::Create(L"testPolygon");
  FdoPtr<FdoPropertyValue> propval_name = FdoPropertyValue::Create(L"name",name_val); 
  propcol->Add(propval_name);
}
  
{
  FdoPtr<FdoInt32Value> idval=  (FdoInt32Value*)FdoDataValue::Create(1111);
  FdoPtr<FdoPropertyValue> propval_name_id = FdoPropertyValue::Create(L"se_row_id",idval); 
  propcol->Add(propval_name_id);
}

  
  
  // Geometry property
  FdoPtr<FdoFgfGeometryFactory> fgf = FdoFgfGeometryFactory::GetInstance();
  double ordinates[10] = { 1,1 ,10,1 ,10,10 ,1,10 ,1,1 }; 
  
  FdoPtr<FdoILinearRing> ring = fgf->CreateLinearRing(0,10,ordinates);
  FdoPtr<FdoIPolygon> polygon = fgf->CreatePolygon(ring,NULL);
  
  FdoPtr<FdoByteArray> barray = fgf->GetFgf(polygon);
  
  FdoPtr<FdoGeometryValue> geom_val=  FdoGeometryValue::Create(barray);
  
  FdoPtr<FdoPropertyValue> propval_geom = FdoPropertyValue::Create(L"locn",geom_val);
   
  propcol->Add(propval_geom);

  FdoPtr<FdoIFeatureReader> insreader = comm_insert->Execute(); 
}                    
*/
// execute delete  
{  
  FdoPtr<FdoIDelete> comm_delete = (FdoIDelete*)conn->CreateCommand( FdoCommandType_Delete );    
  comm_delete->SetFeatureClassName( src_classname );
  
  
  // set filter for delete
  FdoPtr<FdoIdentifier> ident =  FdoIdentifier::Create(L"se_row_id");
  FdoPtr<FdoDataValue> val2 =  FdoDataValue::Create(1111);
  FdoPtr<FdoFilter> filter = FdoComparisonCondition::Create(ident, FdoComparisonOperations_EqualTo, val2);
  comm_delete->SetFilter(filter);
  
  FdoInt32 updated = comm_delete->Execute();
  if( updated != 1 )
  {
    CPPUNIT_FAIL( "c_KgInfDeleteTest::UpdateTest Update should returned 1 for num of changed rows" );
  }
} 

  conn->Close();
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
}
  
}//end of c_KgInfDeleteTest::DeleteTest





void c_KgInfDeleteTest::SetupSchema()
{
try
{
  FdoPtr<FdoIConnection> connection = c_KgInfoUtil::OpenUnitTestConnection();
  FdoPtr<FdoISQLCommand> sqlcomm = (FdoISQLCommand*)connection->CreateCommand( FdoCommandType_SQLCommand );
  
  sqlcomm->SetSQLStatement(L"DROP TABLE insertclass");
  sqlcomm->ExecuteNonQuery();
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  
}



try
{
  // Connect:
        FdoPtr<FdoIConnection> connection = c_KgInfoUtil::OpenUnitTestConnection();
        

        // Define one new schema:
        FdoPtr<FdoFeatureSchema> schema = FdoFeatureSchema::Create(L"insertshema", L"");
        FdoPtr<FdoClassCollection> classes = schema->GetClasses();

        // Define one new class with X/Y/Z lowercase property names (and an identity property and a geometry property):
        FdoPtr<FdoFeatureClass> newClass = FdoFeatureClass::Create(L"insertclass", L"");
        FdoPtr<FdoPropertyDefinitionCollection> newProps = newClass->GetProperties();
        FdoPtr<FdoDataPropertyDefinitionCollection> newIds = newClass->GetIdentityProperties();
        
        FdoPtr<FdoDataPropertyDefinition> dataPropID = FdoDataPropertyDefinition::Create(L"col_id", L"");
        dataPropID->SetDataType(FdoDataType_Int32);
        dataPropID->SetIsAutoGenerated(true);
        dataPropID->SetNullable(false);
        newProps->Add(dataPropID);
        newIds->Add(dataPropID);
        
        FdoPtr<FdoDataPropertyDefinition> datafid = FdoDataPropertyDefinition::Create(L"feat_id", L"");
        datafid->SetDataType(FdoDataType_Int32);
        datafid->SetNullable(false);
        newProps->Add(datafid);
        
        FdoPtr<FdoDataPropertyDefinition> dataPropX = FdoDataPropertyDefinition::Create(L"col_x", L"");
        dataPropX->SetDataType(FdoDataType_Double);
        dataPropX->SetNullable(true);
        newProps->Add(dataPropX);
        FdoPtr<FdoDataPropertyDefinition> dataPropY = FdoDataPropertyDefinition::Create(L"col_y", L"");
        dataPropY->SetDataType(FdoDataType_Double);
        dataPropY->SetNullable(true);
        newProps->Add(dataPropY);
        FdoPtr<FdoDataPropertyDefinition> dataPropZ = FdoDataPropertyDefinition::Create(L"col_z", L"");
        dataPropZ->SetDataType(FdoDataType_Double);
        dataPropZ->SetNullable(true);
        newProps->Add(dataPropZ);
        FdoPtr<FdoDataPropertyDefinition> dataPropstring = FdoDataPropertyDefinition::Create(L"col_name", L"");
        dataPropZ->SetDataType(FdoDataType_String);
        dataPropZ->SetNullable(true);
        newProps->Add(dataPropstring);
        FdoPtr<FdoGeometricPropertyDefinition> dataPropGeom = FdoGeometricPropertyDefinition::Create(L"col_geometry", L"");
        dataPropGeom->SetGeometryTypes(FdoGeometricType_Point);
        newProps->Add(dataPropGeom);
        newClass->SetGeometryProperty(dataPropGeom);
        classes->Add(newClass);

        // Create the new class:
        FdoPtr<FdoIApplySchema> as = (FdoIApplySchema*)connection->CreateCommand(FdoCommandType_ApplySchema);
        as->SetFeatureSchema(schema);
        as->Execute();
                    
        connection->Close();
  
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
  
}
  
}//end of c_KgInfDeleteTest::SetupSchema