#ifndef VISION_noschema

#ifdef PostGIS

/*****************************************************************************/
create table f_schemainfo (
    schemaname       varchar(255) not null,
    description      varchar(255),
    owner            varchar(255) not null,
    creationdate     timestamp,
    schemaversionid  numeric(5,3) not null,
    tableowner       varchar(64),
    tablelinkname    varchar(128),
    tablemapping     varchar(30)
);
COMMENT ON TABLE f_schemainfo IS 'Definition of information properties for FDO meta schema.';

insert into f_schemainfo
(schemaname, description, creationdate, owner, schemaversionid )
values
(current_database(), 'System Metaschema', current_timestamp, current_user, 3.000);

insert into f_schemainfo
(schemaname, description, creationdate, owner, schemaversionid )
values
('F_MetaClass', 'Special classes for FDO Feature metaclasses', current_timestamp, current_user, 3.000);

/*****************************************************************************/
create table f_options (
      name	 varchar(100),
      value	 varchar(100)
);

insert into f_options values ('LT_MODE', '1');
insert into f_options values ('LOCKING_MODE', '1');

/*****************************************************************************/
create table f_schemaoptions (
    ownername    varchar(512) not null,
    elementname  varchar(255) not null,
    elementtype  varchar(30) not null,
    name         varchar(255) not null,
    value        varchar(4000)
);
COMMENT ON TABLE f_schemaoptions IS 'Definition of options for FDO meta schema.';

/*****************************************************************************/
create table f_sad (
    ownername    varchar(512) not null,
    elementname  varchar(255) not null,
    elementtype  varchar(30) not null,
    name         varchar(255) not null,
    value        varchar(4000)
);
COMMENT ON TABLE f_sad IS 'Definition of schema attribute dictionary for FDO meta schema.';

/*****************************************************************************/
create table f_dbopen (
    usernum     integer not null,
    dbuser      varchar(30) not null,
    accessmode  varchar(1),
    activescid  bigint,
    opendate    timestamp,
    sessionid   integer,
    process     varchar(128)
);
COMMENT ON TABLE f_dbopen IS 'TODO';

/*****************************************************************************/
#ifdef FDO_FEATURE
create table f_feature (
    featid        bigint not null,
    classid       numeric(20)
#ifdef FDO_VERSIONS
    ,ltid          numeric(20),
    nextltid      numeric(20),
    ltgeneration  numeric(20)
#endif
#ifdef FDO_LOCKS
    ,rowlockid     numeric(20),
    rowlocktype   varchar(1)
#endif
);
COMMENT ON TABLE f_feature IS 'Definition of FDO spatial feature types.';

#ifndef FDO_VERSIONS
#ifndef FDO_LOCKS
alter table f_feature add (constraint f_feature_pk primary key (featid));
#endif
#endif

#endif 


/*****************************************************************************/
create table f_classdefinition (
    classid          integer not null,
    classname        varchar(255) not null,
    schemaname       varchar(255),
    tablename        varchar(64) not null,
    roottablename    varchar(64),
    tableowner       varchar(64),
    tablelinkname    varchar(128),
    tablemapping     varchar(64),
    classtype        smallint not null,
    description      varchar(255),
    isabstract       smallint not null,
    parentclassname  varchar(512),
    isfixedtable     smallint,
    istablecreator   smallint,
    hasversion       smallint,
    haslock          smallint,
    geometryproperty varchar(4000),

    CONSTRAINT f_classdefinition_pk PRIMARY KEY (classid)
);
COMMENT ON TABLE f_classdefinition IS 'Definition of classes from FDO feature schema.';

/*****************************************************************************/
create table f_attributedefinition (
    tablename         varchar(64) not null,
    classid           integer not null,
    columnname        varchar(255) not null,
    attributename     varchar(4000) not null,
    idposition        smallint,
    columntype        varchar(30) not null,
    columnsize        bigint not null,
    columnscale       smallint,
    attributetype     varchar(512) not null,
    geometrytype      varchar(64),
    isnullable        smallint not null,
    isfeatid          smallint not null,
    issystem          smallint not null,
    isreadonly        smallint not null,
    isautogenerated   smallint,
    isrevisionnumber  smallint,
    sequencename      varchar(30),
    owner             varchar(255),
    description       varchar(255),
    rootobjectname    varchar(64),
    isfixedcolumn     smallint,
    iscolumncreator   smallint,
    haselevation      smallint,
    hasmeasure        smallint
);
COMMENT ON TABLE f_attributedefinition IS 'Definition of properties for classes from FDO feature schema.';


/*****************************************************************************/
create table f_spatialcontextgroup (
    scgid           bigint not null,
    crsname         varchar(255),
    crswkt          varchar(2048),
    srid            bigint,
    areaunit        varchar(30),
    lengthunit      varchar(30),
    positionxyunit  varchar(30), 
    positionzunit   varchar(30),
    volumeunit      varchar(30),
    measureunit     varchar(30),
    xtolerance      double precision not null,
    ztolerance      double precision,
    minx            double precision not null, -- TODO: xmin is a system column name
    miny            double precision not null,
    minz            double precision,
    maxx            double precision not null, -- TODO: xmax is a system column name
    maxy            double precision not null,
    maxz            double precision,
    extenttype      varchar(1) not null,

    CONSTRAINT f_spatialcontextgroup_pk PRIMARY KEY (scgid)
);
COMMENT ON TABLE f_spatialcontextgroup IS 'TODO';

insert into f_spatialcontextgroup
(scgid, crsname, xtolerance, ztolerance, minx, miny, maxx, maxy, extenttype)
values
(1,'', 0.001, 0.001, -2000000, -2000000, 2000000, 2000000, 'S');

/*****************************************************************************/
create table f_spatialcontextgeom (
    scid bigint     not null,
    geomtablename   varchar(64) not null,
    geomcolumnname  varchar(64) not null,
    dimensionality  smallint  not null              
);
COMMENT ON TABLE f_spatialcontextgeom IS 'TODO';

/*****************************************************************************/
create table f_attributedependencies (
    pktablename     varchar(64) not null,
    pkcolumnnames   varchar(1056),
    fktablename     varchar(64) not null,
    fkcolumnnames   varchar(1056),
    fkcardinality   integer not null,
    identitycolumn  varchar(64),
    ordertype       char(1)
);
COMMENT ON TABLE f_attributedependencies IS 'TODO';

#ifdef FDO_FEATURE
/* Add dependency for navigating from a feature to its class and schema name */
insert into f_attributedependencies
( pktablename, pkcolumnnames, fktablename, fkcolumnnames, fkcardinality )
values ( 'F_FEATURE', 'CLASSID', 'F_CLASSDEFINITION', 'CLASSID', 1 );
#endif

/*****************************************************************************/
create table f_associationdefinition (
     pseudocolname        varchar(64) not null,
     pktablename          varchar(64) not null,
     pkcolumnnames        varchar(1056),
     fktablename          varchar(64) not null,
     fkcolumnnames        varchar(1056),
     multiplicity         varchar(5),
     reversemultiplicity  varchar(5),
     cascadelock          char(1),
     deleterule           integer,
     reversename          varchar(200)
);
COMMENT ON TABLE f_associationdefinition IS 'TODO';

/*****************************************************************************/
create table f_spatialcontext (
    scid         bigint not null,
    scname       varchar(255) not null,
    description  varchar(255),
    scgid        bigint null,
#ifdef FDO_LOCKS
    rowlockid    bigint null,
    rowlocktype  varchar(1) null,
#endif

   CONSTRAINT f_spatialcontext_pk PRIMARY KEY (scid)
);
COMMENT ON TABLE f_spatialcontext IS 'Definition of FDO spatial context.';

insert into f_spatialcontext
(scid,scname, description, scgid) 
values
(1, 'Default', 'Default Database Spatial Context', 1);

/*****************************************************************************/
create table f_classtype (
    classtype      integer not null,
    classtypename  varchar(255) not null
);
COMMENT ON TABLE f_classtype IS 'Definition of types for FDO classes.';

insert into f_classtype (classtype, classtypename) values (1, 'Class');
insert into f_classtype (classtype, classtypename) values (2, 'Feature');

/*****************************************************************************/

/* create sequences */
create sequence F_FeatureSeq start with 2;
create sequence F_LockSeq start with 2;
create sequence F_PlanSeq start with 2;
#ifdef FDO_VERSIONS 
create sequence F_VersionSeq start with 1;
create sequence F_GenerationSeq start with 1;
#endif
create sequence F_ClassSeq start with 4;
create sequence F_PlangroupSeq start with 2;
create sequence F_UserSeq start with 1;

create table f_sequence(
    seqid           varchar(30) not null,
    startnum      double precision ,
   CONSTRAINT f_sequence_pk PRIMARY KEY (seqid)
    );

insert into f_sequence values( 'F_FEATURESEQ',2);
insert into f_sequence values( 'F_LOCKSEQ',2);
insert into f_sequence values( 'F_PLANSEQ',2);
insert into f_sequence values( 'F_VERSIONSEQ',1);
insert into f_sequence values( 'F_CLASSSEQ',4);
insert into f_sequence values( 'F_PLANGROUPSEQ',2);
insert into f_sequence values( 'F_USERSEQ',1);
insert into f_sequence values( 'F_Seq_1',1);
insert into f_sequence values( 'F_Seq_2',1);
insert into f_sequence values( 'F_Seq_3',1);
insert into f_sequence values( 'F_Seq_4',1);
insert into f_sequence values( 'F_Seq_5',1);
insert into f_sequence values( 'F_Seq_6',1);
insert into f_sequence values( 'F_Seq_7',1);
insert into f_sequence values( 'F_Seq_8',1);
insert into f_sequence values( 'F_Seq_9',1);
insert into f_sequence values( 'F_Seq_10',1);
insert into f_sequence values( 'F_Seq_11',1);
insert into f_sequence values( 'F_Seq_12',1);

#endif /* PostGIS */

#endif /* VISION_noschema */

/* End */
