/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef POSTGIS_FDOUPDATETEST_H
#define POSTGIS_FDOUPDATETEST_H

#include "FdoUpdateTest.h"

class PostGisFdoUpdateTest : public FdoUpdateTest
{
    CPPUNIT_TEST_SUB_SUITE (PostGisFdoUpdateTest, FdoUpdateTest);
    CPPUNIT_TEST_SUITE_END ();

    void  set_provider();
    virtual FdoStringP TableIdGeomName() {return L"table_id_geom";}

public:
	virtual void ConditionalUpdate () { }

protected:
    virtual FdoInt64 GetSrid( FdoInt64 srid );
    virtual bool CanHandleNullCol() {return false;};

    virtual FdoString* NoMetaSuffix();
	static const wchar_t* mForeignPolygonTest[];
};

#endif // POSTGIS_FDOUPDATETEST_H
