/*
 * Copyright (C) 2006 Refractions Research, Inc. 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef POSTGIS_GET_MSG_H
#define POSTGIS_GET_MSG_H

#ifdef _WIN32
#pragma once
#endif // _WIN32

#include "local.h"

/**
 * Returns error message most recently generated by on the connection.
 *
 * @param context [in] - pointer to PostGIS session context.
 * @param buffer [out] - target buffer for message.
 * @return RDBI_SUCCESS on success, RDBI error code otherwise.
 */
int postgis_get_msg (postgis_context_def *context, char *buffer);

/**
 * Returns error message most recently generated by on the connection.
 * Wide-char version of postgis_get_msg function.
 *
 * @param context [in] - pointer to PostGIS session context.
 * @param buffer [out] - wide-char buffer for message.
 * @return RDBI_SUCCESS on success, RDBI error code otherwise.
 */
int postgis_get_msgW (postgis_context_def *context, wchar_t *buffer);

#endif /* POSTGIS_GET_MSG_H */
