#ifndef FDO_SCHEMA_XML_CONTEXT_H
#define FDO_SCHEMA_XML_CONTEXT_H
// 
//  Copyright (C) 2004-2006  Autodesk, Inc.
//  
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//  
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include <Fdo/Xml/Context.h>
#include <Fdo/Schema/FeatureSchemaCollection.h>
#include <Fdo/Schema/FeatureClass.h>
#include <Fdo/Schema/NetworkLinkFeatureClass.h>
#include <Fdo/Schema/NetworkClass.h>
#include <Fdo/Schema/NetworkNodeFeatureClass.h>
#include <Fdo/Schema/UniqueConstraint.h>
#include <Fdo/Schema/ObjectPropertyDefinition.h>
#include <Fdo/Xml/SchemaMapping.h>
#include <Fdo/Schema/MergeContext.h>

class FdoSchemaXmlContext : public FdoXmlContext
{
public:
    // Constructs a context for parsing Feature Schemas from 
    // an XML document.
    //
    // Parameters:
    //      schemas - read the Feature Schemas into this collection. 
	static FdoSchemaXmlContext* Create( FdoFeatureSchemaCollection* schemas );

    // Constructs a context for serializing Feature Schemas to
    // an XML document.
    //
    // Parameters:
    //      flags - control how XML serialization is performed
    //      writer - serialize to this XML writer.
    static FdoSchemaXmlContext* Create( FdoXmlFlags* flags, FdoXmlWriter* writer );

    // Gets the current XML writer. NULL if not serializing.
    FdoXmlWriter* GetXmlWriter();
    
    // Gets the Merge context used to merge schemas read from XML into the current schemas.
    FdoPtr<FdoSchemaMergeContext> GetMergeContext();

    //  Gets the Schema Mapping Collection generated by this XML Context.
	FdoPhysicalSchemaMappingCollection* GetXmlSchemaMappings();

    // Set the list of schemas read from XML.
    void SetUpdSchemas( FdoFeatureSchemasP schemas );
    
    // Add a schema to the list of read schemas
    FdoFeatureSchemaP AddSchema( FdoString* schemaName, FdoXmlAttributeCollection* attrs );

    // Add GML Schema Mapping for a feature schema
    void AddSchemaMapping (
        FdoString* schemaName,
        FdoString* targetNamespace
    );

    // Add GML Schema Mapping for a global element
    void AddElementMapping (
        FdoString* elementSchema,
        FdoString* elementName,
        FdoString* classSchema,
        FdoString* className,
        FdoString* choiceName
    );

    // Add GML Schema Mapping for a class sub-element
    void AddSubElementMapping (
        FdoString* elementSchema,
        FdoString* elementContainer,
        FdoString* elementName,
        FdoString* classSchema,
        FdoString* className,
        FdoString* gmlUri,
        FdoString* gmlLocalName,
        FdoString* choiceName
    );

    // Add GML Schema Mapping for a class 
    void AddClassMapping (
        FdoString* classSchema,
        FdoString* className,
        FdoString* gmlName,
        FdoString* wkSchema,
        FdoString* wkClass
    );


    FdoClassDefinition* CreateClass( 
        FdoString* schemaName, 
        FdoString* className, 
        FdoXmlAttributeCollection* atts 
    );

    // Converts a name to be a valid XML element or attribute name.
    FdoStringP EncodeName( FdoStringP name );

    // Commits the schemas that were read. Resolves all references. If there
    // are any errors these are thrown. Otherwise, the schemas that were
    // read are merged into the Feature Schema collection.
    //
    void CommitSchemas();

    // Resolve element mapping to class mapping references. Links element mapping objects
    // to the objects for their classes.
    void ResolveSchemaMappings();
    void ResolveElementMappings( 
        FdoXmlSchemaMappingP schemaMapping,
        FdoXmlElementMappingsP elementMappings
    );

    // Given a referenced class definition, returns its schema name.
    // Logs an error if class is orphan (not in a feature schema).
    //
    // Parameters:
    //      pRefElement - schema element that references the class. Used in error message.
    //      pClass - the referenced class.
    FdoStringP RefClass2SchemaName( FdoSchemaElement* pRefElement, FdoClassDefinition* pClass );
    
    // Given a referenced association property, returns whether it can be
    // written to XML.
    // Logs an error if the property's associated class is an orphan (not in a feature 
    // schema).
    //
    // This function is used when writing special association properties for Network
    // classes. These properties are direct members rather than actual properties of
    // these classes. This function ensures that the error message has proper 
    // contextual information.
    //
    // Parameters:
    //      pRefElement - schema element that references the association property. Used in error message.
    //      pAssoc - the association property.
    FdoBoolean CheckWriteAssoc( FdoSchemaElement* pRefElement, FdoAssociationPropertyDefinition* pAssoc );
    
protected:
    FdoSchemaXmlContext() {}
	FdoSchemaXmlContext( FdoFeatureSchemaCollection* schemas );
    FdoSchemaXmlContext( FdoXmlFlags* flags, FdoXmlWriter* writer );
    virtual ~FdoSchemaXmlContext() 
    {
    }

    void Init( FdoFeatureSchemaCollection* schemas );

    // Get a schema mapping set for the given feature schema.
    // Create it if it doesn't yet exist.
    FdoXmlSchemaMappingP GetSchemaMapping( FdoStringP schemaName );

private:
    FdoXmlWriterP mWriter;
    FdoStringP mUrl;

    FdoSchemaMergeContextP mMergeContext;

    // GML to FDO Schema Mappings
    FdoSchemaMappingsP     mXmlSchemaMappings; 
    FdoXmlSchemaMappingP     mXmlMapping;
};

typedef FdoPtr<FdoSchemaXmlContext> FdoSchemaXmlContextP;

#endif

