// Copyright (C) 2004-2006  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


#ifndef CPP_UNIT_GMLWRITETEST_H
#define CPP_UNIT_GMLWRITETEST_H

class GmlWriteTest : public CppUnit::TestCase
{
    FDO_CPPUNIT_DEFINE(testSimpleFeature);
	FDO_CPPUNIT_DEFINE(testGML3SimpleFeature);
    FDO_CPPUNIT_DEFINE(testSimpleFeatureTransform);
    FDO_CPPUNIT_DEFINE(testGML3SimpleFeatureTransform);
 
    CPPUNIT_TEST_SUITE(GmlWriteTest);
    CPPUNIT_TEST(testSimpleFeature);
	CPPUNIT_TEST(testGML3SimpleFeature);
    CPPUNIT_TEST(testSimpleFeatureTransform);
    CPPUNIT_TEST(testGML3SimpleFeatureTransform);
    CPPUNIT_TEST_SUITE_END();

public:
    GmlWriteTest(void);
    virtual ~GmlWriteTest(void);
    void setUp ();

protected:
    void testSimpleFeature();
	void testGML3SimpleFeature();
    void testSimpleFeatureTransform();
    void testGML3SimpleFeatureTransform();
};

class TransformTest : public FdoCoordinateSystemTransform
{
public:
    virtual FdoIDirectPosition* CoordinateSystemTransform(FdoIDirectPosition* sourceGeometry);
};


#endif





