//
// Copyright (C) 2004-2007  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// -------------------------------------------------------------
// PYTHON typemaps
//	Description:	These typemaps will convert between C++
//					arrays to Python Lists
//
// -------------------------------------------------------------
//

%include "typemaps.i"
%apply int& OUTPUT { FdoInt32& count };
%apply int& OUTPUT { FdoInt32& length };
%apply int& OUTPUT { FdoInt32& size };

/* Convert FdoClassType* to Python list of FdoClassType integers */
%typemap(out) FdoClassType* {
	// Verify that we are in the FdoISchemaCapability.GetClassTypes() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper to prevent conflicts where the FdoClassType*
	// points to a single FdoClassType instance instead of an array.
	if (strcmp("$symname", "FdoISchemaCapabilities_GetClassTypes") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoDataType*  to Python list of FdoDataType integers */
%typemap(out) FdoDataType* {
	// Verify that we are in the FdoISchemaCapability.GetDataTypes() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoISchemaCapabilities_GetDataTypes") == 0 || 
		strcmp("$symname", "FdoISchemaCapabilities_GetSupportedAutoGeneratedTypes") == 0 ||
		strcmp("$symname", "FdoISchemaCapabilities_GetSupportedIdentityPropertyTypes") == 0)
	{
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoRasterDataModelType*  to Python list of FdoRasterDataModelType integers */
%typemap(out) FdoRasterDataModelType* {
	// Verify that we are in the FdoRasterDataModel.GetDataModelType() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoRasterDataModel_GetDataModelType") == 0 )
	{
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoRasterDataType*  to Python list of FdoRasterDataType integers */
%typemap(out) FdoRasterDataType* {
	// Verify that we are in the FdoRasterDataModel.GetDataType() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoRasterDataModel_GetDataType") == 0 )
	{
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoRasterDataOrganization*  to Python list of FdoRasterDataOrganization integers */
%typemap(out) FdoRasterDataOrganization* {
	// Verify that we are in the FdoRasterDataModel.GetOrganization() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoRasterDataModel_GetOrganization") == 0 )
	{
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoSpatialContextExtentType*  to Python list of FdoSpatialContextExtentType integers */
%typemap(out) FdoSpatialContextExtentType* {
	// Verify that we are in the FdoIConnectionCapabilities.GetSpatialContextTypes() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoIConnectionCapabilities_GetSpatialContextTypes") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}


/* Convert FdoInt32*  to Python list of FdoICommandType integers */
%typemap(out) FdoInt32* {
	// Verify that we are in the FdoICommandCapabilities.GetCommands() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper
	if (strcmp("$symname", "FdoICommandCapabilities_GetCommands") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}		
	}	
}

/* Convert FdoGeometryType* to Python List */
%typemap(out) FdoGeometryType* {
	if ($1 == NULL) {
		$result = PyTuple_New( 0 );
	}
	else {
		$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
	}
}

/* Convert FdoGeometryComponentType* to Python List */
%typemap(out) FdoGeometryComponentType* {
	if ($1 == NULL) {
		$result = PyTuple_New( 0 );
	}
	else {
		$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
	}
}



/* Convert FdoExpressionType* to Python list of FdoExpressionType integers */
%typemap(out) FdoExpressionType* {
	// Verify that we are in the FdoIExpressionCapabilities.GetExpressionTypes() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper to prevent conflicts where the FdoFunctionDefinition*
	// points to a single FdoFunctionDefinition instance instead of an array.
	if (strcmp("$symname", "FdoIExpressionCapabilities_GetExpressionTypes") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}



/* Convert FdoConditionType* to Python list of FdoConditionType integers */
%typemap(out) FdoConditionType* {
	// Verify that we are in the FdoIFilterCapabilities.FdoConditionType() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper to prevent conflicts where the FdoConditionType*
	// points to a single FdoConditionType instance instead of an array.
	if (strcmp("$symname", "FdoIFilterCapabilities_GetConditionTypes") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}

/* Convert FdoSpatialOperations* to Python list of FdoSpatialOperations integers */
%typemap(out) FdoSpatialOperations* {
	// Verify that we are in the FdoIExpressionCapabilities.GetSpatialOperations() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper to prevent conflicts where the FdoSpatialOperations*
	// points to a single FdoSpatialOperations instance instead of an array.
	if (strcmp("$symname", "FdoIFilterCapabilities_GetSpatialOperations") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}


/* Convert FdoDistanceOperations* to Python list of FdoDistanceOperations integers */
%typemap(out) FdoDistanceOperations* {
	// Verify that we are in the FdoIExpressionCapabilities.GetDistanceOperations() method.
	// This will look redundant in the final C++ wrapper code, but is required
	// by the SWIG wrapper to prevent conflicts where the FdoDistanceOperations*
	// points to a single FdoDistanceOperations instance instead of an array.
	if (strcmp("$symname", "FdoIFilterCapabilities_GetDistanceOperations") == 0) {
		if ($1 == NULL) {
			$result = PyTuple_New( 0 );
		}
		else {
			$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
		}
	}
}


/* Convert FdoLockType* to Python list of FdoLockType integers */
%typemap(out) FdoLockType* {	
	if ($1 == NULL) {
		$result = PyTuple_New( 0 );
	}
	else {
		$result = utils_intArrayToPyTuple( (int*)$1, *arg2 );
	}
}

