/*
* 
* Copyright (C) 2004-2006  Autodesk, Inc.
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*/

#include "stdafx.h"
#include <Fdo.h>

#include "FDO\Connections\Capabilities\mgISchemaCapabilitiesImp.h"

NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::ISchemaCapabilitiesImp(IntPtr unmanaged, Boolean autoDelete) : Disposable(unmanaged, autoDelete)
{

}

FdoISchemaCapabilities* NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::GetImpObj()
{
    return static_cast<FdoISchemaCapabilities*>(UnmanagedObject.ToPointer());
}

IntPtr NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::GetDisposableObject()
{
    return IntPtr(static_cast<FdoIDisposable*>(GetImpObj()));
}

array<NAMESPACE_OSGEO_FDO_SCHEMA::ClassType>^ NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::ClassTypes::get()
{
	FdoClassType* unobj;
	FdoInt32 unlength;
	EXCEPTION_HANDLER(unobj = GetImpObj()->GetClassTypes(unlength))

	array<NAMESPACE_OSGEO_FDO_SCHEMA::ClassType>^ result = gcnew array<NAMESPACE_OSGEO_FDO_SCHEMA::ClassType>(unlength);
	for(FdoInt32 i = 0; i < unlength; i ++)
		result[i] = static_cast<NAMESPACE_OSGEO_FDO_SCHEMA::ClassType>(*(unobj + i));
	
    return result;
}

array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::DataTypes::get()
{
	FdoDataType* unobj;
	FdoInt32 unlength;
	EXCEPTION_HANDLER(unobj = GetImpObj()->GetDataTypes(unlength))
	
	array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ result = gcnew array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(unlength);
	for(FdoInt32 i = 0; i < unlength; i ++)
		result[i] = static_cast<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(*(unobj + i));
	
    return result;
}

System::Int64 NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::MaximumDataValueLength::get(NAMESPACE_OSGEO_FDO_SCHEMA::DataType dataType)
{
	System::Int64 rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->GetMaximumDataValueLength((FdoDataType)dataType));
    return rv;
}

System::Int32 NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::MaximumDecimalPrecision::get()
{
	System::Int32 rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->GetMaximumDecimalPrecision());
    return rv;
}

System::Int32 NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::MaximumDecimalScale::get()
{
	System::Int32 rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->GetMaximumDecimalScale());
    return rv;
}

System::Int32 NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::NameSizeLimit::get(NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::SchemaElementNameType name)
{
	System::Int32 rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->GetNameSizeLimit((FdoSchemaElementNameType) name));
    return rv;
}

System::String^ NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::ReservedCharactersForName::get()
{
	FdoString* result;

	EXCEPTION_HANDLER(result = GetImpObj()->GetReservedCharactersForName());

	return CHECK_STRING(result);
}

array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportedAutoGeneratedTypes::get()
{
	FdoDataType* unobj;
	FdoInt32 unlength;
	EXCEPTION_HANDLER(unobj = GetImpObj()->GetSupportedAutoGeneratedTypes(unlength))

	array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ result = gcnew array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(unlength);
	for(FdoInt32 i = 0; i < unlength; i ++)
		result[i] = static_cast<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(*(unobj + i));

    return result;
}

array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportedIdentityPropertyTypes::get()
{
	FdoDataType* unobj;
	FdoInt32 unlength;
	EXCEPTION_HANDLER(unobj = GetImpObj()->GetSupportedIdentityPropertyTypes(unlength))

	array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>^ result = gcnew array<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(unlength);
	for(FdoInt32 i = 0; i < unlength; i ++)
		result[i] = static_cast<NAMESPACE_OSGEO_FDO_SCHEMA::DataType>(*(unobj + i));

    return result;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsAssociationProperties::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsAssociationProperties())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsAutoIdGeneration::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsAutoIdGeneration())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsCompositeId::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsCompositeId())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsCompositeUniqueValueConstraints::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsCompositeUniqueValueConstraints())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsDataStoreScopeUniqueIdGeneration::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsDataStoreScopeUniqueIdGeneration())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsDefaultValue::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsDefaultValue())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsExclusiveValueRangeConstraints::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsExclusiveValueRangeConstraints())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsInclusiveValueRangeConstraints::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsInclusiveValueRangeConstraints())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsInheritance::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsInheritance())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsMultipleSchemas::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsMultipleSchemas())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsNetworkModel::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsNetworkModel())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsNullValueConstraints::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsNullValueConstraints())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsObjectProperties::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsObjectProperties())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsSchemaModification::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsSchemaModification())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsSchemaOverrides::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = !!GetImpObj()->SupportsSchemaOverrides())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsUniqueValueConstraints::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsUniqueValueConstraints())
	return rv;
}

System::Boolean NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES::ISchemaCapabilitiesImp::SupportsValueConstraintsList::get()
{
	System::Boolean rv;
	EXCEPTION_HANDLER(rv = GetImpObj()->SupportsValueConstraintsList())
	return rv;
}

