/*
* Copyright (C) 2004-2006  Autodesk, Inc.
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
* Revision Control Modification History
*
*         $Id$
*     $Author$
*   $DateTime$
*     $Change$
*
*/

#pragma once

//---------------------------------------------------------------
// Namespace declaration
//---------------------------------------------------------------
// OSGeo
#define BEGIN_NAMESPACE_OSGEO namespace OSGeo {
#define END_NAMESPACE_OSGEO }

#define BEGIN_NAMESPACE_OSGEO_FDO BEGIN_NAMESPACE_OSGEO namespace FDO {
#define END_NAMESPACE_OSGEO_FDO END_NAMESPACE_OSGEO }

#define BEGIN_NAMESPACE_OSGEO_RUNTIME BEGIN_NAMESPACE_OSGEO_FDO namespace Runtime {
#define END_NAMESPACE_OSGEO_RUNTIME END_NAMESPACE_OSGEO_FDO }

// Common
#define BEGIN_NAMESPACE_OSGEO_COMMON BEGIN_NAMESPACE_OSGEO_FDO namespace Common {
#define END_NAMESPACE_OSGEO_COMMON END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_COMMON_IO BEGIN_NAMESPACE_OSGEO_COMMON namespace Io {
#define END_NAMESPACE_OSGEO_COMMON_IO END_NAMESPACE_OSGEO_COMMON }

#define BEGIN_NAMESPACE_OSGEO_COMMON_XML BEGIN_NAMESPACE_OSGEO_COMMON namespace Xml {
#define END_NAMESPACE_OSGEO_COMMON_XML END_NAMESPACE_OSGEO_COMMON }

#define BEGIN_NAMESPACE_OSGEO_COMMON_XSL BEGIN_NAMESPACE_OSGEO_COMMON namespace Xsl {
#define END_NAMESPACE_OSGEO_COMMON_XSL END_NAMESPACE_OSGEO_COMMON }

#define BEGIN_NAMESPACE_OSGEO_COMMON_GML212 BEGIN_NAMESPACE_OSGEO_COMMON namespace Gml212 {
#define END_NAMESPACE_OSGEO_COMMON_GML212 END_NAMESPACE_OSGEO_COMMON }

// Fdo

#define BEGIN_NAMESPACE_OSGEO_FDO_XML BEGIN_NAMESPACE_OSGEO_FDO namespace Xml {
#define END_NAMESPACE_OSGEO_FDO_XML END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_CONNECTIONS BEGIN_NAMESPACE_OSGEO_FDO namespace Connections {
#define END_NAMESPACE_OSGEO_FDO_CONNECTIONS END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS BEGIN_NAMESPACE_OSGEO_FDO namespace Commands {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_SCHEMA BEGIN_NAMESPACE_OSGEO_FDO namespace Schema {
#define END_NAMESPACE_OSGEO_FDO_SCHEMA END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_SCHEMA BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace Schema {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_SCHEMA END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_LONGTRANSACTION BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace LongTransaction {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_LONGTRANSACTION END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_FEATURE BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace Feature {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_FEATURE END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_LOCKING BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace Locking {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_LOCKING END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_SQL BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace SQL {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_SQL END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_UNITOFMEASURE BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace UnitOfMeasure {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_UNITOFMEASURE END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_SPATIALCONTEXT BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace SpatialContext {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_SPATIALCONTEXT END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_NETWORK BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace Network {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_NETWORK END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_TOPOLOGY BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace Topology {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_TOPOLOGY END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS_DATASTORE BEGIN_NAMESPACE_OSGEO_FDO_COMMANDS namespace DataStore {
#define END_NAMESPACE_OSGEO_FDO_COMMANDS_DATASTORE END_NAMESPACE_OSGEO_FDO_COMMANDS }

#define BEGIN_NAMESPACE_OSGEO_FDO_EXPRESSION BEGIN_NAMESPACE_OSGEO_FDO namespace Expression {
#define END_NAMESPACE_OSGEO_FDO_EXPRESSION END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_CONNECTIONS BEGIN_NAMESPACE_OSGEO_FDO namespace Connections {
#define END_NAMESPACE_OSGEO_FDO_CONNECTIONS END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES BEGIN_NAMESPACE_OSGEO_FDO_CONNECTIONS namespace Capabilities{
#define END_NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES END_NAMESPACE_OSGEO_FDO_CONNECTIONS }

#define BEGIN_NAMESPACE_OSGEO_FDO_FILTER BEGIN_NAMESPACE_OSGEO_FDO namespace Filter {
#define END_NAMESPACE_OSGEO_FDO_FILTER END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_RASTER BEGIN_NAMESPACE_OSGEO_FDO namespace Raster {
#define END_NAMESPACE_OSGEO_FDO_RASTER END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_CLIENTSERVICES BEGIN_NAMESPACE_OSGEO_FDO namespace ClientServices{
#define END_NAMESPACE_OSGEO_FDO_CLIENTSERVICES END_NAMESPACE_OSGEO_FDO }

#define BEGIN_NAMESPACE_OSGEO_FDO_PROVIDERS BEGIN_NAMESPACE_OSGEO_FDO namespace Providers{
#define END_NAMESPACE_OSGEO_FDO_PROVIDERS END_NAMESPACE_OSGEO_FDO }

// Geomtry
#define BEGIN_NAMESPACE_OSGEO_GEOMETRY BEGIN_NAMESPACE_OSGEO_FDO namespace Geometry {
#define END_NAMESPACE_OSGEO_GEOMETRY END_NAMESPACE_OSGEO_FDO }

// Spatial
#define BEGIN_NAMESPACE_OSGEO_SPATIAL BEGIN_NAMESPACE_OSGEO_FDO namespace Spatial {
#define END_NAMESPACE_OSGEO_SPATIAL END_NAMESPACE_OSGEO_FDO }

//-------------------------------------------------------------------
// Namespace abbrevative
//-------------------------------------------------------------------
// OSGeo
#define NAMESPACE_OSGEO OSGeo
#define NAMESPACE_OSGEO_FDO NAMESPACE_OSGEO::FDO

#define NAMESPACE_OSGEO_RUNTIME NAMESPACE_OSGEO_FDO::Runtime

// Common
#define NAMESPACE_OSGEO_COMMON NAMESPACE_OSGEO_FDO::Common
#define NAMESPACE_OSGEO_COMMON_IO NAMESPACE_OSGEO_COMMON::Io
#define NAMESPACE_OSGEO_COMMON_XML NAMESPACE_OSGEO_COMMON::Xml
#define NAMESPACE_OSGEO_COMMON_XSL NAMESPACE_OSGEO_COMMON::Xsl
#define NAMESPACE_OSGEO_COMMON_GML212 NAMESPACE_OSGEO_COMMON::Gml212
// Fdo
#define NAMESPACE_OSGEO_FDO_XML NAMESPACE_OSGEO_FDO::Xml
#define NAMESPACE_OSGEO_FDO_SCHEMA NAMESPACE_OSGEO_FDO::Schema
#define NAMESPACE_OSGEO_FDO_COMMANDS NAMESPACE_OSGEO_FDO::Commands
#define NAMESPACE_OSGEO_FDO_COMMANDS_SCHEMA NAMESPACE_OSGEO_FDO_COMMANDS::Schema
#define NAMESPACE_OSGEO_FDO_COMMANDS_LONGTRANSACTION NAMESPACE_OSGEO_FDO_COMMANDS::LongTransaction
#define NAMESPACE_OSGEO_FDO_COMMANDS_FEATURE NAMESPACE_OSGEO_FDO_COMMANDS::Feature
#define NAMESPACE_OSGEO_FDO_COMMANDS_LOCKING NAMESPACE_OSGEO_FDO_COMMANDS::Locking
#define NAMESPACE_OSGEO_FDO_COMMANDS_UNITOFMEASURE NAMESPACE_OSGEO_FDO_COMMANDS::UnitOfMeasure
#define NAMESPACE_OSGEO_FDO_COMMANDS_SPATIALCONTEXT NAMESPACE_OSGEO_FDO_COMMANDS::SpatialContext
#define NAMESPACE_OSGEO_FDO_COMMANDS_TOPOLOGY NAMESPACE_OSGEO_FDO_COMMANDS::Topology
#define NAMESPACE_OSGEO_FDO_COMMANDS_NETWORK NAMESPACE_OSGEO_FDO_COMMANDS::Network
#define NAMESPACE_OSGEO_FDO_COMMANDS_SQL NAMESPACE_OSGEO_FDO_COMMANDS::SQL
#define NAMESPACE_OSGEO_FDO_COMMANDS_DATASTORE NAMESPACE_OSGEO_FDO_COMMANDS::DataStore
#define NAMESPACE_OSGEO_FDO_EXPRESSION NAMESPACE_OSGEO_FDO::Expression
#define NAMESPACE_OSGEO_FDO_CONNECTIONS NAMESPACE_OSGEO_FDO::Connections
#define NAMESPACE_OSGEO_FDO_CONNECTIONS_CAPABILITIES NAMESPACE_OSGEO_FDO_CONNECTIONS::Capabilities
#define NAMESPACE_OSGEO_FDO_FILTER NAMESPACE_OSGEO_FDO::Filter
#define NAMESPACE_OSGEO_FDO_RASTER NAMESPACE_OSGEO_FDO::Raster
#define NAMESPACE_OSGEO_FDO_CLIENTSERVICES NAMESPACE_OSGEO_FDO::ClientServices
#define NAMESPACE_OSGEO_FDO_PROVIDERS NAMESPACE_OSGEO_FDO::Providers

// Geometry
#define NAMESPACE_OSGEO_GEOMETRY NAMESPACE_OSGEO_FDO::Geometry

// Spatial
#define NAMESPACE_OSGEO_SPATIAL NAMESPACE_OSGEO_FDO::Spatial

/// \cond DOXYGEN-IGNORE

//----------------------------------------------------------------
// Exception handler definition
//----------------------------------------------------------------
#define EXCEPTION_HANDLER(clause) \
	try \
{ \
	clause; \
} \
	catch(FdoException* e) \
{ \
    NAMESPACE_OSGEO_COMMON::Exception^ mgE = NAMESPACE_OSGEO_COMMON::Exception::Create(System::IntPtr(e)); \
	e->Release(); \
	throw mgE; \
}

//---------------------------------------------------------------
// Check NULL FdoString* when Convert to System::String*
//---------------------------------------------------------------
#define CHECK_STRING(result) ((nullptr == result) ? nullptr : gcnew System::String(result))

/// \endcond
