//
//  Copyright (C) 2004-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#ifndef SERVICE_H
#define SERVICE_H

/// \defgroup MgService MgService
/// \ingroup Common_Module
/// \{

class MgConnectionProperties;
class MgUserInformation;

/////////////////////////////////////////////////////////////////
/// \brief
/// class Service
/// Base class for all services APIs
class MG_PLATFORMBASE_API MgService : public MgGuardDisposable
{
PUBLISHED_API:
    /// \brief
    /// HasWarnings() method reports if there are warnings.
    ///
    /// <!-- Syntax in .Net, Java, and PHP -->
    /// \htmlinclude DotNetSyntaxTop.html
    /// bool HasWarnings();
    /// \htmlinclude SyntaxBottom.html
    /// \htmlinclude JavaSyntaxTop.html
    /// boolean HasWarnings();
    /// \htmlinclude SyntaxBottom.html
    /// \htmlinclude PHPSyntaxTop.html
    /// bool HasWarnings();
    /// \htmlinclude SyntaxBottom.html
    ///
    /// \return
    /// Returns true or false
    ///
    ///
    bool HasWarnings();

    /// \brief
    /// Returns non-critical messages from the given service.
    ///
    /// <!-- Syntax in .Net, Java, and PHP -->
    /// \htmlinclude DotNetSyntaxTop.html
    /// MgWarnings GetWarningsObject();
    /// \htmlinclude SyntaxBottom.html
    /// \htmlinclude JavaSyntaxTop.html
    /// MgWarnings GetWarningsObject();
    /// \htmlinclude SyntaxBottom.html
    /// \htmlinclude PHPSyntaxTop.html
    /// MgWarnings GetWarningsObject();
    /// \htmlinclude SyntaxBottom.html
    ///
    /// \return
    /// An MgWarnings object containing messages generated by the service.
    ///
    ///
    MgWarnings* GetWarningsObject();

INTERNAL_API:

    /// Internal placeholder used to support user to service binding
    virtual MgUserInformation* GetUserInfo();

    /// Internal placeholder used to support connectivity of a Service with
    /// another entity
    virtual void SetConnectionProperties(MgConnectionProperties* connProp);

protected:
    /////////////////////////////////////////////////////////////////
    /// \brief
    /// Get the class Id
    ///
    /// \return
    /// The integer value
    ///
    INT32 GetClassId();

    //////////////////////////////////////////////////////////////////
    /// \brief
    /// Default Constructor
    ///
    MgService();

    //////////////////////////////////////////////////////////////////
    /// \brief
    /// Destructor. This will clean up the service.
    ///
    /// \return
    /// Nothing
    ///
    virtual ~MgService();


    Ptr<MgWarnings> m_warning;

CLASS_ID:
    static const INT32 m_cls_id = PlatformBase_Service_Service;
};
/// \}

#endif
