/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "stdafx.h"
#include <Sm/Ph/PropertyReader.h>
#include <Sm/Ph/PropertyWriter.h>
#include <Sm/Ph/SpatialContextReader.h>
#include <Sm/Ph/SpatialContextGeomReader.h>
#include <Sm/Ph/Rd/SpatialContextGeomReader.h>
#include <Sm/Ph/Mt/PropertyReader.h>

FdoSmPhPropertyReader::FdoSmPhPropertyReader(FdoStringP schemaName, FdoSmPhMgrP mgr, FdoStringCollection* classNames) : 
    FdoSmPhReader( MakeReader(mgr, schemaName, classNames) ),
    mScId(-1)
{
}

FdoSmPhPropertyReader::FdoSmPhPropertyReader(FdoSmPhReaderP subReader, FdoSmPhMgrP mgr) :
    FdoSmPhReader( subReader ),
    mbAutogeneratedDefined(true),
    mbColumnCreatorDefined(true),
    mbRevisionNumberDefined(true),
    mbRootObjectNameDefined(true),
    mScId(-1)
{
}

FdoSmPhPropertyReader::~FdoSmPhPropertyReader(void)
{
}

FdoStringP FdoSmPhPropertyReader::GetName()
{
	return(GetString(L"", L"attributename"));
}

FdoStringP FdoSmPhPropertyReader::GetColumnName()
{
	return(GetString(L"", L"columnname"));
}

FdoStringP FdoSmPhPropertyReader::GetSequenceName()
{
      return(GetString(L"", L"sequencename"));
}

FdoStringP FdoSmPhPropertyReader::GetColumnType()
{
	return(GetString(L"", L"columntype"));
}

bool FdoSmPhPropertyReader::GetIsFixedColumn()
{
	return(GetBoolean(L"", L"isfixedcolumn"));
}

bool FdoSmPhPropertyReader::GetIsColumnCreator()
{
    bool isColumnCreator = false;

    if ( mbColumnCreatorDefined ) {
    	isColumnCreator = GetBoolean(L"", L"iscolumncreator");
    }
    else {
        FdoSmPhDbObjectP dbObject = GetManager()->FindDbObject( GetTableName() );
        if ( dbObject) {
            if ( dbObject->RefColumns()->RefItem(GetColumnName()) )
                isColumnCreator = true;
        }
    }

    return isColumnCreator;
}

FdoStringP FdoSmPhPropertyReader::GetDescription()
{
	return(GetString(L"", L"description"));
}

FdoStringP FdoSmPhPropertyReader::GetFeatureClassName()
{
	return(GetString(L"", L"classname"));
}


FdoStringP FdoSmPhPropertyReader::GetDataType()
{
	return(GetString(L"", L"attributetype"));
}

FdoStringP FdoSmPhPropertyReader::GetGeometryType()
{
    FdoStringP geometryTypeString = GetString(L"", L"geometrytype");

    if ( geometryTypeString == L"" ) 
    {
		if (GetDataType().IsNumber())
		{
			FdoInt32 geometrictype = atoi(GetDataType());
			FdoInt32 geometrytype = FdoCommonGeometryUtil::GetGeometryTypes(geometrictype);
			geometryTypeString = FdoStringP::Format(L"%d", geometrytype);
		}
		else
		{
			geometryTypeString = FdoStringP::Format(L"%d", FdoCommonGeometryUtil::GetNoneGeometryTypesCode());
		}
	}

    return geometryTypeString;
}

int FdoSmPhPropertyReader::GetIdPosition()
{
	return(GetInteger(L"", L"idposition"));
}

bool FdoSmPhPropertyReader::GetIsNullable()
{
	return(GetBoolean(L"", L"isnullable"));
}

bool FdoSmPhPropertyReader::GetIsReadOnly()
{
	return(GetBoolean(L"", L"isreadonly"));
}

bool FdoSmPhPropertyReader::GetIsFeatId()
{
	return(GetBoolean(L"", L"isfeatid"));
}

bool FdoSmPhPropertyReader::GetIsSystem()
{
	return(GetBoolean(L"", L"issystem"));
}

int FdoSmPhPropertyReader::GetLength()
{
	return(GetInteger(L"", L"columnsize"));
}

int FdoSmPhPropertyReader::GetScale()
{
	return(GetInteger(L"", L"columnscale"));
}

FdoPtr<FdoDataValue> FdoSmPhPropertyReader::GetDefaultValue()
{
    // An Autogenerated property cannot have a default value. This gets around
    // a bug in MySQL. If you create a table with an autogenerated primary key column
    // and a view on the table and then describe the view, the primary key column
    // will have a default value of 0.
    if ( !GetIsAutoGenerated() ) {
	    FdoSmPhDbObjectP dbObject = GetManager()->FindDbObject( GetTableName() );
        if ( dbObject) {
            const FdoSmPhColumn* column = dbObject->RefColumns()->RefItem(GetColumnName());
		    if (column)
			    return column->GetDefaultValue();
		    else
			    return((FdoDataValue*) NULL);
	    }
    }
	return((FdoDataValue*) NULL);
}

FdoStringP FdoSmPhPropertyReader::GetTableName()
{
	return(GetManager()->GetRealDbObjectName(GetString(L"", L"tablename")));
}

FdoStringP FdoSmPhPropertyReader::GetRootObjectName()
{
    if ( mbRootObjectNameDefined ) 
        return(GetString(L"", L"rootobjectname"));
    else
        return(GetString(L"", L"roottablename"));
}

bool FdoSmPhPropertyReader::GetHasElevation()
{
	return(GetBoolean(L"", L"haselevation"));
}

bool FdoSmPhPropertyReader::GetHasMeasure()
{
	return(GetBoolean(L"", L"hasmeasure"));
}

bool FdoSmPhPropertyReader::GetIsAutoGenerated()
{
    if ( mbAutogeneratedDefined ) 
    	return(GetBoolean(L"", L"isautogenerated"));
    else
        return(GetIsFeatId());
}

bool FdoSmPhPropertyReader::GetIsRevisionNumber()
{
    if (mbRevisionNumberDefined)
        return(GetBoolean(L"", L"isrevisionnumber"));
    else   {
	    if ( GetName() == L"RevisionNumber" )
	        return true;
	    else
            return false;
    }
}
/*
const FdoSmPhTable* FdoSmPhPropertyReader::GetTable()
{
	// Returns a cached table definition.
	return( GetPhysicalSchema()->GetTable( GetString(L"", L"tablename") ) );
}
*/
/* TODO
FdoSmPhDependencyReaderP FdoSmPhPropertyReader::GetDependencyReader()
{
	return( new FdoSmPhDependencyReader( (long)GetDouble(L"", L"classid"), GetTableName(), GetPhysicalSchema() ) );
}
*/

FdoSmPhRowsP FdoSmPhPropertyReader::MakeRows( FdoSmPhMgrP mgr )
{
    FdoSmPhRowsP rows = new FdoSmPhRowCollection();

    // ***** IMPORTANT NOTE: if you alter the order of the fields in the rows 
    // created here, you must also synchronize the field list for the fake
    // classid row in FdoSmPhMtPropertyReader::MakeReader().

    // Create row for F_ATTRIBUTEDEFINITION
    FdoSmPhRowP row = FdoSmPhPropertyWriter::MakeRow(mgr);
    rows->Add( row );

    // Create row for F_CLASSDEFINITION
    FdoSmPhOwnerP owner = mgr->GetOwner();

    FdoSmPhRowP classRow;
    if (owner->GetHasClassMetaSchema())
    {
        FdoStringP classDefTable = mgr->GetDcDbObjectName(L"f_classdefinition");
        classRow = new FdoSmPhRow (mgr, L"f_classdefinition", mgr->FindDbObject(classDefTable));
    }
    else
        classRow = new FdoSmPhRow (mgr, L"f_classdefinition", FdoSmPhDbObjectP());

    FdoSmPhFieldP field = new FdoSmPhField( classRow, L"classname" );

    rows->Add( classRow );

    return rows;
}

FdoSmPhReaderP FdoSmPhPropertyReader::MakeReader( FdoSmPhMgrP mgr, FdoStringP schemaName, FdoStringCollection* classNames)
{
    mbAutogeneratedDefined = false;
    mbColumnCreatorDefined = false;
    mbRevisionNumberDefined = false;
    mbRootObjectNameDefined = false;

    FdoSmPhReaderP subReader;

    // Create the rows and fields
    FdoSmPhRowsP rows = FdoSmPhPropertyReader::MakeRows( mgr );

    FdoSmPhRowP propRow = rows->GetItem(0);
    FdoSmPhRowP classRow = rows->GetItem(0);

    FdoSmPhFieldsP	pFields = propRow->GetFields();

    // Check if certain fields are not defined. These won't be
    // in a MetaSchema.
    FdoSmPhFieldP field = pFields->FindItem( L"isautogenerated" );
    if ( field && field->GetColumn() )
        mbAutogeneratedDefined = true;

    field = pFields->FindItem( L"iscolumncreator" );
    if ( field && field->GetColumn() )
        mbColumnCreatorDefined = true;

    field = pFields->FindItem( L"isrevisionnumber" );
    if ( field && field->GetColumn() )
        mbRevisionNumberDefined = true;

    field = pFields->FindItem( L"rootobjectname" );
    if ( field && field->GetColumn() )
        mbRootObjectNameDefined = true;

    if ( FdoSmPhDbObjectP(propRow->GetDbObject())->GetExists() && FdoSmPhDbObjectP(classRow->GetDbObject())->GetExists() ) {
        // F_ATTRIBUTEDEFINITION exists, read from MetaSchema.
        subReader = MakeMtReader( rows, schemaName, mgr, classNames );
    }
    else {
//        pSubReader = MakeRdReader( rows, schemaName, mgr );
    }

    return subReader;
}

FdoSmPhReaderP FdoSmPhPropertyReader::MakeMtReader( FdoSmPhRowsP rows, FdoStringP schemaName, FdoSmPhMgrP mgr, FdoStringCollection* classNames)
{
    return new FdoSmPhMtPropertyReader( rows, schemaName, mgr, classNames);
}
/*
FdoSmPhReaderP FdoSmPhPropertyReader::MakeRdReader( FdoSmPhRowsP rows, FdoStringP schemaName, FdoSmPhMgrP mgr )
{
    return new FdoSmPhRdPropertyReader( rows, schemaName, mgr );
}
*/
