/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef FDOWFSSCHEMACOPYHANDLER_H
#define FDOWFSSCHEMACOPYHANDLER_H
#ifdef _WIN32
#pragma once
#endif // _WIN32

class FdoWfsSchemaCopyHandler : public FdoXmlCopyHandler
{
private:
    std::vector<int> m_ignore;
public:
	static FdoWfsSchemaCopyHandler* Create( FdoXmlWriter* writer);

protected:
	FdoWfsSchemaCopyHandler() {}
	FdoWfsSchemaCopyHandler( FdoXmlWriter* writer);
	virtual ~FdoWfsSchemaCopyHandler() {}

 	virtual FdoXmlSaxHandler* XmlStartElement( 
		FdoXmlSaxContext* saxContext,
		FdoString* uri, 
		FdoString* localName, 
		FdoString* qName, 
		FdoXmlAttributeCollection* atts 
	);
    virtual FdoBoolean XmlEndElement(FdoXmlSaxContext* context, FdoString* uri, FdoString* name, FdoString* qname);
    virtual void XmlCharacters(FdoXmlSaxContext*, FdoString*);

};




#endif


