/*
* Copyright (C) 2010  SL-King d.o.o
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "c_KgKmlSchemaDesc.h"

#include "boost/scoped_ptr.hpp"
#include "kml/convenience/convenience.h"
#include "kml/dom.h"
#include "kml/engine.h"
#include "kml/base/file.h"

#include "minizip/unzip.h"
#include "minizip/zip.h"
#include "minizip/ioapi.h"
#include "c_FdoKml_API.h"

//#include "c_OCCI_API.h"
//#include "c_Ora_API.h"

c_FdoKml_API::c_FdoKml_API(void)
{
}

c_FdoKml_API::~c_FdoKml_API(void)
{
}

typedef std::vector<kmldom::PlacemarkPtr> placemark_vector_t;


FdoFeatureClass* c_FdoKml_API::CreateFdoFeatureClass(FdoString* Name,const kmldom::PlacemarkPtr& Placemark,FdoString* SpatialContextName,c_KgKmlFdoClassConfig* KmlFdoClassConfig)
{
  FdoFeatureClass* fclass = FdoFeatureClass::Create(Name,L"");
  
  FdoInt32 fdo_geom_type = FdoGeometricType_Point|FdoGeometricType_Curve|FdoGeometricType_Surface;
  if( Placemark.get() && Placemark->has_geometry() )
  {
    kmldom::GeometryPtr geometry = Placemark->get_geometry();
  }
  
  FdoPtr<FdoPropertyDefinitionCollection> propcol = fclass->GetProperties();
  
  FdoPtr<FdoGeometricPropertyDefinition> gpd = FdoGeometricPropertyDefinition::Create(L"KML_FDO_GEOMETRY", L"");                        

  gpd->SetGeometryTypes(fdo_geom_type);  
  
  FdoInt32 geomTypesLength=0;
  FdoGeometryType geomTypes[20];
  
  geomTypes[geomTypesLength++] = FdoGeometryType_Point;
  geomTypes[geomTypesLength++] = FdoGeometryType_LineString;
  geomTypes[geomTypesLength++] = FdoGeometryType_Polygon;
  geomTypes[geomTypesLength++] = FdoGeometryType_MultiPoint;
  geomTypes[geomTypesLength++] = FdoGeometryType_MultiPolygon;
  geomTypes[geomTypesLength++] = FdoGeometryType_MultiGeometry;
  
  //geomTypes[geomTypesLength++] = FdoGeometryType_Point;
  //geomTypes[geomTypesLength++] = FdoGeometryType_Point;
  //geomTypes[geomTypesLength++] = FdoGeometryType_Point;
  
  gpd->SetSpecificGeometryTypes(geomTypes, geomTypesLength);
  
  
  if( SpatialContextName ) gpd->SetSpatialContextAssociation( SpatialContextName );

  propcol->Add(gpd);
  fclass->SetGeometryProperty(gpd);
  
// Add name  
 {
  FdoPtr<FdoDataPropertyDefinition> kml_fdo_name = FdoDataPropertyDefinition::Create(L"KML_FDO_NAME", L"");
  kml_fdo_name->SetReadOnly(false);
  kml_fdo_name->SetDataType(FdoDataType_String);
  kml_fdo_name->SetNullable(true);
  //kml_fdo_name->SetLength(2048);  
  propcol->Add(kml_fdo_name);
  KmlFdoClassConfig->SetPlacemarkNameExp(L"KML_FDO_NAME");
  }
  
// Add property description
  {
  FdoPtr<FdoDataPropertyDefinition> kml_fdo_desc = FdoDataPropertyDefinition::Create(L"KML_FDO_DESCRIPTION", L"");
  kml_fdo_desc->SetReadOnly(false);
  kml_fdo_desc->SetDataType(FdoDataType_String);
  kml_fdo_desc->SetNullable(true);
  //kml_fdo_desc->SetLength(2048);
  propcol->Add(kml_fdo_desc);
  KmlFdoClassConfig->SetPlacemarkDescExp(L"KML_FDO_DESCRIPTION");
  }
  
// Add FDO identifier  
  { 
  FdoPtr<FdoDataPropertyDefinition> kml_fdo_id = FdoDataPropertyDefinition::Create(L"KML_FDO_ID", L"");
  kml_fdo_id->SetDataType(FdoDataType_Int32);
  kml_fdo_id->SetNullable(false);
  //kml_fdo_id->SetIsAutoGenerated(true);
  kml_fdo_id->SetReadOnly(false);
  propcol->Add(kml_fdo_id);
   KmlFdoClassConfig->SetFdoProp_KmlFdoId(L"KML_FDO_ID");
  
  FdoPtr<FdoDataPropertyDefinitionCollection> identcol = fclass->GetIdentityProperties();
  identcol->Add( kml_fdo_id );
  }
  
  // Now from Placemark extended data create other properties
  if( Placemark.get() && Placemark->has_extendeddata() )
  {  
    kmldom::ExtendedDataPtr extdata = Placemark->get_extendeddata();
    for(int i=0;i<extdata->get_data_array_size();i++)
    {
      const kmldom::DataPtr data = extdata->get_data_array_at(i);
       
      if( data && data->has_name() )
      {
        std::string dname = data->get_name();
        FdoStringP s1 = dname.c_str();
        FdoPtr<FdoDataPropertyDefinition> kml_data = FdoDataPropertyDefinition::Create(s1,L"");
        kml_data->SetDataType(FdoDataType_String);
        kml_data->SetLength(2048);
        propcol->Add(kml_data);
        
      }
    }    
    
  }
    
  
  
  return fclass;

}//end of c_FdoKml_API::CreateFdoFeatureClass

int c_FdoKml_API::ReadKML(const string& FileName)
{
  // Read the file.
  std::string file_data;
  if (!kmlbase::File::ReadFileToString(FileName, &file_data)) 
  {
    throw FdoConnectionException::Create(L"Failed opening KMZ file!");
    
  }

  // If the file was KMZ, extract the KML file.
  std::string kml;
  if (kmlengine::KmzFile::IsKmz(file_data)) {
    boost::scoped_ptr<kmlengine::KmzFile> kmz_file(kmlengine::KmzFile::OpenFromString(FileName));
    if (!kmz_file.get()) 
    {
      //cout << "Failed opening KMZ file" << endl;
      //return NULL;
      throw FdoConnectionException::Create(L"Failed opening KMZ file!");
    }
    if (!kmz_file->ReadKml(&kml)) 
    {
      throw FdoConnectionException::Create(L"Failed to read KML from KMZ!");
      
    }
  } else {
    kml = file_data;
  }

  // Parse it.
  std::string errors;
  kmldom::ElementPtr root = kmldom::Parse(kml, &errors);
  
  
  return 0;
  
}//end of c_FdoKml_API::ReadKML



