package dbxmltest;
import com.sleepycat.db.DatabaseException;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.FileNotFoundException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.sleepycat.dbxml.*;

public class AutoOpenTest{
    // Container name;
    private static final String CON_NAME = "testData.dbxml";
    private static String docString = "<?xml version=\"1.0\" ?>"
	+ "<a_node atr1=\"test\" atr2=\"test2\"><b_node/>"
	+ "<c_node>Other text</c_node></a_node>";
    String myQuery = "collection('testData.dbxml')/a_node/*";

    private TestConfig hp = null;
    private XmlManager mgr = null;
    private XmlContainer cont = null;

    @BeforeClass
	public static void setupClass() {
	System.out.println("Begin test Auto Open!");
	TestConfig.fileRemove(XmlTestRunner.getEnvironmentPath());
    }

    @Before
	public void setUp() throws Throwable {
	if(hp != null)
	    TestConfig.fileRemove(XmlTestRunner.getEnvironmentPath());
	hp = new TestConfig(XmlTestRunner.getEnvironmentType(),
			    XmlTestRunner.isNodeContainer(), XmlTestRunner.getEnvironmentPath());
	XmlManagerConfig conf = new XmlManagerConfig();
	conf.setAllowAutoOpen(true);
	mgr = hp.createManager(hp.getEnvironmentPath(), conf);
	cont = hp.createContainer(CON_NAME, mgr);
    }

    @After
	public void tearDown() throws Throwable {
	hp.closeContainer(cont);
	hp.closeManager(mgr);
	hp.closeEnvironment();
	TestConfig.fileRemove(XmlTestRunner.getEnvironmentPath());
    }

    @AfterClass
	public static void tearDownClass() {
	System.out.println("Finished test Auto Open!");
    }

    @Test
	public void AutoOpenLazy()throws XmlException, FileNotFoundException, DatabaseException {
	XmlUpdateContext uc = mgr.createUpdateContext();
	XmlTransaction txn = null;
	XmlQueryContext context = mgr.createQueryContext();
	context.setEvaluationType(XmlQueryContext.Lazy);
	XmlResults results = null;
	XmlResults results2 = mgr.createResults();
	XmlValue value = null;
	XmlValue value2 = null;
	try{
	    if(hp.isTransactional()){
		txn = mgr.createTransaction();
		cont.putDocument(txn, "test", docString, uc);
		txn.commit();
		txn = mgr.createTransaction();
	    }else
		cont.putDocument("test", docString, uc);
	    cont.delete();
	    if(hp.isTransactional())
		results = mgr.query(txn, myQuery, context);
	    else
		results = mgr.query(myQuery, context);
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "c_node");
	    value = results.next();
	    assertTrue(value == null);
	    results.reset();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    results2.add(value);
	    value2 = results2.next();
	    assertTrue(value2.isNode());
	    assertEquals(value2.getLocalName(), "b_node");
	}catch(XmlException e){
	    throw e;
	}
	try{
	    results.delete();
	    value.getLocalName();
	    results2.delete();
	    fail("Accessed local name after result set was deleted.");
	} catch (XmlException e) {
	    assertNotNull(e.getMessage());
	    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	}
	try{
		assertEquals(value2.getLocalName(), "b_node");
	} catch (XmlException e) {
	    throw e;
	}finally{
	    results2.delete();
	    if(hp.isTransactional() && txn != null) txn.commit();
	}
	try {
		value2.getLocalName();
		fail("Accessed local name after result set was deleted.");
	} catch (XmlException e) {
		assertNotNull(e.getMessage());
	    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	}
    }

    @Test
	public void AutoOpenEager()throws XmlException, FileNotFoundException {
	XmlTransaction txn = null;
	XmlUpdateContext uc = mgr.createUpdateContext();
	XmlQueryContext context = mgr.createQueryContext();
	context.setEvaluationType(XmlQueryContext.Eager);
	XmlResults results = null;
	XmlResults results2 = mgr.createResults();
	XmlValue value = null;
	XmlValue value2 = null;
	try{
	    if(hp.isTransactional()){
		txn = mgr.createTransaction();
		cont.putDocument(txn, "test", docString, uc);
		txn.commit();
		txn = mgr.createTransaction();
	    }else
		cont.putDocument("test", docString, uc);
	    cont.delete();
	    if(hp.isTransactional())
		results = mgr.query(txn, myQuery, context);
	    else
		results = mgr.query(myQuery, context); 
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "c_node");
	    value = results.next();
	    assertTrue(value == null);
	    results.reset();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    results2.add(value);
	    value2 = results2.next();
	    assertTrue(value2.isNode());
	    assertEquals(value2.getLocalName(), "b_node");
	}catch(XmlException e){
	    throw e;
	}
	try{
	    results.delete();
	    value.getLocalName();
	    results2.delete();
	    fail("Accessed local name after result set was deleted.");
	} catch (XmlException e) {
	    assertNotNull(e.getMessage());
	    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	}
	try{
		assertEquals(value2.getLocalName(), "b_node");
	} catch (XmlException e) {
	    throw e;
	}finally{
	    results2.delete();
	    if(hp.isTransactional() && txn != null) txn.commit();
	}
	try {
		value2.getLocalName();
		fail("Accessed local name after result set was deleted.");
	} catch (XmlException e) {
		assertNotNull(e.getMessage());
	    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	}
    }

    @Test
	public void TransientContainer()throws XmlException, FileNotFoundException {
	XmlDocument doc = mgr.createDocument();
	doc.setContent(docString);
	doc.setName("test.xml");
	XmlResults results = null;
	XmlValue value = null;
	XmlQueryContext context = mgr.createQueryContext();
	context.setEvaluationType(XmlQueryContext.Eager);
	XmlValue docValue = new XmlValue(doc);
	XmlResults results2;
	XmlValue value2;
	XmlTransaction txn = null;
	try{
	    XmlQueryExpression expr = null;
	    if(hp.isTransactional()){
		txn = mgr.createTransaction();
		expr = mgr.prepare(txn, "/a_node/*", context);
		results = expr.execute(txn, docValue, context);
	    }else{
		expr = mgr.prepare("/a_node/*", context);
		results = expr.execute(docValue, context);
	    }
	    expr.delete();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "c_node");
	    try{
		XmlQueryExpression expr2 = null;
		if(hp.isTransactional()){
		    expr2 = mgr.prepare(txn, "../c_node", context);
		    results2 = expr2.execute(txn, value, context);
		}else{
		    expr2 = mgr.prepare("../c_node", context);
		    results2 = expr2.execute(value, context);
		}
		value2 = results2.next();
		assertTrue(value2.isNode());
		assertEquals(value2.getLocalName(), "c_node");
		assertEquals(value2.asString(), "<c_node>Other text</c_node>");
		results2.delete();
		expr2.delete();
	    }catch(XmlException e){
		throw e;
	    }
	    results2 = mgr.createResults();
	    value = results.next();
	    assertTrue(value == null);
	    results.reset();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    results2.add(value);
	    value2 = results2.next();
	    assertTrue(value2.isNode());
	    assertEquals(value2.getLocalName(), "b_node");
	    try{
		results.delete();
		value.getLocalName();
		results2.delete();
		fail("Accessed local name after result set was deleted.");
	    } catch (XmlException e) {
		assertNotNull(e.getMessage());
		assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	    }
	    try {
			assertEquals(value2.getLocalName(), "b_node");
		} catch (XmlException e) {
		    throw e;
		} finally {
			results2.delete();
		}
		try {
			value2.getLocalName();
			fail("Accessed local name after result set was deleted.");
		} catch (XmlException e) {
			assertNotNull(e.getMessage());
		    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
		}
	}catch(XmlException e){
	    throw e;
	}
	context.setEvaluationType(XmlQueryContext.Lazy);
	try{
	    XmlQueryExpression expr = null;
	    if(hp.isTransactional()){
		expr = mgr.prepare(txn, "/a_node/*", context);
		results = expr.execute(txn, docValue, context);
	    }else{
		expr = mgr.prepare("/a_node/*", context);
		results = expr.execute(docValue, context);
	    }
	    expr.delete();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "c_node");
	    try{
		XmlQueryExpression expr2 = null;
		if(hp.isTransactional()){
		    expr2 = mgr.prepare(txn, "../c_node", context);
		    results2 = expr2.execute(txn, value, context);
		}else{
		    expr2 = mgr.prepare("../c_node", context);
		    results2 = expr2.execute(value, context);
		}
		value2 = results2.next();
		assertTrue(value2.isNode());
		assertEquals(value2.asString(), "<c_node>Other text</c_node>");
		results2.delete();
		expr2.delete();
	    }catch(XmlException e){
		throw e;
	    }
	    results2 = mgr.createResults();
	    value = results.next();
	    assertTrue(value == null);
	    results.reset();
	    value = results.next();
	    assertTrue(value.isNode());
	    assertEquals(value.getLocalName(), "b_node");
	    results2.add(value);
	    value2 = results2.next();
	    assertTrue(value2.isNode());
	    assertEquals(value2.getLocalName(), "b_node");
	    results2.delete();
	    try{
		results.delete();
		value.getLocalName();
		fail("Accessed local name after result set was deleted.");
	    } catch (XmlException e) {
		assertNotNull(e.getMessage());
		assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	    }
	}catch(XmlException e){
	    throw e;
	}finally{
	    if(hp.isTransactional() && txn != null)
		txn.commit();
	}
    }

    @Test
	public void ConstructedDocument()throws XmlException, FileNotFoundException{
	String QUERY2 = 
	    "<roster>{\n"  
	    + "    for $player in (collection(\"" + CON_NAME + "\")/Year/player)\n"
	    + "    return <player><numStints>{$player/@stint/string()}</numStints></player>\n"
	    + "}</roster>\n";
	String docContent = "<Year>" 
	    + "<player stint=\"1\"/>"
	    + "<player stint=\"1\"/>"
	    + "<player stint=\"1\"/>"
	    + "<player stint=\"1\"/></Year>";

	XmlDocument doc = mgr.createDocument();
	doc.setContent(docContent);
	doc.setName("test.xml");
	XmlResults docResults = null;
	XmlResults rows = null;
	XmlResults dataResults = null;
	XmlTransaction txn = null;
	XmlQueryExpression dataQuery = null;
	XmlQueryExpression rowQuery = null;
	try{
	    XmlQueryContext context = mgr.createQueryContext();
	    if(hp.isTransactional()){
		txn = mgr.createTransaction();
		cont.putDocument(txn, doc);
		docResults = mgr.query(txn, QUERY2, context);
		rowQuery = mgr.prepare(txn, "player", context);
		XmlValue docVal = docResults.next();
		rows = rowQuery.execute(txn, docVal, context);
		dataQuery = mgr.prepare(txn, "numStints", context);
	    }else{
		cont.putDocument(doc);
		docResults = mgr.query(QUERY2, context);
		rowQuery = mgr.prepare("player", context);
		XmlValue docVal = docResults.next();
		rows = rowQuery.execute(docVal, context);
		dataQuery = mgr.prepare("numStints", context);
	    }
	    rowQuery.delete();
	    while (rows.hasNext()) {
		XmlValue row = rows.next();
		assertEquals("<player><numStints>1</numStints></player>", row.asString());
		if(hp.isTransactional())
		    dataResults = dataQuery.execute(txn, row, context);
		else
		    dataResults = dataQuery.execute(row, context);
		XmlValue dataNode = dataResults.next();
		assertEquals("<numStints>1</numStints>", dataNode.asString());
		XmlValue child = dataNode.getFirstChild();
		assertEquals("1", child.asString());
		dataResults.delete();
		dataResults = null;
	    }
	    dataQuery.delete();
	}catch(XmlException e){
	    throw e;
	}finally{
	    if(rowQuery != null) rowQuery.delete();
	    if(dataQuery != null) dataQuery.delete();
	    if(docResults != null) docResults.delete();
	    if(rows != null) rows.delete();
	    if(dataResults != null) dataResults.delete();
	    if(hp.isTransactional() && txn != null) txn.commit();
	}
    }
    
    /* [16432] Tests that when adding an XmlValue to multiple XmlResults sets
     * the value remains valid until the result set to was added then retrieved from
     * is deleted.
     */
    @Test
	public void MultiAddTest()throws XmlException, FileNotFoundException, DatabaseException {
	XmlUpdateContext uc = mgr.createUpdateContext();
	XmlTransaction txn = null;
	XmlQueryContext context = mgr.createQueryContext();
	context.setEvaluationType(XmlQueryContext.Lazy);
	XmlResults results = null;
	XmlResults results2 = mgr.createResults();
	XmlResults results3 = mgr.createResults();
	XmlValue value = null;
	XmlValue value2 = null;
	XmlValue value3 = null;
	try{
	    if(hp.isTransactional()){
		txn = mgr.createTransaction();
		cont.putDocument(txn, "test", docString, uc);
		txn.commit();
		txn = mgr.createTransaction();
	    }else
		cont.putDocument("test", docString, uc);
	    cont.delete();
	    if(hp.isTransactional())
		results = mgr.query(txn, myQuery, context);
	    else
		results = mgr.query(myQuery, context);
	    //Add and retrieve the node to different result sets
	    value = results.next();
	    results2.add(value);
	    value2 = results2.next();
	    results3.add(value2);
	    value3 = results3.next();
	    //test that the node works for each result set even after deleting an
	    //older result set
	    assertEquals("b_node", value.getLocalName());
	    results.delete();
	    assertEquals("b_node", value2.getLocalName());
	    results2.delete();
	    assertEquals("b_node", value3.getLocalName());
	    //Test that the node is invalid after deleting its most recent result set
	    try {
	    	results3.delete();
	    	value3.getLocalName();
	    	fail("Local name accessed after result set deleted.");
	    } catch (XmlException e) {
	    	assertNotNull(e.getMessage());
		    assertEquals(XmlException.INVALID_VALUE, e.getErrorCode());
	    }
	} catch (XmlException e) {
		throw e;
	} finally {
		if(hp.isTransactional()) txn.commit();
		if (results != null) results.delete();
		results2.delete();
		results3.delete();
	}
	}

}
