//
//  Copyright (C) 2004-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful;
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not; write to the Free Software
//  Foundation; Inc.; 51 Franklin St; Fifth Floor; Boston; MA  02110-1301  USA
//

#ifndef _MGCOORDINATESYSTEMUNITCODE_H_
#define _MGCOORDINATESYSTEMUNITCODE_H_

/// \defgroup MgCoordinateSystemUnitCode MgCoordinateSystemUnitCode
/// \ingroup Coordinate_System_classes
/// \{

///////////////////////////////////////////////////////////////
/// \brief
/// Defines the various coordinate system unit codes
///
class MG_GEOMETRY_API MgCoordinateSystemUnitCode
{
PUBLISHED_API:
    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Meter
    ///
    static const INT32 Meter = 1;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Foot
    ///
    static const INT32 Foot = 2;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Inch
    ///
    static const INT32 Inch = 3;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IFoot
    ///
    static const INT32 IFoot = 4;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// ClarkeFoot
    ///
    static const INT32 ClarkeFoot = 5;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IInch
    ///
    static const INT32 IInch = 6;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Centimeter
    ///
    static const INT32 Centimeter = 7;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Kilometer
    ///
    static const INT32 Kilometer = 8;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Yard
    ///
    static const INT32 Yard = 9;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// SearsYard
    ///
    static const INT32 SearsYard = 10;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Mile
    ///
    static const INT32 Mile = 11;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IYard
    ///
    static const INT32 IYard = 12;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IMile
    ///
    static const INT32 IMile = 13;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Knot
    ///
    static const INT32 Knot = 14;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// NautM
    ///
    static const INT32 NautM = 15;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Lat66
    ///
    static const INT32 Lat66 = 16;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Lat83
    ///
    static const INT32 Lat83 = 17;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Decimeter
    ///
    static const INT32 Decimeter = 18;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Millimeter
    ///
    static const INT32 Millimeter = 19;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Dekameter
    ///
    static const INT32 Dekameter = 20;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Hectometer
    ///
    static const INT32 Hectometer = 21;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// GermanMeter
    ///
    static const INT32 GermanMeter = 22;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// CaGrid
    ///
    static const INT32 CaGrid = 23;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// ClarkeChain
    ///
    static const INT32 ClarkeChain = 24;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// GunterChain
    ///
    static const INT32 GunterChain = 25;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// BenoitChain
    ///
    static const INT32 BenoitChain = 26;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// SearsChain
    ///
    static const INT32 SearsChain = 27;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// ClarkeLink
    ///
    static const INT32 ClarkeLink = 28;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// GunterLink
    ///
    static const INT32 GunterLink = 29;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// BenoitLink
    ///
    static const INT32 BenoitLink = 30;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// SearsLink
    ///
    static const INT32 SearsLink = 31;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Rod
    ///
    static const INT32 Rod = 32;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Perch
    ///
    static const INT32 Perch = 33;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Pole
    ///
    static const INT32 Pole = 34;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Furlong
    ///
    static const INT32 Furlong = 35;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Rood
    ///
    static const INT32 Rood = 36;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// CapeFoot
    ///
    static const INT32 CapeFoot = 37;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Brealey
    ///
    static const INT32 Brealey = 38;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// SearsFoot
    ///
    static const INT32 SearsFoot = 39;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// GoldCoastFoot
    ///
    static const INT32 GoldCoastFoot = 40;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// MicroInch
    ///
    static const INT32 MicroInch = 41;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianYard
    ///
    static const INT32 IndianYard = 42;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianFoot
    ///
    static const INT32 IndianFoot = 43;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianFt37
    ///
    static const INT32 IndianFt37 = 44;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianFt62
    ///
    static const INT32 IndianFt62 = 45;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianFt75
    ///
    static const INT32 IndianFt75 = 46;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// IndianYd37
    ///
    static const INT32 IndianYd37 = 47;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Decameter
    ///
    static const INT32 Decameter = 48;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// InternationalChain
    ///
    static const INT32 InternationalChain = 49;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// InternationalLink
    ///
    static const INT32 InternationalLink = 50;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// BritishFootTrunc
    ///
    static const INT32 BrFootTrunc = 51;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// BritishChainTrunc
    ///
    static const INT32 BrChainTrunc = 52;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// BritishLinkTrunc
    ///
    static const INT32 BrLinkTrunc = 53;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Degree
    ///
    static const INT32 Degree = 1001;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Grad
    ///
    static const INT32 Grad = 1002;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Grade
    ///
    static const INT32 Grade = 1003;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// MapInfo
    ///
    static const INT32 MapInfo = 1004;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Mil
    ///
    static const INT32 Mil = 1005;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Minute
    ///
    static const INT32 Minute = 1006;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Radian
    ///
    static const INT32 Radian = 1007;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Second
    ///
    static const INT32 Second = 1008;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Decisec
    ///
    static const INT32 Decisec = 1009;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Centisec
    ///
    static const INT32 Centisec = 1010;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Millisec
    ///
    static const INT32 Millisec = 1011;

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Unknown
    ///
    static const INT32 Unknown = 0;
};
/// \}

#endif //_MGCOORDINATESYSTEMUNITCODE_H_
