#ifndef FDOSMPHCLASSPROPERTYREADER_H
#define FDOSMPHCLASSPROPERTYREADER_H		1
/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */

#ifdef _WIN32
#pragma once
#endif

#include <Sm/Ph/GroupReader.h>
#include <Sm/Ph/PropertyReader.h>
#include <Sm/Ph/ClassPropertySADReader.h>

//class FdoSmPhTable;

// Retrieves all properties for a given 
// Class. Works in tandem with FdoRdbmsLpPropertyReader
// so not for general use.

class FdoSmPhClassPropertyReader : public FdoSmPhGroupReader
{
public:
    /// Attach to a property reader to read the properties
    /// for a class. 
    /// Call ReadNext() to read each property.
    /// Properties are ordered by property name.
	//
    /// Parameters:
    /// 	schemaName: the schema containing the class.
    /// 	className: get the properties for this class.
    /// 	propReader: reads properties ordered by class and property
    /// 		name. Therefore this object will not get any properties
    /// 		if propReader has passed given class.
    /// 	SADReader: Schema Attribute Dictionary reader. Reads the SAD
    /// 		entries for each property. This reader must read the entries
    /// 		ordered by class and property name.
	FdoSmPhClassPropertyReader(
		FdoStringP schemaName, 
		FdoStringP className, 
		FdoSmPhPropertyReaderP propReader,
		FdoSmPhSADReaderP SADReader
	);

	~FdoSmPhClassPropertyReader(void);

    /// Used by base class to get the current row group. Rows are grouped by 
    /// class name.
	virtual FdoStringP GetGroupName();


    /// Various getters for property attributes.
    /// These are just wrappers around the propReader getters.
    /// See PropertyReader.h for descriptions.

	FdoStringP GetName();
	FdoStringP GetColumnName();
    FdoStringP GetColumnType();
    bool GetIsFixedColumn();
    bool GetIsColumnCreator();
	FdoStringP GetDescription();
	FdoStringP GetFeatureClassName();
	FdoStringP GetDataType();
	FdoStringP GetGeometryType();
	int GetIdPosition();
	bool GetIsNullable();
	bool GetIsReadOnly();
	bool GetIsFeatId();
	bool GetIsSystem();
	int GetLength();
	int GetScale();
	FdoPtr<FdoDataValue> GetDefaultValue();
	FdoStringP GetTableName();
	FdoStringP GetRootObjectName();
// TODO: think about whether this function can be dropped.
//	const FdoSmPhTable* GetTable();
	bool GetHasElevation();
	bool GetHasMeasure();
	bool GetIsAutoGenerated();
    bool GetIsRevisionNumber();
    FdoStringP GetSequenceName();
/* TODO: implement dependency reading.
	FdoSmPhDependencyReaderP GetDependencyReader();
*/
    /// Gets a reader for retrieving the Schema Attribute Dictionary
	FdoSmPhClassPropertySADReaderP GetSADReader();


protected:
    /// Unused constructor needed only to build on Linux
    FdoSmPhClassPropertyReader() {}

private:
	FdoSmPhPropertyReaderP mPropReader;
	FdoSmPhSADReaderP mpSADReader;
	FdoStringP mSchemaName;
	FdoStringP mClassName;
};

typedef FdoPtr<FdoSmPhClassPropertyReader> FdoSmPhClassPropertyReaderP;


#endif


