#include "StdAfx.h"

#include "c_KgInfoUtil.h"
#include "c_KgInfInsertTest.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>
#include <infxcli.h>
#include <milib.h>

#include "D:\Informix\odbc_spatial_demo\commfuncs.h"
#include "D:\Informix\odbc_spatial_demo\commfuncs.c"
#include "D:\Informix\odbc_spatial_demo\wkbfuncs.c"
#include "D:\Informix\odbc_spatial_demo\odbcutils.c"

CPPUNIT_TEST_SUITE_REGISTRATION(c_KgInfInsertTest);



c_KgInfInsertTest::c_KgInfInsertTest(void)
{
}

c_KgInfInsertTest::~c_KgInfInsertTest(void)
{
}


unsigned char szVal[60000];

void c_KgInfInsertTest::InsertTest()
{
    SQLHDBC       hdbc;
    SQLHENV       henv;
    SQLHSTMT      hstmt;
    char          sql_stmt[200];
    int           rc;
    SDWORD        pcbvalue1, pcbvalue2, pcbvalue3;
    Geometry      geom = {(GeomType)0};
    Point         pt[30];
    int           max_alloced = 0;
    int           site_id;
    char         *name;
    int           name_len;
    char         *location_wkb_buf;
    int           location_wkb_len;
    int           srid;
    SQLRETURN retcode;
    SQLPOINTER rgbValue;
    int i = 5;
    rgbValue = &i;


    server_connect ((UCHAR *)"IDS", &henv, &hdbc);

    rc = SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);

       /* Initialize entries for non-spatial columns in the table */
    site_id = 1004;
    name = "Landmark Industrial";
    name_len = strlen(name);

    /* Populate the linestring point array. */
    //(-87,747557248764 43,7232119393936, -87,7475573710658 43,7231815697085)')
    pt[0].x = 87.747557248764;   pt[0].y = 43.7232119393936;
    pt[1].x = 87.7475573710658;   pt[1].y = 43.7231815697085;
    pt[2].x = 2;   pt[2].y = 2;
   /* pt[3].x = 3;   pt[3].y = 3;
    pt[4].x = 4.6; pt[4].y = 5.3;
    pt[5].x = 7;   pt[5].y = 7;*/

    geom.type = geomLineString;
    geom.num_points = 3;
    geom.num_parts  = 1;
    geom.pt = pt;

    /* Convert the points to a Well Known Binary
     * representation of a linestring. */
    geom_to_wkb (&geom, &max_alloced, &location_wkb_len, &location_wkb_buf);
             

    /* INFORMIX_EXTEST_BEGIN pointfromwkb */

    /* Create the SQL insert statement to populate the hazardous_sites
     * table. The question marks are parameter markers that indicate
     * the column values that will be inserted at run time. */
    sprintf(sql_stmt,
            "INSERT INTO rail (featid,geometry) "
            "VALUES(?,ST_LineFromWKB(?,20))");

    /* Prepare the SQL statement for execution. */
    rc = SQLPrepareA(hstmt, (unsigned char *)sql_stmt, SQL_NTS);

    /* Bind the site_id to the first parameter. */
    pcbvalue1 = 0;
    rc = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG,
                           SQL_INTEGER, 0, 0,
                           &site_id, 0, &pcbvalue1);



    /* Bind the location geometry to the third parameter. */
    pcbvalue3 = location_wkb_len;
    rc = SQLBindParameter (hstmt,2, SQL_PARAM_INPUT, SQL_C_BINARY,
                           SQL_INFX_UDT_LVARCHAR, location_wkb_len, 0,
                           location_wkb_buf, location_wkb_len, &pcbvalue3);

    /* Execute the insert statement. */
    rc = SQLExecute (hstmt);
    
    SQLINTEGER	 j = 0;
    SQLINTEGER	 native;
    SQLWCHAR	 state[ 7 ];
    SQLWCHAR	 text[512];
    SQLSMALLINT	 len;
    SQLRETURN	 ret;
    if(rc != SQL_SUCCESS)
     {
          do
          {
              ret = SQLGetDiagRec(SQL_HANDLE_STMT, hstmt, ++j, state, &native, text,
                                  sizeof(text), &len );
          }
          while( ret == SQL_SUCCESS );

     }

    /* INFORMIX_EXTEST_END pointfromwkb */

    SQLFreeStmt (hstmt, SQL_CLOSE);          /* Close the statement handle */
    SQLFreeHandle (SQL_HANDLE_STMT, hstmt);  /* Free the statement handle */
    SQLDisconnect (hdbc);                    /* Close the connection */
    SQLFreeHandle (SQL_HANDLE_DBC, hdbc);    /* Free the database handle */
    SQLFreeHandle (SQL_HANDLE_ENV, henv);    /* Free the ODBC environment */
    printf( "\nTest Complete\n");

try
{
 /*  SQLHENV henv;
   SQLHDBC hdbc;
   SQLHSTMT hstmt;
   SQLRETURN retcode;
   SQLPOINTER rgbValue;
   int i = 5;
   rgbValue = &i;

   SQLCHAR * OutConnStr = (SQLCHAR * )malloc(255);
   SQLSMALLINT * OutConnStrLen = (SQLSMALLINT *)malloc(255);

   // Allocate environment handle
   retcode = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv);

   // Set the ODBC version environment attribute
   if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) {
      retcode = SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION,(SQLPOINTER)SQL_OV_ODBC3, 0); 

      // Allocate connection handle
      if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) {
         retcode = SQLAllocHandle(SQL_HANDLE_DBC, henv, &hdbc); 

         // Set login timeout to 5 seconds
         if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) {
            SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER)(rgbValue), 0);

            // Connect to data source
            retcode = SQLConnect(hdbc, (SQLWCHAR*)L"IDS", SQL_NTS, (SQLWCHAR*) NULL, 0, NULL, 0);

            // Allocate statement handle
            if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) {
               retcode = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &hstmt); 

               double ordinates[2] = {-33.3333333333,57.411111111111}; 
               FdoPtr<FdoFgfGeometryFactory> fgf = FdoFgfGeometryFactory::GetInstance();
               FdoPtr<FdoIPoint> ptf = fgf->CreatePoint(0,ordinates);
               FdoPtr<FdoByteArray> barray = fgf->GetWkb(ptf);
               
               
              
               FdoByte *data;
               int count;
               if( barray.p )
               {
                  count = barray->GetCount();
                  data = barray->GetData();
               } 
                 
              for(int ind=0;ind<count;ind++)
              {
                szVal[ind] = *data;
                data++;
              }
              //404080 00 00 00 00 00

              long lospec_valsize = count;
                      
              SQLINTEGER cbVal= 60000;
               
               retcode = SQLPrepareA(hstmt,(unsigned char*)"INSERT INTO agents (location) VALUES(ST_PointFromWKB(CAST(? as lvarchar),0))", SQL_NTS); 
               retcode =  SQLBindParameter(hstmt,1,SQL_PARAM_INPUT,SQL_C_BINARY ,SQL_INFX_UDT_LVARCHAR,(SQLINTEGER)60000,0,szVal,(SQLINTEGER)60000,&cbVal);
              //insert into agents(location) SELECT ST_GeomFromWKB(CAST(ST_AsBinary(location) as lvarchar) ,0) as geo  FROM agents WHERE se_row_id = 111
               retcode = SQLExecute(hstmt);
               
               if(retcode != SQL_SUCCESS)
               {
                    SQLINTEGER	 i = 0;
                    SQLINTEGER	 native;
                    SQLWCHAR	 state[ 7 ];
                    SQLWCHAR	 text[512];
                    SQLSMALLINT	 len;
                    SQLRETURN	 ret;

                    do
                    {
                        ret = SQLGetDiagRec(SQL_HANDLE_STMT, hstmt, ++i, state, &native, text,
                                            sizeof(text), &len );
                    }
                    while( ret == SQL_SUCCESS );

               }
               
               // Process data
               if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO) {
                  SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
                  
               SQLDisconnect(hdbc);
               
               
               }
               
            }
             if(retcode != SQL_SUCCESS)
             {
                  SQLINTEGER	 i = 0;
                  SQLINTEGER	 native;
                  SQLWCHAR	 state[ 7 ];
                  SQLWCHAR	 text[512];
                  SQLSMALLINT	 len;
                  SQLRETURN	 ret;

                  do
                  {
                      ret = SQLGetDiagRec(SQL_HANDLE_STMT, hstmt, ++i, state, &native, text,
                                          sizeof(text), &len );
                  }
                  while( ret == SQL_SUCCESS );

             }
            SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
         }
      }
       if(retcode != SQL_SUCCESS)
       {
            SQLINTEGER	 i = 0;
            SQLINTEGER	 native;
            SQLWCHAR	 state[ 7 ];
            SQLWCHAR	 text[512];
            SQLSMALLINT	 len;
            SQLRETURN	 ret;

            do
            {
                ret = SQLGetDiagRec(SQL_HANDLE_STMT, hstmt, ++i, state, &native, text,
                                    sizeof(text), &len );
            }
            while( ret == SQL_SUCCESS );

       }
      SQLFreeHandle(SQL_HANDLE_ENV, henv);
   }
*/
  /*


  // Connect:
  FdoPtr<FdoIConnection> conn = c_KgInfoUtil::OpenUnitTestConnection();

  FdoPtr<FdoIDescribeSchema> comm = (FdoIDescribeSchema*)conn->CreateCommand(FdoCommandType_DescribeSchema);
  FdoPtr<FdoFeatureSchemaCollection> schemas = comm->Execute();
  
  FdoStringP src_classname = L"informix~agents~location";
 
// Execute insert  
{ 
  
  double x = 0;
 // while(x < 10)
  {
  
     
  FdoPtr<FdoIInsert> comm_insert = (FdoIInsert*)conn->CreateCommand( FdoCommandType_Insert );    
  comm_insert->SetFeatureClassName( src_classname );
  
  FdoPtr<FdoPropertyValueCollection> propcol = comm_insert->GetPropertyValues();
  
  // Fid property
  
  //FdoPtr<FdoDataValue> fid_val = FdoDataValue::Create(FdoDataType_Int32);  
  //FdoPtr<FdoPropertyValue> propval_fid = FdoPropertyValue::Create(L"col_id",fid_val);
  //propcol->Add(propval_fid);
  
  // Geometry property
  FdoPtr<FdoFgfGeometryFactory> fgf = FdoFgfGeometryFactory::GetInstance();
  
    double ordinates[2] = {-11.16131245,54.48610234}; 
    //+		mwString	0x00e90ff8 "POINT (-1199898.16131245 1285436.48610234)"	wchar_t *

    FdoPtr<FdoIPoint> ptf = fgf->CreatePoint(0,ordinates);
    
    FdoPtr<FdoByteArray> barray = fgf->GetFgf(ptf);
    
    FdoPtr<FdoGeometryValue> geom_val=  FdoGeometryValue::Create(barray);
    
    FdoPtr<FdoPropertyValue> propval_geom = FdoPropertyValue::Create(L"location",geom_val);
    
    // Name string property
    FdoPtr<FdoStringValue> name_val=  (FdoStringValue*)FdoDataValue::Create(L"inserttest_name");
    FdoPtr<FdoInt32Value> int_val=  (FdoInt32Value*)FdoDataValue::Create(12);
    FdoPtr<FdoPropertyValue> propval_name = FdoPropertyValue::Create(L"name",name_val);
    propcol->Add(propval_geom);
   // propcol->Add(propval_name);
    
    FdoPtr<FdoIFeatureReader> insreader = comm_insert->Execute();
    x =x+1;
  }
  conn->Close();
}                    
*/
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
}  
}//end of c_KgInfInsertTest::InsertTest


void c_KgInfInsertTest::InsertTestDecimal()
{

try
{
  // Connect:
  FdoPtr<FdoIConnection> conn = c_KgInfoUtil::OpenUnitTestConnection();

  FdoPtr<FdoIDescribeSchema> comm = (FdoIDescribeSchema*)conn->CreateCommand(FdoCommandType_DescribeSchema);
  FdoPtr<FdoFeatureSchemaCollection> schemas = comm->Execute();
  
  FdoStringP src_classname = L"informix~KRAJE~GEOMETRY";
 
// Execute insert  
{  
  FdoPtr<FdoIInsert> comm_insert = (FdoIInsert*)conn->CreateCommand( FdoCommandType_Insert );    
  comm_insert->SetFeatureClassName( src_classname );
  
  FdoPtr<FdoPropertyValueCollection> propcol = comm_insert->GetPropertyValues();
  
  // Fid property
  
  //FdoPtr<FdoDataValue> fid_val = FdoDataValue::Create(FdoDataType_Int32);  
  //FdoPtr<FdoPropertyValue> propval_fid = FdoPropertyValue::Create(L"col_id",fid_val);
  //propcol->Add(propval_fid);
  
  // Geometry property
  FdoPtr<FdoFgfGeometryFactory> fgf = FdoFgfGeometryFactory::GetInstance();
  
  double ordinates[1372] = {3470165.98790261,5597928.52665957,3469380.8579113,5597855.14974738,3469219.63988984,5597388.95740214,3468967.26192609,5597300.13897983,3468168.34637986,5597251.88803077,3468108.6604201,5597141.54026186,3468553.28382543,5596628.98115964,3468320.65859958,5596324.14415619,3467896.1499432,5596230.96939326,3467120.73290198,5596378.18887938,3466809.052116,5596600.41236631,3466602.65107714,5597394.58565995,3466132.05444611,5597677.76270835,3466428.19484305,5597905.93584981,3465264.44462013,5597732.98739422,3464786.55967169,5596641.27813713,3464913.84369254,5596570.55096321,3464770.14146659,5595949.30909107,3464389.67867702,5596365.62923857,3464441.77151924,5596539.40743606,3463754.37655665,5596620.7094342,3463863.74772595,5597180.08162732,3463704.31930382,5597217.2704718,3463496.953441,5598031.55463074,3463235.56807194,5598432.68337426,3463026.14473676,5598477.76103066,3462969.07277869,5599287.8954126,3462476.66875284,5599389.75511674,3462652.08070048,5599476.72262099,3462637.90971887,5599708.52936169,3462254.16441585,5599647.05382075,3461878.4026646,5599797.69377052,3461848.46053613,5599604.72826067,3461550.46507208,5599718.4950079,3461681.84662131,5599873.8115135,3461544.88449876,5599931.68809061,3461414.95246622,5599786.58096703,3460546.02244189,5599968.64530786,3460710.29362527,5600589.77907877,3460567.5400678,5600400.15098398,3460267.70188719,5600608.34784853,3460498.94275911,5601078.51373822,3460445.27324733,5601310.17923593,3460214.57187897,5601274.84987135,3460049.935309,5601350.75783929,3460267.25555984,5601404.71034111,3460083.74781093,5601560.54919809,3460098.02157938,5601899.66162774,3459904.85649587,5601831.00402738,3459950.4681513,5602052.85055833,3459774.97062252,5602033.62832565,3459487.24109524,5602756.63142818,3458905.6398599,5603108.49868599,3459074.98182295,5603429.95997228,3458892.43189625,5604335.89087184,3458628.3419449,5604656.81651396,3458676.97173147,5605062.02280818,3458451.15414573,5604938.4596765,3458293.66629449,5605776.03950677,3457946.8085695,5605751.87464972,3458172.21871669,5605918.93650489,3458012.09331574,5606065.07630236,3457977.28812785,5606625.29177647,3457078.99930033,5606864.70082244,3457097.43780288,5607284.52293366,3456718.89126709,5607812.59671881,3456301.81682645,5607968.85617844,3456455.10973574,5608371.36730745,3456236.87012211,5609538.14302064,3455458.33108317,5610047.45993745,3455490.4256109,5610289.98998488,3455575.91880958,5610447.79950856,3454827.78252794,5611026.48165583,3455296.21702431,5611994.47790561,3455266.97379735,5612356.24587032,3454808.23602444,5613199.65257199,3454952.60076061,5613332.63246469,3454842.86432903,5613714.40917703,3455019.06184649,5614243.66954364,3454830.91755201,5614325.92588406,3454252.06156327,5614149.55248518,3453703.5736976,5614367.63223538,3453743.59759761,5615450.58455513,3454471.8157159,5616740.65137348,3454592.53828589,5616636.86168039,3456211.78251805,5617935.95271754,3456075.99995974,5618347.06123876,3455415.84967652,5618765.40074802,3455497.80249574,5619527.29809549,3455814.14850049,5619929.81643339,3455840.39469726,5620697.97959064,3456113.17487689,5621293.19374029,3456966.17024448,5621560.61307894,3458034.22454086,5622006.85170721,3458462.5497455,5622799.00843226,3458391.42866453,5623057.46149889,3458742.0335404,5623484.96113354,3458895.36177258,5622938.92499194,3458804.13710649,5622641.02857277,3459045.36291617,5622586.82875382,3459630.35252248,5622725.98505217,3459957.96573123,5623085.77812757,3459011.24106687,5623657.87616971,3459128.3632765,5624419.27725535,3459330.31528857,5624681.7321122,3459539.98770138,5625055.79677401,3459696.24858709,5626346.32167799,3460188.78862796,5626983.86961485,3460109.88792618,5627223.09762335,3460740.77164182,5627220.59205002,3461250.1093894,5626910.02597309,3461865.11330757,5627797.45433387,3461255.44916812,5628409.00726094,3461272.11531313,5628714.69409492,3461839.29261141,5629038.40407369,3461968.9537892,5629296.9694759,3461867.25587039,5629348.83149222,3461710.02128949,5629549.60822387,3461516.44089076,5629418.07332491,3461381.95910405,5629631.0004413,3461532.20228784,5630061.4534875,3461347.36173764,5630258.84199088,3461547.50034945,5630665.13036174,3461826.88430591,5630575.16076201,3461896.65983387,5630845.50197146,3461573.42664336,5630929.03294373,3461342.35285613,5630748.33405456,3461068.99669628,5630770.38857975,3461183.41680177,5630969.05829988,3460801.76218966,5631340.98199382,3461401.30484223,5631675.12070333,3462065.18768497,5631154.79528087,3462482.19881009,5631564.4181398,3463189.15872083,5631889.09597978,3463416.77104327,5631709.8566763,3463722.94397732,5631870.79215391,3463729.10344198,5631363.67968363,3463351.1696521,5631045.96764091,3463791.65689583,5631199.03714833,3464026.85456073,5631084.30964818,3464171.12961323,5631306.4483536,3464525.14879665,5631342.30613473,3465354.36384297,5630812.09193958,3465635.93515722,5630216.01115358,3466405.36099069,5629937.08025104,3466593.79392446,5629634.65903544,3467285.82104579,5629804.13551176,3467723.33800668,5629453.45281667,3467848.50435511,5629839.057689,3467884.61914051,5629660.08686112,3468261.45567878,5629720.7120316,3469133.50406835,5630054.31728351,3469275.86757125,5630841.15206477,3469159.92722559,5631709.96708033,3469448.6338762,5632275.52010709,3469347.77900535,5633014.82102318,3469779.30412688,5633332.29327038,3469607.489718,5634166.88805523,3469719.76893189,5634402.46104298,3471150.79596694,5634211.9911375,3471630.25821831,5634498.49194025,3472192.26280567,5634602.27378243,3472401.08554626,5634837.88007178,3473283.41840281,5636445.29921909,3474140.81302491,5636169.21195493,3475262.77157815,5635422.92365549,3476299.41251003,5635580.47515002,3477727.89494793,5634647.1090278,3478333.23318547,5634305.65476459,3479611.50832608,5634528.25320719,3480391.93461992,5633615.89387994,3480123.3018903,5632871.31731204,3480195.17239724,5632634.34277469,3480545.16791496,5632492.09419684,3481273.09382982,5632782.13697005,3481625.03455149,5633261.28692817,3482134.67225266,5633294.95711796,3482523.15257312,5632734.75889958,3483178.14307001,5632759.48031607,3483363.26366853,5632483.61957414,3483564.50302444,5632477.69175747,3483619.9747699,5632204.37203285,3484602.88928556,5632255.15776891,3485446.04774235,5632681.52509748,3485640.07190333,5632618.95171767,3485571.33694742,5632270.22762086,3486147.7164387,5632784.65150469,3486237.67090108,5634082.45739266,3486801.8935114,5635687.71288315,3487484.36451403,5636505.7179771,3487769.93002824,5637528.88871133,3487656.44820569,5637833.56691629,3488146.73787532,5638107.80391967,3488856.36684669,5637691.97697176,3489392.53864123,5637791.16814816,3489828.43798521,5637624.01773448,3490534.78549075,5637814.90982903,3490743.59973441,5638568.16580795,3491221.40054981,5638613.97549808,3492899.85487593,5637504.3067644,3493096.2939507,5638431.72164324,3495846.34227698,5637691.90691706,3496514.7056486,5637122.90280276,3497283.3953558,5636883.45888392,3498026.85993971,5637136.02135452,3498600.86986321,5637581.00675242,3500003.37998787,5637650.87638262,3500269.84584652,5637637.59608954,3500257.66091067,5638341.52285668,3499989.6085026,5639888.30657141,3499675.34221596,5640250.81971121,3499855.73001303,5640515.00645082,3499851.85670445,5641160.20061754,3500577.42151265,5641875.39596009,3500029.21310667,5641858.95214361,3499973.17377024,5642540.98924002,3499521.50628,5643092.76610111,3499391.9174734,5643562.4704574,3499794.33189747,5644137.1355363,3500207.06111358,5644295.89015061,3501075.03051073,5645632.81753095,3500987.54379953,5645971.73064202,3501183.66986691,5646632.6366777,3500879.82593587,5648000.1851759,3501362.61482299,5648531.82365547,3501635.27624515,5648433.26247543,3501141.10104432,5649097.17311833,3500736.60129667,5650434.77428375,3500500.92518944,5650650.05076493,3499673.38467223,5650186.83803156,3499304.39272464,5649728.18630735,3498430.59313979,5650762.14191245,3497888.45466975,5651167.57909457,3498923.57630153,5652892.20872497,3499072.30276381,5653437.55776108,3499805.10634842,5653319.05716633,3500316.66203532,5653585.51919762,3500819.53555596,5654048.72921515,3501120.09597844,5654081.01551366,3501264.03287308,5654652.58621994,3501774.27881144,5654829.96185413,3502445.92944549,5654605.67378993,3502598.96558037,5654139.27737975,3502501.37337309,5653912.61942821,3502661.5906919,5653679.55965016,3503482.31617022,5653582.80179134,3504170.29012302,5653721.59461429,3504141.06213807,5654815.11436415,3504418.28146906,5654828.6229617,3504897.77455741,5654607.91031772,3504939.69421449,5654267.57346141,3505447.27418741,5654178.23803753,3505552.26569552,5653807.82775983,3506099.12830701,5653894.74008275,3507330.91632216,5653612.71070277,3507655.6310905,5653220.06348088,3506975.27367762,5652611.38945945,3507107.84798317,5651891.21964301,3507216.26821828,5651607.14503091,3507474.83881665,5651335.35607399,3507920.68191462,5651344.07792605,3508555.32547778,5651524.80498652,3509149.35820531,5651176.02953738,3509566.81304372,5651341.95464592,3510103.12770535,5651307.0826692,3509862.58477686,5651548.68984756,3509424.44327008,5651615.19788202,3509570.80889958,5652185.88940012,3510099.96797219,5653108.63443647,3510193.22032789,5653731.73413009,3510920.23368585,5653901.31369281,3512192.65947862,5654499.86951772,3512435.07451962,5653374.45444852,3512456.25482345,5651816.47274599,3512588.87053648,5651601.45457522,3512450.67241599,5650977.05983968,3512192.64514491,5650749.94728534,3512526.81061712,5650585.76888532,3513524.08099002,5650088.84017706,3514071.12046674,5650415.88562743,3513893.52863641,5650997.6253705,3514419.45931897,5651412.10915342,3514966.91627619,5651372.45206243,3515461.06138164,5651743.87013064,3516910.71875856,5652110.84924456,3517180.61182587,5651909.22736108,3516840.28028235,5651688.51546967,3516982.49745766,5651132.25081762,3517184.59309375,5650970.42108924,3516963.5249495,5650661.9554207,3517495.31567334,5649998.73839802,3517705.74858079,5650179.79241986,3518043.39859193,5650179.22257747,3519442.46596269,5649935.89341774,3519624.69097498,5649120.77763542,3519437.04366319,5648073.67475682,3520177.03181136,5647776.43319675,3520679.84704812,5647060.74789547,3520498.05041431,5646372.77645412,3519711.78601051,5645776.22765603,3519638.14666616,5645440.30859347,3519162.16302141,5645112.50795031,3518966.47790784,5644712.80105564,3519080.93121904,5644066.52882294,3518949.33371987,5643294.19081153,3519181.39395454,5642923.75046801,3519665.77285848,5640348.20179827,3519813.49657896,5639905.06134479,3520569.39419915,5639079.2026673,3520754.18978712,5638457.17113106,3521883.39479784,5636996.04920365,3522400.44532661,5636696.92276129,3523094.0454602,5636506.34382542,3523293.8222471,5636583.99980762,3523311.58304296,5636330.51016981,3523996.5516643,5636402.23245835,3524115.51126539,5636166.78732375,3524283.64438522,5636211.47600326,3524324.4982506,5635976.23287605,3524508.63668608,5636037.93365888,3524806.12094311,5635751.53949841,3525050.41183967,5635823.18729702,3525426.2626371,5635026.99052461,3526048.47306066,5634238.43044338,3526366.07525679,5632671.57231463,3526639.13963639,5632416.54413722,3526247.24649058,5631780.56105701,3526487.15848866,5631415.79892604,3526367.85137324,5630954.45465168,3526507.36807817,5630794.71453192,3525959.50014265,5630283.56333758,3526355.72219286,5629584.46682415,3526335.81438142,5629148.24285904,3526529.94903322,5628887.63513137,3526377.21090308,5628586.81083359,3526461.49989607,5628240.73764807,3526243.52387466,5627946.32113575,3526534.90113004,5627515.69673487,3526892.67429475,5627592.3673049,3527310.82147966,5627290.17892677,3527802.64892195,5627371.13593385,3528946.23981909,5628524.88294206,3530092.41854007,5630805.31829849,3530566.12169158,5630953.05864568,3531130.84354157,5631049.65341914,3531817.42437861,5630827.80535372,3531998.22119865,5630371.81181687,3532852.16899731,5630128.70407704,3533560.34045131,5629695.33045763,3533937.09956489,5629063.29160121,3535292.52629728,5628809.768148,3536183.10814259,5629059.44892461,3537088.41818915,5627499.91028128,3537865.73467292,5627803.65202327,3537890.43886417,5626282.77599687,3538062.78520295,5625590.42841496,3538476.90336501,5624973.63506049,3540204.51208082,5623942.98685362,3540579.30225452,5622989.28385517,3540295.09163874,5622141.88277969,3539488.25384633,5620795.26826983,3539505.57847316,5620379.18109146,3540044.68485038,5620000.24971658,3539958.385317,5618590.34839785,3540108.79725126,5618233.12668527,3539907.71814254,5617411.37831496,3539818.47853719,5616906.3973849,3540039.23018378,5616723.92531653,3540609.15763672,5614446.47771366,3541418.78835703,5613801.28158693,3540712.63378487,5613134.5463491,3540092.91500785,5612154.84149741,3540094.66235114,5611994.73853777,3541286.78623406,5611327.65213739,3541696.08787061,5610601.50002305,3541804.29410343,5610026.15395213,3542695.25345416,5609522.59736962,3542080.94045161,5609029.99568549,3541320.2985019,5607821.11172573,3541521.46578348,5607528.82847196,3540513.3244007,5605723.69310085,3541321.98377543,5605188.08077259,3542151.69920832,5605043.30280184,3541896.3261209,5604541.25869364,3541612.02980826,5604332.93277777,3542715.35566111,5603262.0499914,3542025.79178477,5603404.473348,3542091.10252929,5603232.44982749,3542901.74601832,5603072.46600329,3543077.97034164,5602593.16411853,3543515.49192631,5602123.57736281,3543576.55446045,5601695.87993041,3543973.31002026,5601506.37512655,3544451.54440292,5600742.58073449,3544642.84890804,5600766.65668833,3544594.31371256,5600272.92551474,3545012.85500546,5599670.41284334,3544998.79728573,5599377.66655365,3542610.17786226,5599037.7427275,3542237.13286181,5598860.05803162,3542151.17906945,5598588.54644229,3541892.28652822,5599040.98848354,3541562.95565072,5598820.7645896,3541751.70545649,5598368.2933012,3541458.49618954,5598378.63829387,3541239.90998683,5599305.21550536,3541049.33023149,5599252.24384636,3541063.47923138,5599092.73742351,3540698.84711411,5599256.16371321,3540703.06437197,5599505.78409152,3540474.73799277,5599382.36783464,3540523.08566626,5599677.04334432,3540178.56309785,5599732.15684144,3539774.81461449,5599274.37895358,3539437.59438376,5599214.47573818,3539094.93257712,5599045.96845529,3538769.27123323,5599138.82495094,3538750.62276332,5598358.93299038,3538018.51582912,5598289.12223931,3537805.13326354,5598639.57523576,3537385.58261035,5598533.69417163,3537147.74950391,5598755.93309853,3536568.47638433,5598681.75930534,3536327.62863986,5599280.74616435,3535274.51230811,5600407.20371908,3535274.7499593,5601010.44030366,3535459.10974242,5600943.80123369,3535431.48651861,5601186.26294536,3535211.71882508,5601536.89457008,3533864.32437106,5601878.3221226,3533892.71205266,5601552.26377468,3534059.08241223,5601451.84045785,3533921.64608895,5601149.6386192,3534142.32585632,5600697.27716172,3534052.56611613,5600292.86039545,3533909.6703807,5600376.54086159,3533743.21949575,5600251.76798673,3533199.40521949,5600683.8113983,3533088.20121907,5599564.18381593,3532371.7120077,5599264.29010321,3532273.95807044,5599380.86714605,3532058.87782458,5599235.98132035,3531173.08006096,5599262.1385255,3531190.94171663,5598666.54268153,3531026.48467802,5598531.2519178,3531335.60656499,5598143.80903452,3531469.39553962,5597428.06827432,3531466.24273898,5597069.67845693,3532271.81773995,5596749.68800735,3532167.83845086,5596256.19651504,3531639.20516915,5596226.91977774,3531865.90857131,5595812.64508179,3531548.79664528,5595656.53392248,3531419.72211853,5595105.33113182,3531030.75591691,5595141.57529807,3530764.23836387,5595740.26319396,3530358.15876689,5595551.43070696,3530143.84932879,5595281.60306413,3530472.53888998,5594861.4023895,3530480.84161811,5594625.50556401,3530179.10305008,5594713.21733464,3530103.63618332,5594560.92401074,3529726.6963243,5594888.64535335,3529576.66320486,5594560.60440606,3529053.62371471,5594633.90494943,3528621.55904427,5594470.94506506,3527805.73463696,5594503.22710695,3527796.36447977,5594847.89286452,3527564.98459069,5595083.07657475,3527736.00759121,5595180.89993091,3527684.11965682,5595295.17457806,3527365.32455525,5595312.29249213,3527005.40672351,5595673.98902705,3527904.7242847,5595571.86843961,3527922.51869517,5595731.48792009,3527539.48566827,5595811.86601636,3527293.74287982,5596213.58816363,3527546.21946345,5596326.26689869,3527256.30211356,5597040.72067168,3527348.05104364,5597288.52838673,3527046.65277715,5597497.48248923,3526432.52684565,5597051.74232209,3526358.48156625,5596058.94593342,3525718.03117278,5596425.58409379,3525491.4900697,5596832.82363449,3524813.47733228,5597115.9333981,3524527.5998679,5597030.43456372,3524164.57289557,5597725.50787337,3524222.18375419,5598011.04850871,3523426.76467969,5598302.37035095,3523409.14591688,5597959.24662512,3523104.9070501,5597954.05470776,3522897.3114461,5598368.79475768,3522453.41458453,5597845.31761773,3522405.14243569,5598061.90945379,3521458.16751902,5598289.95635412,3521560.67191739,5598623.92626461,3520620.90225487,5599207.86430991,3520607.68623633,5598943.96711357,3520152.52408203,5599356.83752934,3519620.11313063,5599207.0856433,3519610.87171303,5599008.24134375,3519081.3050893,5599337.84617747,3519052.88874778,5599075.00194718,3518708.04857589,5598998.9993315,3518674.50742133,5598664.90232645,3518461.21725685,5598653.36272886,3518162.23750179,5598332.22013311,3518223.46250922,5598210.08081188,3517489.08096487,5597948.41184946,3517543.03481076,5597417.93631938,3517071.89484514,5597493.94997618,3517303.42642513,5597092.39573648,3517262.64081305,5596490.13161198,3517202.50180156,5596273.58998963,3516808.49229046,5596088.35157768,3516401.54254241,5596137.40026866,3515974.28056714,5595927.68004396,3515015.01666469,5596714.81659216,3514235.61571111,5597008.98921634,3513391.5827636,5597291.75262769,3513034.17513306,5597689.07908319,3512559.79935053,5597860.47528393,3511399.89714699,5598517.72276885,3511162.89412882,5598417.39610563,3510644.91042101,5598550.86805591,3510750.30565439,5598865.04382527,3510512.55682211,5599191.17301158,3510173.3907113,5599161.29023531,3510025.48801469,5599451.68072105,3509842.20894008,5599427.9039361,3509949.15798949,5599728.16311311,3509487.14612243,5599948.5608753,3508911.12259793,5600160.21901023,3508521.43264106,5599885.80161223,3508495.07002387,5600046.75035397,3508341.94302377,5600033.94449733,3508364.24624965,5600332.29797719,3507456.09080628,5600175.15971528,3507340.3842308,5600437.45886539,3507097.7014032,5600504.79997791,3506803.5697466,5601927.30495583,3506900.65215789,5602426.07034961,3506646.41403954,5602217.62979224,3506530.36731488,5602346.524241,3506887.15288874,5602700.17762701,3505929.79546095,5603247.38916682,3505483.94088619,5603298.08176292,3505558.87921339,5603626.01323434,3504943.18629805,5603862.21494737,3504645.60208861,5604542.78523885,3504586.46869172,5604560.89171262,3504134.10247176,5604486.39403322,3503738.62988236,5604203.10272462,3503379.03092255,5604426.95893789,3502997.6638546,5603995.56239927,3503102.03081115,5604599.51344292,3502791.78373305,5605020.60958572,3502784.66942651,5605448.12651945,3502788.86849828,5605585.81215935,3502507.67488024,5605589.54798486,3502399.9532698,5605381.20827639,3502192.79724127,5605886.01160367,3501790.13823596,5606174.61880012,3501586.69685571,5606215.91898182,3501405.99172655,5606222.35372214,3500757.51673344,5607503.34808763,3500535.82928178,5607557.53410316,3500675.60297028,5607708.26621087,3500542.11453814,5607901.20083196,3500606.48578982,5608262.04396475,3500153.12249714,5607830.32741766,3499972.48291632,5607792.52843195,3499895.72290668,5608033.03056049,3499771.66285456,5608019.64974093,3499569.38314484,5607716.23322709,3499363.2307073,5607730.33459391,3499037.06465749,5608014.24388549,3498742.44078476,5607953.40537902,3498527.89861589,5608137.15165319,3498779.84426666,5608334.13299846,3498704.02145718,5608427.46939653,3498455.80592423,5608466.55639058,3498321.67847672,5608400.56856457,3498256.87328699,5608280.67358582,3498301.37884873,5607563.36855104,3497746.93168644,5607540.23810745,3497861.3614277,5606881.97919839,3497487.56333148,5607192.9891916,3497116.19204348,5607115.01251646,3496895.64731514,5607423.27392536,3496417.627203,5607561.63100991,3497065.3241031,5607662.7145967,3496554.48813989,5608485.60831284,3496054.83694348,5608523.97703507,3495970.95663746,5608208.56469363,3495637.42094393,5608576.03681751,3495285.1602768,5608576.67402384,3495221.6941708,5608834.7207514,3495437.6784343,5609014.9989198,3495267.13752562,5609498.02056408,3495350.50467534,5609696.39262629,3493988.15880591,5609861.30151391,3493543.57312666,5609618.91985875,3494262.60312016,5608444.43516323,3493962.51961502,5608496.14637011,3493710.01072488,5608413.79831935,3493764.58408135,5608291.86485281,3493428.37761455,5608436.95769172,3493257.24300086,5608237.4125294,3492670.32109714,5607924.76442372,3492888.77498153,5607946.54078324,3493358.46871018,5607151.70717819,3493194.06148039,5607120.42727813,3493658.39064504,5606201.74725759,3493013.98071223,5605936.78747326,3492493.1186398,5605436.94904803,3492323.57949809,5605887.4588421,3492009.63310553,5605530.92559351,3491660.67267676,5605469.15660189,3491355.35085936,5605550.06346024,3490478.96877653,5605061.84979053,3490521.10758001,5604907.98733474,3489269.50471725,5604636.76374921,3489434.96584195,5604248.30594549,3489368.52928829,5603847.92519971,3489873.44190875,5603477.46034229,3490101.27985316,5603048.81454078,3489923.91565908,5602816.12711325,3489708.19266645,5602435.52328764,3489460.06656594,5602452.50390096,3487859.39699545,5600913.56453003,3486016.3742814,5602258.07130325,3482464.79685934,5602930.95984167,3482388.0950331,5601898.16660504,3483031.66484159,5599746.97355684,3482800.87320159,5598875.0146301,3482534.47566766,5598453.54958975,3480617.28784989,5598887.06263276,3480618.03923415,5598570.70459705,3480146.14855167,5596459.57232829,3479949.62147986,5596590.39271058,3479600.07626542,5596212.28279284,3478672.31024973,5596224.07474444,3478623.02952243,5595962.55164068,3477949.48689811,5595772.34783088,3478262.42072987,5594660.2926355,3478148.51797583,5594572.91465612,3478087.82628589,5594607.3982844,3477141.80794692,5595214.8242755,3477013.59846161,5595069.11908189,3476536.45519096,5595031.4467826,3475362.11067323,5595157.55302634,3475112.56681741,5594923.44352415,3475219.21619481,5594439.29557968,3474721.93107495,5594542.84044908,3474371.09668448,5595004.77833112,3473978.68123669,5595208.01820425,3473937.83475018,5594555.3055452,3473759.99767876,5594546.36285738,3473120.284785,5594523.91547787,3473013.74937221,5594816.66576636,3472553.46500728,5594362.68044734,3472718.44880994,5593870.96803759,3472496.74326016,5593544.16187421,3472315.56235865,5593860.88998144,3471705.60900042,5594094.97973792,3471818.90044165,5594266.79792462,3471642.17405354,5594172.97567316,3471583.37939718,5594319.20183308,3471378.57793452,5594230.94114049,3471180.31248625,5594360.09058495,3471132.7482764,5593940.46222659,3470938.57985378,5593895.11545273,3470424.36512991,5594567.62476706,3470295.1739016,5595498.806795,3470019.98249168,5595728.34325179,3470112.0940662,5596239.46452011,3470412.41105486,5596524.84256619,3470595.72865951,5596468.1897064,3470079.97020932,5597038.89851218,3470245.71302292,5597161.04417847,3470179.40108722,5597592.2505241,3470343.91645552,5597755.45665969,3470295.43681319,5597963.58936273,3470165.98790261,5597928.52665957}; 
  //+		0 POINT (44.7676320049 40.3965609385)mwString	0x00e90ff8 "POINT (-1199898.16131245 1285436.48610234)"	wchar_t *
  
  
  FdoLinearRingCollection *linearRingColl = new FdoLinearRingCollection();
  FdoPtr<FdoILinearRing> lring = fgf->CreateLinearRing(0, 1372, ordinates); 
  linearRingColl->Add(lring);
  FdoPtr<FdoIPolygon> ptf = fgf->CreatePolygon(lring,linearRingColl);
  
  FdoPtr<FdoByteArray> barray = fgf->GetFgf(ptf);
  
  FdoPtr<FdoGeometryValue> geom_val=  FdoGeometryValue::Create(barray);
  
  FdoPtr<FdoPropertyValue> propval_geom = FdoPropertyValue::Create(L"GEOMETRY",geom_val);
  
  // Name string property
 // FdoPtr<FdoStringValue> name_val=  (FdoStringValue*)FdoDataValue::Create(L"Simon");
  /*FdoPtr<FdoInt32Value> int_val=  (FdoInt32Value*)FdoDataValue::Create(13);
  FdoPtr<FdoPropertyValue> propval_name = FdoPropertyValue::Create(L"name",name_val);
  propcol->Add(propval_name);*/
  propcol->Add(propval_geom);
  
  
  FdoPtr<FdoIFeatureReader> insreader = comm_insert->Execute();
  
  conn->Close();
}                    

}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
}
  
}//end of c_KgInfInsertTest::InsertTestDecimal



void c_KgInfInsertTest::SetupSchema()
{
try
{
  FdoPtr<FdoIConnection> connection = c_KgInfoUtil::OpenUnitTestConnection();
  FdoPtr<FdoISQLCommand> sqlcomm = (FdoISQLCommand*)connection->CreateCommand( FdoCommandType_SQLCommand );
  
  sqlcomm->SetSQLStatement(L"DROP TABLE insertclass");
  sqlcomm->ExecuteNonQuery();
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  
}



try
{
  // Connect:
        FdoPtr<FdoIConnection> connection = c_KgInfoUtil::OpenUnitTestConnection();
        

        // Define one new schema:
        FdoPtr<FdoFeatureSchema> schema = FdoFeatureSchema::Create(L"insertshema", L"");
        FdoPtr<FdoClassCollection> classes = schema->GetClasses();

        // Define one new class with X/Y/Z lowercase property names (and an identity property and a geometry property):
        FdoPtr<FdoFeatureClass> newClass = FdoFeatureClass::Create(L"insertclass", L"");
        FdoPtr<FdoPropertyDefinitionCollection> newProps = newClass->GetProperties();
        FdoPtr<FdoDataPropertyDefinitionCollection> newIds = newClass->GetIdentityProperties();
        FdoPtr<FdoDataPropertyDefinition> dataPropID = FdoDataPropertyDefinition::Create(L"col_id", L"");
        dataPropID->SetDataType(FdoDataType_Int32);
        dataPropID->SetIsAutoGenerated(true);
        dataPropID->SetNullable(true);
        newProps->Add(dataPropID);
        newIds->Add(dataPropID);
        FdoPtr<FdoDataPropertyDefinition> dataPropX = FdoDataPropertyDefinition::Create(L"col_x", L"");
        dataPropX->SetDataType(FdoDataType_Double);
        dataPropX->SetNullable(true);
        newProps->Add(dataPropX);
        FdoPtr<FdoDataPropertyDefinition> dataPropY = FdoDataPropertyDefinition::Create(L"col_y", L"");
        dataPropY->SetDataType(FdoDataType_Double);
        dataPropY->SetNullable(true);
        newProps->Add(dataPropY);
        FdoPtr<FdoDataPropertyDefinition> dataPropZ = FdoDataPropertyDefinition::Create(L"col_z", L"");
        dataPropZ->SetDataType(FdoDataType_Double);
        dataPropZ->SetNullable(true);
        newProps->Add(dataPropZ);
        FdoPtr<FdoDataPropertyDefinition> dataPropstring = FdoDataPropertyDefinition::Create(L"col_name", L"");
        dataPropZ->SetDataType(FdoDataType_String);
        dataPropZ->SetNullable(true);
        newProps->Add(dataPropstring);
        FdoPtr<FdoGeometricPropertyDefinition> dataPropGeom = FdoGeometricPropertyDefinition::Create(L"col_geometry", L"");
        dataPropGeom->SetGeometryTypes(FdoGeometricType_Point);
        newProps->Add(dataPropGeom);
        newClass->SetGeometryProperty(dataPropGeom);
        classes->Add(newClass);

        // Create the new class:
        FdoPtr<FdoIApplySchema> as = (FdoIApplySchema*)connection->CreateCommand(FdoCommandType_ApplySchema);
        as->SetFeatureSchema(schema);
        as->Execute();
                    
        connection->Close();
  
}
catch(FdoException* ex)
{
  FdoStringP str = ex->GetExceptionMessage();
  ex->Release();
  CPPUNIT_FAIL( (const char*)str );
  
}
  
}//end of c_KgInfInsertTest::SetupSchema