// Copyright (C) 2004-2006  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "stdafx.h"
#include "DbiConnection.h"
#include "FdoRdbmsMySqlConnection.h"
#include "FdoRdbmsMySqlFilterCapabilities.h"

FdoRdbmsMysqlFilterCapabilities::FdoRdbmsMysqlFilterCapabilities(FdoRdbmsMySqlConnection* parent)
{
    m_parent = FDO_SAFE_ADDREF(parent);
}

FdoRdbmsMysqlFilterCapabilities::~FdoRdbmsMysqlFilterCapabilities()
{
    m_parent = NULL;
}

FdoSpatialOperations *FdoRdbmsMysqlFilterCapabilities::GetSpatialOperations(int& length)
{
    //Pre-5.6 capabilities
    static FdoSpatialOperations spatialOperationsOld[] =
    { 
        FdoSpatialOperations_EnvelopeIntersects,
        FdoSpatialOperations_Intersects
    };
    //Capabilities for MySQL 5.6 onwards
    static FdoSpatialOperations spatialOperationsNew[] =
    { 
        FdoSpatialOperations_EnvelopeIntersects,
        FdoSpatialOperations_Intersects,
        FdoSpatialOperations_Disjoint,
        FdoSpatialOperations_Inside,
        FdoSpatialOperations_Contains,
        FdoSpatialOperations_CoveredBy,
        FdoSpatialOperations_Equals,
        FdoSpatialOperations_Overlaps,
        FdoSpatialOperations_Within,
        FdoSpatialOperations_Crosses,
        FdoSpatialOperations_Touches,
    };
    DbiConnection* dbic = m_parent->GetDbiConnection();
    if (dbic != NULL && dbic->GetDbVersion() >= MYSQL_VERSION(5, 6, 0))
    {
        length = sizeof(spatialOperationsNew) / sizeof(FdoSpatialOperations);
        return spatialOperationsNew;
    }
    else //Assume lowest capabilites if this is a MySQL <= 5.6 server or we don't have a DBI connection yet
    {
        length = sizeof(spatialOperationsOld) / sizeof(FdoSpatialOperations);
        return spatialOperationsOld;
    }
}


FdoDistanceOperations* FdoRdbmsMysqlFilterCapabilities::GetDistanceOperations(int& length)
{
    length = 0;
    return NULL;
}
