#ifndef FDORDBMSPVCPROCESSOR_H
#define FDORDBMSPVCPROCESSOR_H    1
/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "Fdo/Pvc/FdoRdbmsPvcOperation.h"
#include "Fdo/Pvc/FdoRdbmsPvcInsertHandler.h"
#include "Fdo/Pvc/FdoRdbmsPvcUpdateHandler.h"
#include "Collection.h"

class FdoRdbmsPvcProcessor
{
protected:
		FdoRdbmsPvcInsertHandler   *mInsertHandler;
		FdoRdbmsPvcUpdateHandler   *mUpdateHandler;
		FdoRdbmsConnection		   *mFdoConnection;

public:
        FdoRdbmsPvcProcessor();

		FdoRdbmsPvcProcessor( FdoRdbmsConnection *conn );

		virtual ~FdoRdbmsPvcProcessor();   

		virtual FdoRdbmsCollection<FdoRdbmsPvcOperation>* RefactorPvc(FdoPropertyValueCollection* values, const FdoSmLpClassDefinition* smLpClassDef, bool forUpdate ) const;

		//
		// This method is required since GroupPvcByClass cannot resolve the operation as the input property value collection
		// may not yet have all the required data values(autogenerated idenity property get generated when the first Pvc operation is executed.)
		// This is used to determine if a record already exist and need to be updated or the record does not exist and an insert is needed.
		void SetPvcOperationHandler( const FdoSmLpClassDefinition* smLpClassDef, FdoRdbmsPvcOperation  *pvcOp ) const;
};

#endif

