# How to contribute to Xbim

## **Did you find a bug?**

* Ensure the bug was not already reported by searching on GitHub under [Issues](https://github.com/xBimTeam/XbimEssentials/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/xBimTeam/XbimEssentials/issues/new).
Be sure to include a **title and clear description**, as much relevant information as possible; if useful an IFC file should be attached to
the issue and a **code sample** demonstrating the fault. xBIM can be used to extract parts of IFC file to isolate the problem if it is data-related.

* The Xbim toolkit is composed of a collection of projects, please ensure that you post your issue under the relevant project.

## **Did you write a patch that fixes a bug?**

* Open a new [GitHub pull request](https://help.github.com/articles/about-pull-requests/) with the patch.

* we have two branches in the project, **please work on the development branch**; your contribution will be merged there and then to master upon the next release.

* Ensure the PR description clearly captures the problem and solution. Include a relevant issue number, if applicable.

## **Did you fix whitespace, format code, or make a purely cosmetic patch?**

We are still likely to accept your PR in this case, patches that improve the documentation of the code are most welcome.

## **Do you intend to add a new feature or change an existing one?**

* open an issue on GitHub to collect feedback about the change, before submitting a [PR](https://help.github.com/articles/creating-a-pull-request/).

## **Do you have questions about the source code?**

* Ask any question in the issues page. If you receive help, please try to give back to the community by improving the documentation in any way you can and submit a Pull Request with your contribution.

Xbim is a volunteer effort. We encourage you to pitch in!

Thanks!

The Xbim Team
