/*! \mainpage Introduction
<div class="mainpage">
<!-- This is the index.html page that the user first sees. -->

<p>The Feature Data Objects (FDO) API provides access to data in a 
data store. A provider is a specific implementation of the FDO API 
that provides access to data in a particular data store. The FDO 
Provider for SQLite provides FDO with access to an SQLite-based data store.

<p>The Autodesk SQLite file format is a standalone, file-based spatial database 
format that supports multiple features classes and properties in a single file, 
and provides spatial indexing, interoperability, and high performance for 
large data sets.
</p>

<p>The SQLite file format has the following characteristics:
</p>
<ul>
  <li>SQLite files can be read on different platforms.
  <li>One schema in a single SQLite file supports multiple feature classes.
  <li>The SDF file has not its own spatial indexing.
  <li>SQLite files can store geometric and non-geometric data with minimum overhead.
  <li>The SQLite file format supports a single writer at any time, with multiple readers.
</ul>

<p>An SQLite schema can support the following:
</p>
<ul>
  <li>Auto ID generation
  <li>Exclusive value range constraints
  <li>Null value constraints
  <li>Spatial contexts
  <li>These geometry types: point, line string, polygon, multi-point, multi-line 
  string, multi-polygon, curve string, curve polygon, multi-curve string, 
  multi-curve polygon, linear ring, line string segment, circular arc segment, and ring.
</ul>

<p>
For more information, see <i>The Essential FDO</i>
and the <i>FDO Developer's Guide</i>.
</p>

<br>
</div>
*/




