# Copyright (c) 2011 The Chromium Embedded Framework Authors. All rights
# reserved. Use of this source code is governed by a BSD-style license that
# can be found in the LICENSE file.

from __future__ import absolute_import
from cef_parser import get_copyright
from cef_version import VersionFormatter
from date_util import *
from file_util import *
import git_util as git
import sys


def make_version_header(header):
  result = get_copyright(full=True, translator=False) + \
"""//
// ---------------------------------------------------------------------------
//
// This file was generated by the make_version_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_VERSION_H_
#define CEF_INCLUDE_CEF_VERSION_H_

#define CEF_VERSION "$VERSION$"
#define CEF_VERSION_MAJOR $VERSION_MAJOR$
#define CEF_VERSION_MINOR $VERSION_MINOR$
#define CEF_VERSION_PATCH $VERSION_PATCH$
#define CEF_COMMIT_NUMBER $COMMIT_NUMBER$
#define CEF_COMMIT_HASH "$COMMIT_HASH$"
#define COPYRIGHT_YEAR $YEAR$

#define CHROME_VERSION_MAJOR $CHROME_MAJOR$
#define CHROME_VERSION_MINOR $CHROME_MINOR$
#define CHROME_VERSION_BUILD $CHROME_BUILD$
#define CHROME_VERSION_PATCH $CHROME_PATCH$

#define DO_MAKE_STRING(p) #p
#define MAKE_STRING(p) DO_MAKE_STRING(p)

#endif  // CEF_INCLUDE_CEF_VERSION_H_
"""

  formatter = VersionFormatter()

  # Substitute hash values for placeholders.
  result = result.replace('$YEAR$', get_year())
  result = result.replace('$VERSION$', formatter.get_version_string())

  commit_components = formatter.get_cef_commit_components()
  for key in ('HASH', 'NUMBER'):
    result = result.replace('$COMMIT_%s$' % key, str(commit_components[key]))

  version_parts = formatter.get_version_parts()
  for key in ('MAJOR', 'MINOR', 'PATCH'):
    result = result.replace('$VERSION_%s$' % key, str(version_parts[key]))

  chrome_version_components = formatter.get_chrome_version_components()
  for key in ('MAJOR', 'MINOR', 'BUILD', 'PATCH'):
    result = result.replace('$CHROME_%s$' % key,
                            str(chrome_version_components[key]))

  return result


def write_version_header(output):
  result = make_version_header(output)
  return write_file_if_changed(output, result)


def main(argv):
  if len(argv) < 2:
    print(("Usage:\n  %s <output_filename>" % argv[0]))
    sys.exit(-1)
  write_version_header(argv[1])


if '__main__' == __name__:
  main(sys.argv)
