// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=d31cea8b172629a308a7d54f8dd6fccff4cc8823$
//

#include "libcef_dll/cpptoc/unresponsive_process_callback_cpptoc.h"

#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK unresponsive_process_callback_wait(
    struct _cef_unresponsive_process_callback_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefUnresponsiveProcessCallbackCppToC::Get(self)->Wait();
}

void CEF_CALLBACK unresponsive_process_callback_terminate(
    struct _cef_unresponsive_process_callback_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefUnresponsiveProcessCallbackCppToC::Get(self)->Terminate();
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefUnresponsiveProcessCallbackCppToC::CefUnresponsiveProcessCallbackCppToC() {
  GetStruct()->wait = unresponsive_process_callback_wait;
  GetStruct()->terminate = unresponsive_process_callback_terminate;
}

// DESTRUCTOR - Do not edit by hand.

CefUnresponsiveProcessCallbackCppToC::~CefUnresponsiveProcessCallbackCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefUnresponsiveProcessCallback>
CefCppToCRefCounted<CefUnresponsiveProcessCallbackCppToC,
                    CefUnresponsiveProcessCallback,
                    cef_unresponsive_process_callback_t>::
    UnwrapDerived(CefWrapperType type, cef_unresponsive_process_callback_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCppToCRefCounted<CefUnresponsiveProcessCallbackCppToC,
                        CefUnresponsiveProcessCallback,
                        cef_unresponsive_process_callback_t>::kWrapperType =
        WT_UNRESPONSIVE_PROCESS_CALLBACK;
