// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=5110030008d3b52ee74e5c9a6e047e191588ebf8$
//

#include "libcef_dll/cpptoc/preference_manager_cpptoc.h"

#include "libcef_dll/cpptoc/dictionary_value_cpptoc.h"
#include "libcef_dll/cpptoc/request_context_cpptoc.h"
#include "libcef_dll/cpptoc/value_cpptoc.h"

// GLOBAL FUNCTIONS - Body may be edited by hand.

CEF_EXPORT cef_preference_manager_t* cef_preference_manager_get_global() {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  CefRefPtr<CefPreferenceManager> _retval =
      CefPreferenceManager::GetGlobalPreferenceManager();

  // Return type: refptr_same
  return CefPreferenceManagerCppToC::Wrap(_retval);
}

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

int CEF_CALLBACK
preference_manager_has_preference(struct _cef_preference_manager_t* self,
                                  const cef_string_t* name) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: name; type: string_byref_const
  DCHECK(name);
  if (!name) {
    return 0;
  }

  // Execute
  bool _retval =
      CefPreferenceManagerCppToC::Get(self)->HasPreference(CefString(name));

  // Return type: bool
  return _retval;
}

struct _cef_value_t* CEF_CALLBACK
preference_manager_get_preference(struct _cef_preference_manager_t* self,
                                  const cef_string_t* name) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }
  // Verify param: name; type: string_byref_const
  DCHECK(name);
  if (!name) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefValue> _retval =
      CefPreferenceManagerCppToC::Get(self)->GetPreference(CefString(name));

  // Return type: refptr_same
  return CefValueCppToC::Wrap(_retval);
}

struct _cef_dictionary_value_t* CEF_CALLBACK
preference_manager_get_all_preferences(struct _cef_preference_manager_t* self,
                                       int include_defaults) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefDictionaryValue> _retval =
      CefPreferenceManagerCppToC::Get(self)->GetAllPreferences(
          include_defaults ? true : false);

  // Return type: refptr_same
  return CefDictionaryValueCppToC::Wrap(_retval);
}

int CEF_CALLBACK
preference_manager_can_set_preference(struct _cef_preference_manager_t* self,
                                      const cef_string_t* name) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: name; type: string_byref_const
  DCHECK(name);
  if (!name) {
    return 0;
  }

  // Execute
  bool _retval =
      CefPreferenceManagerCppToC::Get(self)->CanSetPreference(CefString(name));

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
preference_manager_set_preference(struct _cef_preference_manager_t* self,
                                  const cef_string_t* name,
                                  struct _cef_value_t* value,
                                  cef_string_t* error) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: name; type: string_byref_const
  DCHECK(name);
  if (!name) {
    return 0;
  }
  // Verify param: error; type: string_byref
  DCHECK(error);
  if (!error) {
    return 0;
  }
  // Unverified params: value

  // Translate param: error; type: string_byref
  CefString errorStr(error);

  // Execute
  bool _retval = CefPreferenceManagerCppToC::Get(self)->SetPreference(
      CefString(name), CefValueCppToC::Unwrap(value), errorStr);

  // Return type: bool
  return _retval;
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefPreferenceManagerCppToC::CefPreferenceManagerCppToC() {
  GetStruct()->has_preference = preference_manager_has_preference;
  GetStruct()->get_preference = preference_manager_get_preference;
  GetStruct()->get_all_preferences = preference_manager_get_all_preferences;
  GetStruct()->can_set_preference = preference_manager_can_set_preference;
  GetStruct()->set_preference = preference_manager_set_preference;
}

// DESTRUCTOR - Do not edit by hand.

CefPreferenceManagerCppToC::~CefPreferenceManagerCppToC() {}

template <>
CefRefPtr<CefPreferenceManager> CefCppToCRefCounted<
    CefPreferenceManagerCppToC,
    CefPreferenceManager,
    cef_preference_manager_t>::UnwrapDerived(CefWrapperType type,
                                             cef_preference_manager_t* s) {
  if (type == WT_REQUEST_CONTEXT) {
    return CefRequestContextCppToC::Unwrap(
        reinterpret_cast<cef_request_context_t*>(s));
  }
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefPreferenceManagerCppToC,
                                   CefPreferenceManager,
                                   cef_preference_manager_t>::kWrapperType =
    WT_PREFERENCE_MANAGER;
