// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=5160d214e700202d344ac83c7979e890419ac810$
//

#include "libcef_dll/cpptoc/download_item_cpptoc.h"

#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

int CEF_CALLBACK download_item_is_valid(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefDownloadItemCppToC::Get(self)->IsValid();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
download_item_is_in_progress(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefDownloadItemCppToC::Get(self)->IsInProgress();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK download_item_is_complete(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefDownloadItemCppToC::Get(self)->IsComplete();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK download_item_is_canceled(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefDownloadItemCppToC::Get(self)->IsCanceled();

  // Return type: bool
  return _retval;
}

int CEF_CALLBACK
download_item_is_interrupted(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefDownloadItemCppToC::Get(self)->IsInterrupted();

  // Return type: bool
  return _retval;
}

cef_download_interrupt_reason_t CEF_CALLBACK
download_item_get_interrupt_reason(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CEF_DOWNLOAD_INTERRUPT_REASON_NONE;
  }

  // Execute
  cef_download_interrupt_reason_t _retval =
      CefDownloadItemCppToC::Get(self)->GetInterruptReason();

  // Return type: simple
  return _retval;
}

int64_t CEF_CALLBACK
download_item_get_current_speed(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int64_t _retval = CefDownloadItemCppToC::Get(self)->GetCurrentSpeed();

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK
download_item_get_percent_complete(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int _retval = CefDownloadItemCppToC::Get(self)->GetPercentComplete();

  // Return type: simple
  return _retval;
}

int64_t CEF_CALLBACK
download_item_get_total_bytes(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int64_t _retval = CefDownloadItemCppToC::Get(self)->GetTotalBytes();

  // Return type: simple
  return _retval;
}

int64_t CEF_CALLBACK
download_item_get_received_bytes(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  int64_t _retval = CefDownloadItemCppToC::Get(self)->GetReceivedBytes();

  // Return type: simple
  return _retval;
}

cef_basetime_t CEF_CALLBACK
download_item_get_start_time(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefBaseTime();
  }

  // Execute
  cef_basetime_t _retval = CefDownloadItemCppToC::Get(self)->GetStartTime();

  // Return type: simple
  return _retval;
}

cef_basetime_t CEF_CALLBACK
download_item_get_end_time(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefBaseTime();
  }

  // Execute
  cef_basetime_t _retval = CefDownloadItemCppToC::Get(self)->GetEndTime();

  // Return type: simple
  return _retval;
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_full_path(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetFullPath();

  // Return type: string
  return _retval.DetachToUserFree();
}

uint32_t CEF_CALLBACK download_item_get_id(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  uint32_t _retval = CefDownloadItemCppToC::Get(self)->GetId();

  // Return type: simple
  return _retval;
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_url(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetURL();

  // Return type: string
  return _retval.DetachToUserFree();
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_original_url(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetOriginalUrl();

  // Return type: string
  return _retval.DetachToUserFree();
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_suggested_file_name(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetSuggestedFileName();

  // Return type: string
  return _retval.DetachToUserFree();
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_content_disposition(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetContentDisposition();

  // Return type: string
  return _retval.DetachToUserFree();
}

cef_string_userfree_t CEF_CALLBACK
download_item_get_mime_type(struct _cef_download_item_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefString _retval = CefDownloadItemCppToC::Get(self)->GetMimeType();

  // Return type: string
  return _retval.DetachToUserFree();
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefDownloadItemCppToC::CefDownloadItemCppToC() {
  GetStruct()->is_valid = download_item_is_valid;
  GetStruct()->is_in_progress = download_item_is_in_progress;
  GetStruct()->is_complete = download_item_is_complete;
  GetStruct()->is_canceled = download_item_is_canceled;
  GetStruct()->is_interrupted = download_item_is_interrupted;
  GetStruct()->get_interrupt_reason = download_item_get_interrupt_reason;
  GetStruct()->get_current_speed = download_item_get_current_speed;
  GetStruct()->get_percent_complete = download_item_get_percent_complete;
  GetStruct()->get_total_bytes = download_item_get_total_bytes;
  GetStruct()->get_received_bytes = download_item_get_received_bytes;
  GetStruct()->get_start_time = download_item_get_start_time;
  GetStruct()->get_end_time = download_item_get_end_time;
  GetStruct()->get_full_path = download_item_get_full_path;
  GetStruct()->get_id = download_item_get_id;
  GetStruct()->get_url = download_item_get_url;
  GetStruct()->get_original_url = download_item_get_original_url;
  GetStruct()->get_suggested_file_name = download_item_get_suggested_file_name;
  GetStruct()->get_content_disposition = download_item_get_content_disposition;
  GetStruct()->get_mime_type = download_item_get_mime_type;
}

// DESTRUCTOR - Do not edit by hand.

CefDownloadItemCppToC::~CefDownloadItemCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefDownloadItem> CefCppToCRefCounted<
    CefDownloadItemCppToC,
    CefDownloadItem,
    cef_download_item_t>::UnwrapDerived(CefWrapperType type,
                                        cef_download_item_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefDownloadItemCppToC,
                                   CefDownloadItem,
                                   cef_download_item_t>::kWrapperType =
    WT_DOWNLOAD_ITEM;
