// Copyright 2016 The Chromium Embedded Framework Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be found
// in the LICENSE file.

#ifndef CEF_LIBCEF_BROWSER_VIEWS_PANEL_VIEW_H_
#define CEF_LIBCEF_BROWSER_VIEWS_PANEL_VIEW_H_
#pragma once

#include "base/logging.h"
#include "cef/include/views/cef_panel_delegate.h"
#include "cef/libcef/browser/thread_util.h"
#include "cef/libcef/browser/views/view_view.h"

// Helpers for template boiler-plate.
#define CEF_PANEL_VIEW_T CEF_VIEW_VIEW_T
#define CEF_PANEL_VIEW_A CEF_VIEW_VIEW_A
#define CEF_PANEL_VIEW_D CefPanelView<CEF_PANEL_VIEW_A>

// Template for implementing views::View-derived classes that support adding and
// removing children (called a Panel in CEF terminology). See comments in
// view_impl.h for a usage overview.
CEF_PANEL_VIEW_T class CefPanelView : public CEF_VIEW_VIEW_D {
 public:
  using ParentClass = CEF_VIEW_VIEW_D;

  // |cef_delegate| may be nullptr.
  template <typename... Args>
  explicit CefPanelView(CefViewDelegateClass* cef_delegate, Args... args)
      : ParentClass(cef_delegate, args...) {}

  // Returns the CefPanel associated with this view. See comments on
  // CefViewView::GetCefView.
  CefRefPtr<CefPanel> GetCefPanel() const {
    CefRefPtr<CefPanel> panel = ParentClass::GetCefView()->AsPanel();
    DCHECK(panel);
    return panel;
  }
};

#endif  // CEF_LIBCEF_BROWSER_VIEWS_PANEL_VIEW_H_
