// Copyright 2021 The Chromium Embedded Framework Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be found
// in the LICENSE file.

#include "cef/libcef/browser/chrome/views/chrome_views_util.h"

#include "cef/libcef/browser/views/view_util.h"

namespace cef {

bool IsCefView(views::View* view) {
  return view_util::GetFor(view, /*find_known_parent=*/false) != nullptr;
}

}  // namespace cef
