/*
 * Copyright (C) 2004-2006  Autodesk, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser
 * General Public License as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "stdafx.h"
#include <Sm/Ph/Rd/ColumnReader.h>
#include <Sm/Ph/Mgr.h>

FdoSmPhRdColumnReader::FdoSmPhRdColumnReader(
    FdoSmPhReaderP      reader,
    FdoSmPhDbObjectP    dbObject
) :
	FdoSmPhRdReader(reader),
    mDbObject(dbObject)
{
}

FdoSmPhRdColumnReader::FdoSmPhRdColumnReader(
    FdoSmPhMgrP         mgr,
    FdoSmPhRowsP        rows,
    FdoSmPhDbObjectP    dbObject
) :
	FdoSmPhRdReader(mgr, rows),
    mDbObject(dbObject)
{
}


FdoSmPhRdColumnReader::~FdoSmPhRdColumnReader(void)
{
}

FdoSmPhRowsP FdoSmPhRdColumnReader::MakeRows( FdoSmPhMgrP mgr )
{
    FdoSmPhRowsP rows = new FdoSmPhRowCollection();

    // Single row, no joins
    FdoSmPhRowP row = new FdoSmPhRow( mgr, L"Columns", (FdoSmPhDbObject*) NULL  );
    rows->Add(row);
    
    // Each field adds itself to the row.
    FdoSmPhFieldP field = new FdoSmPhField(
        row, 
        L"table_name",
        row->CreateColumnDbObject(L"table_name",false)
    );

    field = new FdoSmPhField(
        row, 
        L"name",
        row->CreateColumnDbObject(L"name",false)
    );

    field = new FdoSmPhField(
        row, 
        L"type",
        row->CreateColumnInt64(L"type",false)
    );

    field = new FdoSmPhField(
        row, 
        L"size",
        row->CreateColumnInt64(L"size",false)
    );

    field = new FdoSmPhField(
        row, 
        L"scale",
        row->CreateColumnInt64(L"scale",false)
    );

    field = new FdoSmPhField(
        row, 
        L"nullable",
        row->CreateColumnBool(L"nullable",false)
    );

    field = new FdoSmPhField(
        row, 
        L"is_autoincremented",
        row->CreateColumnBool(L"is_autoincremented",false)
    );

	field = new FdoSmPhField(
		row,
		L"default_value",
		row->CreateColumnChar(L"default_value", true, 4096)
	);
    return( rows );
}


