// Copyright (C) 2004-2006  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "stdafx.h"
#include "SpatialContextTest.h"
#include "UnitTestUtil.h"
#include <ctime>
#include <cppunit/extensions/HelperMacros.h>
#include "SDF/SdfCommandType.h"
#include "SDF/ICreateSDFFile.h"
#ifdef _WIN32
static const wchar_t* SC_TEST_FILE = L"..\\..\\TestData\\SpatialContextTest.SDX";
#else
#include <unistd.h>
static const wchar_t* SC_TEST_FILE = L"../../TestData/SpatialContextTest.SDX";
#endif


CPPUNIT_TEST_SUITE_REGISTRATION( SpatialContextTest );
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION( SpatialContextTest, "SpatialContextTest");

SpatialContextTest::SpatialContextTest(void)
{
    
}

SpatialContextTest::~SpatialContextTest(void)
{
    
}


void SpatialContextTest::setUp ()
{

}

void SpatialContextTest::tearDown ()
{
}

void SpatialContextTest::TestFdo309 ()
{
    FdoPtr<FdoIConnection> connection;

    try
    {
        connection = UnitTestUtil::OpenConnection( SC_TEST_FILE, true );

        FdoFeatureSchemaP pTestSchema = InitSchema( connection );

        FdoPtr<FdoIApplySchema>pCmd = (FdoIApplySchema*) connection->CreateCommand(FdoCommandType_ApplySchema);
        pCmd->SetFeatureSchema( pTestSchema );
        pCmd->Execute();
        pTestSchema = NULL;

        connection->Close();
        connection = UnitTestUtil::OpenConnection( SC_TEST_FILE, false );

        FdoPtr<FdoIGetSpatialContexts> gscCmd = (FdoIGetSpatialContexts *)connection->CreateCommand( FdoCommandType_GetSpatialContexts );

        // Get a SC reader
        FdoPtr<FdoISpatialContextReader> reader = gscCmd->Execute();

        // Iterate ...
        while ( reader->ReadNext() )
        {
            reader->GetExtent();
        }

    }
    catch ( FdoException* e )
    {
        TestCommonFail( e );
    }
    catch ( CppUnit::Exception e ) 
    {
        throw;
    }
       catch (...)
       {
           CPPUNIT_FAIL ("caught unexpected exception");
       }
        
    printf( "Done\n" );
}

FdoFeatureSchemaP SpatialContextTest::InitSchema ( FdoIConnection* connection )
{
    FdoFeatureSchemaP pTestSchema = FdoFeatureSchema::Create( L"ScSchema", L"Test spatial contexts" );

    FdoFeatureClassP   pfeatureclass = InitFeatureClass( L"FeatClass1" );
    FdoClassesP(pTestSchema->GetClasses())->Add( pfeatureclass );
    FdoClassP pclass = InitClass( L"Class1" );
    FdoClassesP(pTestSchema->GetClasses())->Add( pclass );

    return pTestSchema;
}

FdoFeatureClassP SpatialContextTest::InitFeatureClass( FdoStringP className ) 
{
    FdoFeatureClassP pfeatureclass = FdoFeatureClass::Create( className, L"FeatureClass Desc" );

    // Add identity property
    FdoDataPropertyP pProp = FdoDataPropertyDefinition::Create( L"FeatId", L"FeatId Prop" );
    pProp->SetDataType( FdoDataType_Int32 );
    pProp->SetNullable(false);
    pProp->SetIsAutoGenerated(true);
    FdoPtr<FdoPropertyDefinitionCollection>(pfeatureclass->GetProperties())->Add( pProp );
    FdoPtr<FdoDataPropertyDefinitionCollection>(pfeatureclass->GetIdentityProperties())->Add( pProp );

    pProp = FdoDataPropertyDefinition::Create( L"Name", L"Name" );
    pProp->SetDataType( FdoDataType_String );
    pProp->SetLength(32);
    pProp->SetNullable(false);
    FdoPtr<FdoPropertyDefinitionCollection>(pfeatureclass->GetProperties())->Add( pProp );

    FdoGeometricPropertyP pGeomProp = FdoGeometricPropertyDefinition::Create( L"Geometry", L"location" );
    pGeomProp->SetGeometryTypes( FdoGeometricType_Point | FdoGeometricType_Curve );
    pGeomProp->SetHasElevation(true);
    FdoPtr<FdoPropertyDefinitionCollection>(pfeatureclass->GetProperties())->Add( pGeomProp );
    pfeatureclass->SetGeometryProperty( pGeomProp );

    return pfeatureclass;
}

FdoClassP SpatialContextTest::InitClass( FdoStringP className ) 
{
    FdoClassP pclass = FdoClass::Create( className, L"Class Desc" );

    // Add identity property
    FdoDataPropertyP pProp = FdoDataPropertyDefinition::Create( L"id", L"id Prop" );
    pProp->SetDataType( FdoDataType_Int32 );
    pProp->SetNullable(false);
    pProp->SetIsAutoGenerated(true);
    FdoPtr<FdoPropertyDefinitionCollection>(pclass->GetProperties())->Add( pProp );
    FdoPtr<FdoDataPropertyDefinitionCollection>(pclass->GetIdentityProperties())->Add( pProp );

    pProp = FdoDataPropertyDefinition::Create( L"Name", L"Name" );
    pProp->SetDataType( FdoDataType_String );
    pProp->SetLength(32);
    pProp->SetNullable(false);
    FdoPtr<FdoPropertyDefinitionCollection>(pclass->GetProperties())->Add( pProp );

    return pclass;
}

