/*
* Copyright (C) 2007  Haris Kurtagic
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _c_KGORASCHEMACAPABILITIES_H
#define _c_KGORASCHEMACAPABILITIES_H


class c_KgInfSchemaCapabilities : public FdoISchemaCapabilities
{
public:
    c_KgInfSchemaCapabilities ();

protected:
    virtual ~c_KgInfSchemaCapabilities ();

protected:
    virtual void Dispose ();

public:
     /// \brief
    /// Returns an array of the FdoClassType objects the feature provider supports.
    /// 
    /// \param length 
    /// Output the number of class types.
    /// 
    /// \return
    /// Returns the list of class types.
    /// 
    FDOKGINF_API virtual FdoClassType* GetClassTypes(FdoInt32& length);

    /// \brief
    /// Returns an array of the FdoDataType objects the feature provider supports.
    /// 
    /// \param length 
    /// Output the number of data types.
    /// 
    /// \return
    /// Returns the list of data types
    /// 
    FDOKGINF_API virtual FdoDataType* GetDataTypes(FdoInt32& length);

    /// \brief
    /// Determines if the feature provider supports inheritance.
    /// 
    /// \return
    /// Returns true if the feature provider supports inheritance
    /// 
    FDOKGINF_API virtual bool SupportsInheritance();

    /// \brief
    /// Determines if the provider supports multiple schemas. Returns false if the provider supports only a single schema.
    /// 
    /// \return
    /// Returns true if the provider supports multiple schemas.
    /// 
    FDOKGINF_API virtual bool SupportsMultipleSchemas();

    /// \brief
    /// Determines if the provider supports object properties. Returns false if the provider supports only data and geometric properties.
    /// 
    /// \return
    /// Returns true if the provider supports object properties.
    /// 
    FDOKGINF_API virtual bool SupportsObjectProperties();

    /// \brief
    /// Determines if the provider supports association property.
    /// 
    /// \return
    /// Returns true if the provider support the association property.
    /// 
    FDOKGINF_API virtual bool SupportsAssociationProperties();

    /// \brief
    /// Determines if the provider supports Schema Mapping Overrides 
    /// (overrides to the default rules for mapping Feature Schemas to provider-specific
    /// physical schemas)
    /// 
    /// \return
    /// Returns true if the provider supports Schema Overrides
    /// 
   	FDOKGINF_API virtual bool SupportsSchemaOverrides();

    /// \brief
    /// Determines if the provider supports the network model.
    /// 
    /// \return
    /// Returns true if the provider supports the network model.
    /// 
    FDOKGINF_API virtual bool SupportsNetworkModel();

    /// \brief
    /// Determines if the provider can auto-generate unique ID values for a class.
    /// 
    /// \return
    /// Returns true if the provider supports id autogeneration.
    /// 
    FDOKGINF_API virtual bool SupportsAutoIdGeneration();
    
    /// \brief
    /// Determines if the provider can auto-generate unique ID values that are unique for the entire datastore, rather than just for a particular class.
    /// 
    /// \return
    /// Returns true if the provider supports id autogeneration unique across an datastore.
    /// 
    FDOKGINF_API virtual bool SupportsDataStoreScopeUniqueIdGeneration();

    /// \brief
    /// Returns an array of the FdoDataType objects the feature provider supports for auto-generation.
    /// 
    /// \param length 
    /// Output the number of data types.
    /// 
    /// \return
    /// Returns the list of data types
    /// 
    FDOKGINF_API virtual FdoDataType* GetSupportedAutoGeneratedTypes(FdoInt32& length);
    
    /// \brief
    /// Determines if the provider support update a schema through the ApplySchema command.
    /// If False, then an application can only create a schema once for the provider. They can use the ApplySchema 
    /// command once for a given datastore. Once the schema is defined, it cannot be changed. If True, then the provider 
    /// supports the ability to modify or add to the schema after it is defined initially.
    /// 
    /// \return
    /// Returns true if the provider supports the update of the schema.
    /// 
    FDOKGINF_API virtual bool  SupportsSchemaModification();

    /// \brief
    /// Determines if the provider supports inclusive value range constraints.
    /// 
    /// \return
    /// Returns true if the provider supports inclusive value range constraints.
    /// 
	FDOKGINF_API virtual bool SupportsInclusiveValueRangeConstraints();

    /// \brief
    /// Determines if the provider supports exclusive value range constraints.
    /// 
    /// \return
    /// Returns true if the provider supports exclusive value range constraints.
    /// 
	FDOKGINF_API virtual bool SupportsExclusiveValueRangeConstraints();

    /// \brief
    /// Determines if the provider supports value constraints list.
    /// 
    /// \return
    /// Returns true if the provider supports value constraints list.
    /// 
    FDOKGINF_API virtual bool SupportsValueConstraintsList();

    /// \brief
    /// Determines if the provider supports nullable value constraint.
    /// 
    /// \return
    /// Returns true if the provider supports nullable value constraint.
    /// 
    FDOKGINF_API virtual bool SupportsNullValueConstraints();

    /// \brief
    /// Determines if the provider supports unique value constraint.
    /// 
    /// \return
    /// Returns true if the provider supports unique value constraint.
    /// 
    FDOKGINF_API virtual bool SupportsUniqueValueConstraints();

    /// \brief
    /// Determines if the provider supports composite unique value constraint.
    /// 
    /// \return
    /// Returns true if the provider supports composite unique value constraint.
    /// 
    FDOKGINF_API virtual bool SupportsCompositeUniqueValueConstraints();

    /// \brief
    /// Determines if the provider supports multiple identity properties per class.
    /// 
    /// \return
    /// Returns true if the provider supports multiple identity properties per class.
    /// 
    FDOKGINF_API virtual bool SupportsCompositeId();
    
    #ifdef _FDO_3_2
    /// \brief
    /// Returns the maximum supported length of String, BLOB, or CLOB data
    /// properties. For decimal, it is typically the combination of the maximum
    /// scale and precision. For other data types that are not variable in size,
    /// the value returned is the byte length.
    ///
    /// \param dataType
    /// The data type for which the information is to retrieved.
    ///
    /// \return
    /// Returns the maximum data value length for the identified data type.
    ///
    FDOKGINF_API virtual FdoInt64 GetMaximumDataValueLength(FdoDataType dataType);

    /// \brief
    /// Returns the maximum supported precision for a decimal data property.
    ///
    /// \param
    /// None.
    ///
    /// \return
    /// Returns the maximum supported precision for a decimal data property.
    ///
    FDOKGINF_API virtual FdoInt32 GetMaximumDecimalPrecision();

    /// \brief
    /// Returns the maximum supported scale for a decimal data property.
    ///
    /// \param
    /// None.
    ///
    /// \return
    /// Returns the maximum supported scale for a decimal data property.
    ///
    FDOKGINF_API virtual FdoInt32 GetMaximumDecimalScale();

    /// \brief
    /// Returns the maximum size of a value of the given type. It includes
    /// limits for the data store name, shema name, class name, property name
    /// and description.
    ///
    /// \param name
    /// The schema element name type identifier for which the information is to
    /// be retrieved. Can be any of the following options: FdoSchemaElementNameType_Datastore,
    /// FdoSchemaElementNameType_Schema, FdoSchemaElementNameType_Class, FdoSchemaElementNameType_Property or 
    /// FdoSchemaElementNameType_Description
    ///
    /// \return
    /// Returns the size limitation for the identified schema element.
    ///
    FDOKGINF_API virtual FdoInt32 GetNameSizeLimit(FdoSchemaElementNameType name);

    /// \brief
    /// Returns a string that includes all the reserved characters that cannot be
    /// used for the various schema element names for the provider.
    ///
    /// \param
    /// None
    ///
    /// \return
    /// Returns a string with the reserved characters for the identified schema element.
    ///
    FDOKGINF_API virtual FdoString* GetReservedCharactersForName();
    
    /// \brief
    /// Returns a list of property types that can be used for identity properties.
    ///
    /// \param length
    /// Output the number of data types.
    ///
    /// \return
    /// Returns a string with the reserved characters for the identified schema element.
    ///
    FDOKGINF_API virtual FdoDataType* GetSupportedIdentityPropertyTypes(FdoInt32& length);
    
    /// \brief
    /// Returns TRUE if default values can be specified for a data property
    /// definition, FALSE otherwise.
    ///
    /// \param
    /// None
    ///
    /// \return
    /// Returns TRUE if default values can be specified for a data property
    /// definition, FALSE otherwise.
    ///
    FDOKGINF_API virtual bool SupportsDefaultValue();
    
    #endif
};

#endif

