/*
* Copyright (C) 2004-2006  Autodesk, Inc.
* 
* This library is free software; you can redistribute it and/or
* modify it under the terms of version 2.1 of the GNU Lesser
* General Public License as published by the Free Software Foundation.
* 
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*/

#pragma once

class FdoRdbmsOvSchemaAutoGeneration;

BEGIN_NAMESPACE_OSGEO_COMMON
ref class StringCollection;
END_NAMESPACE_OSGEO_COMMON

BEGIN_NAMESPACE_OSGEO_FDO_PROVIDERS_RDBMS_OVERRIDE

///<summary>
///This class provides directives for reverse-engineering FDO
///Feature Schema elements from the physical schema of the currently 
///connected datastore.
///</summary>
public ref class OvSchemaAutoGeneration: public NAMESPACE_OSGEO_FDO_COMMANDS_SCHEMA::PhysicalElementMapping
{	
internal:
	OvSchemaAutoGeneration(System::IntPtr unmanaged, System::Boolean autoDelete);
    FdoRdbmsOvSchemaAutoGeneration* GetImpObj();
public:
    virtual IntPtr GetDisposableObject() override;

public:
    ///<summary>Creates a set of schema autogeneration settings.
    ///</summary>
    ///<returns>Returns OvSchemaAutoGeneration</returns>
    OvSchemaAutoGeneration();

    ///<summary>Gets the table prefix for autogenerating class definitions.
    ///When set, an FDO Class Definition is automatically generated for
    ///each table whose name begins with this prefix. Any table already 
    ///referenced by a class definition is skipped. Each generated class is 
    ///added to the Feature Schema for this Schema Mapping Set.
    ///</summary>
    ///<returns>Returns the class autogeneration table name prefix</returns>
    ///<summary>
    ///Sets the table prefix for autogenerating class definitions.
    ///</summary>
    /// <param name="tablePrefix">
    /// Input the table prefix. If L"" then no 
    /// classes will be generated by table prefix.
    /// </param>
    ///<returns>Returns nothing</returns>
    property System::String^ GenTablePrefix
    {
        System::String^ get();
        System::Void set(System::String^ value);
    }

    ///<summary>Gets the table prefix removal setting. This setting affects
    ///how classes, generated from tables matching the table prefix, are named:
    ///    * when true, the class name is the table name with prefix removed. 
    ///    true is the default setting.
    ///    * when false, the class name is the table name. 
    ///</summary>
    ///<returns>Returns Boolean.</returns>
    ///<summary>Sets the "remove table prefix" setting.</summary>
    /// <param name="removeTablePrefix">
    /// Input the "remove table prefix" setting.
    // </param>
    ///<returns>Returns nothing</returns>
    property System::Boolean RemoveTablePrefix
    {
        System::Boolean get();
        System::Void set(System::Boolean removeTablePrefix);
    }

    ///<summary>Gets the list of tables or views for which class definitions 
    ///will be autogenerated. Once retrieved, the caller can populate this 
    ///list.
    ///When set, an FDO Class Definition is automatically generated for
    ///each table in this list. Any table already 
    ///referenced by a class definition is skipped. Each generated class is 
    ///added to the Feature Schema for this Schema Mapping Set.
    ///
    ///Note: the only way to autogenerate a class definition from a view
    ///is to add the view name to this list. There is one caveat in that
    ///the generated class will not have identity properties. 
    ///</summary>
    ///<returns>Returns StringCollection</returns>
    property NAMESPACE_OSGEO_COMMON::StringCollection^ GenTableList
    {
        NAMESPACE_OSGEO_COMMON::StringCollection^ get();
    }

    ///<summary>Gets the maximum number of rows to sample when table data
    ///must be examined to determine schema information. The situations 
    ///where this must be done depend on the provider. For example, 
    ///when a geometric property is generated from a geometric column, the 
    ///geomety types might be determined by examining some of the geometry
    ///values in the column.
    ///
    ///MaxSampleRows can be any positive integer or one of the following:
    ///    * 0: all rows in the table are sampled. (Not recommended for
    ///    large datastores).
    ///    * -1: no rows are sampled.
    ///
    ///</summary>
    ///<returns>Returns Int32.</returns>
    ///<summary>Sets the maximum number of rows to sample when 
    ///determining schema from table data. Higher values give a more
    ///accurate result but lower values provide better performance.</summary>
    /// <param name="maxRows">Input the maximum number of rows to sample.</param>
    ///<returns>Returns nothing</returns>
    property System::Int32 MaxSampleRows
    {
        System::Int32 get();
        System::Void set(System::Int32 maxRows);
    }
};

END_NAMESPACE_OSGEO_FDO_PROVIDERS_RDBMS_OVERRIDE

