//
//  Copyright (C) 2004-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

/// \ingroup Geometry_Module

//-------------------------------------------------------------------------
//
// FILE: opolygnp.h.
//
// PURPOSE: Declaration of the OpsPolygonPrimitive class. All polygon-type
//          primitives in the OPS++ class hierarchy are derived from this
//          class.
//
//------------------------------------------------------------------------------

#ifndef _OPOLYGNP_H_
#define _OPOLYGNP_H_


class OpsPolygonPrimitive : public OpsPrimitive
{
public:
    virtual OpsFloatPoint *GetCentroid(OpsFloatPoint *centroid) const = 0;
    virtual double GetArea() const = 0;
};

#endif
