//
// Copyright (C) 2006 Refractions Research, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
#ifndef FDOSMLPPOSTGISDATAPROPERTYDEFINITION_H
#define FDOSMLPPOSTGISDATAPROPERTYDEFINITION_H

#include "../../../SchemaMgr/Lp/DataPropertyDefinition.h"

/// Defines data property for LogicalPhysical.
/// Used by PostGIS provider.
///
class FdoSmLpPostGisDataPropertyDefinition : 
    public FdoSmLpGrdDataPropertyDefinition
{
public:

    ///
    /// \param
    /// propReader [in] - property reader.
    ///
    /// \param
    /// parent [in] - 
    ///
    FdoSmLpPostGisDataPropertyDefinition(FdoSmPhClassPropertyReaderP propReader,
        FdoSmLpClassDefinition* parent);

    /// Construct an AssociationPropertyDefinition from
    /// FDO property definition.
    ///
    /// \param
    /// fdoPropDef [in] - FDO property definition.
    ///
    /// \param
    /// ignoreStates [in] - 
    ///
    /// \param
    /// parent [in] - pointer to instance of parent class definition.
    ///
    FdoSmLpPostGisDataPropertyDefinition(FdoDataPropertyDefinition* fdoProp,
        bool ignoreStates,
        FdoSmLpClassDefinition* parent);

    /// \todo To be documented.
    ///
    FdoSmLpPostGisDataPropertyDefinition(
        FdoPtr<FdoSmLpDataPropertyDefinition> baseProperty,
        FdoSmLpClassDefinition* targetClass,
        FdoStringP logicalName,
        FdoStringP physicalName,
        bool inherit,
        FdoPhysicalPropertyMapping* propOverrides = NULL);

    /// \todo To be documented.
    ///
    virtual bool AddSchemaMappings(FdoPhysicalClassMappingP schemaMapping,
        bool includeDefaults) const;

    /// \todo To be documented.
    ///
    virtual FdoPhysicalPropertyMappingP GetSchemaMappings(
        bool includeDefaults) const;
    
    /// \todo To be documented.
    ///
    virtual void Update(FdoPropertyDefinition* fdoProp,
        FdoSchemaElementState state,
        FdoPhysicalPropertyMapping* propOverrides,
        bool ignoreStates); 

protected:

    virtual FdoDataType* GetSupportedAutoGeneratedTypes(FdoInt32& length);

    /// Create an inherited copy of this property.
    ///
    /// \param
    /// subClass [in] -
    ///
    virtual FdoSmLpPropertyP NewInherited(
        FdoSmLpClassDefinition* subClass) const;

    /// Create a non-inherited copy of this property.
    /// \param
    /// targetClass [in] - class that will contain the new property.
    ///
    /// \param
    /// logicalName [in] - name for the new property. If empty L"",
    /// then the new property has the same name as this property.
    ///
    /// \param
    /// physicalName [in] - name of the new property's column. If empty L"",
    /// then the column is the same as the base property column name.
    ///
    /// \param
    /// propOverrides [in] - FDO to physical mapping overrides for property.
    ///
    virtual FdoSmLpPropertyP NewCopy(FdoSmLpClassDefinition* targetClass,
        FdoStringP logicalName,
        FdoStringP physicalName,
        FdoPhysicalPropertyMapping* propOverrides) const;
};

/// \brief
/// Declaration of smart-pointer type for FdoSmLpPostGisDataPropertyDefinition.
/// Provided for convenience.
///
typedef FdoPtr<FdoSmLpPostGisDataPropertyDefinition> FdoSmLpPostGisDataPropertyP;

#endif // FDOSMLPPOSTGISDATAPROPERTYDEFINITION_H
