// Copyright (c) 2016 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.

#include "tests/cefclient/browser/window_test_runner.h"

namespace client::window_test {

// static
void WindowTestRunner::ModifyBounds(const CefRect& display, CefRect& window) {
  window.x += display.x;
  window.y += display.y;

  if (window.x < display.x) {
    window.x = display.x;
  }
  if (window.y < display.y) {
    window.y = display.y;
  }
  if (window.width < 100) {
    window.width = 100;
  } else if (window.width >= display.width) {
    window.width = display.width;
  }
  if (window.height < 100) {
    window.height = 100;
  } else if (window.height >= display.height) {
    window.height = display.height;
  }
  if (window.x + window.width >= display.x + display.width) {
    window.x = display.x + display.width - window.width;
  }
  if (window.y + window.height >= display.y + display.height) {
    window.y = display.y + display.height - window.height;
  }
}

void WindowTestRunner::Fullscreen(CefRefPtr<CefBrowser> browser) {
  NOTIMPLEMENTED();
}

void WindowTestRunner::SetTitleBarHeight(CefRefPtr<CefBrowser> browser,
                                         const std::optional<float>& height) {
  NOTIMPLEMENTED();
}

}  // namespace client::window_test
