// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=f1a00c2677b5a02b46ab3a18ac34c85de32e1dcc$
//

#include "libcef_dll/ctocpp/accessibility_handler_ctocpp.h"

#include "libcef_dll/cpptoc/value_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
void CefAccessibilityHandlerCToCpp::OnAccessibilityTreeChange(
    CefRefPtr<CefValue> value) {
  shutdown_checker::AssertNotShutdown();

  cef_accessibility_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_accessibility_tree_change)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: value; type: refptr_diff
  DCHECK(value.get());
  if (!value.get()) {
    return;
  }

  // Execute
  _struct->on_accessibility_tree_change(_struct, CefValueCppToC::Wrap(value));
}

NO_SANITIZE("cfi-icall")
void CefAccessibilityHandlerCToCpp::OnAccessibilityLocationChange(
    CefRefPtr<CefValue> value) {
  shutdown_checker::AssertNotShutdown();

  cef_accessibility_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_accessibility_location_change)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: value; type: refptr_diff
  DCHECK(value.get());
  if (!value.get()) {
    return;
  }

  // Execute
  _struct->on_accessibility_location_change(_struct,
                                            CefValueCppToC::Wrap(value));
}

// CONSTRUCTOR - Do not edit by hand.

CefAccessibilityHandlerCToCpp::CefAccessibilityHandlerCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefAccessibilityHandlerCToCpp::~CefAccessibilityHandlerCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_accessibility_handler_t* CefCToCppRefCounted<
    CefAccessibilityHandlerCToCpp,
    CefAccessibilityHandler,
    cef_accessibility_handler_t>::UnwrapDerived(CefWrapperType type,
                                                CefAccessibilityHandler* c) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefAccessibilityHandlerCToCpp,
                                   CefAccessibilityHandler,
                                   cef_accessibility_handler_t>::kWrapperType =
    WT_ACCESSIBILITY_HANDLER;
