//
//  Copyright (C) 2007-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#ifndef COMPOSITETYPESTYLE_H
#define COMPOSITETYPESTYLE_H

#include "MdfModel.h"
#include "FeatureTypeStyle.h"
#include "CompositeRule.h"

BEGIN_NAMESPACE_MDFMODEL

    //-------------------------------------------------------------------------
    // DESCRIPTION:
    //-------------------------------------------------------------------------
    class MDFMODEL_API CompositeTypeStyle : public FeatureTypeStyle
    {
    public:
        // Construction, destruction, initialization
        CompositeTypeStyle();
        virtual ~CompositeTypeStyle();

        // Operations
        // Implementation of FeatureTypeStyle Visitor pattern method.
        virtual void AcceptVisitor(IFeatureTypeStyleVisitor& iftsVisitor);

    private:
        // Hidden copy constructor and assignment operator.
        CompositeTypeStyle(const CompositeTypeStyle&);
        CompositeTypeStyle& operator=(const CompositeTypeStyle&);
    };

END_NAMESPACE_MDFMODEL
#endif // COMPOSITETYPESTYLE_H
