//
//  Copyright (C) 2004-2011 by Autodesk, Inc.
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of version 2.1 of the GNU Lesser
//  General Public License as published by the Free Software Foundation.
//
//  This library is distributed in the hope that it will be useful;
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not; write to the Free Software
//  Foundation; Inc.; 51 Franklin St; Fifth Floor; Boston; MA  02110-1301  USA
//

#ifndef _MGCOORDINATESYSTEMPROJECTIONPARAMETERTYPE_H_
#define _MGCOORDINATESYSTEMPROJECTIONPARAMETERTYPE_H_

/// \defgroup MgCoordinateSystemProjectionParameterType MgCoordinateSystemProjectionParameterType
/// \ingroup Coordinate_System_classes
/// \{

///////////////////////////////////////////////////////////////
/// \brief
/// Defines the types of coordinate system projection parameters
///
class MG_GEOMETRY_API MgCoordinateSystemProjectionParameterType
{
PUBLISHED_API:
    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Not used.
    ///
    static const INT32 NotUsed = 0;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Central Meridian
    ///
    static const INT32 Cntmer = 1;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Northern Standard Parallel
    ///
    static const INT32 Nstdpll = 2;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Southern Standard Parallel
    ///
    static const INT32 Sstdpll = 3;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Standard Parallel
    ///
    static const INT32 Stdpll = 4;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// First Great Circle Point Longitude
    ///
    static const INT32 Gcp1lng = 5;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// First Great Circle Point Latitude
    ///
    static const INT32 Gcp1lat = 6;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Second Great Circle Point Longitude
    ///
    static const INT32 Gcp2lng = 7;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Second Great Circle Point Latitude
    ///
    static const INT32 Gcp2lat = 8;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Great Circle Point Longitude
    ///
    static const INT32 Gcplng = 9;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Great Circle Point Latitude
    ///
    static const INT32 Gcplat = 10;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Great Circle Azimuth
    ///
    static const INT32 Gcazm = 11;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Y axis azimuth
    ///
    static const INT32 Yaxisaz = 12;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Eastern Standard Meridian
    ///
    static const INT32 Estdmer = 13;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Northern Parallel
    ///
    static const INT32 Nparall = 14;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Southern Parallel
    ///
    static const INT32 Sparall = 15;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// First pole longitude
    ///
    static const INT32 P1lng = 16;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// First pole latitude
    ///
    static const INT32 P1lat = 17;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Second pole longitude
    ///
    static const INT32 P2lng = 18;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Second pole latitude
    ///
    static const INT32 P2lat = 19;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Distance between the poles.
    ///
    static const INT32 Adp1p2 = 20;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Angular distance to the first standard parallel
    ///
    static const INT32 Adsp1 = 21;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Angular distance to the second standard parallel
    ///
    static const INT32 Adsp2 = 22;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Complex Parameter A (n). Label string includes a %s for generation by sprintf.
    ///
    static const INT32 Cmplxan = 23;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Complex Parameter B (n). Label string includes a %s for generation by sprintf.
    ///
    static const INT32 Cmplxbn = 24;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Western end of Longitude range.
    ///
    static const INT32 Westll = 25;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Eastern end of Longitude range
    ///
    static const INT32 Eastll = 26;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// UTM Zone Number
    ///
    static const INT32 Utmzn = 27;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// North/South Hemisphere
    ///
    static const INT32 Hsns = 28;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Average Geoid Height
    ///
    static const INT32 Ghgt = 29;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Average Elevation
    ///
    static const INT32 Aelev = 30;          

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Oblique Pole Longitude
    ///
    static const INT32 Polelng = 31;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Oblique Pole Latitude
    ///
    static const INT32 Polelat = 32;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Oblique Cone Standard Parallel
    ///
    static const INT32 Ostdpll = 33;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Standard Circle Latitude
    ///
    static const INT32 Stdcir = 34;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine A0 Coefficient
    ///
    static const INT32 Afa0 = 35;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine B0 Coefficient
    ///
    static const INT32 Afb0 = 36;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine A1 Coefficient
    ///
    static const INT32 Afa1 = 37;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine A2 Coefficient
    ///
    static const INT32 Afa2 = 38;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine B1 Coefficient
    ///
    static const INT32 Afb1 = 39;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Affine B2 Coefficient
    ///
    static const INT32 Afb2 = 40;           

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Normal Parallel
    ///
    static const INT32 Nrmlpll = 41;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Danish System 24 Region
    ///
    static const INT32 Denrgn = 42;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// cs_PRMCOD_SKWAZM - Skew Azimuth at Rectified Origin.
    ///
    static const INT32 Skwazm = 43;         

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// X Coordinate of Scale/Rotate Origin
    ///
    static const INT32 Sclrotorgx = 44;     

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Y Coordinate of Scale/Rotate Origin
    ///
    static const INT32 Sclrotorgy = 45;     

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Cartesian Scale Factor
    ///
    static const INT32 Nrthscl = 46;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Cartesian Rotation Angle
    ///
    static const INT32 Nrthrot = 47;        

    ///////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief
    /// Ellipsoid scaling factor
    ///
    static const INT32 EllipsoidScale = 48;
};
/// \}

#endif //_MGCOORDINATESYSTEMPROJECTIONPARAMETERTYPE_H_
