// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=0a888470de76a25470054666096f28a2c4e51d07$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_APP_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_APP_CTOCPP_H_
#pragma once

#if !defined(BUILDING_CEF_SHARED)
#error This file can be included DLL-side only
#endif

#include "include/capi/cef_app_capi.h"
#include "include/cef_app.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed DLL-side only.
class CefAppCToCpp
    : public CefCToCppRefCounted<CefAppCToCpp, CefApp, cef_app_t> {
 public:
  CefAppCToCpp();
  virtual ~CefAppCToCpp();

  // CefApp methods.
  void OnBeforeCommandLineProcessing(
      const CefString& process_type,
      CefRefPtr<CefCommandLine> command_line) override;
  void OnRegisterCustomSchemes(
      CefRawPtr<CefSchemeRegistrar> registrar) override;
  CefRefPtr<CefResourceBundleHandler> GetResourceBundleHandler() override;
  CefRefPtr<CefBrowserProcessHandler> GetBrowserProcessHandler() override;
  CefRefPtr<CefRenderProcessHandler> GetRenderProcessHandler() override;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_APP_CTOCPP_H_
