// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=318aa17fd227ce261d357eb4850b5cd1cb7ab97f$
//

#include "libcef_dll/ctocpp/domvisitor_ctocpp.h"
#include "libcef_dll/cpptoc/domdocument_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
void CefDOMVisitorCToCpp::Visit(CefRefPtr<CefDOMDocument> document) {
  shutdown_checker::AssertNotShutdown();

  cef_domvisitor_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, visit)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: document; type: refptr_diff
  DCHECK(document.get());
  if (!document.get()) {
    return;
  }

  // Execute
  _struct->visit(_struct, CefDOMDocumentCppToC::Wrap(document));
}

// CONSTRUCTOR - Do not edit by hand.

CefDOMVisitorCToCpp::CefDOMVisitorCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefDOMVisitorCToCpp::~CefDOMVisitorCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_domvisitor_t*
CefCToCppRefCounted<CefDOMVisitorCToCpp, CefDOMVisitor, cef_domvisitor_t>::
    UnwrapDerived(CefWrapperType type, CefDOMVisitor* c) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefDOMVisitorCToCpp,
                                   CefDOMVisitor,
                                   cef_domvisitor_t>::kWrapperType =
    WT_DOMVISITOR;
