// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=592d43a6597f03f91eb13ea9354ed552f581ebec$
//

#include "libcef_dll/cpptoc/shared_process_message_builder_cpptoc.h"
#include "libcef_dll/cpptoc/process_message_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

// GLOBAL FUNCTIONS - Body may be edited by hand.

CEF_EXPORT cef_shared_process_message_builder_t*
cef_shared_process_message_builder_create(const cef_string_t* name,
                                          size_t byte_size) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: name; type: string_byref_const
  DCHECK(name);
  if (!name) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefSharedProcessMessageBuilder> _retval =
      CefSharedProcessMessageBuilder::Create(CefString(name), byte_size);

  // Return type: refptr_same
  return CefSharedProcessMessageBuilderCppToC::Wrap(_retval);
}

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

int CEF_CALLBACK shared_process_message_builder_is_valid(
    struct _cef_shared_process_message_builder_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  bool _retval = CefSharedProcessMessageBuilderCppToC::Get(self)->IsValid();

  // Return type: bool
  return _retval;
}

size_t CEF_CALLBACK shared_process_message_builder_size(
    struct _cef_shared_process_message_builder_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  size_t _retval = CefSharedProcessMessageBuilderCppToC::Get(self)->Size();

  // Return type: simple
  return _retval;
}

void* CEF_CALLBACK shared_process_message_builder_memory(
    struct _cef_shared_process_message_builder_t* self) {
  shutdown_checker::AssertNotShutdown();

  DCHECK(self);
  if (!self) {
    return 0;
  }

  // Execute
  void* _retval = CefSharedProcessMessageBuilderCppToC::Get(self)->Memory();

  // Return type: simple
  return _retval;
}

cef_process_message_t* CEF_CALLBACK shared_process_message_builder_build(
    struct _cef_shared_process_message_builder_t* self) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return NULL;
  }

  // Execute
  CefRefPtr<CefProcessMessage> _retval =
      CefSharedProcessMessageBuilderCppToC::Get(self)->Build();

  // Return type: refptr_same
  return CefProcessMessageCppToC::Wrap(_retval);
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefSharedProcessMessageBuilderCppToC::CefSharedProcessMessageBuilderCppToC() {
  GetStruct()->is_valid = shared_process_message_builder_is_valid;
  GetStruct()->size = shared_process_message_builder_size;
  GetStruct()->memory = shared_process_message_builder_memory;
  GetStruct()->build = shared_process_message_builder_build;
}

// DESTRUCTOR - Do not edit by hand.

CefSharedProcessMessageBuilderCppToC::~CefSharedProcessMessageBuilderCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefSharedProcessMessageBuilder>
CefCppToCRefCounted<CefSharedProcessMessageBuilderCppToC,
                    CefSharedProcessMessageBuilder,
                    cef_shared_process_message_builder_t>::
    UnwrapDerived(CefWrapperType type,
                  cef_shared_process_message_builder_t* s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCppToCRefCounted<CefSharedProcessMessageBuilderCppToC,
                        CefSharedProcessMessageBuilder,
                        cef_shared_process_message_builder_t>::kWrapperType =
        WT_SHARED_PROCESS_MESSAGE_BUILDER;
