// ExerciseFdoSchema.cpp
//
// 
// Copyright (C) 2008  Autodesk, Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of version 2.1 of the GNU Lesser
// General Public License as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
// 
//

#include "stdafx.h"
#include "ExerciseFdoSchema.h"
#ifndef _WIN32
#include <unistd.h>
#endif


ExerciseFdoSchema::ExerciseFdoSchema(StrToFdoType * str2FdoType,
	ExerciseFdoUtilities * utilities,
	FdoIConnection * connection) {
	this->str2FdoType = str2FdoType;
	this->utilities = utilities;
	this->connection = connection;
	connectionInfo = connection->GetConnectionInfo();
}

void
ExerciseFdoSchema::AddClassDefinitionProperties(
	FdoClassDefinition * classDef,
	ParseSchemaDefinitionFile * schemaDefinitionFile) {
	classDef->SetIsAbstract(schemaDefinitionFile->GetClassAbstract());
	classDef->SetIsComputed(schemaDefinitionFile->GetClassComputed());
}

void
ExerciseFdoSchema::AddProperties(
		FdoClassDefinition * classDef,
		ParseSchemaDefinitionFile * schemaDefinitionFile) {

	int propertyCount = 0;
	FdoPtr<FdoDataPropertyDefinition> dataProperty;
	FdoPtr<FdoGeometricPropertyDefinition> geometricProperty;
	FdoPtr<FdoPropertyDefinitionCollection> classProperties;
	FdoPtr<FdoDataPropertyDefinitionCollection> identityProperties;
	FdoFeatureClass * featureClass;
	FdoPropertyType propertyType;
	FdoDataType dataType;
	propertyCount = schemaDefinitionFile->GetPropertyCount();
	classProperties = classDef->GetProperties();
	identityProperties = classDef->GetIdentityProperties();
	FdoInt32 geoTypesInt = 0;
	int retval = 0;
	for(int i = 0; i < propertyCount; i++) {
		retval = schemaDefinitionFile->GetNextProperty();
		propertyType = str2FdoType->convStrToFdoPropertyType(schemaDefinitionFile->GetPropertyType());
		switch(propertyType) {
			case FdoPropertyType_DataProperty:
				dataProperty = FdoDataPropertyDefinition::Create(schemaDefinitionFile->GetPropertyName(), schemaDefinitionFile->GetPropertyDescription());
				dataProperty->SetReadOnly(schemaDefinitionFile->GetPropertyReadOnly());
				dataProperty->SetNullable(schemaDefinitionFile->GetPropertyNullable());
				dataProperty->SetIsAutoGenerated(schemaDefinitionFile->GetPropertyAutoGenerated());
				dataType = str2FdoType->convStrToFdoDataType(schemaDefinitionFile->GetPropertyDataType());
				dataProperty->SetDataType(dataType);
				switch(dataType) {
					case FdoDataType_String:
						dataProperty->SetLength(schemaDefinitionFile->GetPropertyLength());
						break;
					case FdoDataType_Int32:
						break;
					default:
						sprintf(errString, "ERROR unknown data type: %s", schemaDefinitionFile->GetPropertyDataType());
						throw(errString);
				}
				classProperties->Add(dataProperty);
				if (schemaDefinitionFile->GetPropertyIdentity()) {
					identityProperties->Add(dataProperty);
				}
				break;
			case FdoPropertyType_GeometricProperty:
				geometricProperty = FdoGeometricPropertyDefinition::Create(schemaDefinitionFile->GetPropertyName(), schemaDefinitionFile->GetPropertyDescription());
				geometricProperty->SetReadOnly(schemaDefinitionFile->GetPropertyReadOnly());
				geometricProperty->SetHasMeasure(schemaDefinitionFile->GetPropertyHasMeasure());
				geometricProperty->SetHasElevation(schemaDefinitionFile->GetPropertyHasElevation());
				geoTypesInt = convGeoTypesToInt(schemaDefinitionFile->GetPropertyGeometricTypes());
				geometricProperty->SetGeometryTypes(geoTypesInt);
				classProperties->Add(geometricProperty);
				featureClass = dynamic_cast <FdoFeatureClass *> (classDef);
				featureClass->SetGeometryProperty(geometricProperty);
				break;
			default:
				sprintf(errString, "ERROR: unknown FdoPropertyType %s", schemaDefinitionFile->GetPropertyType());
				throw(errString);
		}
	}
}

// the string argument can contain multiple FdoGeometricType strings
FdoInt32
ExerciseFdoSchema::convGeoTypesToInt(const char * geometricTypes) {
	FdoInt32 typesOred = 0;
	strcpy(charbuf, geometricTypes);
	char * token = NULL;
	token = strtok(charbuf, " ");
	while (token != NULL) {
		typesOred = typesOred | str2FdoType->convStrToFdoGeometricType(token);
		token = strtok(NULL, " ");
	}
	return typesOred;
}


