// Copyright (c) 2024 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=1d072dd56acd042383f193e1986606ebb2bb9ee1$
//

#include "libcef_dll/ctocpp/browser_process_handler_ctocpp.h"
#include "libcef_dll/cpptoc/command_line_cpptoc.h"
#include "libcef_dll/cpptoc/preference_registrar_cpptoc.h"
#include "libcef_dll/ctocpp/client_ctocpp.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
void CefBrowserProcessHandlerCToCpp::OnRegisterCustomPreferences(
    cef_preferences_type_t type,
    CefRawPtr<CefPreferenceRegistrar> registrar) {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_register_custom_preferences)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: registrar; type: rawptr_diff
  DCHECK(registrar);
  if (!registrar) {
    return;
  }

  // Translate param: registrar; type: rawptr_diff
  CefOwnPtr<CefPreferenceRegistrarCppToC> registrarPtr(
      CefPreferenceRegistrarCppToC::WrapRaw(registrar));

  // Execute
  _struct->on_register_custom_preferences(_struct, type,
                                          registrarPtr->GetStruct());
}

NO_SANITIZE("cfi-icall")
void CefBrowserProcessHandlerCToCpp::OnContextInitialized() {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_context_initialized)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->on_context_initialized(_struct);
}

NO_SANITIZE("cfi-icall")
void CefBrowserProcessHandlerCToCpp::OnBeforeChildProcessLaunch(
    CefRefPtr<CefCommandLine> command_line) {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_before_child_process_launch)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: command_line; type: refptr_diff
  DCHECK(command_line.get());
  if (!command_line.get()) {
    return;
  }

  // Execute
  _struct->on_before_child_process_launch(
      _struct, CefCommandLineCppToC::Wrap(command_line));
}

NO_SANITIZE("cfi-icall")
bool CefBrowserProcessHandlerCToCpp::OnAlreadyRunningAppRelaunch(
    CefRefPtr<CefCommandLine> command_line,
    const CefString& current_directory) {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_already_running_app_relaunch)) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: command_line; type: refptr_diff
  DCHECK(command_line.get());
  if (!command_line.get()) {
    return false;
  }
  // Unverified params: current_directory

  // Execute
  int _retval = _struct->on_already_running_app_relaunch(
      _struct, CefCommandLineCppToC::Wrap(command_line),
      current_directory.GetStruct());

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
void CefBrowserProcessHandlerCToCpp::OnScheduleMessagePumpWork(
    int64_t delay_ms) {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, on_schedule_message_pump_work)) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->on_schedule_message_pump_work(_struct, delay_ms);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefClient> CefBrowserProcessHandlerCToCpp::GetDefaultClient() {
  cef_browser_process_handler_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_default_client)) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_client_t* _retval = _struct->get_default_client(_struct);

  // Return type: refptr_same
  return CefClientCToCpp::Wrap(_retval);
}

// CONSTRUCTOR - Do not edit by hand.

CefBrowserProcessHandlerCToCpp::CefBrowserProcessHandlerCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefBrowserProcessHandlerCToCpp::~CefBrowserProcessHandlerCToCpp() {}

template <>
cef_browser_process_handler_t* CefCToCppRefCounted<
    CefBrowserProcessHandlerCToCpp,
    CefBrowserProcessHandler,
    cef_browser_process_handler_t>::UnwrapDerived(CefWrapperType type,
                                                  CefBrowserProcessHandler* c) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCToCppRefCounted<CefBrowserProcessHandlerCToCpp,
                        CefBrowserProcessHandler,
                        cef_browser_process_handler_t>::kWrapperType =
        WT_BROWSER_PROCESS_HANDLER;
