// Copyright (c) 2023 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=c7fa8f548cc0e606e09fe76532b3d2bc19473b16$
//

#include "libcef_dll/cpptoc/resource_read_callback_cpptoc.h"
#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK
resource_read_callback_cont(struct _cef_resource_read_callback_t* self,
                            int bytes_read) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }

  // Execute
  CefResourceReadCallbackCppToC::Get(self)->Continue(bytes_read);
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefResourceReadCallbackCppToC::CefResourceReadCallbackCppToC() {
  GetStruct()->cont = resource_read_callback_cont;
}

// DESTRUCTOR - Do not edit by hand.

CefResourceReadCallbackCppToC::~CefResourceReadCallbackCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefResourceReadCallback> CefCppToCRefCounted<
    CefResourceReadCallbackCppToC,
    CefResourceReadCallback,
    cef_resource_read_callback_t>::UnwrapDerived(CefWrapperType type,
                                                 cef_resource_read_callback_t*
                                                     s) {
  DCHECK(false) << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefResourceReadCallbackCppToC,
                                   CefResourceReadCallback,
                                   cef_resource_read_callback_t>::kWrapperType =
    WT_RESOURCE_READ_CALLBACK;
